/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.block.BlockDispenser;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.util.EnumHelper;
import org.apache.commons.lang3.ArrayUtils;
import rafradek.TF2weapons.CommonProxy;
import rafradek.TF2weapons.DamageSourceBullet;
import rafradek.TF2weapons.MapList;
import rafradek.TF2weapons.TF2Attribute;
import rafradek.TF2weapons.TF2EventBusListener;
import rafradek.TF2weapons.characters.EntityHeavy;
import rafradek.TF2weapons.characters.EntityScout;
import rafradek.TF2weapons.characters.EntitySniper;
import rafradek.TF2weapons.characters.ItemMonsterPlacerPlus;
import rafradek.TF2weapons.message.TF2ActionHandler;
import rafradek.TF2weapons.message.TF2Message;
import rafradek.TF2weapons.weapons.ItemRangedWeapon;
import rafradek.TF2weapons.weapons.ItemUsable;

@Mod(modid="rafradek_tf2_weapons", name="TF2 Stuff Mod", version="0.2")
public class TF2weapons {
    public int[] itemid = new int[9];
    public Configuration conf;
    public static CreativeTabs tabtf2;
    public static final ItemArmor.ArmorMaterial OPARMOR;
    public static SimpleNetworkWrapper network;
    public static Item itemPlacer;
    public static Item mobHeldItem;
    public File weaponDir;
    @SidedProxy(clientSide="rafradek.TF2weapons.ClientProxy", serverSide="rafradek.TF2weapons.CommonProxy")
    public static CommonProxy proxy;

    @Mod.EventHandler
    public void preinit(FMLPreInitializationEvent event) {
        this.weaponDir = new File(event.getModConfigurationDirectory(), "TF2WeaponsLists");
        if (!this.weaponDir.exists()) {
            this.weaponDir.mkdirs();
        }
        File outputFile = new File(this.weaponDir, "Weapons.cfg");
        File file = event.getSourceFile();
        if (!outputFile.exists()) {
            if (file.isFile()) {
                try {
                    ZipFile zip = new ZipFile(file);
                    ZipEntry entry = zip.getEntry("Weapons.cfg");
                    if (entry != null) {
                        InputStream zin = zip.getInputStream(entry);
                        byte[] bytes = new byte[(int)entry.getSize()];
                        zin.read(bytes);
                        FileOutputStream str = new FileOutputStream(outputFile);
                        str.write(bytes);
                        str.close();
                        zin.close();
                        zip.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    File inputFile = new File(file, "Weapons.cfg");
                    FileInputStream istr = new FileInputStream(inputFile);
                    byte[] bytes = new byte[(int)inputFile.length()];
                    istr.read(bytes);
                    FileOutputStream str = new FileOutputStream(outputFile);
                    str.write(bytes);
                    str.close();
                    istr.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        MapList.initMaps();
        TF2Attribute.initAttributes();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        tabtf2 = new CreativeTabs("tf2"){

            public Item func_78016_d() {
                return MapList.weaponClasses.get("Bullet");
            }
        };
        EntityRegistry.registerModEntity(EntityHeavy.class, (String)"heavy", (int)2, (Object)this, (int)80, (int)3, (boolean)true);
        EntityRegistry.registerModEntity(EntityScout.class, (String)"scout", (int)3, (Object)this, (int)80, (int)3, (boolean)true);
        EntityRegistry.registerModEntity(EntitySniper.class, (String)"sniper", (int)4, (Object)this, (int)80, (int)3, (boolean)true);
        itemPlacer = new ItemMonsterPlacerPlus().func_77655_b("monsterPlacer").func_111206_d("spawn_egg");
        GameRegistry.registerItem((Item)itemPlacer, (String)"placer");
        EntityRegistry.addSpawn(EntitySniper.class, (int)46, (int)1, (int)3, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])((BiomeGenBase[])ArrayUtils.subarray((Object[])BiomeGenBase.func_150565_n(), (int)0, (int)ArrayUtils.indexOf((Object[])BiomeGenBase.func_150565_n(), null, (int)0))));
        EntityRegistry.addSpawn(EntityHeavy.class, (int)46, (int)1, (int)3, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])((BiomeGenBase[])ArrayUtils.subarray((Object[])BiomeGenBase.func_150565_n(), (int)0, (int)ArrayUtils.indexOf((Object[])BiomeGenBase.func_150565_n(), null, (int)0))));
        EntityRegistry.addSpawn(EntityScout.class, (int)46, (int)1, (int)3, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])((BiomeGenBase[])ArrayUtils.subarray((Object[])BiomeGenBase.func_150565_n(), (int)0, (int)ArrayUtils.indexOf((Object[])BiomeGenBase.func_150565_n(), null, (int)0))));
        BlockDispenser.field_149943_a.func_82595_a((Object)itemPlacer, (Object)new BehaviorDefaultDispenseItem(){

            public ItemStack func_82487_b(IBlockSource p_82487_1_, ItemStack p_82487_2_) {
                EnumFacing enumfacing = BlockDispenser.func_149937_b((int)p_82487_1_.func_82620_h());
                double d0 = p_82487_1_.func_82615_a() + (double)enumfacing.func_82601_c();
                double d1 = (float)p_82487_1_.func_82622_e() + 0.2f;
                double d2 = p_82487_1_.func_82616_c() + (double)enumfacing.func_82599_e();
                Entity entity = ItemMonsterPlacerPlus.spawnCreature(p_82487_1_.func_82618_k(), p_82487_2_.func_77960_j(), d0, d1, d2);
                if (entity instanceof EntityLivingBase && p_82487_2_.func_82837_s()) {
                    ((EntityLiving)entity).func_94058_c(p_82487_2_.func_82833_r());
                }
                p_82487_2_.func_77979_a(1);
                return p_82487_2_;
            }
        });
        this.loadWeapons();
        network = NetworkRegistry.INSTANCE.newSimpleChannel("rafradek_tf2_weapons");
        network.registerMessage(TF2ActionHandler.class, TF2Message.ActionMessage.class, 0, Side.SERVER);
        MinecraftForge.EVENT_BUS.register((Object)new TF2EventBusListener());
        FMLCommonHandler.instance().bus().register((Object)new TF2EventBusListener());
        proxy.registerRenderInformation();
    }

    public void loadWeapons() {
        File[] files;
        for (String name : MapList.weaponClasses.keySet()) {
            GameRegistry.registerItem((Item)MapList.weaponClasses.get(name), (String)("rafradek_" + name));
        }
        this.loadConfig(new File(this.weaponDir, "Weapons.cfg"));
        for (File file : files = this.weaponDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File arg0, String arg1) {
                return !arg1.equalsIgnoreCase("Weapons.cfg");
            }
        })) {
            this.loadConfig(file);
        }
    }

    public void loadConfig(File file) {
        Configuration weaponsFile = new Configuration(file);
        weaponsFile.load();
        for (String weaponEntry : weaponsFile.getCategoryNames()) {
            ConfigCategory weaponData = weaponsFile.getCategory(weaponEntry);
            try {
                if (weaponData.containsKey("Based on") && MapList.nameToCC.containsKey(weaponData.get("Based on").getString())) {
                    weaponData = TF2weapons.attach(MapList.nameToCC.get(weaponData.get("Based on").getString()), weaponData);
                }
                MapList.nameToCC.put(weaponEntry, weaponData);
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74778_a("Type", weaponEntry);
                NBTTagCompound tag2 = new NBTTagCompound();
                if (weaponData.containsKey("Attributes")) {
                    String[] attributes = weaponData.get("Attributes").getStringList();
                    for (int i = 0; i < attributes.length; ++i) {
                        String attributeName = attributes[i].split(":")[0];
                        String attributeValue = attributes[i].split(":")[1];
                        Iterator<String> iterator2 = MapList.nameToAttribute.keySet().iterator();
                        boolean has = false;
                        while (iterator2.hasNext()) {
                            if (!iterator2.next().equals(attributeName)) continue;
                            tag2.func_74776_a(String.valueOf(MapList.nameToAttribute.get((Object)attributeName).id), Float.parseFloat(attributeValue));
                            has = true;
                        }
                        if (has) continue;
                        tag2.func_74776_a(attributeName, Float.parseFloat(attributeValue));
                    }
                }
                tag.func_74782_a("Attributes", (NBTBase)tag2);
                MapList.buildInAttributes.put(weaponEntry, tag);
            }
            catch (Exception var4) {
                var4.printStackTrace();
            }
        }
    }

    public static ConfigCategory attach(ConfigCategory old, ConfigCategory additional) {
        Set dataKeys = old.keySet();
        for (String key : dataKeys) {
            if (additional.containsKey(key)) continue;
            additional.put(key, old.get(key));
        }
        Set data2Keys = old.keySet();
        Iterator iterator2 = data2Keys.iterator();
        new ConfigCategory(null, additional);
        return additional;
    }

    public static DamageSource causeBulletDamage(String weapon, Entity shooter, boolean crititical) {
        return new DamageSourceBullet(weapon, shooter).func_76349_b();
    }

    public static int RoundUp(double value, int zero) {
        if (value > (double)((int)value)) {
            return (int)value + 1;
        }
        return (int)value;
    }

    public static double[] radiusRandom3D(float radius, Random random) {
        double x = Double.MAX_VALUE;
        double y = Double.MAX_VALUE;
        double z = Double.MAX_VALUE;
        while (Math.sqrt(Math.pow(x, 2.0) + Math.pow(y, 2.0) + Math.pow(z, 2.0)) > (double)radius) {
            x = random.nextDouble() * (double)radius * 2.0 - (double)radius;
            y = random.nextDouble() * (double)radius * 2.0 - (double)radius;
            z = random.nextDouble() * (double)radius * 2.0 - (double)radius;
        }
        return new double[]{x, y, z};
    }

    public static double[] radiusRandom2D(float radius, Random random) {
        float a = random.nextFloat();
        float b = random.nextFloat();
        return new double[]{(double)(Math.max(a, b) * radius) * Math.cos(Math.PI * 2 * (double)Math.min(a, b) / (double)Math.max(a, b)), (double)(Math.max(a, b) * radius) * Math.sin(Math.PI * 2 * (double)Math.min(a, b) / (double)Math.max(a, b))};
    }

    public static MovingObjectPosition pierce(World world, EntityLivingBase living, double startX, double startY, double startZ, double endX, double endY, double endZ, boolean headshot) {
        Vec3 var17 = Vec3.func_72443_a((double)startX, (double)startY, (double)startZ);
        Vec3 var3 = Vec3.func_72443_a((double)endX, (double)endY, (double)endZ);
        MovingObjectPosition var4 = world.func_147447_a(var17, var3, false, true, false);
        var17 = Vec3.func_72443_a((double)startX, (double)startY, (double)startZ);
        var3 = Vec3.func_72443_a((double)endX, (double)endY, (double)endZ);
        if (var4 != null) {
            var3 = Vec3.func_72443_a((double)var4.field_72307_f.field_72450_a, (double)var4.field_72307_f.field_72448_b, (double)var4.field_72307_f.field_72449_c);
        }
        Entity var5 = null;
        AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)(startX - 0.5), (double)(startY - 0.5), (double)(startZ - 0.5), (double)(startX + 0.5), (double)(startY + 0.5), (double)(startZ + 0.5));
        List var6 = world.func_72839_b((Entity)living, living.field_70121_D.func_72321_a(endX - startX, endY - startY, endZ - startZ).func_72314_b(1.0, 1.0, 1.0));
        double var7 = 0.0;
        Iterator iterator = var6.iterator();
        Vec3 collideVec = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        while (iterator.hasNext()) {
            double var14;
            float var11;
            AxisAlignedBB var12;
            MovingObjectPosition var13;
            Entity var10 = (Entity)iterator.next();
            if (!var10.func_70067_L() || var10 instanceof EntityLivingBase && (!(var10 instanceof EntityLivingBase) || ((EntityLivingBase)var10).field_70725_aQ > 0) || (var13 = (var12 = var10.field_70121_D.func_72314_b((double)(var11 = 0.08f), (double)var11 + (double)0.16f, (double)var11)).func_72327_a(var17, var3)) == null || !((var14 = var17.func_72438_d(var13.field_72307_f)) < var7) && var7 != 0.0) continue;
            var5 = var10;
            var7 = var14;
            collideVec = var13.field_72307_f;
        }
        if (!(var5 == null || var5 instanceof EntityLivingBase && ((EntityLivingBase)var5).func_110143_aJ() <= 0.0f)) {
            var4 = new MovingObjectPosition(var5, collideVec);
            if (headshot) {
                double ymax = var5.field_70121_D.field_72337_e;
                AxisAlignedBB head = AxisAlignedBB.func_72330_a((double)(var5.field_70165_t - 0.32), (double)(ymax - 0.24), (double)(var5.field_70161_v - 0.32), (double)(var5.field_70165_t + 0.32), (double)(ymax + 0.48), (double)(var5.field_70161_v + 0.32));
                if (var5 instanceof EntityCreeper || var5 instanceof EntityEnderman || var5 instanceof EntityIronGolem) {
                    head.func_72317_d(0.0, -0.24, 0.0);
                }
                if ((double)var5.field_70130_N > (double)var5.field_70131_O * 0.65) {
                    double offsetX = MathHelper.func_76134_b((float)(living.field_70177_z / 180.0f * (float)Math.PI)) * var5.field_70130_N / 2.0f;
                    double offsetZ = -((double)(MathHelper.func_76126_a((float)(living.field_70177_z / 180.0f * (float)Math.PI)) * var5.field_70130_N / 2.0f));
                    head.func_72317_d(offsetX, 0.0, offsetZ);
                }
                MovingObjectPosition var13 = head.func_72327_a(var17, var3);
                var4.hitInfo = var13;
            }
        }
        return var4;
    }

    public static float calculateDamage(World world, EntityLivingBase living, ItemStack stack, ItemRangedWeapon weapon, boolean critical, float distance) {
        float calculateddamage = weapon.getWeaponDamage(stack, living);
        if (calculateddamage == 0.0f) {
            return 0.0f;
        }
        calculateddamage = !critical ? (distance <= (float)weapon.getWeaponDamageFalloff(stack) ? (calculateddamage *= weapon.getWeaponMaxDamage(stack, living) / weapon.getWeaponDamage(stack, living) - distance / (float)weapon.getWeaponDamageFalloff(stack) * (weapon.getWeaponMaxDamage(stack, living) / weapon.getWeaponDamage(stack, living) - 1.0f)) : (calculateddamage *= Math.max(weapon.getWeaponMinDamage(stack, living) / weapon.getWeaponDamage(stack, living), (weapon.getWeaponDamage(stack, living) - (distance - (float)weapon.getWeaponDamageFalloff(stack)) / ((float)weapon.getWeaponDamageFalloff(stack) * 2.0f) * (weapon.getWeaponDamage(stack, living) - weapon.getWeaponMinDamage(stack, living))) / weapon.getWeaponDamage(stack, living)))) : (calculateddamage *= 3.0f);
        return calculateddamage;
    }

    public static void dealDamage(Entity entity, World world, EntityLivingBase living, ItemStack stack, ItemRangedWeapon weapon, boolean critical, float damage, DamageSource source, float distance) {
        double lvelocityX = entity.field_70159_w;
        double lvelocityY = entity.field_70181_x;
        double lvelocityZ = entity.field_70179_y;
        if (!world.field_72995_K && entity.func_70097_a(source, damage)) {
            if (!ItemUsable.lastDamage.containsKey(living)) {
                ItemUsable.lastDamage.put(living, new float[20]);
            }
            float[] fArray = ItemUsable.lastDamage.get(living);
            fArray[0] = fArray[0] + damage;
            if (entity instanceof EntityLivingBase) {
                EntityLivingBase livingTarget = (EntityLivingBase)entity;
                livingTarget.field_70172_ad = 0;
                if (critical) {
                    world.func_72956_a(entity, "tf2weapons:misc.crit", 0.7f, 1.2f / (world.field_73012_v.nextFloat() * 0.2f + 0.9f));
                }
                world.func_72956_a(entity, "tf2weapons:misc.pain", 0.6f, 1.2f / (world.field_73012_v.nextFloat() * 0.2f + 0.9f));
                if (living instanceof EntityPlayer && !world.field_72995_K) {
                    EntityPlayer player = (EntityPlayer)living;
                    String string = "";
                    for (int i = 0; i < 20; ++i) {
                        string = string + ItemUsable.lastDamage.get(living)[i] + " ";
                    }
                }
                livingTarget.field_70159_w = lvelocityX;
                livingTarget.field_70181_x = lvelocityY;
                livingTarget.field_70179_y = lvelocityZ;
            }
        }
    }

    static {
        OPARMOR = EnumHelper.addArmorMaterial((String)"OPARMOR", (int)1000, (int[])new int[]{24, 0, 0, 0}, (int)100);
    }
}

