/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.weapons;

import java.util.HashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import rafradek.TF2weapons.ClientProxy;
import rafradek.TF2weapons.TF2weapons;
import rafradek.TF2weapons.weapons.ItemRangedWeapon;

public class ItemBulletWeapon
extends ItemRangedWeapon {
    public static double lastStartX = 90.0;
    public static double lastStartY = 90.0;
    public static double lastStartZ = 90.0;
    public static double lastEndX = 990.0;
    public static double lastEndY = 900.0;
    public static double lastEndZ = 900.0;
    public static int maxRange = 300;
    public static HashMap<Entity, float[]> lastShot = new HashMap();

    @Override
    public boolean use(ItemStack stack, EntityLivingBase living, World world, EntityLivingBase target) {
        if (super.use(stack, living, world, target)) {
            DamageSource var22 = null;
            if (!world.field_72995_K && living != null) {
                var22 = TF2weapons.causeBulletDamage(stack.func_77977_a(), (Entity)living, critical);
                for (Entity entity : lastShot.keySet()) {
                    float distance = (float)Vec3.func_72443_a((double)living.field_70165_t, (double)living.field_70163_u, (double)living.field_70161_v).func_72438_d(Vec3.func_72443_a((double)entity.field_70165_t, (double)entity.field_70163_u, (double)entity.field_70161_v));
                    if (lastShot.get(entity) == null || lastShot.get(entity)[1] == 0.0f) continue;
                    TF2weapons.dealDamage(entity, world, living, stack, this, critical, lastShot.get(entity)[1], var22, distance);
                    distance = (float)maxRange / distance;
                    double distX = (living.field_70165_t - entity.field_70165_t) * (double)distance;
                    double distY = (living.field_70163_u - entity.field_70163_u) * (double)distance;
                    double distZ = (living.field_70161_v - entity.field_70161_v) * (double)distance;
                    if (entity == null || stack == null || lastShot.get(entity) == null) continue;
                    double knockbackAmount = this.getWeaponKnockback(stack, living) * (double)lastShot.get(entity)[1] * 0.016875 / (double)maxRange;
                    if (!(knockbackAmount > 0.0) || !(distance > 0.0f)) continue;
                    entity.func_70024_g(-(distX * knockbackAmount), -(distY * knockbackAmount), -(distZ * knockbackAmount));
                }
                lastShot.clear();
            }
            return true;
        }
        return false;
    }

    public boolean showTracer(ItemStack stack) {
        return true;
    }

    @Override
    public void shoot(ItemStack stack, EntityLivingBase living, World world, EntityLivingBase target, boolean critical) {
        MovingObjectPosition var4;
        double startX = 0.0;
        double startY = 0.0;
        double startZ = 0.0;
        double pureX = 0.0;
        double pureY = 0.0;
        double pureZ = 0.0;
        double endX = 0.0;
        double endY = 0.0;
        double endZ = 0.0;
        double[] rand = TF2weapons.radiusRandom3D(this.getWeaponSpread(stack, living), world.field_73012_v);
        if (target == null) {
            startX = living.field_70165_t;
            startY = living.field_70163_u + (double)living.func_70047_e();
            startZ = living.field_70161_v;
            float spreadPitch = living.field_70125_A / 180.0f;
            float spreadYaw = living.field_70759_as / 180.0f;
            endX = -MathHelper.func_76126_a((float)(spreadYaw * (float)Math.PI)) * MathHelper.func_76134_b((float)(spreadPitch * (float)Math.PI));
            endY = -MathHelper.func_76126_a((float)(spreadPitch * (float)Math.PI));
            endZ = MathHelper.func_76134_b((float)(spreadYaw * (float)Math.PI)) * MathHelper.func_76134_b((float)(spreadPitch * (float)Math.PI));
            float var9 = MathHelper.func_76133_a((double)(endX * endX + endY * endY + endZ * endZ));
            endX = (endX / (double)var9 + rand[0]) * (double)maxRange;
            endY = (endY / (double)var9 + rand[1]) * (double)maxRange;
            endZ = (endZ / (double)var9 + rand[2]) * (double)maxRange;
            double distance = (double)maxRange / Math.sqrt(Math.pow(endX, 2.0) + Math.pow(endY, 2.0) + Math.pow(endZ, 2.0));
            pureX = endX - rand[0] * (double)maxRange;
            pureY = endY - rand[1] * (double)maxRange;
            pureZ = endZ - rand[2] * (double)maxRange;
            endX *= distance;
            endY *= distance;
            endZ *= distance;
            endX += startX;
            endY += startY;
            endZ += startZ;
        } else {
            startY = living.field_70163_u + (double)living.func_70047_e() - (double)0.1f;
            endX = target.field_70165_t - living.field_70165_t;
            double var8 = target.field_70163_u + (double)target.func_70047_e() - (double)0.7f - startY;
            endZ = target.field_70161_v - living.field_70161_v;
            double var12 = MathHelper.func_76133_a((double)(endX * endX + endZ * endZ));
            if (var12 >= 1.0E-7) {
                float var14 = (float)(Math.atan2(endZ, endX) * 180.0 / Math.PI) - 90.0f;
                float var15 = (float)(-(Math.atan2(var8, var12) * 180.0 / Math.PI));
                double var16 = endX / var12;
                double var18 = endZ / var12;
                startX = living.field_70165_t + var16;
                startZ = living.field_70161_v + var18;
                float var20 = (float)var12 * 0.2f;
                endY = var8 + (double)var20;
                float var9 = MathHelper.func_76133_a((double)(endX * endX + endY * endY + endZ * endZ));
                endX = (endX / (double)var9 + rand[0]) * (double)maxRange;
                endY = (endY / (double)var9 + rand[1]) * (double)maxRange;
                endZ = (endZ / (double)var9 + rand[2]) * (double)maxRange;
                double distance = (double)maxRange / Math.sqrt(Math.pow(endX, 2.0) + Math.pow(endY, 2.0) + Math.pow(endZ, 2.0));
                pureX = endX - rand[0] * (double)maxRange;
                pureY = endY - rand[1] * (double)maxRange;
                pureZ = endZ - rand[2] * (double)maxRange;
                endX *= distance;
                endY *= distance;
                endZ *= distance;
                endX += startX;
                endY += startY;
                endZ += startZ;
            }
        }
        if (world.field_72995_K && this.showTracer(stack)) {
            ClientProxy.spawnBulletParticle(world, startX - (double)(MathHelper.func_76134_b((float)(living.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f), startY, startZ - (double)(MathHelper.func_76126_a((float)(living.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f), endX, endY, endZ, 20);
        }
        if ((var4 = TF2weapons.pierce(world, living, startX, startY, startZ, endX, endY, endZ, this.canHeadshot(stack))) != null && var4.field_72308_g != null) {
            float distance = 0.0f;
            if (living != null) {
                distance = (float)Vec3.func_72443_a((double)living.field_70165_t, (double)living.field_70163_u, (double)living.field_70161_v).func_72438_d(Vec3.func_72443_a((double)var4.field_72308_g.field_70165_t, (double)var4.field_72308_g.field_70163_u, (double)var4.field_72308_g.field_70161_v));
            }
            if (!world.field_72995_K) {
                if (!lastShot.containsKey(var4.field_72308_g) || lastShot.get(var4.field_72308_g) == null) {
                    lastShot.put(var4.field_72308_g, new float[2]);
                }
                if (var4.hitInfo != null) {
                    critical = true;
                    ItemRangedWeapon.critical = true;
                }
                float[] values = lastShot.get(var4.field_72308_g);
                values[0] = values[0] + 1.0f;
                values[1] = values[1] + TF2weapons.calculateDamage(world, living, stack, this, critical, distance);
            }
        }
    }

    public boolean canHeadshot(ItemStack stack) {
        return false;
    }

    public int positive(float value) {
        if (value > 0.0f) {
            return 1;
        }
        return -1;
    }

    public float[] calculateRatioX(float yaw, float pitch) {
        float[] result = new float[3];
        float angledYaw = Math.abs(MathHelper.func_76142_g((float)yaw));
        float distanceYaw = Math.max(angledYaw, 90.0f) - Math.min(angledYaw, 90.0f);
        result[0] = distanceYaw / 90.0f + (1.0f - distanceYaw / 90.0f) * (-pitch / 90.0f);
        result[2] = 1.0f - distanceYaw / 90.0f;
        result[1] = 0.0f;
        return result;
    }

    public float[] calculateRatioY(float yaw, float pitch) {
        float[] result = new float[3];
        float angledYaw = Math.abs(MathHelper.func_76142_g((float)yaw));
        float distanceYaw = Math.max(angledYaw, 90.0f) - Math.min(angledYaw, 90.0f);
        result[0] = 0.0f;
        result[2] = distanceYaw / 90.0f * (-pitch / 90.0f);
        result[1] = 1.0f - Math.abs(pitch) / 90.0f;
        return result;
    }

    @Override
    public void usingItemFirst(ItemStack stack, World world, EntityLivingBase entity) {
    }
}

