/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.weapons;

import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import rafradek.TF2weapons.ClientProxy;
import rafradek.TF2weapons.TF2Attribute;
import rafradek.TF2weapons.message.TF2ActionHandler;
import rafradek.TF2weapons.weapons.ItemBulletWeapon;
import rafradek.TF2weapons.weapons.MinigunSound;

public class ItemMinigun
extends ItemBulletWeapon {
    public static UUID slowdownUUID = UUID.fromString("12843092-A5D6-BBCD-3D4F-A3DD4D8C94C8");
    public static AttributeModifier slowdown = new AttributeModifier(slowdownUUID, "minigun slowdown", -0.58, 2);

    @Override
    public void func_77663_a(ItemStack par1ItemStack, World par2World, Entity par3Entity, int par4, boolean par5) {
        super.func_77663_a(par1ItemStack, par2World, par3Entity, par4, par5);
        if (par1ItemStack.field_77990_d != null && (par3Entity instanceof EntityPlayer && par4 != ((EntityPlayer)par3Entity).field_71071_by.field_70461_c || ((HashMap)TF2ActionHandler.playerAction.get()).get(par3Entity) != null && ((Integer)((HashMap)TF2ActionHandler.playerAction.get()).get(par3Entity) == 0 || (Integer)((HashMap)TF2ActionHandler.playerAction.get()).get(par3Entity) == 4)) && par1ItemStack.field_77990_d.func_74765_d("minigunticks") > 0) {
            par1ItemStack.field_77990_d.func_74777_a("minigunticks", (short)(par1ItemStack.field_77990_d.func_74765_d("minigunticks") - 1));
            ((EntityLivingBase)par3Entity).func_110148_a(SharedMonsterAttributes.field_111263_d).func_111124_b(slowdown);
        }
    }

    @Override
    public void usingItemFirst(ItemStack stack, World world, EntityLivingBase entity) {
        if (!world.field_72995_K) {
            return;
        }
    }

    @Override
    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par2List, boolean par4) {
        super.func_77624_a(par1ItemStack, par2EntityPlayer, par2List, par4);
        if (par1ItemStack.func_77942_o()) {
            par2List.add("minigun: " + Integer.toString(par1ItemStack.field_77990_d.func_74765_d("minigunticks")));
        }
    }

    @Override
    public boolean startUse(ItemStack stack, EntityLivingBase living, World world) {
        if (world.field_72995_K && (!ClientProxy.fireSounds.containsKey((Object)living) || ((MinigunSound)((Object)ClientProxy.fireSounds.get((Object)living))).type != 3)) {
            ResourceLocation playSound = new ResourceLocation(ItemMinigun.getData(stack).get("Wind Up Sound").getString());
            ClientProxy.playMinigunSound(living, playSound, false, 3, stack);
        }
        return false;
    }

    @Override
    public boolean endUse(ItemStack stack, EntityLivingBase living, World world) {
        if (world.field_72995_K && (!ClientProxy.fireSounds.containsKey((Object)living) || ((MinigunSound)((Object)ClientProxy.fireSounds.get((Object)living))).type != 4)) {
            ResourceLocation playSound = new ResourceLocation(ItemMinigun.getData(stack).get("Wind Down Sound").getString());
            ClientProxy.playMinigunSound(living, playSound, false, 4, stack);
        }
        return false;
    }

    @Override
    public boolean fireTick(ItemStack stack, EntityLivingBase living, World world) {
        if (world.field_72995_K && this.canFire(world, living, stack)) {
            if (!(stack.field_77990_d.func_74765_d("crittime") > 0 || ClientProxy.fireSounds.containsKey((Object)living) && ((MinigunSound)((Object)ClientProxy.fireSounds.get((Object)living))).type == 0)) {
                ResourceLocation playSound = new ResourceLocation(ItemMinigun.getData(stack).get("Minigun Sound").getString());
                ClientProxy.playMinigunSound(living, playSound, true, 0, stack);
            } else if (!(stack.field_77990_d.func_74765_d("crittime") <= 0 || ClientProxy.fireSounds.containsKey((Object)living) && ((MinigunSound)((Object)ClientProxy.fireSounds.get((Object)living))).type == 1)) {
                ResourceLocation playSoundCrit = new ResourceLocation(ItemMinigun.getData(stack).get("Minigun Sound").getString() + ".crit");
                ClientProxy.playMinigunSound(living, playSoundCrit, true, 1, stack);
            }
        }
        this.spinMinigun(stack, living, world);
        return false;
    }

    @Override
    public boolean altFireTick(ItemStack stack, EntityLivingBase living, World world) {
        if (world.field_72995_K && this.canFire(world, living, stack) && (!ClientProxy.fireSounds.containsKey((Object)living) || ((MinigunSound)((Object)ClientProxy.fireSounds.get((Object)living))).type > 2)) {
            ResourceLocation playSound = new ResourceLocation(ItemMinigun.getData(stack).get("Spin Sound").getString());
            ClientProxy.playMinigunSound(living, playSound, true, 2, stack);
        }
        this.spinMinigun(stack, living, world);
        return false;
    }

    public void spinMinigun(ItemStack stack, EntityLivingBase living, World world) {
        if (living.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111127_a(slowdownUUID) == null) {
            living.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(slowdown);
        }
        if (stack.field_77990_d != null && stack.field_77990_d.func_74765_d("reload") <= 0 && (float)stack.field_77990_d.func_74765_d("minigunticks") < 17.0f * TF2Attribute.getModifier("Minigun Spinup", stack, 1.0f, living)) {
            stack.field_77990_d.func_74777_a("minigunticks", (short)(stack.field_77990_d.func_74765_d("minigunticks") + 1));
        }
    }

    @Override
    public boolean canFire(World world, EntityLivingBase living, ItemStack stack) {
        return stack.func_77960_j() < stack.func_77958_k() && (float)stack.field_77990_d.func_74765_d("minigunticks") >= 17.0f * TF2Attribute.getModifier("Minigun Spinup", stack, 1.0f, living) || living instanceof EntityPlayer && ((EntityPlayer)living).field_71075_bZ.field_75098_d;
    }
}

