/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.weapons;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import rafradek.TF2weapons.ClientProxy;
import rafradek.TF2weapons.IWeaponItem;
import rafradek.TF2weapons.TF2Attribute;
import rafradek.TF2weapons.characters.EntityTF2Character;
import rafradek.TF2weapons.characters.IRangedWeaponAttackMob;
import rafradek.TF2weapons.weapons.ItemUsable;

public abstract class ItemRangedWeapon
extends ItemUsable
implements IWeaponItem {
    public static boolean critical;

    @Override
    public void func_77663_a(ItemStack par1ItemStack, World par2World, Entity par3Entity, int par4, boolean par5) {
        super.func_77663_a(par1ItemStack, par2World, par3Entity, par4, par5);
        if (par1ItemStack.field_77990_d != null) {
            if (par3Entity instanceof EntityPlayer && par4 != ((EntityPlayer)par3Entity).field_71071_by.field_70461_c && par1ItemStack.field_77990_d.func_74765_d("reloadd") > 0) {
                par1ItemStack.field_77990_d.func_74777_a("reloadd", (short)0);
            }
            if (!par2World.field_72995_K && par1ItemStack.field_77990_d.func_74765_d("timeleft") <= 0) {
                par1ItemStack.field_77990_d.func_74777_a("timeleft", (short)20);
                if (this.rapidFireCrits(par1ItemStack) && this.hasRandomCrits(par1ItemStack, par3Entity) && Math.random() < (double)this.critChance(par1ItemStack, par3Entity)) {
                    par1ItemStack.field_77990_d.func_74777_a("crittime", (short)40);
                }
            }
            if (par1ItemStack.field_77990_d.func_74765_d("crittime") > 0) {
                par1ItemStack.field_77990_d.func_74777_a("crittime", (short)(par1ItemStack.field_77990_d.func_74765_d("crittime") - 1));
            }
            par1ItemStack.field_77990_d.func_74777_a("timeleft", (short)(par1ItemStack.field_77990_d.func_74765_d("timeleft") - 1));
        }
    }

    @Override
    public boolean use(ItemStack stack, EntityLivingBase living, World world, EntityLivingBase target) {
        if (stack.func_77960_j() != stack.func_77958_k() && this.hasClip(stack)) {
            stack.func_77972_a(1, living);
        }
        boolean thisCritical = false;
        if (!this.rapidFireCrits(stack) && this.hasRandomCrits(stack, (Entity)living) && Math.random() < (double)this.critChance(stack, (Entity)living) || stack.field_77990_d.func_74765_d("crittime") > 0) {
            thisCritical = true;
        }
        critical = thisCritical;
        if (living instanceof IRangedWeaponAttackMob && ((IRangedWeaponAttackMob)living).getAmmo() >= 0) {
            ((IRangedWeaponAttackMob)living).useAmmo(1);
        }
        if (ItemRangedWeapon.getData(stack).containsKey("Fire Sound")) {
            String soundToPlay = ItemRangedWeapon.getData(stack).get("Fire Sound").getString() + (thisCritical ? ".crit" : "");
            world.func_72956_a((Entity)living, soundToPlay, 0.45f, 1.0f);
            if (world.field_72995_K) {
                ClientProxy.removeReloadSound(living);
            }
        }
        for (int x = 0; x < this.getWeaponPelletCount(stack, living); ++x) {
            this.shoot(stack, living, world, target, thisCritical);
        }
        return true;
    }

    public abstract void shoot(ItemStack var1, EntityLivingBase var2, World var3, EntityLivingBase var4, boolean var5);

    @Override
    public boolean canFire(World world, EntityLivingBase living, ItemStack stack) {
        boolean flag = true;
        if (living instanceof IRangedWeaponAttackMob && ((IRangedWeaponAttackMob)living).getAmmo() <= 0) {
            flag = false;
        }
        return stack.func_77960_j() < stack.func_77958_k() || living instanceof EntityPlayer && ((EntityPlayer)living).field_71075_bZ.field_75098_d;
    }

    @Override
    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par2List, boolean par4) {
        super.func_77624_a(par1ItemStack, par2EntityPlayer, par2List, par4);
        if (par1ItemStack.func_77942_o()) {
            par2List.add("Firing: " + Integer.toString(par1ItemStack.field_77990_d.func_74765_d("reload")));
            par2List.add("Reload: " + Integer.toString(par1ItemStack.field_77990_d.func_74765_d("reloadd")));
            par2List.add("Crit: " + Integer.toString(par1ItemStack.field_77990_d.func_74765_d("crittime")));
        }
        par2List.add("Clip: " + Integer.toString(par1ItemStack.func_77960_j()));
    }

    public float critChance(ItemStack stack, Entity entity) {
        float chance = 0.02f;
        if (ItemUsable.lastDamage.containsKey(entity)) {
            for (int i = 0; i < 20; ++i) {
                chance += ItemUsable.lastDamage.get(entity)[i] / 800.0f;
            }
        }
        return Math.min(chance, 0.12f);
    }

    @Override
    public boolean fireTick(ItemStack stack, EntityLivingBase living, World world) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    @Override
    public boolean altFireTick(ItemStack stack, EntityLivingBase living, World world) {
        return false;
    }

    public int getMaxDamage(ItemStack stack) {
        return stack.func_77942_o() ? this.getWeaponClipSize(stack, null) : 0;
    }

    @Override
    public float getWeaponDamage(ItemStack stack, EntityLivingBase living) {
        return (float)ItemRangedWeapon.getData(stack).get("Damage").getDouble(1.0) * TF2Attribute.getModifier("Damage", stack, 1.0f, living);
    }

    public float getWeaponMaxDamage(ItemStack stack, EntityLivingBase living) {
        return (float)ItemRangedWeapon.getData(stack).get("Max damage").getDouble(1.0) * TF2Attribute.getModifier("Damage", stack, 1.0f, living);
    }

    public float getWeaponMinDamage(ItemStack stack, EntityLivingBase living) {
        return (float)ItemRangedWeapon.getData(stack).get("Min damage").getDouble(1.0) * TF2Attribute.getModifier("Damage", stack, 1.0f, living);
    }

    public float getWeaponSpread(ItemStack stack, EntityLivingBase living) {
        float base = this.getWeaponSpreadBase(stack, living);
        if (living instanceof EntityTF2Character && ((EntityTF2Character)living).func_70638_az() != null) {
            base = (float)((double)base + ((EntityTF2Character)living).attack.lookingAtMax() * ((EntityTF2Character)living).motionSensitivity);
        }
        return Math.abs(base);
    }

    public float getWeaponSpreadBase(ItemStack stack, EntityLivingBase living) {
        return (float)(ItemRangedWeapon.getData(stack).get("Spread Recovery").getBoolean(false) && stack.field_77990_d.func_74765_d("lastfire") <= 0 ? 0.0 : ItemRangedWeapon.getData(stack).get("Spread").getDouble(1.0) * (double)TF2Attribute.getModifier("Spread", stack, 1.0f, living));
    }

    public int getWeaponPelletCount(ItemStack stack, EntityLivingBase living) {
        return (int)((float)ItemRangedWeapon.getData(stack).get("Pellets").getInt(1) * TF2Attribute.getModifier("Pellet Count", stack, 1.0f, living));
    }

    public int getWeaponDamageFalloff(ItemStack stack) {
        return ItemRangedWeapon.getData(stack).get("Damage falloff").getInt(10);
    }

    public int getWeaponReloadTime(ItemStack stack, EntityLivingBase living) {
        return (int)((float)ItemRangedWeapon.getData(stack).get("Reload time").getInt(1000) * TF2Attribute.getModifier("Reload Time", stack, 1.0f, living));
    }

    public int getWeaponFirstReloadTime(ItemStack stack, EntityLivingBase living) {
        return (int)((float)ItemRangedWeapon.getData(stack).get("Reload time first").getInt(1000) * TF2Attribute.getModifier("Reload Time", stack, 1.0f, living));
    }

    public boolean hasClip(ItemStack stack) {
        return ItemRangedWeapon.getData(stack).get("Reloads clip").getBoolean(true);
    }

    public int getWeaponClipSize(ItemStack stack, EntityLivingBase living) {
        return (int)((float)ItemRangedWeapon.getData(stack).get("Clip size").getInt(1) * TF2Attribute.getModifier("Clip Size", stack, 1.0f, living));
    }

    public boolean IsReloadingFullClip(ItemStack stack) {
        return ItemRangedWeapon.getData(stack).get("Reloads full clip").getBoolean(false);
    }

    public boolean hasRandomCrits(ItemStack stack, Entity par3Entity) {
        return par3Entity instanceof EntityPlayer && ItemRangedWeapon.getData(stack).get("Random crits").getBoolean(true);
    }

    public double getWeaponKnockback(ItemStack stack, EntityLivingBase living) {
        return (float)ItemRangedWeapon.getData(stack).get("Knockback").getInt(0) * TF2Attribute.getModifier("Knockback", stack, 1.0f, living);
    }

    public boolean rapidFireCrits(ItemStack stack) {
        return ItemRangedWeapon.getData(stack).get("Rapidfire crits").getBoolean(false);
    }
}

