/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.weapons;

import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import rafradek.TF2weapons.TF2Attribute;
import rafradek.TF2weapons.characters.EntitySniper;
import rafradek.TF2weapons.weapons.ItemBulletWeapon;

public class ItemSniperRifle
extends ItemBulletWeapon {
    public static UUID slowdownUUID = UUID.fromString("12843092-A5D6-BBCD-3D4F-A3DD4D8C65A9");
    public static AttributeModifier slowdown = new AttributeModifier(slowdownUUID, "sniper slowdown", -0.73, 2);
    public float oldSensitive;

    @Override
    public boolean canAltFire(World worldObj, EntityLivingBase player, ItemStack item) {
        return item.field_77990_d.func_74765_d("reload") <= 0;
    }

    @Override
    public boolean use(ItemStack stack, EntityLivingBase living, World world, EntityLivingBase target) {
        if (living instanceof EntityPlayer || stack.func_77978_p().func_74767_n("WaitProper")) {
            super.use(stack, living, world, target);
            this.disableZoom(stack, living);
            stack.func_77978_p().func_74757_a("WaitProper", false);
        } else {
            stack.func_77978_p().func_74757_a("WaitProper", true);
            this.altUse(stack, living, world);
            stack.field_77990_d.func_74768_a("reload", 2500);
        }
        return true;
    }

    @Override
    public void altUse(ItemStack stack, EntityLivingBase living, World world) {
        if (!stack.func_77978_p().func_74767_n("Zoomed")) {
            stack.func_77978_p().func_74757_a("Zoomed", true);
            if (living instanceof EntityPlayer && world.field_72995_K && this.oldSensitive == 0.0f) {
                this.oldSensitive = Minecraft.func_71410_x().field_71474_y.field_74341_c;
                Minecraft.func_71410_x().field_71474_y.field_74341_c *= 0.4f;
            }
            if (living.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111127_a(slowdownUUID) == null) {
                living.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(slowdown);
            }
        } else {
            this.disableZoom(stack, living);
        }
    }

    public void disableZoom(ItemStack stack, EntityLivingBase living) {
        if (living instanceof EntityPlayer && living.field_70170_p.field_72995_K && this.oldSensitive != 0.0f && stack.func_77978_p().func_74767_n("Zoomed")) {
            Minecraft.func_71410_x().field_71474_y.field_74341_c = this.oldSensitive;
            this.oldSensitive = 0.0f;
        }
        stack.func_77978_p().func_74768_a("ZoomTime", 0);
        stack.func_77978_p().func_74757_a("Zoomed", false);
        living.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111124_b(slowdown);
    }

    @Override
    public boolean canHeadshot(ItemStack stack) {
        return stack.func_77978_p().func_74762_e("ZoomTime") > 4;
    }

    @Override
    public boolean showTracer(ItemStack stack) {
        return false;
    }

    @Override
    public float getWeaponDamage(ItemStack stack, EntityLivingBase living) {
        return super.getWeaponDamage(stack, living) * this.getZoomBonus(stack, living);
    }

    @Override
    public float getWeaponMaxDamage(ItemStack stack, EntityLivingBase living) {
        return super.getWeaponMaxDamage(stack, living) * this.getZoomBonus(stack, living);
    }

    @Override
    public float getWeaponMinDamage(ItemStack stack, EntityLivingBase living) {
        return super.getWeaponMinDamage(stack, living) * this.getZoomBonus(stack, living);
    }

    public float getZoomBonus(ItemStack stack, EntityLivingBase living) {
        return 1.0f + Math.max(0.0f, (float)(stack.field_77990_d.func_74762_e("ZoomTime") - 20) / ((ItemSniperRifle.getChargeTime(stack, living) - 20.0f) / 2.0f));
    }

    public static float getChargeTime(ItemStack stack, EntityLivingBase living) {
        return 66.0f * TF2Attribute.getModifier("Charge", stack, 1.0f, living);
    }

    @Override
    public short getAltFiringSpeed(ItemStack item, EntityLivingBase player) {
        return 400;
    }

    @Override
    public void func_77663_a(ItemStack par1ItemStack, World par2World, Entity par3Entity, int par4, boolean par5) {
        super.func_77663_a(par1ItemStack, par2World, par3Entity, par4, par5);
        if (par1ItemStack.field_77990_d.func_74767_n("Zoomed")) {
            if (!par5) {
                this.disableZoom(par1ItemStack, (EntityLivingBase)par3Entity);
            } else if (par1ItemStack.func_77978_p().func_74762_e("ZoomTime") < 66) {
                par1ItemStack.func_77978_p().func_74768_a("ZoomTime", par1ItemStack.func_77978_p().func_74762_e("ZoomTime") + 1);
            }
        }
        if (par3Entity instanceof EntitySniper && ((EntitySniper)par3Entity).func_70638_az() != null && par1ItemStack.func_77978_p().func_74767_n("WaitProper") && ((EntitySniper)par3Entity).func_110143_aJ() < 8.0f && par1ItemStack.func_77978_p().func_74762_e("reload") > 250) {
            par1ItemStack.func_77978_p().func_74768_a("reload", 250);
        }
    }

    @Override
    public boolean onDroppedByPlayer(ItemStack item, EntityPlayer player) {
        super.onDroppedByPlayer(item, player);
        this.disableZoom(item, (EntityLivingBase)player);
        return true;
    }
}

