/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.accessibility.util;

import com.sun.java.accessibility.util.EventQueueMonitor;
import com.sun.java.accessibility.util.TopLevelWindowListener;
import java.awt.AWTEventMulticaster;
import java.awt.Adjustable;
import java.awt.Component;
import java.awt.Container;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AWTEventMonitor {
    private static boolean runningOnJDK1_4 = false;
    protected static Component componentWithFocus = null;
    protected static ComponentListener componentListener = null;
    protected static ContainerListener containerListener = null;
    protected static FocusListener focusListener = null;
    protected static KeyListener keyListener = null;
    protected static MouseListener mouseListener = null;
    protected static MouseMotionListener mouseMotionListener = null;
    protected static WindowListener windowListener = null;
    protected static ActionListener actionListener = null;
    protected static AdjustmentListener adjustmentListener = null;
    protected static ItemListener itemListener = null;
    protected static TextListener textListener = null;
    protected static AWTEventsListener awtListener = new AWTEventsListener();

    public static Component getComponentWithFocus() {
        return componentWithFocus;
    }

    public static void addComponentListener(ComponentListener componentListener) {
        if (AWTEventMonitor.componentListener == null) {
            awtListener.installListeners(2);
        }
        AWTEventMonitor.componentListener = AWTEventMulticaster.add(AWTEventMonitor.componentListener, componentListener);
    }

    public static void removeComponentListener(ComponentListener componentListener) {
        if ((AWTEventMonitor.componentListener = AWTEventMulticaster.remove(AWTEventMonitor.componentListener, componentListener)) == null) {
            awtListener.removeListeners(2);
        }
    }

    public static void addContainerListener(ContainerListener containerListener) {
        AWTEventMonitor.containerListener = AWTEventMulticaster.add(AWTEventMonitor.containerListener, containerListener);
    }

    public static void removeContainerListener(ContainerListener containerListener) {
        AWTEventMonitor.containerListener = AWTEventMulticaster.remove(AWTEventMonitor.containerListener, containerListener);
    }

    public static void addFocusListener(FocusListener focusListener) {
        AWTEventMonitor.focusListener = AWTEventMulticaster.add(AWTEventMonitor.focusListener, focusListener);
    }

    public static void removeFocusListener(FocusListener focusListener) {
        AWTEventMonitor.focusListener = AWTEventMulticaster.remove(AWTEventMonitor.focusListener, focusListener);
    }

    public static void addKeyListener(KeyListener keyListener) {
        if (AWTEventMonitor.keyListener == null) {
            awtListener.installListeners(6);
        }
        AWTEventMonitor.keyListener = AWTEventMulticaster.add(AWTEventMonitor.keyListener, keyListener);
    }

    public static void removeKeyListener(KeyListener keyListener) {
        if ((AWTEventMonitor.keyListener = AWTEventMulticaster.remove(AWTEventMonitor.keyListener, keyListener)) == null) {
            awtListener.removeListeners(6);
        }
    }

    public static void addMouseListener(MouseListener mouseListener) {
        if (AWTEventMonitor.mouseListener == null) {
            awtListener.installListeners(7);
        }
        AWTEventMonitor.mouseListener = AWTEventMulticaster.add(AWTEventMonitor.mouseListener, mouseListener);
    }

    public static void removeMouseListener(MouseListener mouseListener) {
        if ((AWTEventMonitor.mouseListener = AWTEventMulticaster.remove(AWTEventMonitor.mouseListener, mouseListener)) == null) {
            awtListener.removeListeners(7);
        }
    }

    public static void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        if (AWTEventMonitor.mouseMotionListener == null) {
            awtListener.installListeners(8);
        }
        AWTEventMonitor.mouseMotionListener = AWTEventMulticaster.add(AWTEventMonitor.mouseMotionListener, mouseMotionListener);
    }

    public static void removeMouseMotionListener(MouseMotionListener mouseMotionListener) {
        if ((AWTEventMonitor.mouseMotionListener = AWTEventMulticaster.remove(AWTEventMonitor.mouseMotionListener, mouseMotionListener)) == null) {
            awtListener.removeListeners(8);
        }
    }

    public static void addWindowListener(WindowListener windowListener) {
        if (AWTEventMonitor.windowListener == null) {
            awtListener.installListeners(11);
        }
        AWTEventMonitor.windowListener = AWTEventMulticaster.add(AWTEventMonitor.windowListener, windowListener);
    }

    public static void removeWindowListener(WindowListener windowListener) {
        if ((AWTEventMonitor.windowListener = AWTEventMulticaster.remove(AWTEventMonitor.windowListener, windowListener)) == null) {
            awtListener.removeListeners(11);
        }
    }

    public static void addActionListener(ActionListener actionListener) {
        if (AWTEventMonitor.actionListener == null) {
            awtListener.installListeners(0);
        }
        AWTEventMonitor.actionListener = AWTEventMulticaster.add(AWTEventMonitor.actionListener, actionListener);
    }

    public static void removeActionListener(ActionListener actionListener) {
        if ((AWTEventMonitor.actionListener = AWTEventMulticaster.remove(AWTEventMonitor.actionListener, actionListener)) == null) {
            awtListener.removeListeners(0);
        }
    }

    public static void addAdjustmentListener(AdjustmentListener adjustmentListener) {
        if (AWTEventMonitor.adjustmentListener == null) {
            awtListener.installListeners(1);
        }
        AWTEventMonitor.adjustmentListener = AWTEventMulticaster.add(AWTEventMonitor.adjustmentListener, adjustmentListener);
    }

    public static void removeAdjustmentListener(AdjustmentListener adjustmentListener) {
        if ((AWTEventMonitor.adjustmentListener = AWTEventMulticaster.remove(AWTEventMonitor.adjustmentListener, adjustmentListener)) == null) {
            awtListener.removeListeners(1);
        }
    }

    public static void addItemListener(ItemListener itemListener) {
        if (AWTEventMonitor.itemListener == null) {
            awtListener.installListeners(5);
        }
        AWTEventMonitor.itemListener = AWTEventMulticaster.add(AWTEventMonitor.itemListener, itemListener);
    }

    public static void removeItemListener(ItemListener itemListener) {
        if ((AWTEventMonitor.itemListener = AWTEventMulticaster.remove(AWTEventMonitor.itemListener, itemListener)) == null) {
            awtListener.removeListeners(5);
        }
    }

    public static void addTextListener(TextListener textListener) {
        if (AWTEventMonitor.textListener == null) {
            awtListener.installListeners(10);
        }
        AWTEventMonitor.textListener = AWTEventMulticaster.add(AWTEventMonitor.textListener, textListener);
    }

    public static void removeTextListener(TextListener textListener) {
        if ((AWTEventMonitor.textListener = AWTEventMulticaster.remove(AWTEventMonitor.textListener, textListener)) == null) {
            awtListener.removeListeners(10);
        }
    }

    static class AWTEventsListener
    implements TopLevelWindowListener,
    ActionListener,
    AdjustmentListener,
    ComponentListener,
    ContainerListener,
    FocusListener,
    ItemListener,
    KeyListener,
    MouseListener,
    MouseMotionListener,
    TextListener,
    WindowListener,
    ChangeListener {
        private Class[] actionListeners;
        private Method removeActionMethod;
        private Method addActionMethod;
        private Object[] actionArgs;
        private Class[] itemListeners;
        private Method removeItemMethod;
        private Method addItemMethod;
        private Object[] itemArgs;
        private Class[] textListeners;
        private Method removeTextMethod;
        private Method addTextMethod;
        private Object[] textArgs;
        private Class[] windowListeners;
        private Method removeWindowMethod;
        private Method addWindowMethod;
        private Object[] windowArgs;

        public AWTEventsListener() {
            String string = System.getProperty("java.version");
            if (string != null) {
                runningOnJDK1_4 = string.compareTo("1.4") >= 0;
            }
            this.initializeIntrospection();
            this.installListeners();
            if (runningOnJDK1_4) {
                MenuSelectionManager.defaultManager().addChangeListener(this);
            }
            EventQueueMonitor.addTopLevelWindowListener(this);
        }

        private boolean initializeIntrospection() {
            try {
                this.actionListeners = new Class[1];
                this.actionArgs = new Object[1];
                this.actionListeners[0] = Class.forName("java.awt.event.ActionListener");
                this.actionArgs[0] = this;
                this.itemListeners = new Class[1];
                this.itemArgs = new Object[1];
                this.itemListeners[0] = Class.forName("java.awt.event.ItemListener");
                this.itemArgs[0] = this;
                this.textListeners = new Class[1];
                this.textArgs = new Object[1];
                this.textListeners[0] = Class.forName("java.awt.event.TextListener");
                this.textArgs[0] = this;
                this.windowListeners = new Class[1];
                this.windowArgs = new Object[1];
                this.windowListeners[0] = Class.forName("java.awt.event.WindowListener");
                this.windowArgs[0] = this;
                return true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.out.println("EXCEPTION - Class 'java.awt.event.*' not in CLASSPATH");
                return false;
            }
        }

        protected void installListeners() {
            Window[] windowArray = EventQueueMonitor.getTopLevelWindows();
            if (windowArray != null) {
                for (int i = 0; i < windowArray.length; ++i) {
                    this.installListeners(windowArray[i]);
                }
            }
        }

        protected void installListeners(int n) {
            Window[] windowArray = EventQueueMonitor.getTopLevelWindows();
            if (windowArray != null) {
                for (int i = 0; i < windowArray.length; ++i) {
                    this.installListeners(windowArray[i], n);
                }
            }
        }

        protected void installListeners(Component component) {
            this.installListeners(component, 3);
            this.installListeners(component, 4);
            if (componentListener != null) {
                this.installListeners(component, 2);
            }
            if (keyListener != null) {
                this.installListeners(component, 6);
            }
            if (mouseListener != null) {
                this.installListeners(component, 7);
            }
            if (mouseMotionListener != null) {
                this.installListeners(component, 8);
            }
            if (windowListener != null) {
                this.installListeners(component, 11);
            }
            if (actionListener != null) {
                this.installListeners(component, 0);
            }
            if (adjustmentListener != null) {
                this.installListeners(component, 1);
            }
            if (itemListener != null) {
                this.installListeners(component, 5);
            }
            if (textListener != null) {
                this.installListeners(component, 10);
            }
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            this.processFocusGained();
        }

        private void processFocusGained() {
            Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (component == null) {
                return;
            }
            MenuSelectionManager.defaultManager().removeChangeListener(this);
            MenuSelectionManager.defaultManager().addChangeListener(this);
            if (component instanceof JRootPane) {
                MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
                if (menuElementArray.length > 1) {
                    Component component2 = menuElementArray[menuElementArray.length - 2].getComponent();
                    Component component3 = menuElementArray[menuElementArray.length - 1].getComponent();
                    if (component3 instanceof JPopupMenu || component3 instanceof JMenu) {
                        componentWithFocus = component3;
                    } else if (component2 instanceof JPopupMenu) {
                        componentWithFocus = component2;
                    }
                }
            } else {
                componentWithFocus = component;
            }
        }

        protected void installListeners(Component component, int n) {
            switch (n) {
                case 0: {
                    try {
                        this.removeActionMethod = component.getClass().getMethod("removeActionListener", this.actionListeners);
                        this.addActionMethod = component.getClass().getMethod("addActionListener", this.actionListeners);
                        try {
                            this.removeActionMethod.invoke((Object)component, this.actionArgs);
                            this.addActionMethod.invoke((Object)component, this.actionArgs);
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            System.out.println("Exception: " + invocationTargetException.toString());
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            System.out.println("Exception: " + illegalAccessException.toString());
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                    }
                    catch (SecurityException securityException) {
                        System.out.println("Exception: " + securityException.toString());
                    }
                    break;
                }
                case 1: {
                    if (!(component instanceof Adjustable)) break;
                    ((Adjustable)((Object)component)).removeAdjustmentListener(this);
                    ((Adjustable)((Object)component)).addAdjustmentListener(this);
                    break;
                }
                case 2: {
                    component.removeComponentListener(this);
                    component.addComponentListener(this);
                    break;
                }
                case 3: {
                    if (!(component instanceof Container)) break;
                    ((Container)component).removeContainerListener(this);
                    ((Container)component).addContainerListener(this);
                    break;
                }
                case 4: {
                    component.removeFocusListener(this);
                    component.addFocusListener(this);
                    if (runningOnJDK1_4) {
                        this.processFocusGained();
                        break;
                    }
                    if (component == componentWithFocus || !component.hasFocus()) break;
                    componentWithFocus = component;
                    break;
                }
                case 5: {
                    try {
                        this.removeItemMethod = component.getClass().getMethod("removeItemListener", this.itemListeners);
                        this.addItemMethod = component.getClass().getMethod("addItemListener", this.itemListeners);
                        try {
                            this.removeItemMethod.invoke((Object)component, this.itemArgs);
                            this.addItemMethod.invoke((Object)component, this.itemArgs);
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            System.out.println("Exception: " + invocationTargetException.toString());
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            System.out.println("Exception: " + illegalAccessException.toString());
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                    }
                    catch (SecurityException securityException) {
                        System.out.println("Exception: " + securityException.toString());
                    }
                    break;
                }
                case 6: {
                    component.removeKeyListener(this);
                    component.addKeyListener(this);
                    break;
                }
                case 7: {
                    component.removeMouseListener(this);
                    component.addMouseListener(this);
                    break;
                }
                case 8: {
                    component.removeMouseMotionListener(this);
                    component.addMouseMotionListener(this);
                    break;
                }
                case 10: {
                    try {
                        this.removeTextMethod = component.getClass().getMethod("removeTextListener", this.textListeners);
                        this.addTextMethod = component.getClass().getMethod("addTextListener", this.textListeners);
                        try {
                            this.removeTextMethod.invoke((Object)component, this.textArgs);
                            this.addTextMethod.invoke((Object)component, this.textArgs);
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            System.out.println("Exception: " + invocationTargetException.toString());
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            System.out.println("Exception: " + illegalAccessException.toString());
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                    }
                    catch (SecurityException securityException) {
                        System.out.println("Exception: " + securityException.toString());
                    }
                    break;
                }
                case 11: {
                    try {
                        this.removeWindowMethod = component.getClass().getMethod("removeWindowListener", this.windowListeners);
                        this.addWindowMethod = component.getClass().getMethod("addWindowListener", this.windowListeners);
                        try {
                            this.removeWindowMethod.invoke((Object)component, this.windowArgs);
                            this.addWindowMethod.invoke((Object)component, this.windowArgs);
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            System.out.println("Exception: " + invocationTargetException.toString());
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            System.out.println("Exception: " + illegalAccessException.toString());
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                    }
                    catch (SecurityException securityException) {
                        System.out.println("Exception: " + securityException.toString());
                    }
                    break;
                }
                default: {
                    return;
                }
            }
            if (component instanceof Container) {
                int n2 = ((Container)component).getComponentCount();
                for (int i = 0; i < n2; ++i) {
                    this.installListeners(((Container)component).getComponent(i), n);
                }
            }
        }

        protected void removeListeners(int n) {
            Window[] windowArray = EventQueueMonitor.getTopLevelWindows();
            if (windowArray != null) {
                for (int i = 0; i < windowArray.length; ++i) {
                    this.removeListeners(windowArray[i], n);
                }
            }
        }

        protected void removeListeners(Component component) {
            if (componentListener != null) {
                this.removeListeners(component, 2);
            }
            if (keyListener != null) {
                this.removeListeners(component, 6);
            }
            if (mouseListener != null) {
                this.removeListeners(component, 7);
            }
            if (mouseMotionListener != null) {
                this.removeListeners(component, 8);
            }
            if (windowListener != null) {
                this.removeListeners(component, 11);
            }
            if (actionListener != null) {
                this.removeListeners(component, 0);
            }
            if (adjustmentListener != null) {
                this.removeListeners(component, 1);
            }
            if (itemListener != null) {
                this.removeListeners(component, 5);
            }
            if (textListener != null) {
                this.removeListeners(component, 10);
            }
        }

        protected void removeListeners(Component component, int n) {
            switch (n) {
                case 0: {
                    try {
                        this.removeActionMethod = component.getClass().getMethod("removeActionListener", this.actionListeners);
                        try {
                            this.removeActionMethod.invoke((Object)component, this.actionArgs);
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            System.out.println("Exception: " + invocationTargetException.toString());
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            System.out.println("Exception: " + illegalAccessException.toString());
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                    }
                    catch (SecurityException securityException) {
                        System.out.println("Exception: " + securityException.toString());
                    }
                    break;
                }
                case 1: {
                    if (!(component instanceof Adjustable)) break;
                    ((Adjustable)((Object)component)).removeAdjustmentListener(this);
                    break;
                }
                case 2: {
                    component.removeComponentListener(this);
                    break;
                }
                case 5: {
                    try {
                        this.removeItemMethod = component.getClass().getMethod("removeItemListener", this.itemListeners);
                        try {
                            this.removeItemMethod.invoke((Object)component, this.itemArgs);
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            System.out.println("Exception: " + invocationTargetException.toString());
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            System.out.println("Exception: " + illegalAccessException.toString());
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                    }
                    catch (SecurityException securityException) {
                        System.out.println("Exception: " + securityException.toString());
                    }
                    break;
                }
                case 6: {
                    component.removeKeyListener(this);
                    break;
                }
                case 7: {
                    component.removeMouseListener(this);
                    break;
                }
                case 8: {
                    component.removeMouseMotionListener(this);
                    break;
                }
                case 10: {
                    try {
                        this.removeTextMethod = component.getClass().getMethod("removeTextListener", this.textListeners);
                        try {
                            this.removeTextMethod.invoke((Object)component, this.textArgs);
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            System.out.println("Exception: " + invocationTargetException.toString());
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            System.out.println("Exception: " + illegalAccessException.toString());
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                    }
                    catch (SecurityException securityException) {
                        System.out.println("Exception: " + securityException.toString());
                    }
                    break;
                }
                case 11: {
                    try {
                        this.removeWindowMethod = component.getClass().getMethod("removeWindowListener", this.windowListeners);
                        try {
                            this.removeWindowMethod.invoke((Object)component, this.windowArgs);
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            System.out.println("Exception: " + invocationTargetException.toString());
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            System.out.println("Exception: " + illegalAccessException.toString());
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                    }
                    catch (SecurityException securityException) {
                        System.out.println("Exception: " + securityException.toString());
                    }
                    break;
                }
                default: {
                    return;
                }
            }
            if (component instanceof Container) {
                int n2 = ((Container)component).getComponentCount();
                for (int i = 0; i < n2; ++i) {
                    this.removeListeners(((Container)component).getComponent(i), n);
                }
            }
        }

        @Override
        public void topLevelWindowCreated(Window window) {
            this.installListeners(window);
        }

        @Override
        public void topLevelWindowDestroyed(Window window) {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionListener != null) {
                actionListener.actionPerformed(actionEvent);
            }
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            if (adjustmentListener != null) {
                adjustmentListener.adjustmentValueChanged(adjustmentEvent);
            }
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
            if (componentListener != null) {
                componentListener.componentHidden(componentEvent);
            }
        }

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
            if (componentListener != null) {
                componentListener.componentMoved(componentEvent);
            }
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            if (componentListener != null) {
                componentListener.componentResized(componentEvent);
            }
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
            if (componentListener != null) {
                componentListener.componentShown(componentEvent);
            }
        }

        @Override
        public void componentAdded(ContainerEvent containerEvent) {
            this.installListeners(containerEvent.getChild());
            if (containerListener != null) {
                containerListener.componentAdded(containerEvent);
            }
        }

        @Override
        public void componentRemoved(ContainerEvent containerEvent) {
            this.removeListeners(containerEvent.getChild());
            if (containerListener != null) {
                containerListener.componentRemoved(containerEvent);
            }
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            componentWithFocus = (Component)focusEvent.getSource();
            if (focusListener != null) {
                focusListener.focusGained(focusEvent);
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            componentWithFocus = null;
            if (focusListener != null) {
                focusListener.focusLost(focusEvent);
            }
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemListener != null) {
                itemListener.itemStateChanged(itemEvent);
            }
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyListener != null) {
                keyListener.keyPressed(keyEvent);
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            if (keyListener != null) {
                keyListener.keyReleased(keyEvent);
            }
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            if (keyListener != null) {
                keyListener.keyTyped(keyEvent);
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseListener != null) {
                mouseListener.mouseClicked(mouseEvent);
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            if (mouseListener != null) {
                mouseListener.mouseEntered(mouseEvent);
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (mouseListener != null) {
                mouseListener.mouseExited(mouseEvent);
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseListener != null) {
                mouseListener.mousePressed(mouseEvent);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseListener != null) {
                mouseListener.mouseReleased(mouseEvent);
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (mouseMotionListener != null) {
                mouseMotionListener.mouseDragged(mouseEvent);
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (mouseMotionListener != null) {
                mouseMotionListener.mouseMoved(mouseEvent);
            }
        }

        @Override
        public void textValueChanged(TextEvent textEvent) {
            if (textListener != null) {
                textListener.textValueChanged(textEvent);
            }
        }

        @Override
        public void windowOpened(WindowEvent windowEvent) {
            if (windowListener != null) {
                windowListener.windowOpened(windowEvent);
            }
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            if (windowListener != null) {
                windowListener.windowClosing(windowEvent);
            }
        }

        @Override
        public void windowClosed(WindowEvent windowEvent) {
            if (windowListener != null) {
                windowListener.windowClosed(windowEvent);
            }
        }

        @Override
        public void windowIconified(WindowEvent windowEvent) {
            if (windowListener != null) {
                windowListener.windowIconified(windowEvent);
            }
        }

        @Override
        public void windowDeiconified(WindowEvent windowEvent) {
            if (windowListener != null) {
                windowListener.windowDeiconified(windowEvent);
            }
        }

        @Override
        public void windowActivated(WindowEvent windowEvent) {
            if (windowListener != null) {
                windowListener.windowActivated(windowEvent);
            }
        }

        @Override
        public void windowDeactivated(WindowEvent windowEvent) {
            if (windowListener != null) {
                windowListener.windowDeactivated(windowEvent);
            }
        }
    }
}

