/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webpane.webkit.dom;

import com.sun.webpane.platform.Disposer;
import com.sun.webpane.platform.DisposerRecord;
import org.w3c.dom.css.Counter;

public class CounterImpl
implements Counter {
    protected final long contextPeer;
    protected final long rootPeer;
    protected final long peer;

    CounterImpl(long peer, long contextPeer, long rootPeer) {
        this.peer = peer;
        this.contextPeer = contextPeer;
        this.rootPeer = rootPeer;
        Disposer.addRecord(this, new SelfDisposer(peer));
    }

    static Counter create(long peer, long contextPeer, long rootPeer) {
        if (peer == 0L) {
            return null;
        }
        return new CounterImpl(peer, contextPeer, rootPeer);
    }

    long getPeer() {
        return this.peer;
    }

    static long getPeer(Counter arg) {
        return arg == null ? 0L : ((CounterImpl)arg).getPeer();
    }

    public boolean equals(Object that) {
        return that instanceof CounterImpl && this.peer == ((CounterImpl)that).peer;
    }

    public int hashCode() {
        long p = this.peer;
        return (int)(p ^ p >> 17);
    }

    private static native void dispose(long var0);

    static Counter getImpl(long peer, long contextPeer, long rootPeer) {
        return CounterImpl.create(peer, contextPeer, rootPeer);
    }

    @Override
    public String getIdentifier() {
        return CounterImpl.getIdentifierImpl(this.getPeer());
    }

    static native String getIdentifierImpl(long var0);

    @Override
    public String getListStyle() {
        return CounterImpl.getListStyleImpl(this.getPeer());
    }

    static native String getListStyleImpl(long var0);

    @Override
    public String getSeparator() {
        return CounterImpl.getSeparatorImpl(this.getPeer());
    }

    static native String getSeparatorImpl(long var0);

    static class SelfDisposer
    implements DisposerRecord {
        private final long peer;

        SelfDisposer(long peer) {
            this.peer = peer;
        }

        @Override
        public void dispose() {
            CounterImpl.dispose(this.peer);
        }
    }
}

