// This is an Unreal Script
class X2Ability_AssassinAbilitySet extends X2Ability config(AssassinAbilities);

static function array<X2DataTemplate> CreateTemplates()
{
	local array<X2DataTemplate> Templates;

	Templates.AddItem(ShadowVeil());
	Templates.AddItem(ShadowDash());
	//Templates.AddItem(Lethality());
	Templates.AddItem(Snapshot());

	Templates.AddItem(AddExecutionerAbility());

	return Templates;
}

//Shadow Veil +10 Dodge
static function X2AbilityTemplate ShadowVeil()
{
	local X2AbilityTemplate						Template;
	local X2Effect_PersistentStatChange         Dodge;

	// Icon Properties
	`CREATE_X2ABILITY_TEMPLATE(Template, 'ShadowVeil');
	Template.IconImage = "img:///UILibrary_PerkIcons.UIPerk_leap";

	Template.AbilitySourceName = 'eAbilitySource_Perk';
	Template.eAbilityIconBehaviorHUD = EAbilityIconBehavior_NeverShow;
	Template.Hostility = eHostility_Neutral;

	Template.AbilityToHitCalc = default.DeadEye;
	Template.AbilityTargetStyle = default.SelfTarget;
	Template.AbilityTriggers.AddItem(default.UnitPostBeginPlayTrigger);

	Dodge = new class'X2Effect_PersistentStatChange';
	Dodge.AddPersistentStatChange(eStat_Dodge, 10);
	Dodge.BuildPersistentEffect(1, true, false, false);
	Dodge.SetDisplayInfo(ePerkBuff_Passive, Template.LocFriendlyName, Template.GetMyLongDescription(), Template.IconImage,,,Template.AbilitySourceName);
	Template.AddTargetEffect(Dodge);
	Template.SetUIStatMarkup(class'XLocalizedData'.default.DodgeLabel, eStat_Dodge, 10);

	Template.BuildNewGameStateFn = TypicalAbility_BuildGameState;
	//  NOTE: No visualization on purpose!
	Template.bCrossClassEligible = true;

	return Template;
}

//Shadow Dash +5 Mobility
static function X2AbilityTemplate ShadowDash()
{
	local X2AbilityTemplate						Template;
	local X2Effect_PersistentStatChange         Mobility;

	// Icon Properties
	`CREATE_X2ABILITY_TEMPLATE(Template, 'ShadowDash');
	Template.IconImage = "img:///UILibrary_PerkIcons.UIPerk_stickandmove";

	Template.AbilitySourceName = 'eAbilitySource_Perk';
	Template.eAbilityIconBehaviorHUD = EAbilityIconBehavior_NeverShow;
	Template.Hostility = eHostility_Neutral;

	Template.AbilityToHitCalc = default.DeadEye;
	Template.AbilityTargetStyle = default.SelfTarget;
	Template.AbilityTriggers.AddItem(default.UnitPostBeginPlayTrigger);

	Mobility = new class'X2Effect_PersistentStatChange';
	Mobility.AddPersistentStatChange(eStat_Mobility, 5);
	Mobility.BuildPersistentEffect(1, true, false, false);
	Mobility.SetDisplayInfo(ePerkBuff_Passive, Template.LocFriendlyName, Template.GetMyLongDescription(), Template.IconImage,,,Template.AbilitySourceName);
	Template.AddTargetEffect(Mobility);
	Template.SetUIStatMarkup(class'XLocalizedData'.default.DodgeLabel, eStat_Mobility, 5);

	Template.BuildNewGameStateFn = TypicalAbility_BuildGameState;
	//  NOTE: No visualization on purpose!
	Template.bCrossClassEligible = true;

	return Template;
}

//Quickshot Skill

static function X2AbilityTemplate Snapshot()
{
	local X2AbilityTemplate                 Template;
	local X2AbilityToHitCalc_StandardAim    ToHitCalc;
	local X2Condition_Visibility            TargetVisibilityCondition;
	local X2AbilityCost_Ammo                AmmoCost;
	local X2AbilityCost_ActionPoints        ActionPointCost;

	Template= new(None, string('Snapshot')) class'X2AbilityTemplate'; Template.SetTemplateName('Snapshot');;;

	Template.IconImage = "img:///UILibrary_PerkIcons.UIPerk_snapshot";
	Template.AbilitySourceName = 'eAbilitySource_Perk';
	Template.eAbilityIconBehaviorHUD = eAbilityIconBehavior_AlwaysShow;
	Template.Hostility = eHostility_Offensive;
	Template.ShotHUDPriority = class'UIUtilities_Tactical'.const.CLASS_CAPTAIN_PRIORITY;
	Template.AbilityConfirmSound = "TacticalUI_ActivateAbility";

	Template.TargetingMethod = class'X2TargetingMethod_OverTheShoulder';
	Template.bUsesFiringCamera = true;
	Template.CinescriptCameraType = "StandardGunFiring";

	ToHitCalc = new class'X2AbilityToHitCalc_StandardAim';
	ToHitCalc.FinalMultiplier = 0.4f;
	Template.AbilityToHitCalc = ToHitCalc;

	AmmoCost = new class'X2AbilityCost_Ammo';
	AmmoCost.iAmmo = 1;
	Template.AbilityCosts.AddItem(AmmoCost);

	ActionPointCost = new class'X2AbilityCost_ActionPoints';
	ActionPointCost.iNumPoints = 1;
	ActionPointCost.bConsumeAllPoints = true;
	Template.AbilityCosts.AddItem(ActionPointCost);

	Template.AbilityTargetStyle = default.SimpleSingleTarget;
	Template.AbilityTriggers.AddItem(default.PlayerInputTrigger);

	Template.AbilityShooterConditions.AddItem(default.LivingShooterProperty);
	Template.AddShooterEffectExclusions();

	TargetVisibilityCondition = new class'X2Condition_Visibility';
	TargetVisibilityCondition.bRequireGameplayVisible = true;
	TargetVisibilityCondition.bAllowSquadsight = true;
	Template.AbilityTargetConditions.AddItem(TargetVisibilityCondition);
	Template.AbilityTargetConditions.AddItem(default.LivingHostileTargetProperty);

	//  Put holo target effect first because if the target dies from this shot, it will be too late to notify the effect.
	Template.AddTargetEffect(class'X2Ability_GrenadierAbilitySet'.static.HoloTargetEffect());
	Template.AddTargetEffect(class'X2Ability_GrenadierAbilitySet'.static.ShredderDamageEffect());

	Template.bAllowAmmoEffects = true;

	Template.BuildNewGameStateFn = TypicalAbility_BuildGameState;
	Template.BuildVisualizationFn = TypicalAbility_BuildVisualization;

	Template.bCrossClassEligible = true;

	return Template;
}

//Lethality +2 DMG on Critical Strikes
//static function X2AbilityTemplate Lethality()
//{
//	local X2AbilityTemplate						Template;
//	local X2Effect_BonusWeaponDamage            DamageEffect;

	// Icon Properties
//	`CREATE_X2ABILITY_TEMPLATE(Template, 'Lethality');
//	Template.IconImage = "img:///UILibrary_PerkIcons.UIPerk_bringemon"; //Icon?

//	Template.AbilitySourceName = 'eAbilitySource_Perk';
//	Template.eAbilityIconBehaviorHUD = EAbilityIconBehavior_NeverShow;
//	Template.Hostility = eHostility_Neutral;

//	Template.AbilityToHitCalc = default.DeadEye;
//	Template.AbilityTargetStyle = default.SelfTarget;
//	Template.AbilityTriggers.AddItem(default.UnitPostBeginPlayTrigger);

	// BUFF PLAYER ATTACK w/ SHOTS
//	DamageEffect = new class'X2Effect_BonusWeaponDamage';
//	DamageEffect.BonusDmg = 2;
//	DamageEffect.BuildPersistentEffect(1, true, false, false);
//	DamageEffect.SetDisplayInfo(ePerkBuff_Passive, Template.LocFriendlyName, Template.GetMyLongDescription(), Template.IconImage, true,,Template.AbilitySourceName);
//	Template.AddTargetEffect(DamageEffect);

//	Template.BuildNewGameStateFn = TypicalAbility_BuildGameState;
	//  NOTE: No visualization on purpose!
//	Template.bCrossClassEligible = true;

//	return Template;
//}

//******** Executioner Ability (GTS) **********

static function X2AbilityTemplate AddExecutionerAbility()
{
	local X2AbilityTemplate						Template;
	local X2AbilityTargetStyle                  TargetStyle;
	local X2AbilityTrigger						Trigger;
	local X2Effect_ToHitModifier                ToCriModifier;
	local X2Effect_PersistentStatChange         MobilityGTS;

	`CREATE_X2ABILITY_TEMPLATE(Template, 'Executioner');
	Template.IconImage = "img:///UILibrary_PerkIcons.UIPerk_killerinstinct";

	Template.AbilitySourceName = 'eAbilitySource_Perk';
	Template.eAbilityIconBehaviorHUD = EAbilityIconBehavior_NeverShow;
	Template.Hostility = eHostility_Neutral;

	Template.AbilityToHitCalc = default.DeadEye;

	TargetStyle = new class'X2AbilityTarget_Self';
	Template.AbilityTargetStyle = TargetStyle;

	Trigger = new class'X2AbilityTrigger_UnitPostBeginPlay';
	Template.AbilityTriggers.AddItem(Trigger);

		// INCREASE CHANCE TO CRI
	ToCriModifier = new class'X2Effect_ToHitModifier';
	ToCriModifier.BuildPersistentEffect(1, true, true, true);
	ToCriModifier.SetDisplayInfo(ePerkBuff_Passive, Template.LocFriendlyName, Template.GetMyLongDescription(), Template.IconImage,,,Template.AbilitySourceName);
	ToCriModifier.AddEffectHitModifier(eHit_Crit, 5, Template.LocFriendlyName, /*StandardCri*/, false, true, true, true);
	Template.AddTargetEffect(ToCriModifier);

	MobilityGTS = new class'X2Effect_PersistentStatChange';
	MobilityGTS.AddPersistentStatChange(eStat_Mobility, 3);
	MobilityGTS.BuildPersistentEffect(1, true, false, false);
	Template.AddTargetEffect(MobilityGTS);
	Template.SetUIStatMarkup(class'XLocalizedData'.default.MobilityLabel, eStat_Mobility, 3);

	Template.BuildNewGameStateFn = TypicalAbility_BuildGameState;
	//  NOTE: No visualization on purpose!

	return Template;
}
