// This is an Unreal Script
class X2StrategyElement_AcademyUnlocksAssassin extends X2StrategyElement;   //Class Data

static function array<X2DataTemplate> CreateTemplates()
{
	local array<X2DataTemplate> Templates;
		
	Templates.AddItem(Executioner());   //Skill Data

	return Templates;
}

static function X2SoldierAbilityUnlockTemplate Executioner()   //Skill Data
{
	local X2SoldierAbilityUnlockTemplate Template;
	local ArtifactCost Resources;

	`CREATE_X2TEMPLATE(class'X2SoldierAbilityUnlockTemplate', Template, 'Executioner');   //Skill Data

	Template.AllowedClasses.AddItem('Assassin');   //Class Data
	Template.AbilityName = 'Executioner';   //Skill Data
	Template.strImage = "img:///UILibrary_StrategyImages.GTS.GTS_Vengeance"; //Icon

	// Requirements
	Template.Requirements.RequiredHighestSoldierRank = 5;
	Template.Requirements.RequiredSoldierClass = 'Assassin';   //Class Data
	Template.Requirements.RequiredSoldierRankClassCombo = true;
	Template.Requirements.bVisibleIfSoldierRankGatesNotMet = true;

	// Cost
	Resources.ItemTemplateName = 'Supplies';
	Resources.Quantity = 75;
	Template.Cost.ResourceCosts.AddItem(Resources);

	return Template;
}