﻿FUI.ns("FSE.common", "FSE.common.Config", "FSE.common.PcFunction", "FSE.data", "FSE.dialog", "FSE.editor", "FSE.resources", 'FSE.common.fetionConnect', 'FSE.common.FeedManager', 'FCE.common');

FSE.dialog = FUI.create(FUI.widget.Dialog, {
	_buildHTML: function() {
		return [
            '<div class="layer_link" >',
            '<div class="layer_title" id="' + this.opt.titleId + '"><a href="javascript:void(0);" class="close" id="' + this.opt.closeId + '"></a></div>',
            '<div class="layer_m_cont" id="' + this.opt.contentId + '">',
            '</div>',
            '<div class="layer_button" id="' + this.opt.buttonsId + '">',
            '<span id="' + this.opt.msgId + '"  class="notice"></span>',
            '</div></div>'].join("");
	},
	createButton: function(buttons) {
		var i = 1, idPre = "fse_dialog_", self = this;
		for (var key in buttons) {
			var button = document.createElement("button");
			button.id = idPre + key;
			button.className = "l_n_button";
			button.onclick = this._buttonClick(buttons[key]["handler"], self);
			button.innerHTML = buttons[key]["label"];
			this.buttonContainer.appendChild(button);
			i++;
		}
	},
	setTitle: function(c) {
		$(this.title).prepend(c);
	},
	setMsg: function(msg) {
		document.getElementById(this.opt.msgId).innerHTML = msg;
	}

});

FSE.dialog.alert = function(message) {
	var html = '<div class="info_l_cont"><span class="i_symbol"></span><strong>' + message + '</strong></div>';
	var self = this;
	new FSE.dialog(html, {
		width: 371,
		height: 150,
		title: '提示',
		autoAdjust: false,
		containerId: "alert_containerId",
		titleId: 'alert_titleId',
		contentId: 'alert_contentId',
		buttonsId: 'alert_buttonsId',
		msgId: 'alert_msgId',
		closeId: 'link_closeId',
		modal: true,
		zIndex: 10010,
		align: "center",
		buttons: {
			ok: {
				label: "确定",
				handler: function(me) {
					me.hide();
					return false;
				}
			}
		}
	});
};

FSE.dialog.messageBox = function(message, ok, cancel) {
	var html = '<div class="info_l_cont"><span class="i_symbol"></span><strong>' + message + '</strong></div>';
	var self = this;
	new FSE.dialog(html, {
		width: 371,
		height: 150,
		title: '提示',
		autoAdjust: false,
		containerId: "message_containerId",
		containerId: "message_containerId",
		titleId: 'message_titleId',
		contentId: 'message_contentId',
		buttonsId: 'message_buttonsId',
		msgId: 'message_msgId',
		closeId: 'message_closeId',
		modal: true,
		zIndex: 10012,
		align: "center",
		buttons: {
			cancel: {
				label: "取消",
				handler: cancel || function(me) { me.hide(); return false; }
			},
			ok: {
				label: "确定",
				handler: ok || function(me) { me.hide(); return false; }
			}
		}
	});
};

FSE.tab = FUI.create({
	init: function(content, opt) {
		this.opt = opt || {};
		this.opt.items = this.opt.items || [];
		this.items = {};
		this.currentTabId = "";
		this.selectedClass = this.opt.selectedClass || "current";
		this.initControl();
	},
	initControl: function() {
		for (var i = 0; i < this.opt.items.length; i++) {
			var item = this.opt.items[i];
			if (this.currentTabId == "") {
				this.currentTabId = item.tabId;
			}
			if (this.currentTabId == item.tabId) {
				$("#" + item.tabId).addClass(this.selectedClass);
				$("#" + item.containerId).show();
			} else {
				$("#" + item.tabId).removeClass(this.selectedClass);
				$("#" + item.containerId).hide();
			}
			this.addTab(item);
		}
	},
	addTab: function(item) {
		var self = this;
		var tabId = item.tabId;
		this.items[tabId] = item;
		$("#" + tabId).click(function() {
			self.setCurrentTab(this.id);
		});
	},
	setCurrentTab: function(tabId) {
		if (this.currentTabId != tabId) {
			var selectedTab = this.items[this.currentTabId];
			if (selectedTab) {
				$("#" + selectedTab.tabId).removeClass(this.selectedClass);
				$("#" + selectedTab.containerId).hide();
			}
			var tab = this.items[tabId];
			$("#" + tabId).addClass(this.selectedClass);
			$("#" + tab.containerId).show();
			this.currentTabId = tabId;
		}
	}
});
// 默认浏览器打开URL带上C
FSE.common.openUrl = function(url) {
	if (url == '') {
		return;
	}
	var c = encodeURIComponent(FSE.common.PcFunction.c_credentials());
	window.open(url.indexOf('?') > 0 ? (url + '&c=' + c) : (url + '?c=' + c));
	return false;
};

FSE.resources = {
	ajaxReqError: '无法连接到服务器，请稍后再试！',
	offlineError: '无法连接到服务器，请稍后再试！'
};

FSE.common.getQueryString = function(name) {
	var reg = new RegExp("(^|\\?|&)" + name + "=([^&]*)(\\s|&|$)", "i");
	if (reg.test(location.href))
		return unescape(RegExp.$2.replace(/\+/g, " "));
	return "";
};

FSE.common.getClientVars = function(name) {
	return FSE.common.getQueryString('cv');
};
// 统计打开次数
FSE.common.watracer = function() {
	//if (!FSE.common.Config.w_a) {
	//    return;
	//}
	var initImg = new Image(), strArr = [], d = document, s = window.screen, fs = typeof fx_pagestart != 'undefined' && fx_pagestart || 0, lh = 'http://space.feixin.10086.cn/spaceditor', eu = encodeURIComponent;
	strArr = ['url=' + eu(lh), 'referrer=' + '', 'sw=' + s.width, 'sh=' + s.height, 'sc=' + s.colorDepth, 'urlIdentity=/space/pceditoronload', 'lastmode=' + Math.random(), 'pageloadtime=0'];
	initImg.onload = function() {
		initImg.onload = null;
		initImg.onerror = null;
	};
	initImg.onerror = function() {
		initImg.onload = null;
		initImg.onerror = null;
	};

	initImg.src = "http://wa.feixin.10086.cn/pv.ashx?" + strArr.join('&');
};

(function() {
	// 定义所有和PC接口
	FSE.common.PcFunction = {
		// 主动关闭窗口
		c_close: function() {
			window.external.CloseSpaceEditor();
		},
		// 公用获取用户登录凭证
		c_credentials: function() {
			return window.external.GetM161Credentials();
		},
		// 判断用户是否在线
		// return IsOnline
		c_isOnline: function() {
			// TODO: 客户端TAB上没有该方法
			return window.external.IsOnline();
			//return true;
		},

		// 插入图片 
		// param m:boolean 是否是选择多图
		// return:image path
		m_insertImage: function(m) {
			return window.external.InsertImage(m);
		},
		// 插入截屏
		// return : image path
		m_insertCaptureImage: function() {
			return window.external.InsertCaptureImage();
		},
		// 获取图片的BASE64
		// param: 图片的地址
		// 返回图片base64
		m_getImageBase64: function(path) {
			return window.external.GetImageBase64(path.replace("file:///", ""));
		},
		// 激活编辑器窗口
		// param:1：流言飞语 2：上传照片 3：
		t_openEditor: function(t) {
			window.external.OpenSpaceEditorWnd(t);
		},
		// 激活回复窗口
		t_openCommentWindow: function(t) {
			window.external.ReplyMoodPhrase(t);
		},

		// 通知PC用户已经刷新获取最新动态
		t_tabRefresh: function() {
			window.external.SetDynamicRead();
		},

		// PC动态调用我们这边的方法
		// Refresh: function(version) {
		//     console.log("刷新动态还没有实现");
		// },
		TryClose: function() {
			return true;
		},
		SetTab: function(t) {
			console.log("设置对应Tab还没有实现");
		}
	};

	/*****
	* 需要定义全局的关闭是内容验证
	* 如果正在上传数据，应该有对应提示
	*****/

	/***获取所有配置文件
	*获取所有配置文件
	//我传给你的参数：credention
	//---微博
	// 获取推荐位数据连接地址：”m_r”         //”m_region”:”http://space.fetion.com.cn”
	// iframe页面地址           “m_u”           //“m_userInfo”:””
	// 发送留言飞语地址        “m_s”           //“m_sendmoon”:””
	// 获取用户Id地址           “m_g”           //“m_getuserid”:””
	// "我以前的"连接地址      “m_p”           //“m_prevmoon”:””
	// "统计代码添加"             "w_a"
	//--上传照片
	// 获取照片分类地址         “p_g”            //“p_getcategory”:””  
	// 上传照片地址             “p_u”            //“p_upload”:””
	// 创建相册地址             “p_c”             //“p_createcategoryl”:””
	// 获取相册剩余空间地址     “p_l”        
	//
	//-- 日志
	// 日志分类获取地址         “b_gc”
	// 日志分类创建地址         “b_cc”
	// 相册获取对应分类内图片   “b_gp”
	*  日志创建地址             	 “b_c”
	* 
	*  用户动态获取最新		 	"t_l"  	参数:version,credention 			返回：html
	*  用户动态根据版本号获取50条 	"t_t"	参数:version,n(条数),credention		返回：html，最好一条id
	*  用户动态根据Id获取后10条   	"t_o"	参数:id,n(条数),credention			返回：html,最后一条Id
	* 
	* 动态设置 d_d
	* 写流言飞语 d_l
	* 飞语默认信息 mood
	***/

	//$(document).ready(function() {
	$.ajax({
		url: "http://space.feixin.10086.cn/client/geturl",
		type: "get",
		data: { "c": FSE.common.PcFunction.c_credentials() },
		//async: false,
		dataType: "json",
		success: function(data) {
			if (data.Code.IsSuccess) {
				FSE.common.Config = data.Result;
			}
			FSE.common.Config.GlobalInit = data.Code.IsSuccess;
		},
		error: function(msg) {
			//FSE.dialog.alert('获取初始化数据失败！');
			// 全局初始化失败 TODO: 所有元素都需要判断该元素是否初始化成功
			FSE.common.Config.GlobalInit = false;
		}
	});
	// });

	FSE.data.common = {
		Ajax: function(opt) {
			// 判断用户是否在线
			if (FSE.common.PcFunction.c_isOnline()) {
				var c = FSE.common.PcFunction.c_credentials();
				opt.self = opt.self || this;
				opt.data = opt.data || {};
				opt.data.c = c;
				opt.data.rad = Math.random();
				opt.dataType = opt.dataType || 'json';
				var errorCallBack = opt.error || null;

				opt.error = function() {
					if (errorCallBack) {
						errorCallBack.call(this, FSE.resources.ajaxReqError);
					} else {
						FSE.dialog.alert(FSE.resources.ajaxReqError);
					}
				};

				$.ajax(opt);
			}
			else {
				if (opt.error) {
					opt.error.call(this, FSE.resources.offlineError);
				} else {
					FSE.dialog.alert(FSE.resources.offlineError);
				}
			}
		},
		Get: function(opt) {
			opt.type = 'get';
			this.Ajax(opt);
		},
		Post: function(opt) {
			opt.type = 'post';
			this.Ajax(opt);
		}
	};

	// 流言飞语数据相关操作
	FSE.data.moond = {
		// 上传留言飞语和图片 返回新上传的内容和结果
		create: function(opt) {
			opt.url = FSE.common.Config.m_s;
			FSE.data.common.Post(opt);
		},
		// 获取微博推荐内容数据
		getRegionData: function(opt) {
			opt.url = FSE.common.Config.m_r;
			FSE.data.common.Get(opt);
		}
	};

	FSE.data.photo = {
		// 获取相册分类
		getCategorys: function(opt) {
			opt.url = FSE.common.Config.p_g;
			FSE.data.common.Get(opt);
		},
		// 创建相册分类
		createCategory: function(opt) {
			opt.url = FSE.common.Config.p_c;
			FSE.data.common.Post(opt);
		},
		// 获取相册剩余空间
		getExcess: function(opt) {
			opt.url = FSE.common.Config.p_l;
			FSE.data.common.Get(opt);
		},
		// 获取相册内图片列表
		getPhotos: function(opt) {
			opt.url = FSE.common.Config.b_gp;
			FSE.data.common.Get(opt);
		},
		// 创建相片
		createPhoto: function(opt) {
			opt.url = FSE.common.Config.p_u;
			FSE.data.common.Post(opt);
		},
		//创建动态
		createDynamic: function(opt) {
			opt.url = FSE.common.Config.e_u;
			FSE.data.common.Post(opt);
		}
	};

	FSE.data.blog = {
		// 获取日志分类
		getCategory: function(opt) {
			opt.url = FSE.common.Config.b_gc;
			FSE.data.common.Get(opt);
		},
		// 创建日志分类 
		createCategory: function(opt) {
			opt.url = FSE.common.Config.b_cc;
			FSE.data.common.Post(opt);
		},
		// 创建日志
		createArticle: function(opt) {
			opt.url = FSE.common.Config.b_c;
			FSE.data.common.Post(opt);
		}
	};

	FSE.data.tab = {
		// *  用户动态获取最新		 	"t_l"  	参数:version,credention 			返回：html
		// *  用户动态根据版本号获取50条 	"t_t"	参数:version,n(条数),credention		返回：html，最好一条id
		// *  用户动态根据Id获取后10条   	"t_o"	参数:id,n(条数),credention			返回：html,最后一条Id
		// 根据版本号获取最新50条
		getByVersion: function(opt) {
			opt.url = FSE.common.Config.t_l;
			FSE.data.common.Get(opt);
		},
		// 鼠标下拉获取以前版本的10条
		getByMinId: function(opt) {
			opt.url = FSE.common.Config.t_o;
			FSE.data.common.Get(opt);
		},
		// 跟进版本号获取之后新增
		getNewByVersion: function(opt) {
			opt.url = FSE.common.Config.t_t;
			FSE.data.common.Get(opt);
		}
	}

})();

FSE.common.positionCursor = function(input, position) {
	var range;
	range = input.createTextRange();
	range.collapse(true);
	range.moveStart('character', position);
	range.select();
};

String.prototype.format = function() {
	var args = arguments;
	return this.replace(/\{\{|\}\}|\{(\d+)\}/g, function(m, n) {
		if (m == "{{") { return "{"; }
		if (m == "}}") { return "}"; }
		return args[n];
	});
};

// 聚享公用
FCE.common = {

	domain: 'http://i2.feixin.10086.cn',
	portraitdomain: 'http://i-imgh.fetionpic.com',
	resdomain: 'http://i-res.fetionpic.com',
	picturedomain: 'http://i-imgp.fetionpic.com',
	wadomain: 'http://wa.feixin.10086.cn',

	clientdomain: function(){
		var t = this;
		if(window.parent.userprofile){
			return t.domain+'/feedclient/'+window.parent.userprofile.profile.userId;
		}
		else if(userprofile){
			return t.domain+'/feedclient/'+userprofile.profile.userId;
		}
	},
	getQueryString : function(name) {
		var reg = new RegExp("(^|\\?|&)" + name + "=([^&]*)(\\s|&|$)", "i");
		if (reg.test(location.href))
			return unescape(RegExp.$2.replace(/\+/g, " "));
		return "";
	},
	getClientVars :function() {
		var cv = this.getQueryString('cv');
		if (cv == '')
			return 0;
		cv = cv.replace(/\./g, '');
		for (var i = 0; i < 7 - cv.length; i++) {
			cv += 0;
		}
		return cv.substring(0, 5);
	},
	loadCss:function(cssname){
		var ua = window.navigator.userAgent;
		var isVistaWin7 = ua.indexOf("Windows NT 6.0") > -1 || ua.indexOf("Windows NT 6.1") > -1;
		// && this.getClientVars() >= 43100
		if (isVistaWin7 ) {
			document.writeln('<link href="css/'+cssname+'.css" rel="stylesheet" type="text/css" />');
		} else {
			document.writeln('<link href="css/'+cssname+'xp.css" rel="stylesheet" type="text/css" />');
		}
	},
	//加载用户头像
	loadPortrait: function(str) {
		if (str.indexOf("http:") == 0) {
			return str;
		}
		else {
			if (str.indexOf("/") == 0)
				return this.portraitdomain + str;
			else
				return this.portraitdomain + "/" + str;
		}
	},
	//加载用户头像
	loadPicture: function(str) {
		if (str.indexOf("http:") == 0) {
			return str;
		}
		else {
			if (str.indexOf("/") == 0)
				return this.picturedomain + str;
			else
				return this.picturedomain + "/" + str;
		}
	},
	// 关闭聚享window
	closeJuxiangWnd: function() {
		window.external.CloseJuxiangWnd();
	},
	// 刷新聚享Tab
	refreshJuxiangTab: function(obj) {
		window.external.RefreshJuxiangTab(obj);
	},
	// 获取客户端版本
	getClientVersion: function() {
		return window.external.GetClientVersion();
	},
	// 打开发送微博接口 useOldWnd：bool true:旧,false：新
	showFlySmsWnd: function(useOldWnd) {
		window.external.ShowFlySmsWnd(1, useOldWnd);
		//window.external.ShowFlySmsWnd(useOldWnd);
	},
	// 打开新评论转发窗口p:链接地址  http://i.fx-dev.com/client/feed/[feedkey]?c={Credential}，t:Title, w:width, h:heigth
	weiboShowPopup: function(p, t, w, h) {
		window.external.WeiboShowPopup(p, t, w, h);
	},
	// 获取登录凭证
	getc: function() {
		return window.external.GetM161Credentials();
	},
	// 打开新页面，会带上最新的C
	openUrl: function(url) {
		FSE.common.openUrl(url);
	},
	// 统计系统PV统计
	watracerPV: function(urlIdentity) {
		var initImg = new Image(), strArr = [], d = document, s = window.screen, fs = typeof fx_pagestart != 'undefined' && fx_pagestart || 0, lh = 'http://i.feixin.10086.cn/pceditor', eu = encodeURIComponent;
		strArr = ['url=' + eu(lh), 'referrer=' + '', 'sw=' + s.width, 'sh=' + s.height, 'sc=' + s.colorDepth, 'urlIdentity=' + urlIdentity, 'lastmode=' + Math.random(), 'pageloadtime=0'];
		initImg.onload = function() {
			initImg.onload = null;
			initImg.onerror = null;
		};
		initImg.onerror = function() {
			initImg.onload = null;
			initImg.onerror = null;
		};

		initImg.src = this.wadomain + "/pv.ashx?" + strArr.join('&');
	},
	watracerReg: function(regid, userid) {
		var initImg = new Image(), querystring = ['regid=' + regid, 'waiid=' + userid, 'wasud=' + userid, 'isspace=0', 'lastmode=' + Math.random(), 'linkindex=0'];
		initImg.onload = function() {
			initImg.onload = null;
			initImg.onerror = null;
		};
		initImg.onerror = function() {
			initImg.onload = null;
			initImg.onerror = null;
		};

		initImg.src = this.wadomain + '/reg.ashx?' + querystring.join('&');
	},
	// 空间动态、聚享切换
	loadToggle: function(tabw, slide, menulist) {
		var timer;
		tabw.bind('click', function() { tabw.toggleClass('sd'); });
		tabw.mouseover(function() { $(this).addClass('hvr'); });
		tabw.mouseout(function() { $(this).removeClass('hvr'); });
		$.each(menulist.find('li'), function(i, v) {
			var item = $(v);
			$(v).bind('mouseover', function() { item.addClass('h'); }).bind('mouseout', function() { item.removeClass('h'); });
		});
		tabw.bind('mouseout', function() { timer = setTimeout(function() { tabw.removeClass('sd'); }, 600); }).bind('mouseover', function() { clearTimeout(timer); });
	},
	openLocal: function(option) {
		if (/(.*?)[^\/]+\.htm[l]?/gi.test(location.href)) {
			var url = RegExp.$1 + option.url;
			this.weiboShowPopup(url, option.title, option.width, option.height);
		}
	},
	// 处理@用户问题
	fixSummaryLink: function() {
		var t = this;
		$.each($('a[uid]'), function(i, v) {
			if (v.href.indexOf('file') == 0) {
				var link = t.domain + '/' + v.uid;
				v.href = 'javascript:void(0);';
				v.onclick = function() { FSE.common.openUrl(link); };
			}
			else {
				if (v.href.indexOf('http://') == 0) {
					v.target = '_blank';
				}
			}
		});
	},
	formatTime: function(time, onlineTime) {
		if (!time)
			return '';
		var diff = this.computeTime(onlineTime, time);
		var minute = 1000 * 60, hour = minute * 60, day = hour * 24;
		if (diff < minute)
			return '刚刚';
		else if (diff < hour)
			return parseInt(diff / minute) + '分钟前';
		else if (diff < day)
			return parseInt(diff / hour) + '小时前';
		else {
			var d = this.parseDate(time);
			return this.dateFormat(d, 'yyyy-MM-dd hh:mm');
		}
	},
	parseDate: function(source) {
		var reg = new RegExp("^\\d+(\\-|\\/)\\d+(\\-|\\/)\\d+\x24");
		if ('string' == typeof source) {
			if (reg.test(source) || isNaN(Date.parse(source))) {
				var d = source.split(/ |T/),
		d1 = d.length > 1
				? d[1].split(/[^\d]/)
				: [0, 0, 0],
		d0 = d[0].split(/[^\d]/);
				return new Date(d0[0] - 0,
					d0[1] - 1,
					d0[2] - 0,
					d1[0] - 0,
					d1[1] - 0,
					d1[2] - 0);
			}
			else {
				return new Date(source);
			}
		}

		return new Date();
	},
	dateFormat: function(date, format) {
		var o = {
			"M+": date.getMonth() + 1,
			"d+": date.getDate(),
			"h+": date.getHours(),
			"m+": date.getMinutes(),
			"s+": date.getSeconds(),
			"q+": Math.floor((date.getMonth() + 3) / 3),
			"S": date.getMilliseconds()
		};

		if (/(y+)/.test(format)) {
			format = format.replace(RegExp.$1, (date.getFullYear() + "").substr(4 - RegExp.$1.length));
		}

		for (var k in o) {
			if (new RegExp("(" + k + ")").test(format)) {
				format = format.replace(RegExp.$1, RegExp.$1.length == 1 ? o[k] : ("00" + o[k]).substr(("" + o[k]).length));
			}
		}

		return format;
	},
	computeTime: function(now, d) {
		return (this.parseDate(now) - this.parseDate(d));
	},
	// 修正所有的a链接click事件，加上Credention
	fixHref: function() {
		var t = this;

		$.each($("a[href^='http://']"), function(i, v) {
			if (v.href.indexOf(FCE.common.domain) == 0) {
				if (v.href.indexOf('?c=') < 0) {
					var link = v.href;
					v.href = 'javascript:void(0);';
					v.onclick = function() { FSE.common.openUrl(link); };
				}
			}
			else {
				if (v.href.indexOf('http://') == 0) {
					v.target = '_blank';
				}
			}
		});
	},
	alinkEventHandler: function(e) {
		var t = this;
		var v = e.originalTarget || e.Target || e.srcElement;

		if (v.tagName == 'A' || v.parentNode.tagName == 'A') {
			if (v.tagName != 'A' && v.parentNode.tagName == 'A') {
				v = v.parentNode;
			}
			var url = encodeURI($(v).attr('href'));
		
			if (url.indexOf(FCE.common.domain) == 0) {
				var c = encodeURIComponent(FSE.common.PcFunction.c_credentials());
				window.open(url.indexOf('?') > 0 ? (url + '&c=' + c) : (url + '?c=' + c));
				e.preventDefault();
				return false;
			}
			else {
				if (url.indexOf('http://') == 0) {
					window.open(url);
					e.preventDefault();
					return false;
				}
			}

		}
	}
};
function fnBind(func, scope) {
	var xargs = arguments.length > 2 ? [].slice.call(arguments, 2) : null;
	return function() {
		var fn = func,
        args = (xargs) ? xargs.concat([].slice.call(arguments, 0)) : arguments;
		return fn.apply(scope || fn, args);
	};
}

function trace(obj) {
	var result = [];
	for (var k in obj)
		result.push(k + ':' + obj[k] + '\r\n');
	result = result.join('');
	alert(result);
}

var toJson = (function() {
	var escapeMap = {
		"\b": '\\b',
		"\t": '\\t',
		"\n": '\\n',
		"\f": '\\f',
		"\r": '\\r',
		'"': '\\"',
		"\\": '\\\\'
	};
	function encodeString(source, pure) {
		if (/["\\\x00-\x1f]/.test(source)) {
			source = source.replace(
                    /["\\\x00-\x1f]/g,
                    function(match) {
                    	var c = escapeMap[match];
                    	if (c) {
                    		return c;
                    	}
                    	c = match.charCodeAt();
                    	return "\\u00"
                                + Math.floor(c / 16).toString(16)
                                + (c % 16).toString(16);
                    });
		}
		if (pure)
			return source;
		return '"' + source + '"';
	}
	function encodeArray(source) {
		var result = ["["],
                        l = source.length,
                        preComma, i, item;
		for (i = 0; i < l; i++) {
			item = source[i];
			switch (typeof item) {
				case "undefined":
				case "function":
				case "unknown":
					break;
				default:
					if (preComma) {
						result.push(',');
					}
					result.push(toJson(item));
					preComma = 1;
			}
		}
		result.push("]");
		return result.join("");
	}
	function pad(source) {
		return source < 10 ? '0' + source : source;
	}
	function encodeDate(source) {
		return '"' + source.getFullYear() + "-"
                        + pad(source.getMonth() + 1) + "-"
                        + pad(source.getDate()) + "T"
                        + pad(source.getHours()) + ":"
                        + pad(source.getMinutes()) + ":"
                        + pad(source.getSeconds()) + '"';
	}
	return function(value) {
		switch (typeof value) {
			case 'undefined':
				return 'undefined';
			case 'number':
				return isFinite(value) ? String(value) : "null";
			case 'string':
				return encodeString(value);
			case 'boolean':
				return String(value);
			default:
				if (value === null) {
					return 'null';
				} else if (value instanceof Array) {
					return encodeArray(value);
				} else if (value instanceof Date) {
					return encodeDate(value);
				} else {
					var result = ['{'],
                    encode = toJson,
                    preComma,
                    item;
					for (var key in value) {
						if (Object.prototype.hasOwnProperty.call(value, key)) {
							item = value[key];
							switch (typeof item) {
								case 'undefined':
								case 'unknown':
								case 'function':
									break;
								default:
									if (preComma) {
										result.push(',');
									}
									preComma = 1;
									result.push(encodeString(key, true) + ':' + encode(item));
							}
						}
					}
					result.push('}');
					return result.join('');
				}
		}
	};
})();

function makePageParam(value) {
	return value.replace(/[^a-zA-Z0-9\u4E00-\u9FA5~!\*\(\)\-_'\.]+/gi, function(a, b, c, d) {
		return encodeURIComponent(a);
	});
}

function getPageParam(key) {
	var search = location.search;
	if (new RegExp('(?:\\?|&)' + key + '\\=([^&]*)(?:&|$)', 'gi').test(search))
		return decodeURIComponent(RegExp.$1);
	else
		return '';
}

function stripTags(source) {
	return String(source || '').replace(/<[^>]+>/g, '');
}

function reslove(data) {
	return eval('(' + data + ')');
}

function setCursor(control, position) {
	if (typeof position == 'undefined')
		position = control.value.length - 1;
	if (control.setSelectionRange) {
		control.focus();
		control.setSelectionRange(position, position);
	}
	else if (control.createTextRange) {
		var range = control.createTextRange();
		range.collapse(true);
		range.moveEnd('character', position);
		range.moveStart('character', position);
		range.select();
	}
}

function getOriginFeed(obj) {
	if (obj.category == 'status:republish')
		return obj.object;
	else
		return obj;
}

function needSync(feedData, forward) {
	if (forward && feedData.category == 'status:republish')
        feedData = feedData.object;
		
	var serviceId = 0, source = feedData.source.permalink.toLowerCase(), result = '';
	 if (source.indexOf('http://weibo.com') >= 0)
		serviceId = 2;
	else if (source.indexOf('http://t.sohu.com') >= 0)
		serviceId = 7;
	else if (source.indexOf('http://t.163.com') >= 0)
		serviceId = 5;
	else if (source.indexOf('http://shequ.10086.cn') >= 0)
		serviceId = 25;
	else if (source.indexOf('http://t.qq.com') >= 0)
		serviceId = 4;
	else if (source.indexOf('http://renren.com') >= 0 && !forward)
		serviceId = 26;
	else if (source.indexOf('http://www.kaixin001.com') >= 0 && !forward)
		serviceId = 3;

	if (serviceId)
		$.each(parent.userprofile.services, function(i, s) {
			if (s.serviceId == serviceId) {
				result = s.serviceName;
				return false;
			}
		});
	return result;
}

function getCommentParams(obj) {
	var origin = obj;  //getOriginFeed(obj);
	var s = FUI.lan.string.stripTags(origin.summary ? origin.summary : origin.object.summary);
	var data = { i: origin.feedId,
		a: origin.author.portrait ? FCE.common.loadPortrait(origin.author.portrait) : FCE.common.loadPortrait('/img/public/head50.jpg'),
		n: origin.author.name,
		h: origin.author.homepage,
		s: FUI.lan.string.byteTruncate(FUI.lan.string.stripTags(origin.summary ? origin.summary : origin.object.summary), 50, 48, '...'),
		ui: parent.userprofile.profile.userId
	};
	var sync = needSync(origin,false);
	if (sync)
		data.y = sync;
	return data;
}

function getForwardParams(obj) {
	var origin = getOriginFeed(obj);
	var data = { i: origin.feedId || origin.id,
		a: origin.author.portrait ? FCE.common.loadPortrait(origin.author.portrait) : FCE.common.loadPortrait('/img/public/head50.jpg'),
		n: origin.author.name,
		h: origin.author.homepage,
		s: FUI.lan.string.byteTruncate(FUI.lan.string.stripTags(origin.object.summary), 50, 48, '...'),
		c: obj.summary ? (obj.author.id ? '||@' + obj.author.id + '：' : '||@' + FUI.lan.string.unescapeHTML(obj.author.name) + '：') + FUI.lan.string.unescapeHTML(FUI.lan.string.stripTags(obj.summary)) : '',
		u: origin.author.id,
		ui: parent.userprofile.profile.userId
	};
	var sync = needSync(origin,true);
	if (sync)
		data.y = sync;
	return data;
}

function getRevertParams(obj) {
	return { i: obj.feedId,
		a: obj.userPortrait ? FCE.common.loadPortrait(obj.userPortrait) : FCE.common.loadPortrait('/img/public/head50.jpg'),
		n: obj.userName,
		s: FUI.lan.string.byteTruncate(FUI.lan.string.stripTags(obj.content), 50, 48, '...'),
		c: '@' + obj.userId + '：',
		h: '/'+ obj.userId,
		ui: parent.userprofile.profile.userId
	};
}

//V11