﻿FUI.ns('FCS.PcApp');
FCS.PcApp.Feed = {
	feeds: {},
	duration: 0,
	timeSpan: 60000,
	init: function() {
		var t = this;
		this.startTime = new Date();
		this.timeThread = 0;
		t.timeThread = window.setTimeout(function() { t.resetTime(); }, t.timeSpan);
	},
	resetTime: function() {
		var t = this;
		window.clearTimeout(t.timeThread);
		t.duration++;
		t.startTime.setMinutes(t.startTime.getMinutes() + 1);
		$("a[et='timer']").each(function() {
			var obj = $(this);
			var time = t.formatTime(obj.attr('ev'));
			obj.html(time);
		});

		t.timeThread = window.setTimeout(function() { t.resetTime(); }, t.timeSpan);
	},
	stringToTime: function(str) {
		var year = Number(str.substring(0, 4));
		var month = Number(str.substring(5, 7));
		var day = Number(str.substring(8, 10));
		var hour = Number(str.substring(11, 13));
		var minute = Number(str.substring(14, 16));
		var second = Number(str.substring(17, 19));
		return new Date(year, month-1, day, hour, minute, second);
	},
	getFeedPage: function(id) {
		return FCE.common.domain + "/feed/" + id;
	},
	formatContent: function(obj) {
		var summary = '';
		var attechment = '';

		switch (obj.category) {
			case 'status:publish':
				summary = obj.object.summary;
				attechment = this.formatPreview(obj, obj.feedId);
				break;
			case 'status:republish':
				summary = obj.summary;
				attechment = this.formatForward(obj);
				break;
			default:
				break;
		}

		if (attechment.length > 0) {
			attechment = '<div class="c">' + attechment + '</div>';
		}

		var published = this.formatTime(obj.published);
		var feedPage = this.getFeedPage(obj.feedId);
		var content = ['<div class="t"><a href="{0}" class="" target="_blank" regid="401492" hideFocus="true">{1}</a><span class="time">',
		'<a href="{5}" target="_blank" class="" et="timer" ev="{4}" regid="401492" hideFocus="true">{2}</a>',
		'<a href="{5}" target="_blank" class="" et="detail" style="display:none" regid="401492" hideFocus="true">查看详情</a>',
		'</span><p><span class="sys">{3}</span></p></div>'].join('')
						.format(this.formatAuthorHomepage(obj.author.homepage), obj.author.name, published, summary, obj.published, feedPage);
		content += attechment;

		return content;
	},
	formatAuthorHomepage: function(homepage) {
		if (homepage.indexOf("http") == 0) {
			return homepage;
		}
		else {
			return FCE.common.domain + homepage;
		}
	},
	formatForward: function(obj) {
		if (obj.object.status && obj.object.status == 2) {
			var content = ['<div class="quote">',
							'<div class="c">',
								'<p>',
								'<span class="userz">此新鲜事已被原作者删除</span></p>',
							'</div>',
						'</div>'].join('');
			return content;
		}
		else {
			var attechment = this.formatPreview(obj.object, obj.feedId);
			var published = this.formatTime(obj.object.published);
			var feedPage = this.getFeedPage(obj.object.id);
			var authHome = this.formatAuthorHomepage(obj.object.author.homepage);
			var content = ['<div class="quote">',
							'<div class="c">',
								'<p><span class="sys"><a href="{3}" target="_blank" regid="401492" hideFocus="true">{2}</a>：</span>',
								'<span class="userz">{0}</span></p>',
								'{1}',
							'</div>',
						'</div>'].join('')
						.format(obj.object.object.summary,
						attechment,
						obj.object.author.name,
						authHome);
			return content;
		}
	},
	formatPreview: function(obj, feedId) {
		var attechment = '';
		if (typeof (obj.object.photo) != 'undefined') {
			attechment += this.formatPicture(obj.object, feedId);
		}
		if (typeof (obj.object.video) != 'undefined') {
			attechment += this.formatVideo(obj.object, feedId);
		}

		if (attechment.length > 0) {
			var content = '<div class="preview">{0}</div>'.format(attechment);
			return content;
		}

		return '';
	},
	formatPicture: function(obj, feedId) {
		var feedPage = this.getFeedPage(feedId);
		var img = new Image();
		img.src = FCE.common.loadPicture(obj.photo.thumbnail);
		var imgwidth = "";
		if (img.width > 130) {
			imgwidth = ' width="130"';
		}

		var content = '<div class="feedimg"><a href="{1}" target="_blank" regid="401492" hideFocus="true"><img src="{0}"{2}></a></div>'
						.format(FCE.common.loadPicture(obj.photo.thumbnail), feedPage, imgwidth);
		return content;
	},
	formatVideo: function(obj, feedId) {
		var feedPage = this.getFeedPage(feedId);
		var content = '<div class="feedimg"><a class="m" href="{1}" target="_blank" regid="401492" hideFocus="true"><img src="{0}"><em class="play">play</em></a></div>'
						.format(FCE.common.loadPicture(obj.video.thumbnail), feedPage);
		return content;
	},
	formatPortrait: function(obj) {
		var content = '<div class="extra upic"><a href="{0}" target="_blank" regid="401492" hideFocus="true"><img src="{1}" alt=""></a></div>'.format(this.formatAuthorHomepage(obj.author.homepage), FCE.common.loadPortrait(obj.author.portrait));
		return content;
	},
	formatBottom: function(obj) {
		var commentCount = this.formatNumber(obj.commentCount);
		var forwardCount = this.formatNumber(obj.forwardCount);
		var favourCount = this.formatNumber(obj.favourCount);
		var favourTitle = obj.isFavour ? "你已经喜欢过这条内容啦" : "喜欢";
		var content = ['<div class="b">',
									'<div class="feedinf">',
										'<div class="attr">',
											'<span class="from"><a title="{3}" href="{4}" target="_blank" regid="401493" hideFocus="true">{3}</a></span>',
										'</div>',
										'<div class="inf">',
											'<span class="digwp"><a href="javascript:void(0);" et="favour" title="{5}" regid="401641" hideFocus="true"><em class="ico ' + (obj.isFavour ? 'idigged' : 'idigg') + '"></em><i et="favourcount">{2}</i></a></span>',
											'<span><a href="javascript:void(0);" et="forward" title="转发给好友" regid="401640" hideFocus="true"><em class="ico iquote"></em><i et="forwardcount">{1}</i></a></span>',
											'<span><a href="javascript:void(0);" et="comment" title="输入评论" regid="401494" hideFocus="true"><em class="ico icomment"></em><i et="commentcount">{0}</i></a></span>{6}',
										'</div>',
									'</div>',
								'</div>'].join('').format(commentCount, forwardCount, favourCount, obj.source.title, obj.source.permalink, favourTitle,this.formatDeleteFeed(obj));
		return content;
	},
	formatItem: function(obj) {
		if (this.feeds.hasOwnProperty(obj.feedId))
			return null;

		this.feeds[obj.feedId] = obj;
		var content = '<li class="gride48m0" feedid="{3}"><div class="main ufeed"><div class="mainw">{0}{1}</div></div>{2}</li>'
        .format(this.formatContent(obj), this.formatBottom(obj), this.formatPortrait(obj), obj.feedId);
		var item = $(content);
		$(item).find("a[uid]").each(function() {
			var uid = $(this).attr('uid');
			$(this).attr('href', FCE.common.domain + "/" + uid);
			$(this).attr('target', '_blank');
		});

		item.mouseover(function() {
			$(this).find("a[et='timer']").hide();
			$(this).find("a[et='detail']").show();
			$(this).find("a[et='deletefeed']").show();
		});

		item.mouseout(function() {
			$(this).find("a[et='timer']").show();
			$(this).find("a[et='detail']").hide();
			$(this).find("a[et='deletefeed']").hide();
		});

		var t = this;
		item.find("a[et='deletefeed']").click(function(){
			$("#delete_popup").show();
			$("#popupmask").show();
			t.current_delete_feed_id = obj.feedId;
		});
		item.find("a[et='comment']").click(function() {
			var params = getCommentParams(obj);
			params = toJson(params);
			var queryString = makePageParam(params);
			FCE.common.openLocal({ url: "comment.htm?fc=" + queryString,
				title: "评论",
				width: 376,
				height: 182
			});
		});
		item.find("a[et='forward']").click(function() {
			var params = getForwardParams(obj);
			params = toJson(params);
			var queryString = makePageParam(params);
			FCE.common.openLocal({ url: "forward.htm?fc=" + queryString,
				title: "转发",
				width: 376,
				height: 182
			});
		});
		item.find("a[et='favour']").click(function() {
			var s = $(this);

			if (obj.isFavour) {
				return false;
			}
			else {
				$.ajax({
					url: FCE.common.clientdomain()+ '/feedoperation/addfavour',
					type: "POST",
					data: { feedId: obj.feedId,
						category: obj.category
					},
					dataType: "json",
					cache: false,
					success: function() {
						t.feeds[obj.feedId].favourCount++;
						t.feeds[obj.feedId].isFavour = true;
						var favourCount = t.formatNumber(t.feeds[obj.feedId].favourCount);
						s.find("i[et='favourcount']").html(favourCount);
						s.find("em").removeClass('idigg').addClass('idigged');
						s.attr("title", "你已经喜欢过这条内容啦");
					},
					error: function() {
					}
				});
			}
			s.blur();
		});
		return item;
	},
	formatNumber: function(num) {
		if (typeof (num) == "undefined") {
			return "";
		}
		var max = 99;
		if (num == 0)
			return '';
		else if (num > max)
			return '(' + max + '+)';
		else
			return '(' + num + ')';
	},
	formatTime: function(dateFormate) {
		var d = this.stringToTime(dateFormate);
		var val = Math.round((this.startTime - d) / 60000);
		if (val <= 1) {
			return '刚刚';
		}
		else if (val > 1 && val < 60) {
			return val + "分钟前";
		}
		else if (val >= 60 && val < 1440) {
			return Math.round(val / 60) + "小时前";
		}

		return FCE.common.dateFormat(d, 'yyyy-MM-dd hh:mm');
	},
	addComment: function(feedId) {
		this.feeds[feedId].commentCount++;
		var commentCount = this.formatNumber(this.feeds[feedId].commentCount);
		$("li[feedId='" + feedId + "']").find("i[et='commentcount']").html(commentCount);
	},
	addForward: function(obj) {
		var profile = parent.userprofile.profile;

		obj.author = {
			name: profile.nickname,
			portrait: profile.portraitTiny,
			homepage: '/' + profile.userId,
			id: profile.userId
		};
		obj.source = {
			title: "\u98de\u4fe1PC\u5ba2\u6237\u7aef",
			permalink: "http://feixin.10086.cn/download/pcclient/",
			icon: "/img/temp/network_links.png"
		};

		this.feeds[obj.object.id].forwardCount++;
		var forwardCount = this.formatNumber(this.feeds[obj.object.id].forwardCount);

		$("li[feedId='" + obj.object.id + "']").find("i[et='forwardcount']").html(forwardCount);

		return obj;
	},
	// 删除feed组件
	formatDeleteFeed:function(obj){
		if(obj.author.id == parent.userprofile.profile.userId){
			return '<span><a href="javascript:void(0);" title="删除" et="deletefeed" fid="{0}" class="del">删除</a></span>'.format(obj.object.id);
		}
		else
		{
			return '';
		}
		// delete LINK http://juxiang.com/feedoperation/deletefeed  参数：feedid
	},
	deleteFeed:function(){
		var t = this;
		var id = t.current_delete_feed_id;
		if(id){
			var url = FCE.common.clientdomain()+'/feedoperation/deletefeed';
			$.ajax({
				url: url,
				type: "GET",
				data: {feedid:id},
				dataType: "json",
				success: function(obj) {
					$("li[feedId='" + id + "']").hide();
					$("#delete_popup").hide();
					$("#popupmask").hide();
					t.current_delete_feed_id = null;
				},
				error:function(){
				}
			});
		}
	},
	cancelDeleteFeed:function(){
		$("#delete_popup").hide();
		$("#popupmask").hide();
		this.current_delete_feed_id = null;
	}
};

FCS.PcApp.NavBar = {
	homePage: 0,
	atmePage: 1,
	commentPage: 2,
	notifyUrl: FCE.common.clientdomain() + '/notify/systemmessage?callback=?',
	accessHandler: 0,
	init: function(page) {
		this.feedsPannel = $('#feedsPanel');
		this.render(page);
		this.bind(page);
	},
	homeLinkHandler: null,
	atmeLinkHandler: null,
	commentLinkHandler: null,
	render: function(page) {
		var html = ['<div class="toolbar clearfix">',
			'<a href="javascript:" class="tweet" title="发布" id="publishBtn" regid="401643" hideFocus="true">发 布</a>',
			'<div class="microtab">',
				'<div class="tabw" id="tabw" regid="401648">',
					'<a href="javascript:void(0);" class="" hidefocus="true" title="新鲜事" hideFocus="true"><em class="ico current open"></em><em class="ico slide" id="slide"></em></a>',
					'<ul id="menulist">',
						'<li class="c" title="新鲜事" onclick="window.location.href=\'index.htm?cv=4.5.4\';" hideFocus="true"><em class="ico open"></em></li>',
						'<li title="空间" onclick="window.location.href=\'space.htm?cv=4.5.4\';" hideFocus="true"><em class="ico space"></em></li>',
					'</ul>',
				'</div>',
			'</div>',
			'<div class="tools">',
				'<a href="juxiang.htm" id="homeLinkBtn" title="我的首页" class="ico home" regid="401644" hideFocus="true">' + (page == this.homePage ? '<em class="ico triw"></em>' : '') + '</a>',
				'<a href="atme.htm" id="atmeLinkBtn" title="提到我的" class="ico at" regid="401645" hideFocus="true">' + (page == this.atmePage ? '<em class="ico triw"></em>' : '') + '</a>',
				'<a href="commentme.htm" id="commentLinkBtn" title="评论我的" class="ico words" regid="401646" hideFocus="true">' + (page == this.commentPage ? '<em class="ico triw"></em>' : '') + '</a>',
				'<a href="javascript:void(0);" title="刷新" class="ico refresh" id="refreshBtn" regid="401647" hideFocus="true"></a>',
			'</div>',
		'</div>'].join('');

		var navcontent = $(html);
		this.feedsPannel.prepend(navcontent);
	},
	bind: function(page) {
		var t = this;
		$("#publishBtn").click(function() { FCE.common.showFlySmsWnd(false) });
		$("#publishweibo").click(function() { FCE.common.showFlySmsWnd(false) });
		
		$("#refreshBtn").click(function() { location.reload(); });
		FCE.common.loadToggle($('#tabw'), $('#slide'), $('#menulist'));
		this.accessHandler = window.setTimeout(function() { t.request() }, 20000);
	},
	request: function() {
		window.clearTimeout(this.accessHandler);
		var t = this;
		$.ajax({
			url: this.notifyUrl,
			type: "GET",
			data: {},
			dataType: "jsonp",
			cache: false,
			success: function(obj) {
				var atmeCount = Number(obj.new_at_count || 0);
				var commentCount = Number(obj.new_comment_count || 0);
				var newFeedCount = Number(obj.new_feed_count || 0);

				if (newFeedCount > 0) {
					$("#homeLinkBtn").prepend('<em class="ico dot"></em>');
					$("#homeLinkBtn").attr('title', '你有{0}条新消息'.format(newFeedCount));
					if (t.homeLinkHandler) {
						$("#homeLinkBtn").click(t.homeLinkHandler);
					}
				}
				else {
					if (t.homeLinkHandler) {
						$("#homeLinkBtn").unbind('click', t.homeLinkHandler);
					}
				}

				if (atmeCount > 0) {
					$("#atmeLinkBtn").prepend('<em class="ico dot"></em>');
					$("#atmeLinkBtn").attr('title', '提到我的\r\n{0}条新动态'.format(atmeCount));
				}

				if (commentCount > 0) {
					$("#commentLinkBtn").prepend('<em class="ico dot"></em>');
					$("#commentLinkBtn").attr('title', '评论我的\r\n{0}条新动态'.format(commentCount));
				}
			},
			error: function() {

			}
		});
		this.accessHandler = window.setTimeout(function() { t.request() }, 30000);
	}
};
// 统计系统PV统计
FCS.PcApp.watracer = {
	PV: function(url, urlIdentity) {
		var initImg = new Image(), strArr = [], d = document, s = window.screen, fs = typeof fx_pagestart != 'undefined' && fx_pagestart || 0, lh = url, eu = encodeURIComponent;
		strArr = ['url=' + eu(lh), 'referrer=' + '', 'sw=' + s.width, 'sh=' + s.height, 'sc=' + s.colorDepth, 'urlIdentity=' + urlIdentity, 'lastmode=' + Math.random(), 'pageloadtime=0'];
		initImg.onload = function() {
			initImg.onload = null;
			initImg.onerror = null;
		};
		initImg.onerror = function() {
			initImg.onload = null;
			initImg.onerror = null;
		};

		initImg.src = FCE.common.wadomain + "/pv.ashx?" + strArr.join('&');
	},
	reg: function(e) {
		var item = this.getEventTarget(e);
		while (true) {
			if (item.regid) {
				FCE.common.watracerReg(item.regid, parent.userprofile.profile.userId);
				break;
			}

			item = item.parentNode;

			if (!item) {
				break;
			}
		}
	},
	getEventTarget: function(e) {
		return e.originalTarget || e.Target || e.srcElement;
	}
}

$(document).ready(function() {
	$(document).bind("contextmenu", function(e) {
		return false;
	});
	if ($("#feedsPanel").get(0) != null) {
		var cheight = 27;

		if ($("#servbindpanel").get(0) != null) {
			cheight = 50;
		}
		parent.resizeHandler = function(height) {
			$("#feedsPanel").height(height - cheight);
		};
		parent.resizeIframe();
	}

});