﻿FUI.ns('FCS.PcApp');
var userId;
FCS.PcApp.Comment = {
	init: function() {
		this.load();
		this.render();
		this.compose();
		this.bind();
		this.startup();
	},

	load: function() {
		//var userid = getCookieUserId();
		//setCookieUserId('',-1);
		var fc = getPageParam('fc');
		this.data = reslove(fc);
		userId = this.data.ui;

		this.limit = 140;
		this.urlConfig = { 'addComment': FCE.common.domain+'/feedclient/'+userId+ '/feedoperation/addcomment' };
		if (this.data.h.indexOf('http') < 0)
		    this.data.h = FCE.common.domain + this.data.h;
	},

	render: function() {
	    $('#avatar').html('<img src="' + this.data.a + '" class="uface" />').attr({ 'href': this.data.h, 'target': '_blank' });
	    $('#nickname').html(this.data.n).attr({ 'href': this.data.h, 'target': '_blank' });
		$('#summary').html(this.data.s);
		this.content = $('#content');
		this.counter = $('#counter');
		this.send = $('#send');
		this.syncCheck = $('#syncCheck');
		if (this.data.y) {
			$('#syncLabel').text('同时评论到' + this.data.y);
			this.syncCheck.attr('checked', true);
			$('#sync').show();
		}
		if (this.data.c) {
			this.send.text('回复');
			this.content.val(this.data.c);
		}
		this.content.focus();
	},

	compose: function() {

	},

	bind: function() {
		var t = this;
		this.checkHandler = fnBind(this.checkCounter, this);
		var pasteHandler = function() { setTimeout(t.checkHandler, 100); };
		this.content.bind('keyup', this.checkHandler);
		this.content.bind('paste', pasteHandler);
		this.content.bind('cut', pasteHandler);
		this.send.bind('click', fnBind(this.submit, this));
		this.content.bind('keypress', fnBind(function(evt)
		{
		    if (evt.ctrlKey && evt.keyCode == 10)
		        this.submit();
		}, this));
	},

	startup: function() {
		this.checkCounter();
		if (this.data.c)
			setCursor(this.content[0], this.data.c.length);
	},

	checkCounter: function() {
		var fakeLink = '超链接占位符';
		var content = FUI.lan.string.trim(this.content.val());
		content = content.replace(/(http|https):\/\/[a-zA-Z0-9]+(\.[a-zA-Z0-9]+)+([-A-Z0-9a-z\$\.\+\!\_\*\(\)\/\,\:;@&=\?~#%]*)*/gi, fakeLink);
		var contentLength = Math.round(FUI.lan.string.byteLength(content) / 2);
		var diff = contentLength - this.limit, caption;
		if (diff > 0)
			caption = '超出<i class="overtop">' + diff + '</i>字';
		else
			caption = '还可以输入<i>' + Math.abs(diff) + '</i>字';
		this.counter.html(caption);
		return diff <= 0;
	},

	submit: function() {
		var t = this;
		var fakeLink = '超链接占位符';
		var content = FUI.lan.string.trim(this.content.val());
		content = content.replace(/(http|https):\/\/[a-zA-Z0-9]+(\.[a-zA-Z0-9]+)+([-A-Z0-9a-z\$\.\+\!\_\*\(\)\/\,\:;@&=\?~#%]*)*/gi, fakeLink);
		var contentLength = Math.round(FUI.lan.string.byteLength(content) / 2);
		if (contentLength == 0)
			return;
		var diff = contentLength - this.limit, caption;
		if (diff > 0)
			return;
		$.ajax({
			url: this.urlConfig.addComment,
			type: "POST",
			data: { 'feedId': this.data.i,'sourceId':6, 'content': FUI.lan.string.trim(this.content.val()), 'synctosource': this.syncCheck.attr('checked') ? 1 : 0 },
			dataType: "json",
			cache: false,
			success: function(obj) {
				if (!this.data.c)
					FCE.common.refreshJuxiangTab('{type:"comment",object:{feedId:"' + t.data.i + '"}}');
				FCE.common.closeJuxiangWnd();
			},
			error: function() {

			}
		});
	}
};

FUI.ns('FCS.PcApp');
FCS.PcApp.Forward = {
	init: function() {
		this.load();
		this.render();
		this.compose();
		this.bind();
		this.startup();
	},

	load: function() {
		var fc = getPageParam('fc');
		this.data = reslove(fc);
		userId = this.data.ui;
		this.limit = 140;
		this.urlConfig = { 'forward': FCE.common.domain +'/feedclient/'+userId+ '/feedoperation/forward' };
		if (this.data.h.indexOf('http') < 0)
		    this.data.h = FCE.common.domain + this.data.h;
	},

	render: function() {
	    $('#summary').html(this.data.s);
	    $('#nickname').html(this.data.n).attr({ 'href': this.data.h, 'target': '_blank' });
		$('#avatar').html('<img src="' + this.data.a + '" class="uface" />').attr({ 'href': this.data.h, 'target': '_blank' });
		this.content = $('#content');
		this.counter = $('#counter');
		this.send = $('#send');
		var content = this.data.c;
		//        if (this.data.userId && content)
		//            content = '||@' + this.data.userId + '：' + content;
		this.syncCheck = $('#syncCheck');
		if (this.data.y) {
			$('#syncLabel').text('同时转发到' + this.data.y);
			this.syncCheck.attr('checked', true);
			$('#sync').show();
		}
		this.content.val(content);
		this.content.focus();
		setCursor(this.content[0], 0);
	},

	compose: function() {

	},

	bind: function() {
		var t = this;
		this.checkHandler = fnBind(this.checkCounter, this);
		var pasteHandler = function() { setTimeout(t.checkHandler, 100); };
		this.content.bind('keyup', this.checkHandler);
		this.content.bind('paste', pasteHandler);
		this.content.bind('cut', pasteHandler);
		this.send.bind('click', fnBind(this.submit, this));
		this.content.bind('keypress', fnBind(function(evt)
		{
		    if (evt.ctrlKey && evt.keyCode == 10)
		        this.submit();
		}, this));
	},

	startup: function() {
		this.checkCounter();
	},

	checkCounter: function() {
		var fakeLink = '超链接占位符';
		var content = FUI.lan.string.trim(this.content.val());
		content = content.replace(/(http|https):\/\/[a-zA-Z0-9]+(\.[a-zA-Z0-9]+)+([-A-Z0-9a-z\$\.\+\!\_\*\(\)\/\,\:;@&=\?~#%]*)*/gi, fakeLink);
		var contentLength = Math.round(FUI.lan.string.byteLength(content) / 2);
		var diff = contentLength - this.limit, caption;
		if (diff > 0)
			caption = '超出<i class="overtop">' + diff + '</i>字';
		else
			caption = '还可以输入<i>' + Math.abs(diff) + '</i>字';
		this.counter.html(caption);
		return diff <= 0;
	},

	submit: function() {
		var fakeLink = '超链接占位符';
		var content = FUI.lan.string.trim(this.content.val());
		content = content.replace(/(http|https):\/\/[a-zA-Z0-9]+(\.[a-zA-Z0-9]+)+([-A-Z0-9a-z\$\.\+\!\_\*\(\)\/\,\:;@&=\?~#%]*)*/gi, fakeLink);
		var contentLength = Math.round(FUI.lan.string.byteLength(content) / 2);
		var diff = contentLength - this.limit, caption;
		if (diff > 0)
			return;
		$.ajax({
			url: this.urlConfig.forward,
			type: "POST",
			data: { 'feedId': this.data.i, 'sourceId':6,'summary': FUI.lan.string.trim(this.content.val()), 'synctosource': this.syncCheck.attr('checked') ? 1 : 0 },
			dataType: "html",
			cache: false,
			success: function(obj) {
				FCE.common.refreshJuxiangTab('{type:"forward",object:' + obj + '}');
				FCE.common.closeJuxiangWnd();
			},
			error: function() {

			}
		});
	}
};
// 统计系统PV统计
FCS.PcApp.watracer = {
	PV: function(url, urlIdentity) {
		var initImg = new Image(), strArr = [], d = document, s = window.screen, fs = typeof fx_pagestart != 'undefined' && fx_pagestart || 0, lh = url, eu = encodeURIComponent;
		strArr = ['url=' + eu(lh), 'referrer=' + '', 'sw=' + s.width, 'sh=' + s.height, 'sc=' + s.colorDepth, 'urlIdentity=' + urlIdentity, 'lastmode=' + Math.random(), 'pageloadtime=0'];
		initImg.onload = function() {
			initImg.onload = null;
			initImg.onerror = null;
		};
		initImg.onerror = function() {
			initImg.onload = null;
			initImg.onerror = null;
		};

		initImg.src = FCE.common.wadomain + "/pv.ashx?" + strArr.join('&');
	},
	reg: function(e) {
		var item = this.getEventTarget(e);
		while (true) {
			if (item.regid) {
				FCE.common.watracerReg(item.regid, userId);
				break;
			}

			item = item.parentNode;

			if (!item) {
				break;
			}
		}
	},
	getEventTarget: function(e) {
		return e.originalTarget || e.Target || e.srcElement;
	}
};