
precision highp float;

uniform vec2 textureSize;
uniform vec2 sourceSize;
uniform vec2 screenSize;

attribute vec4 position;
attribute vec4 texcoord;

varying vec4 texCoordVarying[5];

void main() {
    vec4 offsetx;
    vec4 offsety;
    
    gl_Position = position;
    
    offsetx.x = (sourceSize.x / screenSize.x) * (1.0 / textureSize.x);
    offsetx.y = 0.0;
    offsetx.w = 0.0;
    offsetx.z = 0.0;
    offsety.y = (sourceSize.y / screenSize.y) * (1.0 / textureSize.y);
    offsety.x = 0.0;
    offsety.w = 0.0;
    offsety.z = 0.0;
    
    texCoordVarying[0] = texcoord;         //center
    texCoordVarying[1] = texCoordVarying[0] - offsetx;  //left
    texCoordVarying[2] = texCoordVarying[0] + offsetx;  //right
    texCoordVarying[3] = texCoordVarying[0] - offsety;  //top
    texCoordVarying[4] = texCoordVarying[0] + offsety;  //bottom
}
