package com.kingdee.eas.lifetime.util.BaseInfoRead;

import java.util.LinkedHashMap;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.lifetime.util.EDxbangUtil;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.emp.PersonPositionCollection;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.hr.emp.PersonPositionInfo;

/**
 *  
 * 
 * @author lifeTime
 */
public class EDadminOrgUnitRead {

	static final org.apache.log4j.Logger logger = CoreUIObject.getLogger(EDadminOrgUnitRead.class.getName());

	/**
	 * Ƶõ
	 * 
	 * @param name
	 * @return
	 * @throws BOSException
	 */
	public static AdminOrgUnitInfo getInfoByName(String name) throws BOSException {
		LinkedHashMap queryMap = new LinkedHashMap();
		queryMap.put("name", name);
		AdminOrgUnitCollection collection = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitCollection(
				EDxbangUtil.getEntityViewInfo(queryMap, new CompareType[] { CompareType.EQUALS }));
		return collection.size() == 0 ? null : collection.get(0);
	}

	/**
	 * @param adminId
	 * @return
	 */
	public static AdminOrgUnitInfo getInfoById(String adminId) {
		try {
			return AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitInfo(new ObjectUuidPK(adminId));
		} catch (EASBizException e) {
			e.printStackTrace();
		} catch (BOSException e) {
			e.printStackTrace();
		}
		return null;
	}

	/**
	 * ñõ
	 * 
	 * @param number
	 * @return
	 * @throws BOSException
	 */
	public static AdminOrgUnitInfo getInfoByNumber(String number) throws BOSException {
		LinkedHashMap queryMap = new LinkedHashMap();
		queryMap.put("number", number);
		AdminOrgUnitCollection collection = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitCollection(
				EDxbangUtil.getEntityViewInfo(queryMap, new CompareType[] { CompareType.EQUALS }));
		return collection.size() == 0 ? null : collection.get(0);
	}

	/**
	 * ݲŻӲţµӣ
	 * 
	 * @param parent
	 * @return
	 * @throws BOSException
	 */
	public static AdminOrgUnitCollection getChildByParent(AdminOrgUnitInfo parent) throws BOSException {
		LinkedHashMap queryMap = new LinkedHashMap();
		queryMap.put("parent", parent.getId().toString());
		AdminOrgUnitCollection resutl = new AdminOrgUnitCollection();
		resutl.add(parent);
		AdminOrgUnitCollection collection = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitCollection(
				EDxbangUtil.getEntityViewInfo(queryMap, new CompareType[] { CompareType.EQUALS }));
		for (int i = collection.size(); --i >= 0;) {
			AdminOrgUnitInfo adminOrgUnitInfo = collection.get(i);
			if (!adminOrgUnitInfo.isIsLeaf()) {
				resutl.addCollection(getChildByParent(adminOrgUnitInfo));
			}
		}
		resutl.addCollection(collection);
		return resutl;
	}

	/**
	 * ԱڵĲ,ȡΪ3(ҪְλΪ׼)
	 * 
	 * @param personId
	 * @return
	 * @throws BOSException
	 * @throws EASBizException
	 */
	public static AdminOrgUnitInfo getInfoByPersonId(String personId) throws BOSException, EASBizException {
		LinkedHashMap queryMap = new LinkedHashMap();
		queryMap.put("person", personId);
		PersonPositionCollection collection = PersonPositionFactory.getRemoteInstance().getPersonPositionCollection(
				EDxbangUtil.getEntityViewInfo(queryMap, new CompareType[] { CompareType.EQUALS }));
		if (collection.size() == 0) {
			return null;
		}
		PersonPositionInfo positionInfo = collection.get(0);
		String adminId = positionInfo.getPersonDep().getId().toString();
		AdminOrgUnitInfo depart = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitInfo(new ObjectUuidPK(adminId));
		String longNum = depart.getLongNumber();//  01!T00001!P03000!P03500
		if (longNum.length() < 16) {
			return null;
		} else {
			longNum = longNum.substring(10, 16);
		}

		return getInfoByNumber(longNum);
	}

	/**
	 * ֯(пǲţҲΪµĿң)
	 * 
	 * @param personId
	 * @return
	 */
	public static AdminOrgUnitInfo getAdminByPersonId(String personId) {
		String oql = "select personDep.* where person = '" + personId + "'";
		try {
			PersonPositionInfo positionInfo = PersonPositionFactory.getRemoteInstance().getPersonPositionInfo(oql);
			return positionInfo.getPersonDep();
		} catch (EASBizException e) {
			e.printStackTrace();
		} catch (BOSException e) {
			e.printStackTrace();
		}
		return null;
	}

	/**
	 * õlevel֯
	 * 
	 * @param adminId
	 * @param level
	 *            3𣺲
	 * @return
	 */
	public static AdminOrgUnitInfo getAdminLevel(String adminId, int level) {
		AdminOrgUnitInfo adminOrgUnitInfo = getInfoById(adminId);
		if (adminOrgUnitInfo != null) {
			String longNumber = adminOrgUnitInfo.getLongNumber();
			String[] numbers = longNumber.split("!");
			if (numbers != null && numbers.length != 0) {
				String number = numbers[level - 1];
				if (number != null) {
					try {
						return getInfoByNumber(number);
					} catch (BOSException e) {
						e.printStackTrace();
					}
				}
			}
		}
		return null;
	}

	/**
	 * ǷΪ촬HRԴ
	 * 
	 * @param personId
	 * @return
	 */
	public static boolean isHrDepart(String personId) {
		String HRnumber = "T05000";
		// String HRname = "Դ";
		try {
			AdminOrgUnitInfo adminOrgUnitInfo = getInfoByPersonId(personId);
			if (adminOrgUnitInfo != null && HRnumber.equals(adminOrgUnitInfo.getNumber())) {
				return true;
			}
		} catch (EASBizException e) {
			e.printStackTrace();
		} catch (BOSException e) {
			e.printStackTrace();
		}
		return false;
	}

}
