package com.kingdee.eas.lifetime.util.BaseInfoRead;

import java.util.LinkedHashMap;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.lifetime.util.EDxbangUtil;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.EmployeeTypeCollection;
import com.kingdee.eas.hr.base.EmployeeTypeFactory;
import com.kingdee.eas.hr.base.EmployeeTypeInfo;

/**
 * Ա״̬ 
 * 
 * @author lifeTime
 */
public class EDemployeeTypeRead {
	static final org.apache.log4j.Logger logger = CoreUIObject.getLogger(EDemployeeFenLeiRead.class.getName());

	/**
	 * ƵõԱ״̬
	 * 
	 * @param name
	 * @return
	 * @throws BOSException
	 */
	public static EmployeeTypeInfo getInfoByName(String name) throws BOSException {
		LinkedHashMap queryMap = new LinkedHashMap();
		queryMap.put("name", name);
		EmployeeTypeCollection collection = EmployeeTypeFactory.getRemoteInstance().getEmployeeTypeCollection(
				EDxbangUtil.getEntityViewInfo(queryMap, new CompareType[] { CompareType.EQUALS }));
		return collection.size() == 0 ? null : collection.get(0);
	}

	/**
	 * ñõԱ״̬
	 * 
	 * @param number
	 * @return
	 * @throws BOSException
	 */
	public static EmployeeTypeInfo getInfoByNumber(String number) throws BOSException {
		LinkedHashMap queryMap = new LinkedHashMap();
		queryMap.put("number", number);
		EmployeeTypeCollection collection = EmployeeTypeFactory.getRemoteInstance().getEmployeeTypeCollection(
				EDxbangUtil.getEntityViewInfo(queryMap, new CompareType[] { CompareType.EQUALS }));
		return collection.size() == 0 ? null : collection.get(0);
	}

	/**
	 * õĳԱµԱ״̬
	 * 
	 * @param fenLeiId
	 * @return
	 * @throws BOSException
	 */
	public static EmployeeTypeCollection getCollectionByFenLeiId(String fenLeiId) throws BOSException {
		LinkedHashMap queryMap = new LinkedHashMap();
		queryMap.put("employeeFenLei", fenLeiId);
		return EmployeeTypeFactory.getRemoteInstance().getEmployeeTypeCollection(
				EDxbangUtil.getEntityViewInfo(queryMap, new CompareType[] { CompareType.EQUALS }));
	}

	/**
	 * Ա״̬
	 * 
	 * @param personId
	 * @return
	 */
	public static EmployeeTypeInfo getInfoByPersonId(String personId) {
		SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
		selectorItemCollection.add(new SelectorItemInfo("employeeType.*"));
		selectorItemCollection.add(new SelectorItemInfo("*"));
		try {
			PersonInfo personInfo = PersonFactory.getRemoteInstance().getPersonInfo(new ObjectUuidPK(personId), selectorItemCollection);
			return personInfo.getEmployeeType();
		} catch (EASBizException e) {
			e.printStackTrace();
		} catch (BOSException e) {
			e.printStackTrace();
		}
		return null;
	}

}
