package com.kingdee.eas.lifetime.util.BaseInfoRead;

import java.util.LinkedHashMap;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.lifetime.util.EDxbangUtil;
import com.kingdee.eas.basedata.org.JobCategoryCollection;
import com.kingdee.eas.basedata.org.JobCategoryFactory;
import com.kingdee.eas.basedata.org.JobCategoryInfo;

/**
 * ְͶȡ
 * 
 * @author lifeTime
 * 
 */
public class EDjobCategoryRead {
	static final org.apache.log4j.Logger logger = CoreUIObject.getLogger(EDjobCategoryRead.class.getName());

	/**
	 * Ƶõְ
	 * 
	 * @param name
	 * @return
	 * @throws BOSException
	 */
	public static JobCategoryInfo getInfoByName(String name) throws BOSException {
		LinkedHashMap queryMap = new LinkedHashMap();
		queryMap.put("name", name);
		JobCategoryCollection collection = JobCategoryFactory.getRemoteInstance().getJobCategoryCollection(
				EDxbangUtil.getEntityViewInfo(queryMap, new CompareType[] { CompareType.EQUALS }));
		return collection.size() == 0 ? null : collection.get(0);
	}

	/**
	 * ñõְ
	 * 
	 * @param number
	 * @return
	 * @throws BOSException
	 */
	public static JobCategoryInfo getInfoByNumber(String number) throws BOSException {
		LinkedHashMap queryMap = new LinkedHashMap();
		queryMap.put("number", number);
		JobCategoryCollection collection = JobCategoryFactory.getRemoteInstance().getJobCategoryCollection(
				EDxbangUtil.getEntityViewInfo(queryMap, new CompareType[] { CompareType.EQUALS }));
		return collection.size() == 0 ? null : collection.get(0);
	}

	/**
	 * ݸְͻְͣµӣ
	 * 
	 * @param parent
	 * @return
	 * @throws BOSException
	 */
	public static JobCategoryCollection getChildByParent(JobCategoryInfo parent) throws BOSException {
		LinkedHashMap queryMap = new LinkedHashMap();
		queryMap.put("parent", parent.getId().toString());
		JobCategoryCollection resutl = new JobCategoryCollection();
		JobCategoryCollection collection = JobCategoryFactory.getRemoteInstance().getJobCategoryCollection(
				EDxbangUtil.getEntityViewInfo(queryMap, new CompareType[] { CompareType.EQUALS }));
		for (int i = collection.size(); --i >= 0;) {
			JobCategoryInfo categoryInfo = collection.get(i);
			if (!categoryInfo.isIsLeaf()) {
				resutl.addCollection(getChildByParent(categoryInfo));
			}
		}
		resutl.addCollection(collection);
		return resutl;
	}

}
