package com.kingdee.eas.lifetime.util.BaseInfoRead;

import java.sql.SQLException;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.perf.EvaluResultFactory;
import com.kingdee.eas.hr.perf.EvaluResultInfo;
import com.kingdee.jdbc.rowset.IRowSet;

/**
 * ЧϢȡ
 * 
 * @author lifeTime 2009-10-28 02:54:22
 * 
 */
public class EDperfRead {

	private EDperfRead() {
	}

	/**
	 * personһεĿ˽
	 * 
	 * @param personId
	 * @return
	 */
	public static EvaluResultInfo getEvaluResult(String personId) {
		return getEvaluResult(personId, 1);
	}

	/**
	 * personcountεĸ˿˽
	 * 
	 * @param personId
	 * @param count
	 *            Ŀ˴
	 * @return
	 */
	public static EvaluResultInfo getEvaluResult(String personId, int count) {
		MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.perf.app", "PerformanceInfoUnionQuery");
		IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance(queryPK);
		EntityViewInfo evi = new EntityViewInfo();
		FilterInfo fi = new FilterInfo();
		fi.getFilterItems().add(new FilterItemInfo("isApproved", new Integer(1)));
		fi.getFilterItems().add(new FilterItemInfo("person.id", personId));
		if (SysContext.getSysContext().getCurrentHRUnit() != null)
			fi.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", SysContext.getSysContext().getCurrentHRUnit().getId().toString()));
		evi.setFilter(fi);
		SorterItemCollection sorter = evi.getSorter();
		SorterItemInfo si = new SorterItemInfo("assessPeriod.startDate");
		si.setSortType(SortType.DESCEND);
		sorter.add(si);
		exec.setObjectView(evi);
		try {
			IRowSet rowSet = exec.executeQuery();
			if (rowSet.next() && count == 1) {
				String evaluResultId = rowSet.getString("id");
				return EvaluResultFactory.getRemoteInstance().getEvaluResultInfo(new ObjectUuidPK(evaluResultId));
			}
			count--;
		} catch (BOSException e) {
			e.printStackTrace();
		} catch (SQLException e) {
			e.printStackTrace();
		} catch (EASBizException e) {
			e.printStackTrace();
		}
		return null;
	}

}
