package com.kingdee.eas.lifetime.util.BaseInfoRead;

import java.util.Date;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.hr.compensation.CmpPeriodCollection;
import com.kingdee.eas.hr.compensation.CmpPeriodFactory;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.util.DateTimeUtils;

/**
 * нڼȡ
 * 
 * @author lifeTime
 * 
 */
public class EDperiodRead {

	static EDperiodRead read = null;
	HROrgUnitInfo unitInfo = null;
	Context ctx;

	/**
	 * ȡڵڼ(δ)
	 * 
	 * @param date
	 * @return
	 * @throws BOSException
	 */
	public CmpPeriodInfo getCmpPeriodInfo(Date date) throws BOSException {
		CmpPeriodInfo info1 = null;
		CmpPeriodInfo info2 = null;
		CmpPeriodCollection collection1 = null;
		CmpPeriodCollection collection2 = null;
		if (ctx == null) {
			collection1 = CmpPeriodFactory.getRemoteInstance().getCmpPeriodCollection(
					"where hrOrgUnit = '" + unitInfo.getId().toString() + "' and beginDate <= '"
							+ DateTimeUtils.format(date, "yyyy-MM-dd hh:mm:ss") + "' order by beginDate desc");
			collection2 = CmpPeriodFactory.getRemoteInstance().getCmpPeriodCollection(
					"where hrOrgUnit = '" + unitInfo.getId().toString() + "' and endDate >= '"
							+ DateTimeUtils.format(date, "yyyy-MM-dd hh:mm:ss") + "' order by endDate");
		} else {
			collection1 = CmpPeriodFactory.getLocalInstance(ctx).getCmpPeriodCollection(
					"where hrOrgUnit = '" + unitInfo.getId().toString() + "' and beginDate <= '"
							+ DateTimeUtils.format(date, "yyyy-MM-dd hh:mm:ss") + "' order by beginDate desc");
			collection2 = CmpPeriodFactory.getLocalInstance(ctx).getCmpPeriodCollection(
					"where hrOrgUnit = '" + unitInfo.getId().toString() + "' and endDate >= '"
							+ DateTimeUtils.format(date, "yyyy-MM-dd hh:mm:ss") + "' order by endDate");
		}
		info1 = collection1.isEmpty() ? null : collection1.get(0);
		info2 = collection2.isEmpty() ? null : collection2.get(0);
		if (info1 == null) {
			return null;
		}
		if (info1.equals(info2)) {
			return info1;
		}
		return null;
	}

	/**
	 * һڼ
	 * 
	 * @param periodInfo
	 * @return
	 * @throws BOSException
	 */
	public CmpPeriodInfo getNextPeriod(CmpPeriodInfo periodInfo) throws BOSException {
		Date date = periodInfo.getBeginDate();
		CmpPeriodCollection collection = null;
		if (ctx == null) {
			collection = CmpPeriodFactory.getRemoteInstance().getCmpPeriodCollection(
					"where hrOrgUnit = '" + unitInfo.getId().toString() + "' and beginDate > '"
							+ DateTimeUtils.format(date, "yyyy-MM-dd hh:mm:ss") + "' order by beginDate");
		} else {
			collection = CmpPeriodFactory.getLocalInstance(ctx).getCmpPeriodCollection(
					"where hrOrgUnit = '" + unitInfo.getId().toString() + "' and beginDate > '"
							+ DateTimeUtils.format(date, "yyyy-MM-dd hh:mm:ss") + "' order by beginDate");
		}
		return collection.isEmpty() ? null : collection.get(0).equals(periodInfo) ? (collection.get(1) == null ? null : collection.get(1))
				: collection.get(0);
	}

	/**
	 * һڼ
	 * 
	 * @param periodInfo
	 * @return
	 * @throws BOSException
	 */
	public CmpPeriodInfo getPriorPeriod(CmpPeriodInfo periodInfo) throws BOSException {
		Date date = periodInfo.getEndDate();
		CmpPeriodCollection collection = null;
		if (ctx == null) {
			collection = CmpPeriodFactory.getRemoteInstance().getCmpPeriodCollection(
					"where hrOrgUnit = '" + unitInfo.getId().toString() + "' and beginDate < '"
							+ DateTimeUtils.format(date, "yyyy-MM-dd hh:mm:ss") + "' order by beginDate desc");

		} else {
			collection = CmpPeriodFactory.getLocalInstance(ctx).getCmpPeriodCollection(
					"where hrOrgUnit = '" + unitInfo.getId().toString() + "' and beginDate < '"
							+ DateTimeUtils.format(date, "yyyy-MM-dd hh:mm:ss") + "' order by beginDate desc");
		}
		return collection.isEmpty() ? null : collection.get(0);
	}

	private EDperiodRead() {
	}

	private EDperiodRead(HROrgUnitInfo unitInfoInfo) {
		this.unitInfo = unitInfoInfo;
	}

	private EDperiodRead(HROrgUnitInfo unitInfoInfo, Context ctx) {
		this.unitInfo = unitInfoInfo;
		this.ctx = ctx;
	}

	public static EDperiodRead getInstance(HROrgUnitInfo unitInfoInfo) {
		return getInstance(unitInfoInfo, null);
	}

	public static EDperiodRead getInstance(HROrgUnitInfo unitInfoInfo, Context ctx) {
		read = new EDperiodRead(unitInfoInfo, ctx);
		return read;
	}

}
