package com.kingdee.eas.lifetime.util.BaseInfoRead;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.lifetime.util.EDxbangUtil;
import com.kingdee.eas.lifetime.util.edcommonutils.EDcommonUtils;
import com.kingdee.eas.base.param.ParamItemFactory;
import com.kingdee.eas.base.param.ParamItemInfo;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.emp.PersonPositionCollection;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.BaseException;

/**
 * @author lifeTime
 * 
 */
public class EDpersonRead {
	private EDpersonRead() {
	}

	static IPerson inface = null;

	static {
		try {
			inface = PersonFactory.getRemoteInstance();
		} catch (BOSException e) {
			e.printStackTrace();
		}
	}

	public static PersonInfo getCurrentPerson() {
		return getCurrentPerson(null);
	}

	/**
	 * õǰûӦԱ
	 * 
	 * @param ctx
	 * @return
	 */
	public static PersonInfo getCurrentPerson(Context ctx) {
		String userId = null;
		IUser user = null;
		try {
			if (ctx != null) {
				user = UserFactory.getLocalInstance(ctx);
				userId = ContextUtil.getCurrentUserInfo(ctx).getId().toString();
			} else {
				user = UserFactory.getRemoteInstance();
				userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
			}
			UserInfo userInfo = user.getUserInfo("select person.* , * where id = '" + userId + "'");
			if (userInfo != null) {
				return userInfo.getPerson();
			}
		} catch (BaseException e) {
			e.printStackTrace();
		}
		return null;
	}

	/**
	 * 
	 * @param personId
	 * @return
	 * @throws EASBizException
	 * @throws BOSException
	 */
	public static PersonInfo getInfoById(String personId) throws EASBizException, BOSException {
		return inface.exists(new ObjectUuidPK(personId)) ? inface.getPersonInfo(new ObjectUuidPK(personId)) : null;
	}

	/**
	 * personIdPersonְλ
	 * 
	 * @param personId
	 * @return
	 */
	public static PersonPositionInfo getPersonPositionByPersonId(String personId) {
		LinkedHashMap queryMap = new LinkedHashMap();
		queryMap.put("person", personId);
		PersonPositionCollection collection = null;
		try {
			collection = PersonPositionFactory.getRemoteInstance().getPersonPositionCollection(
					EDxbangUtil.getEntityViewInfo(queryMap, new CompareType[] { CompareType.EQUALS }));
		} catch (Exception e) {
			e.printStackTrace();
		}
		return collection == null ? null : collection.get(0);
	}

	/**
	 * Աڵ֯ҪְλΪ׼
	 * 
	 * @param personId
	 * @return
	 */
	public static AdminOrgUnitInfo getAdminByPersonID(String personId) {
		PositionInfo positionInfo = getPositionByPersonId(personId);
		return positionInfo == null ? null : positionInfo.getAdminOrgUnit();
	}

	/**
	 * õǰûӦ֯
	 * 
	 * @return
	 */
	public static AdminOrgUnitInfo getCurrentAdmin() {
		PersonInfo personInfo = getCurrentPerson();
		if (personInfo == null) {
			return null;
		}
		return getAdminByPersonID(personInfo.getId().toString());
	}

	/**
	 * ԱidPositionInfo
	 * 
	 * @param personId
	 * @return
	 */
	public static PositionInfo getPositionByPersonId(String personId) {
		String oql = "select primaryPosition.* where person = '" + personId + "'";
		try {
			PersonPositionInfo positionInfo = PersonPositionFactory.getRemoteInstance().getPersonPositionInfo(oql);
			return positionInfo.getPrimaryPosition();
		} catch (EASBizException e) {
			e.printStackTrace();
		} catch (BOSException e) {
			e.printStackTrace();
		}
		return null;
	}

	/**
	 * øò(Ӳ)Ա,ϵͳйء IS_SUM_ADMINΪʾΪµԱְԱ֮
	 * 
	 * @param admin
	 * @return
	 */
	public static PersonCollection getPersonsByDepart(AdminOrgUnitInfo admin, OrgUnitInfo unitInfo) {
		FilterInfo filterInfo = new FilterInfo();
		HashSet fenLeiSet = new HashSet();
		fenLeiSet.add("ְ");
		fenLeiSet.add("");
		filterInfo.getFilterItems().add(new FilterItemInfo("person.employeeType.employeeFenLei.name", fenLeiSet, CompareType.NOTINCLUDE));
		return getPersonsByDepart(admin, unitInfo, filterInfo);
	}

	/**
	 * øò(Ӳ)Ա,ϵͳйء IS_SUM_ADMINΪʾΪµԱְԱ֮
	 * 
	 * @param admin
	 * @param unitInfo
	 * @param filterInfo
	 *            ⲿfilterInfoҪPersonPositionPositionMerber(person)˲
	 * @return
	 */
	public static PersonCollection getPersonsByDepart(AdminOrgUnitInfo admin, OrgUnitInfo unitInfo, FilterInfo filterInfo) {
		if (EDcommonUtils.StringUtils.isEmpty(admin.getNumber())) {
			System.out.println("##########EDpersonRead.getPersonsByDepart AdminOrgUnitInfoıΪգ");
			return null;
		}
		String number = admin.getNumber();
		String oql = "select *,keyID.* where orgUnitID = '" + unitInfo.getId().toString() + "' and keyID.number = 'IS_SUM_ADMIN'";
		boolean isIncludePartJob = false;
		try {
			ParamItemInfo paramItemInfo = ParamItemFactory.getRemoteInstance().getParamItemInfo(oql);
			if (paramItemInfo != null) {
				String booleanValue = paramItemInfo.getValue();
				if ("true".equals(booleanValue)) {
					isIncludePartJob = true;
				} else {
					isIncludePartJob = false;
				}
			}
			PersonCollection personCollection = new PersonCollection();
			HashSet personSet = new HashSet();
			EntityViewInfo entityViewInfo = new EntityViewInfo();
			SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
			selectorItemCollection.add(new SelectorItemInfo("person.*"));
			selectorItemCollection.add(new SelectorItemInfo("*"));
			FilterInfo info = new FilterInfo();
			entityViewInfo.setSelector(selectorItemCollection);

			if (isIncludePartJob) {
				info.appendFilterItem("position.hrOrgUnit", unitInfo.getId().toString());
				info.getFilterItems().add(new FilterItemInfo("position.adminOrgUnit.longNumber", "%" + number + "%", CompareType.LIKE));
				if (filterInfo != null && filterInfo.getFilterItems().size() > 0) {
					info.mergeFilter(filterInfo, "and");
				}
				entityViewInfo.setFilter(info);
				PositionMemberCollection memberCollection = PositionMemberFactory.getRemoteInstance()
						.getPositionMemberCollection(entityViewInfo);
				for (int i = 0, k = memberCollection.size(); i < k; i++) {
					personSet.add(memberCollection.get(i).getPerson());
				}
			} else {
				info.appendFilterItem("primaryPosition.hrOrgUnit", unitInfo.getId().toString());
				info.getFilterItems().add(new FilterItemInfo("personDep.longNumber", "%" + number + "%", CompareType.LIKE));
				if (filterInfo != null && filterInfo.getFilterItems().size() > 0) {
					info.mergeFilter(filterInfo, "and");
				}
				entityViewInfo.setFilter(info);
				PersonPositionCollection personPositionCollection = PersonPositionFactory.getRemoteInstance().getPersonPositionCollection(
						entityViewInfo);
				for (int i = 0, k = personPositionCollection.size(); i < k; i++) {
					personSet.add(personPositionCollection.get(i).getPerson());
				}
			}
			for (Iterator it = personSet.iterator(); it.hasNext();) {
				PersonInfo personInfo = (PersonInfo) it.next();
				personCollection.add(personInfo);
			}
			return personCollection;
		} catch (BOSException e) {
			e.printStackTrace();
		} catch (EASBizException e) {
			e.printStackTrace();
		}
		return null;
	}

}
