package com.kingdee.eas.lifetime.util.DButil;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import org.apache.log4j.Logger;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.query.PropertyUnitCollection;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.lifetime.util.bizutil.EDbizUtil;
import com.kingdee.eas.lifetime.util.edcommonutils.EDcommonUtils;
import com.kingdee.eas.base.commonquery.ColumnItemData;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;

/**
 * @author lifeTime
 *
 */
public class EDdbUtil {
	static final Logger logger = CoreUIObject.getLogger(EDdbUtil.class);

	/**
	 * ִЧksqlؽlist
	 * 
	 * @param sql
	 * @return
	 * @throws BOSException
	 * @throws SQLException
	 */
	public static List execQuery(String sql) throws BOSException, SQLException {
		ArrayList result = new ArrayList();
		IRowSet rowSet = SQLExecutorFactory.getRemoteInstance(sql).executeSQL();
		ResultSetMetaData metaData = rowSet.getMetaData();
		int colCount = metaData.getColumnCount();
		while (rowSet.next()) {
			HashMap resMap = new HashMap();
			for (int i = 1; i <= colCount; i++) {
				String colName = metaData.getColumnName(i);
				resMap.put(colName, rowSet.getObject(i));
			}
			result.add(resMap);
		}
		return result;
	}

	/**
	 * ִquery
	 * 
	 * @param queryStr
	 *            queryȫ·
	 * @param viewInfo
	 * @return
	 * @throws BOSException
	 * @throws SQLException
	 */
	public static List execQueryInfo(String queryStr, EntityViewInfo viewInfo) throws BOSException, SQLException {
		IQueryExecutor executor = QueryExecutorFactory.getRemoteInstance(new MetaDataPK(queryStr));
		if (viewInfo != null) {
			executor.setObjectView(viewInfo);
		}
		return execQuery(executor.getSQL());
	}

	/**
	 * ִquery
	 * 
	 * @param queryStr
	 *            queryȫ·
	 * @param oql
	 * @return
	 * @throws BOSException
	 * @throws SQLException
	 */
	public static List execQueryInfo(String queryStr, String oql) throws BOSException, SQLException {
		IQueryExecutor executor = QueryExecutorFactory.getRemoteInstance(new MetaDataPK(queryStr));
		if (!EDcommonUtils.StringUtils.isEmpty(oql)) {
			executor.setObjectView(oql);
		}
		return execQuery(executor.getSQL());
	}

	/**
	 * ͨqueryȫmap
	 * 
	 * @param queryPK
	 * @return
	 */
	public static HashMap getFieldFromQuery(String queryPK) {
		QueryInfo queryInfo = EDbizUtil.getQueryInfo(queryPK);
		if (queryInfo == null)
			return null;
		else
			return getFieldFromQuery(queryInfo);
	}

	/**
	 * 
	 * @param queryInfo
	 * @return
	 */
	public static HashMap getFieldFromQuery(QueryInfo queryInfo) {
		HashMap fieldMap = new HashMap();
		PropertyUnitCollection propertyUnitCollection = queryInfo.getUnits();
		if (propertyUnitCollection != null) {
			int size = propertyUnitCollection.size();
			for (int i = 0; i < size; i++) {
				if (!(propertyUnitCollection.get(i) instanceof QueryFieldInfo))
					continue;
				ColumnItemData item = new ColumnItemData();
				QueryFieldInfo queryFieldInfo = (QueryFieldInfo) propertyUnitCollection.get(i);
				item.setKey(queryFieldInfo.getName());
				item.setIndex(i);
				item.setTitle(queryFieldInfo.getDisplayName());
				String tempWidth = queryFieldInfo.getExtendedProperty("colWidthInKDTable");
				if (tempWidth != null && !tempWidth.trim().equalsIgnoreCase(""))
					item.setWidth(Integer.valueOf(tempWidth).intValue());
				else
					item.setWidth(50);
				item.setHidden(!queryFieldInfo.isIsSelector());
				if (!item.isHidden() && !StringUtils.isEmpty(item.getTitle()) && !item.getTitle().equals("ID"))
					fieldMap.put(item.getKey(), item);
			}

		}
		return fieldMap;
	}

}
