package com.kingdee.eas.lifetime.util.DButil;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

import org.apache.log4j.Logger;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

import com.kingdee.bos.ui.face.CoreUIObject;

/**
 * InputStream stream = EDmemberWeekReportUI.class.getResourceAsStream("EDmemberWeekReport_sql.xml");
		EDsqlResult sqlResult = EDsqlReader.getInstance().getSql(stream, "selectAll");
		Map queryMap = new HashMap();
		queryMap.put("orgId", SysContext.getSysContext().getCurrentHRUnit().getId().toString());
		queryMap.put("memberClass2", "Ա");
		queryMap.put("memberClass3", "Ա");
		sqlResult.setCondition(queryMap);
		queryList = EDdbUtil.execQuery(sqlResult.getSqlValue());
	#òַ֧
 * @author lifeTime
 * 
 */
public class EDsqlReader {
	static final Logger logger = CoreUIObject.getLogger(EDsqlReader.class);

	private static EDsqlReader reader = null;

	/**
	 * һ<sql></sql>
	 */
	private static final String sql_sign = "sql";

	/**
	 * <sql name=""></sql>name
	 */
	private static final String sql_sign_att_queryName = "name";

	public static EDsqlReader getInstance() {
		if (reader == null) {
			reader = new EDsqlReader();
		}
		return reader;
	}

	/**
	 * sql
	 * 
	 * @param sqlXmlFilePath
	 *            sqlxmlļ·
	 * @param sqlName
	 *            ļsqlName
	 * @return
	 */
	public EDsqlResult getSql(String sqlXmlFilePath, String sqlName) {
		SAXBuilder builder = new SAXBuilder();
		try {
			Document document = builder.build(new File(sqlXmlFilePath));
			return getSql(document, sqlName);
		} catch (JDOMException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		return null;
	}

	/**
	 * sql
	 * 
	 * @param stream
	 *            sqlļ
	 * @param sqlName
	 *            
	 * @return
	 */
	public EDsqlResult getSql(InputStream stream, String sqlName) {
		SAXBuilder builder = new SAXBuilder();
		try {
			Document document = builder.build(stream);
			return getSql(document, sqlName);
		} catch (JDOMException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		return null;
	}

	private EDsqlResult getSql(Document document, String sqlName) {
		Element element = document.getRootElement();
		List lists = element.getChildren(sql_sign);
		for (int i = lists.size(); --i >= 0;) {
			Element ele = (Element) lists.get(i);
			Attribute attribute = ele.getAttribute(sql_sign_att_queryName);
			if (attribute != null && sqlName.equals(attribute.getValue())) {
				return new EDsqlResult(ele.getText());
			}
		}
		return null;
	}

}
