package com.kingdee.eas.lifetime.util;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

import org.apache.log4j.Logger;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.databinding.DataBinder;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeManager;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDNumberTextField;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDTimePicker;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.EDxbangUtil.kdcontrolutils.EDkdTableUtil;
import com.kingdee.eas.base.uiframe.client.NewMainFrame;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.common.client.UIFactoryName;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.multiDetail.DetailPanel;
import com.kingdee.eas.framework.client.multiDetail.HMDUtils;
import com.kingdee.eas.hr.rec.client.PositionF7PromptBox;
import com.kingdee.eas.tools.datatask.FilesPathInfo;
import com.kingdee.eas.tools.datatask.util.GlobalFunction;
import com.kingdee.eas.tools.datatask.util.GlobalInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;

/**
 * @author lifeTime
 * @deprecated ಿַEDkdTableUtilٲֱEDwindowUtil
 */
public class EDxbangUtil {

	private static final Logger logger = CoreUIObject.getLogger(EDxbangUtil.class);

	/**
	 * tableǷѡ
	 * 
	 * @param table
	 */
	public static void checkSelect(KDTable table) {
		EDkdTableUtil.SelectManager.checkSelect(table);
	}

	/**
	 * ɾtableһݶΪյ
	 * 
	 * @param table
	 */
	public static void removeNullRow(KDTable table) {
		int rowCount = table.getRowCount();
		int colCount = table.getColumnCount();
		for1: for (int i = 0; i < rowCount; i++) {
			IRow row = table.getRow(i);
			boolean isDelete = true;
			for (int j = 0; j < colCount; j++) {
				if (row.getCell(j).getValue() != null) {
					isDelete = false;
					continue for1;
				}
			}
			if (isDelete) {
				table.removeRow(i);
			}
		}
	}

	/**
	 * tableһַʽ(tableclick¼ע)
	 * 
	 * @param table
	 */
	public static void forbiddenTableSort(KDTable table) {
		table.addKDTMouseListener(new KDTMouseListener() {
			public void tableClicked(KDTMouseEvent e) {
				SysUtil.abort();
			}
		});
	}

	private static long methodTime = 0;

	public static void loggerStart() {
		methodTime = System.currentTimeMillis();
	}

	public static void loggerEnd() {
		loggerEnd("");
	}

	public static void loggerEnd(String msg) {
		String msg1 = getHHMMSSstr(System.currentTimeMillis() - methodTime);
		logger.info(msg + "    ʱ " + msg1);
	}

	/**
	 * ڷʱ
	 * 
	 * @param timeLong
	 * @return
	 */
	public static String getHHMMSSstr(long timeLong) {
		long h = 60 * 60 * 1000;
		long m = 60 * 1000;
		long s = 1000;

		long hh = timeLong / h;
		long mm = (timeLong % h) / m;
		long ss = ((timeLong % h) % m) / s;
		long mill = ((timeLong % h) % m) % s;

		String msg = String.valueOf(hh) + ":" + String.valueOf(mm) + ":" + String.valueOf(ss) + "   " + String.valueOf(mill);
		return msg;
	}

	/**
	 * entityViewInfo
	 * 
	 * @param LinkedHashMap
	 *            keyΪqueryֶΣvalueΪȽֵ
	 * @param compareTypes
	 *            CompareTypeöֵ
	 * @return
	 */
	public static EntityViewInfo getEntityViewInfo(LinkedHashMap map, CompareType[] compareTypes) {

		EntityViewInfo entityViewInfo = new EntityViewInfo();
		FilterInfo filterInfo = new FilterInfo();

		if (isEmpty(map) || isEmpty(compareTypes)) {
			logger.info("map  compareTypes  null !");
			return entityViewInfo;
		}

		if (map.values().size() != compareTypes.length) {
			logger.info("map  types һ");
			return entityViewInfo;
		}
		Iterator iterator = map.keySet().iterator();
		int i = 0;
		while (iterator.hasNext()) {
			String key = (String) iterator.next();
			Object value = map.get(key);
			filterInfo.getFilterItems().add(new FilterItemInfo(key, value, compareTypes[i]));
			i++;
		}
		entityViewInfo.setFilter(filterInfo);
		return entityViewInfo;
	}

	public static boolean isEmpty(Object obj) {
		if (obj == null) {
			return true;
		}
		if (obj instanceof Collection) {
			Collection coll = (Collection) obj;
			if (coll.size() == 0) {
				return true;
			}
		}
		if (obj.toString().trim().equals("")) {
			return true;
		}
		return false;
	}

	/**
	 * Ϊtableϵĳһаб
	 * 
	 * @param table
	 * @param colIndex
	 * @return
	 */
	public static KDComboBox bindColumnComboBox(KDTable table, int colIndex) {
		KDComboBox box = new KDComboBox();
		KDTDefaultCellEditor seqState = new KDTDefaultCellEditor(box);
		table.getColumn(colIndex).setEditor(seqState);
		return box;
	}

	/**
	 * Ϊtableϵĳһаб
	 * 
	 * @param table
	 * @param colIndex
	 * @return
	 */
	public static KDComboBox bindColumnComboBox(KDTable table, String colName) {
		KDComboBox box = new KDComboBox();
		KDTDefaultCellEditor seqState = new KDTDefaultCellEditor(box);
		table.getColumn(colName).setEditor(seqState);
		return box;
	}

	/**
	 * ΪtableϵĳһԪб
	 * 
	 * @param table
	 * @param colIndex
	 * @return
	 */
	public static KDComboBox bindCellComboBox(KDTable table, int rowIndex, int colIndex) {
		KDComboBox box = new KDComboBox();
		KDTDefaultCellEditor seqState = new KDTDefaultCellEditor(box);
		table.getCell(rowIndex, colIndex).setEditor(seqState);
		return box;
	}

	/**
	 * ΪtableϵĳһԪб
	 * 
	 * @param table
	 * @param colIndex
	 * @return
	 */
	public static KDComboBox bindCellComboBox(KDTable table, int rowIndex, String colName) {
		KDComboBox box = new KDComboBox();
		KDTDefaultCellEditor seqState = new KDTDefaultCellEditor(box);
		table.getCell(rowIndex, colName).setEditor(seqState);
		return box;
	}

	/**
	 * ΪtableϵĳһԪ󶨸ѡ
	 * 
	 * @param table
	 * @param colIndex
	 * @return
	 */
	public static KDCheckBox bindCellCheckBox(KDTable table, int rowIndex, String colName) {
		KDCheckBox box = new KDCheckBox();
		KDTDefaultCellEditor seqState = new KDTDefaultCellEditor(box);
		table.getCell(rowIndex, colName).setEditor(seqState);
		return box;
	}

	/**
	 * ΪtableϵĳһԪ󶨸ѡ
	 * 
	 * @param table
	 * @param colIndex
	 * @return
	 */
	public static KDCheckBox bindCellCheckBox(KDTable table, int rowIndex, int colIndex) {
		KDCheckBox box = new KDCheckBox();
		KDTDefaultCellEditor seqState = new KDTDefaultCellEditor(box);
		table.getCell(rowIndex, colIndex).setEditor(seqState);
		return box;
	}

	/**
	 * Ϊtableϵĳһа󶨸ѡ
	 * 
	 * @param table
	 * @param colIndex
	 * @return
	 */
	public static KDCheckBox bindColumnCheckBox(KDTable table, int colIndex) {
		KDCheckBox box = new KDCheckBox();
		KDTDefaultCellEditor seqState = new KDTDefaultCellEditor(box);
		table.getColumn(colIndex).setEditor(seqState);
		return box;
	}

	/**
	 * Ϊtableϵĳһа󶨸ѡ
	 * 
	 * @param table
	 * @param colIndex
	 * @return
	 */
	public static KDCheckBox bindColumnCheckBox(KDTable table, String colName) {
		KDCheckBox box = new KDCheckBox();
		KDTDefaultCellEditor seqState = new KDTDefaultCellEditor(box);
		table.getColumn(colName).setEditor(seqState);
		return box;
	}

	/**
	 * Ϊtableϵĳһаıؼ
	 * 
	 * @param table
	 * @param colIndex
	 * @return
	 */
	public static KDNumberTextField bindColumnNumberText(KDTable table, String colName) {
		KDNumberTextField numberText = new KDNumberTextField();
		numberText.setVisible(true);
		numberText.setEditable(true);
		numberText.setHorizontalAlignment(2);
		numberText.setDataType(1);
		numberText.setMaximumNumber(new java.math.BigDecimal("99999999999999.99"));
		numberText.setMaximumNumber(new java.math.BigDecimal("99999999999999.99"));
		numberText.setPrecision(10);
		KDTDefaultCellEditor seqState = new KDTDefaultCellEditor(numberText);
		table.getColumn(colName).setEditor(seqState);
		return numberText;
	}

	/**
	 * Ϊtableϵĳһаıؼ
	 * 
	 * @param table
	 * @param colIndex
	 * @return
	 */
	public static KDNumberTextField bindColumnNumberText(KDTable table, int colIndex) {
		KDNumberTextField numberText = new KDNumberTextField();
		numberText.setVisible(true);
		numberText.setEditable(true);
		numberText.setHorizontalAlignment(2);
		numberText.setDataType(1);
		numberText.setMaximumNumber(new java.math.BigDecimal("99999999999999.99"));
		numberText.setMaximumNumber(new java.math.BigDecimal("99999999999999.99"));
		numberText.setPrecision(10);
		KDTDefaultCellEditor seqState = new KDTDefaultCellEditor(numberText);
		table.getColumn(colIndex).setEditor(seqState);
		return numberText;
	}

	/**
	 * ΪtableϵĳһԪıؼ
	 * 
	 * @param table
	 * @param colIndex
	 * @return
	 */
	public static KDNumberTextField bindCellNumberText(KDTable table, int rowIndex, String colName) {
		KDNumberTextField numberText = new KDNumberTextField();
		numberText.setVisible(true);
		numberText.setEditable(true);
		numberText.setHorizontalAlignment(2);
		numberText.setDataType(1);
		numberText.setMaximumNumber(new Long(999999999));
		numberText.setMaximumNumber(new Long(999999999));
		numberText.setPrecision(10);
		KDTDefaultCellEditor seqState = new KDTDefaultCellEditor(numberText);
		table.getCell(rowIndex, colName).setEditor(seqState);
		return numberText;
	}

	/**
	 * ΪtableϵĳһԪıؼ
	 * 
	 * @param table
	 * @param colIndex
	 * @return
	 */
	public static KDNumberTextField bindCellNumberText(KDTable table, int rowIndex, int colIndex) {
		KDNumberTextField numberText = new KDNumberTextField();
		numberText.setVisible(true);
		numberText.setEditable(true);
		numberText.setHorizontalAlignment(2);
		numberText.setDataType(1);
		numberText.setMaximumNumber(new java.math.BigDecimal("99999999999999.99"));
		numberText.setMaximumNumber(new java.math.BigDecimal("99999999999999.99"));
		numberText.setPrecision(10);
		KDTDefaultCellEditor seqState = new KDTDefaultCellEditor(numberText);
		table.getCell(rowIndex, colIndex).setEditor(seqState);
		return numberText;
	}

	/**
	 * ΪcellKDFormattedTextField
	 * 
	 * @param table
	 * @param rowIndex
	 * @param colName
	 * @return
	 */
	public static KDFormattedTextField bindCellFormattedTextField(KDTable table, int rowIndex, String colName) {
		KDFormattedTextField formatText = new KDFormattedTextField();
		formatText.setVisible(true);
		formatText.setEditable(true);
		formatText.setHorizontalAlignment(2);
		formatText.setDataType(1);
		formatText.setMinimumValue(new java.math.BigDecimal("-999999999999.9999"));
		formatText.setMaximumValue(new java.math.BigDecimal("999999999999.9999"));
		formatText.setPrecision(4);
		KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor(formatText);
		table.getCell(rowIndex, colName).setEditor(cellEditor);
		return formatText;
	}

	/**
	 * ΪcolumnKDFormattedTextField
	 * 
	 * @param table
	 * @param rowIndex
	 * @param colName
	 * @return
	 */
	public static KDFormattedTextField bindColumnFormattedTextField(KDTable table, String colName) {
		KDFormattedTextField formatText = new KDFormattedTextField();
		formatText.setMinimumValue(new java.math.BigDecimal("-999999999999.9999"));
		formatText.setMaximumValue(new java.math.BigDecimal("999999999999.9999"));
		KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor(formatText);
		table.getColumn(colName).setEditor(cellEditor);
		return formatText;
	}

	/**
	 * ΪԪ ıؼKDTextField
	 * 
	 * @param table
	 * @param rowIndex
	 * @param colName
	 * @return
	 */
	public static KDTextField bindTextField(KDTable table, int rowIndex, String colName) {
		KDTextField textField = new KDTextField();
		textField.setName("textField");
		textField.setMaxLength(80);
		KDTDefaultCellEditor seqState = new KDTDefaultCellEditor(textField);
		table.getCell(rowIndex, colName).setEditor(seqState);
		return textField;
	}

	/**
	 * ΪtableϵĳһаF7
	 * 
	 * @param table
	 * @param colIndex
	 * @return
	 */
	public static KDBizPromptBox bindColumnF7(KDTable table, int colIndex, String queryStr) {
		KDBizPromptBox bizPromptBox = new KDBizPromptBox();
		bizPromptBox.setQueryInfo(queryStr);
		KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor(bizPromptBox);
		table.getColumn(colIndex).setEditor(cellEditor);
		return bizPromptBox;
	}

	/**
	 * ΪtableϵĳһаF7
	 * 
	 * @param table
	 * @param colIndex
	 * @return
	 */
	public static KDBizPromptBox bindF7(KDTable table, int colIndex, String queryStr) {
		return bindColumnF7(table, colIndex, queryStr);
	}

	/**
	 * ΪtableϵĳһаF7
	 * 
	 * @param table
	 * @param colIndex
	 * @return
	 */
	public static KDBizPromptBox bindColumnF7(KDTable table, String colName, String queryStr) {
		KDBizPromptBox bizPromptBox = new KDBizPromptBox();
		bizPromptBox.setQueryInfo(queryStr);
		KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor(bizPromptBox);
		table.getColumn(colName).setEditor(cellEditor);
		return bizPromptBox;
	}

	/**
	 * ΪtableϵĳһаF7
	 * 
	 * @param table
	 * @param colIndex
	 * @return
	 */
	public static KDBizPromptBox bindF7(KDTable table, String colName, String queryStr) {
		return bindColumnF7(table, colName, queryStr);
	}

	/**
	 * ΪtableϵĳһԪcomboBox
	 * 
	 * @param table
	 * @param colIndex
	 * @return
	 */
	public static KDBizPromptBox bindCellF7(KDTable table, int rowIndex, String colName, String queryStr) {
		KDBizPromptBox bizPromptBox = new KDBizPromptBox();
		bizPromptBox.setQueryInfo(queryStr);
		KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor(bizPromptBox);
		table.getCell(rowIndex, colName).setEditor(cellEditor);
		return bizPromptBox;
	}

	/**
	 * ΪtableϵĳһԪF7
	 * 
	 * @param colIndex
	 * @return
	 */
	public static KDBizPromptBox bindCellF7(KDTable table, int rowIndex, int colIndex, String queryStr) {
		KDBizPromptBox bizPromptBox = new KDBizPromptBox();
		bizPromptBox.setQueryInfo(queryStr);
		KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor(bizPromptBox);
		table.getCell(rowIndex, colIndex).setEditor(cellEditor);
		return bizPromptBox;
	}

	/**
	 * ĳаΪKDTextArea
	 * 
	 * @param columnName
	 */
	public static KDTextArea bindTextArea(KDTable table, String columnName) {
		KDTextArea area = new KDTextArea();
		KDTDefaultCellEditor allowance = new KDTDefaultCellEditor(area);
		area.setLineWrap(true);
		table.getColumn(columnName).setEditor(allowance);
		return area;
	}

	/**
	 * ĳаΪKDTextArea
	 * 
	 * @param columnName
	 */
	public static KDTextArea bindTextArea(KDTable table, int colIndex) {
		KDTextArea area = new KDTextArea();
		KDTDefaultCellEditor allowance = new KDTDefaultCellEditor(area);
		area.setLineWrap(true);
		table.getColumn(colIndex).setEditor(allowance);
		return area;
	}

	/**
	 * ĳԪΪKDTextArea
	 * 
	 * @param columnName
	 */
	public static KDTextArea bindTextArea(KDTable table, int rowIndex, int colIndex) {
		KDTextArea area = new KDTextArea();
		KDTDefaultCellEditor allowance = new KDTDefaultCellEditor(area);
		area.setLineWrap(true);
		table.getCell(rowIndex, colIndex).setEditor(allowance);
		return area;
	}

	/**
	 * ĳԪΪKDTextArea
	 * 
	 * @param columnName
	 */
	public static KDTextArea bindTextArea(KDTable table, int rowIndex, String columnName) {
		KDTextArea area = new KDTextArea();
		KDTDefaultCellEditor allowance = new KDTDefaultCellEditor(area);
		area.setLineWrap(true);
		table.getCell(rowIndex, columnName).setEditor(allowance);
		return area;
	}

	/**
	 * ְλѡ񴰿
	 * 
	 * @param component
	 * @param ctx
	 * @return
	 */
	public static PositionF7PromptBox showPositionComponent(Component component) {
		Frame frame = getCurrMainFrame(component);
		PositionF7PromptBox pmt = new PositionF7PromptBox(frame);
		pmt.setModal(true);
		return pmt;
	}

	private static Frame getCurrMainFrame(Component component) {
		if (component == null)
			throw new IllegalArgumentException("Argument component is null");
		Component window = SwingUtilities.getRoot(component);
		if (window instanceof Applet)
			return JOptionPane.getFrameForComponent(window);
		if (window instanceof Frame)
			return (Frame) window;
		if (window instanceof Dialog)
			return getCurrMainFrame(((Component) (((Dialog) window).getOwner())));
		if (window instanceof NewMainFrame)
			return (NewMainFrame) window;
		if (window instanceof IUIWindow) {
			IUIWindow uiWindow = (IUIWindow) window;
			IUIObject ui = uiWindow.getUIObject();
			Map context = ui.getUIContext();
			Component c = (Component) context.get("OwnerWindow");
			if (c != null)
				return getCurrMainFrame(c);
		}
		throw new IllegalArgumentException("Component is not associated mainframe");
	}

	/**
	 * ĳаΪKDPromptBox
	 * 
	 * @param table
	 * @param colName
	 * @return
	 */
	public static KDPromptBox bindPromptBox(KDTable table, String colName) {
		KDPromptBox biz = new KDPromptBox();
		KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor(biz);
		table.getColumn(colName).setEditor(cellEditor);
		return biz;
	}

	/**
	 * ĳаΪKDPromptBox
	 * 
	 * @param table
	 * @param colIndex
	 * @return
	 */
	public static KDPromptBox bindPromptBox(KDTable table, int colIndex) {
		KDPromptBox biz = new KDPromptBox();
		KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor(biz);
		table.getColumn(colIndex).setEditor(cellEditor);
		return biz;
	}

	/**
	 * ĳԪΪKDPromptBox
	 * 
	 * @param table
	 * @param rowIndex
	 * @param colName
	 * @return
	 */
	public static KDPromptBox bindPromptBox(KDTable table, int rowIndex, String colName) {
		KDPromptBox biz = new KDPromptBox();
		KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor(biz);
		table.getCell(rowIndex, colName).setEditor(cellEditor);
		return biz;
	}

	/**
	 * ĳԪΪKDPromptBox
	 * 
	 * @param table
	 * @param rowIndex
	 * @param colIndex
	 * @return
	 */
	public static KDPromptBox bindPromptBox(KDTable table, int rowIndex, int colIndex) {
		KDPromptBox biz = new KDPromptBox();
		KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor(biz);
		table.getCell(rowIndex, colIndex).setEditor(cellEditor);
		return biz;
	}

	/**
	 * Ϊcellڿؼ
	 * 
	 * @param table
	 * @param rowIndex
	 * @param colName
	 * @return
	 */
	public static KDDatePicker bindDatePicker(KDTable table, int rowIndex, String colName) {
		KDDatePicker datePicker = new KDDatePicker();
		KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor(datePicker);
		table.getCell(rowIndex, colName).setEditor(cellEditor);
		return datePicker;
	}

	/**
	 * Ϊcellʱؼ
	 * 
	 * @param table
	 * @param rowIndex
	 * @param colName
	 * @return
	 */
	public static KDTimePicker bindTimePicker(KDTable table, int rowIndex, String colName) {
		KDTimePicker datePicker = new KDTimePicker();
		KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor(datePicker);
		table.getCell(rowIndex, colName).setEditor(cellEditor);
		return datePicker;
	}

	/**
	 * ļťͼ
	 * 
	 * @param workButton
	 * @return
	 */
	public static KDWorkButton setFileSelectIcon(KDWorkButton workButton) {
		workButton.setIcon(GlobalInfo.getIcon("tbtn_open"));
		return workButton;
	}

	/**
	 * õǰѡеļ·
	 * 
	 * @param ui
	 *            ǰ
	 * @param textField
	 *            ļ
	 * @return
	 */
	public static String getFilePath(Component ui, KDTextField textField) {
		String sFileName = null;
		FilesPathInfo fpInfo = null;
		try {
			fpInfo = GlobalFunction.excelFileChoose(ui, true, getAlltFilePath(textField));
		} catch (Exception e) {
			MsgBox.showError(e.getMessage());
			return null;
		}
		textField.setText(sFileName);
		return sFileName = fpInfo.getFilePath() == null ? null : fpInfo.getFilePath()[0];
	}

	private static FilesPathInfo getAlltFilePath(KDTextField textField) {
		return (FilesPathInfo) textField.getUserObject();
	}

	/**
	 * 촰
	 * 
	 * @param obj
	 *            new UIContext(obj)
	 * @param windowName
	 *            
	 * @param windowState
	 *            ״̬
	 * @return
	 */
	public static IUIWindow getWindow(Object obj, String windowName, String windowState) {
		IUIWindow myWindow = null;
		Map map = new UIContext(obj);
		try {
			myWindow = UIFactory.createUIFactory(UIFactoryName.MODEL).create(windowName, map, null, windowState);
		} catch (UIException e) {
			e.printStackTrace();
		}
		return myWindow;
	}

	/**
	 * 촰
	 * 
	 * @param obj
	 *            new UIContext(obj)
	 * @param windowName
	 *            
	 * @param windowState
	 *            ״̬
	 * @return
	 */
	public static IUIWindow getWindow(Map uiContent, String windowName, String windowState) {
		IUIWindow myWindow = null;
		try {
			myWindow = UIFactory.createUIFactory(UIFactoryName.MODEL).create(windowName, uiContent, null, windowState);
		} catch (UIException e) {
			e.printStackTrace();
		}
		return myWindow;
	}

	/**
	 * 촰
	 * 
	 * @param UIFactoryName
	 *            .MODEL ״̬
	 * 
	 * @param obj
	 *            new UIContext(obj)
	 * @param windowName
	 *            
	 * @param windowState
	 *            ״̬
	 * @return
	 */
	public static IUIWindow getWindow(String uiFactoryName, Map uiContent, String windowName, String windowState) {
		IUIWindow myWindow = null;
		try {
			myWindow = UIFactory.createUIFactory(uiFactoryName).create(windowName, uiContent, null, windowState);
		} catch (UIException e) {
			e.printStackTrace();
		}
		return myWindow;
	}

	/**
	 * زдڵ
	 * 
	 * @param table
	 * @param columnNames
	 */
	public static void hideColumns(KDTable table, String[] columnNames) {
		if (columnNames != null) {
			for (int i = 0; i < columnNames.length; i++) {
				setColumnHide(table, columnNames[i], true);
			}
		}
	}

	/**
	 * table˲
	 * 
	 * @param table
	 * @param columnNames
	 */
	public static void hideWithoutColumns(KDTable table, String[] columnNames) {
		int cols = table.getColumnCount();
		for (int i = 0; i < cols; i++) {
			String key = table.getColumn(i).getKey();
			boolean has = false;
			for (int j = 0; j < columnNames.length; j++) {
				if (columnNames[j].equals(key)) {
					has = true;
				}
			}
			if (!has) {
				setColumnHide(table, key, true);
			}
		}
	}

	/**
	 * ĳǷ
	 * 
	 * @param table
	 * @param columnName
	 * @param state
	 *            ture: false:ʾ
	 */
	public static void setColumnHide(KDTable table, String columnName, boolean state) {
		if (table == null) {
			logger.error("Ϊգ");
			return;
		} else if (columnName == null) {
			logger.error("Ϊգ");
			return;
		} else {
			if (table.getColumn(columnName) == null) {
				logger.error(" " + columnName + " ڱ " + table + " ﲻڣ");
				return;
			}
		}
		table.getColumn(columnName).getStyleAttributes().setHided(state);
	}

	/**
	 * ĳǷ༭
	 * 
	 * @param table
	 * @param columnName
	 * @param state
	 *            ture:༭ false:༭
	 */
	public static void setColumnEnable(KDTable table, String columnName, boolean state) {
		if (table == null) {
			logger.error("Ϊգ");
			return;
		} else if (columnName == null) {
			logger.error("Ϊգ");
			return;
		} else {
			if (table.getColumn(columnName) == null) {
				logger.error(" " + columnName + " ڱ " + table + " ﲻڣ");
				return;
			}
		}
		table.getColumn(columnName).getStyleAttributes().setLocked(state);
	}

	/**
	 * tableһ
	 * 
	 * @param table
	 * @param rowIndex
	 * @param columns
	 */
	public static void clearRowRecord(KDTable table, int rowIndex, String[] columns) {
		IRow row = table.getRow(rowIndex);
		if (row == null) {
			logger.error("row Ϊգ");
			return;
		}
		for (int i = columns.length; i-- > 0;) {
			try {
				row.getCell(columns[i]).setValue(null);
			} catch (NullPointerException n) {
				logger.error("---------------- " + columns[i] + "" + table.getName() + "-------------------");
			}
		}
	}

	/**
	 * tableһ
	 * 
	 * @param table
	 * @param rowIndex
	 * @param columns
	 */
	public static void clearRowRecord(KDTable table, int rowIndex) {
		int colCount = table.getColumnCount();
		IRow row = table.getRow(rowIndex);
		for (int i = 0; i < colCount; i++) {
			try {
				row.getCell(table.getColumnKey(i)).setValue(null);
			} catch (NullPointerException n) {
				logger.info("---------------- " + table.getColumnKey(i) + "" + table.getName() + "-------------------");
			}
		}
	}

	/**
	 * Ϊֻ, [start,end]
	 * 
	 * @param start
	 * @param end
	 */
	public static void setRangLockWithColumn(KDTable table, int start, int end) {
		for (int i = start; i <= end; i++) {
			if (table.getColumn(i) == null) {
				continue;
			}
			table.getColumn(i).getStyleAttributes().setLocked(true);
		}
	}

	/**
	 * ɾĳ
	 * 
	 * @param table
	 * @param colName
	 */
	public static void removeColumn(KDTable table, String colName) {
		int colIndex = table.getColumnIndex(colName);
		table.removeColumn(colIndex);
	}

	/**
	 * ɾ
	 * 
	 * @param table
	 * @param colNames
	 */
	public static void removeColumn(KDTable table, String[] colNames) {
		for (int i = 0; i < colNames.length; i++) {
			removeColumn(table, colNames[i]);
		}
	}

	/**
	 * ɾtable˲
	 * 
	 * @param table
	 * @param colNames
	 */
	public static void removeColumnWithoutParams(KDTable table, String[] colNames) {
		List list = new ArrayList(colNames.length);
		for (int i = 0; i < colNames.length; i++) {
			list.add(colNames[i]);
		}
		int colCount = table.getColumnCount();
		for (int i = 0; i < colCount; i++) {
			String key = table.getColumnKey(i);
			if (list.contains(key)) {
				continue;
			} else {
				table.removeColumn(i);
			}
		}
	}

	/**
	 * Ϊtablelineļ :</br> detailPanel.addAddListener(new
	 * com.kingdee.eas.framework.client.multiDetail.IDetailPanelListener()
	 * {</br> public void
	 * beforeEvent(com.kingdee.eas.framework.client.multiDetail.DetailPanelEvent
	 * event) throws Exception {</br> IObjectValue vo =
	 * event.getObjectValue();</br> vo.put("EDdataType","0");</br> }</br> public
	 * void afterEvent(com.kingdee.eas.framework.client.multiDetail.
	 * DetailPanelEvent event) throws Exception {</br> }</br> });</br>
	 * 
	 * @param ui
	 *            this
	 * @param dataBinder
	 * @param kdt
	 * @param newVo
	 * @return
	 */
	public static DetailPanel addTableLineListener(CoreUI ui, DataBinder dataBinder, KDTable kdt, AbstractObjectValue newVo) {
		DetailPanel detailPanel = (DetailPanel) HMDUtils.buildDetail(ui, dataBinder, kdt, newVo, null, false);
		return detailPanel;
	}

	/**
	 * @param table
	 * @param colIndex
	 */
	public static void mergeColumn(KDTable table, int colIndex) {
		IColumn column = table.getColumn(colIndex);
		mergeColumn(table, column);
	}

	/**
	 * ںָ(浥Ԫֵ(ָequals==)ں)
	 * 
	 * @param table
	 * @param columnName
	 */
	public static void mergeColumn(KDTable table, String columnName) {
		IColumn column = table.getColumn(columnName);
		mergeColumn(table, column);
	}

	/**
	 * @param table
	 * @param column
	 */
	public static void mergeColumn(KDTable table, IColumn column) {
		int rowCount = table.getRowCount();
		if (column == null) {
			logger.info("в ");
			return;
		}
		if (rowCount < 1) {
			return;
		}
		String columnName = column.getKey();
		KDTMergeManager manager = table.getMergeManager();
		int colIndex = column.getColumnIndex();
		int top = 0, left = colIndex, bottom = 0, right = colIndex;
		Object tempFrist = table.getCell(0, columnName).getValue();
		for (int i = 0; i < rowCount; i++) {
			Object temp = table.getCell(i, columnName).getValue();
			temp = temp == null ? "" : temp;
			if (temp.equals(tempFrist)) {
				bottom++;
			} else {
				manager.mergeBlock(top, left, bottom - 1, right);
				top = bottom;
				bottom++;
				tempFrist = temp;
			}
			if (i == bottom - 1 && top != bottom) {
				manager.mergeBlock(top, left, bottom - 1, right);
			}
		}
	}

	/**
	 * ָtableĶں
	 * 
	 * @param table
	 * @param columnNames
	 */
	public static void mergeColumn(KDTable table, String[] columnNames) {
		if (columnNames != null && columnNames.length > 0) {
			for (int i = 0; i < columnNames.length; i++) {
				String columnName = columnNames[i];
				mergeColumn(table, columnName);
			}
		}
	}

	public static final int SELECT_TOP = 1;
	public static final int SELECT_LEFT = 2;
	public static final int SELECT_BOTTOM = 3;
	public static final int SELECT_RIGHT = 4;

	/**
	 * tableѡеtopУ
	 * 
	 * @param table
	 * @return
	 */
	public static int getSelectedRow(KDTable table) {
		return getSelectedRow(table, SELECT_TOP);
	}

	/**
	 * tableѡеУֻһУ
	 * 
	 * @param table
	 * @param selectModel
	 *            ȡеģʽEDxbangUtil.SELECT_TOP
	 * @return
	 */
	public static int getSelectedRow(KDTable table, int selectModel) {
		if (table.getSelectManager().size() == 0) {
			return -1;
		} else {
			if (SELECT_TOP == selectModel) {
				return table.getSelectManager().get().getTop();
			} else if (SELECT_BOTTOM == selectModel) {
				return table.getSelectManager().get().getBottom();
			}
			return table.getSelectManager().get().getTop();
		}
	}

	/**
	 * ñѡе
	 * 
	 * @param table
	 * @return
	 */
	public static int getSelectedRowCount(KDTable table) {
		int count = 0;
		for (int i = 0; i < table.getSelectManager().size(); i++) {
			KDTSelectBlock block = table.getSelectManager().get(i);
			count += (block.getBottom() - block.getTop()) + 1;
		}
		return count;
	}

	/**
	 * tableѡе
	 * 
	 * @param table
	 * @return
	 */
	public static int[] getSelectedRows(KDTable table) {
		if (table.getSelectManager().size() == 0)
			return new int[0];
		int count = getSelectedRowCount(table);
		int rows[] = new int[count];
		int k = 0;
		for (int i = 0; i < table.getSelectManager().size(); i++) {
			KDTSelectBlock block = table.getSelectManager().get(i);
			for (int j = block.getTop(); j <= block.getBottom(); j++) {
				rows[k] = j;
				k++;
			}
		}
		return rows;
	}

	/**
	 * ֤һؼֵǷΪ,ӦϢ
	 * 
	 * @param components
	 * @param msgs
	 * @return
	 */
	public static boolean verifyNull(JComponent[] components, String[] msgs) {
		for (int i = 0; i < components.length; i++) {
			if (!verifyNull(components[i], msgs[i]))
				return false;
		}
		return true;
	}

	/**
	 * ֤һؼֵǷΪ
	 * 
	 * @param components
	 * @return false һؼΪ򷵻false
	 */
	public static boolean verifyNull(JComponent[] components) {
		String[] temp = new String[components.length];
		return verifyNull(components, temp);
	}

	/**
	 * ֤ؼֵǷΪ
	 * 
	 * @param com
	 *            ؼ
	 * @param msg
	 *            ΪʱϢ(null̸Ϣ)
	 * @return
	 */
	public static boolean verifyNull(JComponent com, String msg) {
		if (com instanceof KDBizPromptBox) {
			KDBizPromptBox bizBox = (KDBizPromptBox) com;
			if (bizBox.getValue() != null) {
				return true;
			}
		} else if (com instanceof KDDatePicker) {
			KDDatePicker datePicker = (KDDatePicker) com;
			if (datePicker.getValue() != null) {
				return true;
			}
		} else if (com instanceof KDTextField) {
			KDTextField textField = (KDTextField) com;
			if (!isEmpty(textField.getText())) {
				return true;
			}
		} else if (com instanceof KDTextArea) {
			KDTextArea textArea = (KDTextArea) com;
			if (!isEmpty(textArea.getText())) {
				return true;
			}
		} else if (com instanceof KDPromptBox) {
			KDPromptBox promptBox = (KDPromptBox) com;
			if (promptBox.getValue() != null) {
				return true;
			}
		}
		if (msg != null) {
			showDialog(msg);
		}
		return false;
	}

	public static void showDialog(String msg, String title, JComponent parentFrame) {
		WindowUtil.msgboxInfo(msg, title, parentFrame);
	}

	public static void showDialog(String msg) {
		MsgBox.showInfo(msg);
	}

	/**
	 * ɾУȡ
	 * 
	 * @param table
	 */
	public static void removeAllRow(KDTable table) {
		for (int i = table.getRowCount() - 1; i >= 0; i--)
			table.removeRow(i);
	}

	/**
	 * ֤tableĳһвܴظ
	 * 
	 * @param table
	 *            Ҫ֤table
	 * @param colName
	 *            Ҫ֤
	 * @param bizInterface
	 *            Ҫк֤ʱҵӿ,Ϊnull򲻽к֤
	 * @param queryColName
	 *            к̨֤ʱʵȽֶ
	 * @return true ʾѴ
	 * @throws BOSException
	 * @throws EASBizException
	 */
	public static boolean exists(KDTable table, String colName, ICoreBase bizInterface, String queryColName) throws EASBizException,
			BOSException {
		int rowCount = table.getRowCount();
		Set tempSet = new HashSet();

		for (int i = 0; i < rowCount; i++) {
			Object tempValue = table.getRow(i).getCell(colName).getValue();
			if (tempValue != null) {
				tempSet.add(tempValue);
			}
			FilterInfo filterInfo = new FilterInfo();
			filterInfo.getFilterItems().add(new FilterItemInfo(queryColName, tempValue, CompareType.EQUALS));
			if (bizInterface != null) {
				if (bizInterface.exists(filterInfo)) {
					return true;
				}
			}
		}
		if (tempSet.size() != rowCount) {
			return true;
		}
		return false;
	}

	public static boolean isNumber(String str) {
		try {
			new Integer(str);
		} catch (Exception ex) {
			ex.printStackTrace();
			return false;
		}
		return true;
	}

	/**
	 * object[]תΪList
	 * 
	 * @param objs
	 * @return
	 */
	public static List convetObjectsToList(Object objs) {
		ArrayList result = new ArrayList();
		if (objs instanceof Object[]) {
			Object[] temp = (Object[]) objs;
			for (int i = 0; i < temp.length; i++) {
				result.add(temp[i]);
			}
		}
		return result;
	}

	public static boolean isEmpty(String str) {
		return str == null || str.length() == 0;
	}

	/**
	 * жstringǷΪ
	 * 
	 * @param str
	 * @param b
	 *            Ƿȥȫǿոж(true:ȥ)
	 * @return
	 */
	public static boolean isEmpty(String str, boolean b) {
		if (!b) {
			return isEmpty(str);
		} else {
			String temp = str.replaceAll("", "");
			return isEmpty(temp);
		}
	}

	/**
	 * תΪ
	 * 
	 * @param obj
	 * @return
	 */
	public static Integer convertToInteger(Object obj) {
		try {
			Integer temp = new Integer(getObjectString(obj));
			return temp;
		} catch (Exception e) {
			logger.info(e.getMessage(), e.getCause());
		}
		return new Integer(0);
	}

	public static String getObjectString(Object obj) {
		return obj == null ? "" : obj.toString();
	}

	public static boolean isEmpty(Date date) {
		return date == null;
	}

	public static boolean isEmpty(Collection collection) {
		return collection == null || collection.size() == 0;
	}

}
