package com.kingdee.eas.lifetime.util.baseDataWindow.commonui.commonSelector;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.view.MetaDataBriefInfo;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.eas.lifetime.util.baseDataWindow.commonui.ui.EDentityTreeUI;
import com.kingdee.eas.lifetime.util.baseDataWindow.commonui.util.EDentityTreeUtil;
import com.kingdee.eas.lifetime.util.kdcontrolutils.EDwindowUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;

/**
 * صĽûobject[]ʽأListء
 * 
 * @author lifeTime
 * 
 */
public class EDentityTreeSelector implements KDPromptSelector {

	protected EDentityTreeUI entityTreeUI;

	private static final String msg = "ԶӦԱûй,ѡ";

	/**
	 * ǷҪperson
	 */
	protected boolean isNeedUnionPerson = false;

	public EDentityTreeSelector() {
	}

	public EDentityTreeSelector(boolean isNeedUnionPerson) {
		this.isNeedUnionPerson = isNeedUnionPerson;
	}

	public Object getData() {
		Object obj = entityTreeUI.getUIContext().get(EDentityTreeUI.ResultObject);
		if (obj != null && obj instanceof List) {
			List datas = (List) obj;
			List result = new ArrayList();
			for (int i = 0, k = datas.size(); i < k; i++) {
				Object data = datas.get(i);
				if (data != null && data instanceof DefaultKingdeeTreeNode) {
					DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode) data;
					if (i == 0 && isNeedUnionPerson && !EDentityTreeUtil.checkNodeUnionPerson(node)) {
						MsgBox.showWarning(msg);
						SysUtil.abort();
					}
					if (node != null && node.getUserObject() != null && !(node.getUserObject() instanceof MetaDataBriefInfo)) {
						result.add(node);
					}
				}
			}
			return result;
		}
		return null;
	}

	public boolean isCanceled() {
		return false;
	}

	public void show() {
		Map uiContext = new HashMap();
		IUIWindow window = EDwindowUtil.getWindow(uiContext, EDentityTreeUI.class.getName());
		entityTreeUI = (EDentityTreeUI) window.getUIObject();
		window.show();
	}

}
