/**
 * output package name
 */
package com.kingdee.eas.lifetime.util.baseDataWindow.commonui.impl;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.Map;

import javax.swing.SwingUtilities;

import org.apache.log4j.Logger;

import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.eas.lifetime.util.baseDataWindow.commonui.IEDcommonUI;
import com.kingdee.eas.lifetime.util.edcommonutils.EDcommonUtils;
import com.kingdee.eas.base.uiframe.client.UIFactoryHelper;

/**
 * UIUI
 * 
 * @author lifeTime
 */
public abstract class AbstractEDcommonUI extends com.kingdee.eas.framework.client.CoreUI implements IEDcommonUI {
	private static final long serialVersionUID = 1L;
	private static final Logger logger = CoreUIObject.getLogger(AbstractEDcommonUI.class);
	protected com.kingdee.bos.ctrl.swing.KDSeparator kDSeparator2;
	protected com.kingdee.bos.ctrl.swing.KDButton EDok;
	protected com.kingdee.bos.ctrl.swing.KDButton EDcancel;
	protected com.kingdee.bos.ctrl.swing.KDPanel mainPanel;
	protected CoreUIObject billUI;
	private String cusStatus = null;

	String uiTitle = "ȡֵ";

	private static final String msg_1 = "޿UIأhoho";
	private static final String msg_2 = "ʧܣ";

	public AbstractEDcommonUI() throws Exception {
		super();
		jbInit();
	}

	/**
	 * С仯¼
	 * 
	 * @param e
	 */
	protected void windowResized(ComponentEvent e) {
		int height = getUIContentPane().getHeight();
		int width = getUIContentPane().getWidth();
		mainPanel.setBounds(new Rectangle(0, 0, width, height - 35));
		billUI.getUIContentPane().setSize(width, height - 35);
		kDSeparator2.setBounds(new Rectangle(4, height - 33, width - 8, 10));
		EDok.setBounds(new Rectangle(width - 250, height - 25, 90, 21));
		EDcancel.setBounds(new Rectangle(width - 120, height - 25, 90, 21));
		this.updateUI();
	}

	protected void loadUI() {
		billUIInvokeLater();
	}

	private void billUIInvokeLater() {
		if (EDcommonUtils.StringUtils.isEmpty(getClientUIClassName())) {
			logger.info(msg_1);
		}

		getUIContext().put("InitDataObject", null);
		if (getUIContext().get("customBizUIStatus") != null)
			cusStatus = (String) getUIContext().get("customBizUIStatus");
		if (EDcommonUtils.StringUtils.isEmpty(cusStatus))
			cusStatus = "FINDVIEW";
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				addUI();
			}
		});
	}

	private void addUI() {
		try {
			billUI = (CoreUIObject) UIFactoryHelper.initUIObject(getClientUIClassName(), getUIContext(), getDataObjects(), cusStatus);
		} catch (UIException e) {
			handUIException(e);
			e.printStackTrace();
		}
		if (billUI == null) {
			logger.info(getClientUIClassName() + msg_2);
			return;
		}

		if (billUI.getPreferredSize().width == 0 || billUI.getPreferredSize().height == 0) {
			if (billUI.getLayout() == null)
				billUI.setBounds(0, 0, 720, 463);
			if (billUI.getLayout() instanceof KDLayout)
				billUI.setSize(700, 463);
		} else {
			billUI.setBounds(0, 0, 700, 463);
		}
		mainPanel.add(billUI, null);
		mainPanel.updateUI();
		afterAddClientUI();
		setMainToolMenu();
	}

	protected void afterAddClientUI() {

	}

	protected void setMainToolMenu() {
		Component[] components = billUI.getUIToolBar().getToolBarComponents();
		for (int i = 0; i < getToolBarNames().length; i++) {
			String barName = getToolBarNames()[i];
			Component bar = getBarComp(barName, components);
			if (bar != null && bar instanceof KDWorkButton) {
				getUIToolBar().addWorkButton((KDWorkButton) bar);
			}
		}
	}

	private Component getBarComp(String barName, Component[] components) {
		if (components == null || barName == null) {
			return null;
		}
		for (int i = 0; i < components.length; i++) {
			if (barName.equals(components[i].getName())) {
				return components[i];
			}
		}
		return null;
	}

	protected String[] getToolBarNames() {
		return new String[] {};
	}

	protected Map getAllActions() {
		if (billUI == null) {
			return null;
		}
		return billUI.getActionManager().getActionSet();
	}

	protected ItemAction getAction(String actionName) {
		if (billUI == null) {
			return null;
		}
		ItemAction itemAction = billUI.getActionManager().getAction(actionName);
		if (itemAction == null) {
			logger.error("==============can not find ItemAction : " + actionName);
		}
		return itemAction;
	}

	protected void initListener() {
		super.initListener();
		loadUI();
		this.addComponentListener(new ComponentListener() {
			public void componentHidden(ComponentEvent e) {
			}

			public void componentMoved(ComponentEvent e) {
			}

			public void componentResized(ComponentEvent e) {
				windowResized(e);
			}

			public void componentShown(ComponentEvent e) {
			}
		});
	}

	private void jbInit() throws Exception {
		this.setUITitle(getUiTitle());
		this.kDSeparator2 = new com.kingdee.bos.ctrl.swing.KDSeparator();
		this.EDok = new com.kingdee.bos.ctrl.swing.KDButton();
		this.EDcancel = new com.kingdee.bos.ctrl.swing.KDButton();
		this.mainPanel = new com.kingdee.bos.ctrl.swing.KDPanel();
		this.kDSeparator2.setName("kDSeparator2");
		this.EDok.setName("EDok");
		this.EDcancel.setName("EDcancel");
		this.mainPanel.setName("mainPanel");
		this.EDok.setText("ȷ");
		this.EDcancel.setText("ȡ");
		this.EDok.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent e) {
				beforeActionPerformed(e);
				try {
					EDok_actionPerformed(e);
				} catch (Exception exc) {
					handUIException(exc);
				} finally {
					afterActionPerformed(e);
				}
			}
		});
		this.EDcancel.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent e) {
				beforeActionPerformed(e);
				try {
					EDcancel_actionPerformed(e);
				} catch (Exception exc) {
					handUIException(exc);
				} finally {
					afterActionPerformed(e);
				}
			}
		});

	}

	public String getUiTitle() {
		return uiTitle;
	}

	public void setUiTitle(String uiTitle) {
		this.uiTitle = uiTitle;
	}

	public void initUIContentLayout() {
		this.setBounds(new Rectangle(10, 10, 700, 500));
		this.setLayout(null);
		kDSeparator2.setBounds(new Rectangle(4, 466, 693, 10));
		this.add(kDSeparator2, null);
		EDok.setBounds(new Rectangle(500, 473, 76, 21));
		this.add(EDok, null);
		EDcancel.setBounds(new Rectangle(601, 473, 76, 21));
		this.add(EDcancel, null);
		mainPanel.setBounds(new Rectangle(0, 0, 720, 453));
		this.add(mainPanel, null);
		mainPanel.setLayout(null);
	}

	public void initUIMenuBarLayout() {
		this.menuBar.add(menuFile);
		this.menuBar.add(menuTool);
		this.menuBar.add(menuHelp);
		menuFile.add(menuItemPageSetup);
		menuFile.add(kDSeparator1);
		menuFile.add(menuItemExitCurrent);
		menuTool.add(menuItemSendMessage);
		menuTool.add(menuItemCalculator);
		menuHelp.add(menuItemHelp);
		menuHelp.add(kDSeparator12);
		menuHelp.add(menuItemRegPro);
		menuHelp.add(menuItemPersonalSite);
		menuHelp.add(helpseparatorDiv);
		menuHelp.add(menuitemProductval);
		menuHelp.add(kDSeparatorProduct);
		menuHelp.add(menuItemAbout);

	}

	public void initUIToolBarLayout() {
		this.toolBar.add(btnPageSetup);
	}

	protected void EDok_actionPerformed(java.awt.event.ActionEvent e) throws Exception {
	}

	protected void EDcancel_actionPerformed(java.awt.event.ActionEvent e) throws Exception {
		getUIWindow().close();
	}

	public IMetaDataPK getMetaDataPK() {
		return null;
	}

	public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
		super.actionExitCurrent_actionPerformed(e);
	}

}