package com.kingdee.eas.lifetime.util.baseDataWindow.commonui.impl;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import javax.swing.JComponent;
import javax.swing.tree.TreePath;

import org.apache.log4j.Logger;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.lifetime.util.jcomponentutil.EDjComponentUtil;
import com.kingdee.eas.lifetime.util.kdcontrolutils.EDkdTableUtil;
import com.kingdee.eas.lifetime.util.kdcontrolutils.EDtreeUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.AbortException;
import com.kingdee.eas.util.client.MsgBox;

/**
 * @author lifeTime
 * 
 */
public class EDcommonUI extends AbstractEDcommonUI {
	private static final long serialVersionUID = 1L;
	static final Logger logger = CoreUIObject.getLogger(EDcommonUI.class);
	private List data;

	/**
	 * 
	 */
	public static final String Data = "date";

	/**
	 * ҪصUI
	 */
	public static final String ClientUIClassName = "clientUIClassName";
	/**
	 * ӦȷťĿؼ
	 */
	public static final String FetchDataControlName = "fetchDataControlName";
	/**
	 * 
	 */
	public static final String IS_Mutil_Select = "mutilSelect";

	/**
	 * ҵӿ
	 */
	public static final String BizInface = "bizInface";

	/**
	 * ҵӿڹid(KDTable)
	 */
	public static final String BizIdName = "bizIdName";

	JComponent fatchDataComponent;

	public EDcommonUI() throws Exception {
		super();
		data = new ArrayList();
	}

	public void onLoad() throws Exception {
		super.onLoad();
	}

	protected void afterAddClientUI() {
		super.afterAddClientUI();
		fatchDataComponent = EDjComponentUtil.getComponentByName(getFetchDataControlName(), this);
		if (fatchDataComponent != null) {
			EDjComponentUtil.removeAllKeyListeners(fatchDataComponent);
			EDjComponentUtil.removeClickListeners(fatchDataComponent);
			if (fatchDataComponent instanceof KDTable) {
				final KDTable table = (KDTable) fatchDataComponent;
				table.addKDTMouseListener(new KDTMouseListener() {
					public void tableClicked(KDTMouseEvent e) {
						EDcommonUI.this.tableClicked(e, table);
					}
				});
			}
		}
	}

	protected String[] getToolBarNames() {
		return new String[] { "btnQuery" };
	}

	/**
	 * ҵӿڹid
	 * 
	 * @return
	 */
	public String getBizIdName() {
		Object bizIdName = getUIContext().get(BizIdName);
		if (bizIdName == null) {
			return "id";
		} else {
			return bizIdName.toString();
		}
	}

	public boolean isMutilSelectMode() {
		Object selectMode = getUIContext().get(IS_Mutil_Select);
		if (selectMode == null) {
			return false;
		} else if (selectMode instanceof Boolean) {
			return ((Boolean) selectMode).booleanValue();
		}
		return false;
	}

	public void setMutilSelectMode(boolean mode) {
		getUIContext().put(IS_Mutil_Select, Boolean.valueOf(mode));
	}

	public ICoreBase getBizInteface() {
		Object inface = getUIContext().get(BizInface);
		return inface == null ? null : inface instanceof ICoreBase ? (ICoreBase) inface : null;
	}

	protected void EDcancel_actionPerformed(ActionEvent e) throws Exception {
		closeWindow();
	}

	protected boolean closeWindow() {
		return getUIWindow().close();
	}

	protected void EDok_actionPerformed(ActionEvent e) throws Exception {
		data.clear();
		if (fatchDataComponent == null) {
			throw new RuntimeException("ûҵָĿؼ" + getFetchDataControlName());
		} else if (fatchDataComponent instanceof KDTable) {
			KDTable table = (KDTable) fatchDataComponent;
			prepareTableData(table);
		} else if (fatchDataComponent instanceof KDTree) {
			prepareTreeData((KDTree) fatchDataComponent);
		} else {
			throw new RuntimeException("ָ֧ؼȡĿǰֵ֧ĿؼΪKDTable,KDTree");
		}
		prepareData();
	}

	protected void prepareData() {
		if (closeWindow()) {
			getUIContext().put(Data, data);
		} else {
			data.clear();
		}
	}

	protected void tableClicked(KDTMouseEvent e, KDTable table) {
		if (e.getClickCount() == 2) {
			throw new AbortException();
		}
	}

	protected List prepareTableData(KDTable table) {
		EDkdTableUtil.SelectManager.checkSelect(table);
		int[] counts = EDkdTableUtil.SelectManager.getSelectedRows(table);
		int columnCount = table.getColumnCount();
		String[] keys = new String[columnCount];
		for (int i = 0; i < columnCount; i++) {
			keys[i] = table.getColumn(i).getKey();
		}
		for (int i = 0; i < counts.length; i++) {
			int index = counts[i];
			IRow row = table.getRow(index);
			if (getBizInteface() != null && row.getCell(getBizIdName()) != null) {
				try {
					CoreBaseInfo baseInfo = getBizInteface().getValue(new ObjectUuidPK(row.getCell(getBizIdName()).getValue().toString()));
					data.add(baseInfo);
				} catch (EASBizException e) {
					e.printStackTrace();
				} catch (BOSException e) {
					e.printStackTrace();
				}
			} else {
				HashMap rowMap = new HashMap();
				for (int j = 0; j < keys.length; j++) {
					rowMap.put(keys[j], row.getCell(keys[j]).getValue());
				}
				data.add(rowMap);
			}
		}
		logger.info("======ѡ" + data.size() + ".");
		return data;
	}

	protected List prepareTreeData(KDTree tree) {
		TreePath treePath = tree.getSelectionPath();
		if (treePath == null) {
			MsgBox.showInfo("ѡб");
		}
		if (isMutilSelectMode()) {
			DefaultKingdeeTreeNode[] nodes = EDtreeUtil.getCheckedNodes(tree);
			for (int i = 0; i < nodes.length; i++) {
				data.add(nodes[i].getUserObject());
			}
		} else {
			DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode) treePath.getLastPathComponent();
			data.add(node.getUserObject());
		}
		logger.info("======ѡ" + data.size() + ".");
		return data;
	}

	public String getClientUIClassName() {
		Object clientClass = getUIContext().get(ClientUIClassName);
		if (clientClass == null) {
			throw new RuntimeException("ָclientUIClassNameΪգ");
		} else if (clientClass instanceof String) {
			return clientClass.toString();
		} else if (clientClass instanceof Class) {
			return ((Class) clientClass).getName();
		} else {
			throw new RuntimeException("δָܽclientUIClassName");
		}
	}

	public String getFetchDataControlName() {
		Object controlName = getUIContext().get(FetchDataControlName);
		if (controlName == null) {
			throw new RuntimeException("ָfetchDataControlNameΪգ");
		} else if (controlName instanceof String) {
			return controlName.toString();
		} else {
			throw new RuntimeException("δָܽfetchDataControlName");
		}
	}

	public IMetaDataPK getMetaDataPK() {
		return new MetaDataPK("com.kingdee.eas.lifetime.util.baseDataWindow.commonui.impl", "EDcommonUI");
	}

}