package com.kingdee.eas.lifetime.util.baseDataWindow.commonui.impl;

import java.awt.Color;
import java.util.List;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import org.apache.log4j.Logger;

import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.lifetime.util.baseDataWindow.commonui.info.FindItem;
import com.kingdee.eas.lifetime.util.edcommonutils.EDcommonUtils;
import com.kingdee.eas.lifetime.util.kdcontrolutils.EDkdTableUtil;
import com.kingdee.eas.util.SysUtil;

/**
 * ٶλ</br> ʾ÷<br>
 * 
 * <pre>
 * Map uiCon = new HashMap();
 * FindItem findItem0 = new FindItem(&quot;column1&quot;, &quot;һ&quot;);
 * FindItem findItem = new FindItem(&quot;column2&quot;, &quot;ڶ&quot;);
 * ArrayList list = new ArrayList();
 * list.add(findItem0);
 * list.add(findItem);
 * uiCon.put(EDlocaltionUI.Table_Key, kDTable1);
 * uiCon.put(EDlocaltionUI.FindItems_Key, list);
 * IUIWindow window = EDwindowUtil.getWindow(uiCon, EDlocaltionUI.class.getName());
 * window.show();
 * </pre>
 * 
 * @author lifeTime 2009-10-22 11:19:31
 */
public class EDlocaltionUI extends AbstractEDlocaltionUI {

	private static final long serialVersionUID = 1L;
	/**
	 * ȫѯitem
	 */
	private static final FindItem allTableSelectItem = new FindItem("EDlocaltionUI_All_Table_Select", "ȫѯ");
	private static final Color selectCellBgColor = Color.lightGray;

	/**
	 * 趨λtable
	 */
	public static final String Table_Key = "table";
	/**
	 * ΪFindItemlist
	 */
	public static final String FindItems_Key = "findItems";
	/**
	 * Ƿȫѯѡ
	 */
	public static final String IsAllSelect_Key = "isAllSelect";

	/**
	 * cellѡкıɫΪȡϵͳĬɫ(Color.lightGray)
	 */
	public static final String SelectCellBgColor = "SelectCellBgColor";

	protected KDTable table;
	protected List findItems;
	protected Color oldCellBgColor;

	private int oldRowIndex;
	private int oldColIndex;
	/**
	 * Ƿȫѯ(ĬΪtrue)
	 */
	private boolean isAllSelect = true;

	private Color cellSelectBgColor;

	public EDlocaltionUI() throws Exception {
		super();
	}

	public void onLoad() throws Exception {
		super.onLoad();
		initData();
		initControl();
		settingContrlDefaultAction();
	}

	protected void initData() {
		if (getUIContext().containsKey(Table_Key)) {
			table = (KDTable) getUIContext().get(Table_Key);
		}
		if (getUIContext().containsKey(FindItems_Key)) {
			findItems = (List) getUIContext().get(FindItems_Key);
		}
		if (getUIContext().containsKey(IsAllSelect_Key)) {
			isAllSelect = Boolean.valueOf(getUIContext().get(IsAllSelect_Key).toString()).booleanValue();
		}
		if (getUIContext().containsKey(SelectCellBgColor)) {
			cellSelectBgColor = (Color) getUIContext().get(SelectCellBgColor);
		}
	}

	protected void initControl() {
		EDisLikeQuery.addChangeListener(new ChangeListener() {
			public void stateChanged(ChangeEvent e) {
				action_isLikeQuery(e);
			}
		});
	}

	protected void action_isLikeQuery(ChangeEvent e) {

	}

	protected void settingContrlDefaultAction() {
		if (findItems != null && !findItems.isEmpty()) {
			if (isAllSelect()) {
				EDlocalContentList.addElement(allTableSelectItem);
			}
			for (int i = 0, k = findItems.size(); i < k; i++) {
				EDlocalContentList.addElement(findItems.get(i));
			}
			if (EDlocalContentList.getElementCount() > 0) {
				EDlocalContentList.setSelectedIndex(0);
			}
		}
		EDisLikeQuery.setSelected(true);
		EDloopLocal.setSelected(true);
		EDinputContent.requestFocus();
	}

	public void verifyData() throws Exception {
		super.verifyData();
		if (table == null) {
			throw new RuntimeException("ָλıΪգ");
		}
		Object obj = EDlocalContentList.getSelectedValue();
		if (obj != null && obj instanceof FindItem) {
			FindItem findItem = (FindItem) obj;
			if (findItem != allTableSelectItem) {
				if (findItem.getFindKey() == null) {
					throw new RuntimeException(findItem + "δָkey");
				}
				if (table.getColumn(findItem.getFindKey()) == null) {
					throw new RuntimeException("ָkey[" + findItem.getFindKey() + "]ڣ");
				}
			}
		}
		String findName = EDinputContent.getText();
		if (EDcommonUtils.StringUtils.isEmpty(findName)) {
			SysUtil.abort();
		}
	}

	protected void EDcancel_actionPerformed(java.awt.event.ActionEvent e) throws Exception {
		super.EDcancel_actionPerformed(e);
		this.getUIWindow().close();
	}

	protected void EDok_actionPerformed(java.awt.event.ActionEvent e) throws Exception {
		super.EDok_actionPerformed(e);
		verifyData();
		Object obj = EDlocalContentList.getSelectedValue();
		doOK((FindItem) obj);
	}

	protected void doOK(FindItem findItem) {
		if (allTableSelectItem == findItem) {
			doAllSelect();
		} else {
			doSingleSelect(findItem.getFindKey());
		}
	}

	/**
	 * ȫѯ
	 */
	protected void doAllSelect() {
		boolean isLikeQuery = EDisLikeQuery.isSelected();
		String findName = EDinputContent.getText();
		int rowIndex = getRowIndex();
		int colIndex = getColIndex();
		if (EDloopLocal.isSelected()) {
			loopFind(rowIndex, colIndex, isLikeQuery, findName);
		} else if (EDforwardLocal.isSelected()) {
			forwardFind(rowIndex, colIndex, isLikeQuery, findName);
		} else if (EDbackwardLocal.isSelected()) {
			backwardFind(rowIndex, colIndex, isLikeQuery, findName);
		}
	}

	/**
	 * ȫѯ
	 */
	protected void doSingleSelect(String findKey) {
		boolean isLikeQuery = EDisLikeQuery.isSelected();
		String findName = EDinputContent.getText();
		int rowIndex = getRowIndex();
		int colIndex = getColIndex();
		if (EDloopLocal.isSelected()) {
			loopColumnFind(rowIndex, colIndex, isLikeQuery, findName, findKey);
		} else if (EDforwardLocal.isSelected()) {
			forwardColumnFind(rowIndex, colIndex, isLikeQuery, findName, findKey);
		} else if (EDbackwardLocal.isSelected()) {
			backwardColumnFind(rowIndex, colIndex, isLikeQuery, findName, findKey);
		}
	}

	private Object getCellValue(int rowIndex, int colIndex) {
		return table.getCell(rowIndex, colIndex).getValue();
	}

	protected void loopFind(int rowIndex, int colIndex, boolean isLikeQuery, String findName) {
		int rowCount = table.getRowCount();
		int colCount = table.getColumnCount();
		int allCount = rowCount * colCount;
		int k = 0;
		loop1: for (; rowIndex < rowCount; rowIndex++) {
			for (; colIndex < colCount; colIndex++, k++) {
				if (getRowIndex() == rowIndex && getColIndex() == colIndex) {
					if (rowIndex == rowCount - 1 && colIndex == colCount - 1) {
						rowIndex = -1;
						colIndex = 0;
						continue loop1;
					}
					continue;
				}
				Object cellObj = getCellValue(rowIndex, colIndex);
				String cellStr = cellObj == null ? "" : cellObj.toString();
				if (isLikeQuery) {
					if (cellStr == findName || cellStr.indexOf(findName) != -1) {
						selectCell(rowIndex, colIndex);
						break loop1;
					}
				} else {
					if (cellStr == findName || cellStr.equals(findName)) {
						selectCell(rowIndex, colIndex);
						break loop1;
					}
				}
				if (rowIndex == rowCount - 1 && colIndex == colCount - 1) {
					rowIndex = -1;
					colIndex = 0;
					continue loop1;
				}
				if (k == allCount) {
					rowIndex = -1;
					colIndex = 0;
					break loop1;
				}
			}
			colIndex = 0;
		}
	}

	/**
	 * еѭ
	 * 
	 * @param rowIndex
	 * @param colIndex
	 * @param isLikeQuery
	 * @param findName
	 * @param findKey
	 */
	protected void loopColumnFind(int rowIndex, int colIndex, boolean isLikeQuery, String findName, String findKey) {
		int rowCount = table.getRowCount();
		int k = 0;
		int selectColumnIndex = table.getColumnIndex(findKey);
		for (; rowIndex < rowCount; rowIndex++, k++) {
			if (getRowIndex() == rowIndex && getColIndex() == colIndex) {
				if (rowIndex == rowCount - 1) {
					rowIndex = -1;
				}
				continue;
			}
			Object cellValue = table.getCell(rowIndex, findKey).getValue();
			if (isLikeQuery) {
				if ((cellValue == null ? "" : cellValue.toString()).indexOf(findName) != -1) {
					selectCell(rowIndex, selectColumnIndex);
					break;
				}
			} else {
				if (findName.equals(cellValue == null ? "" : cellValue.toString())) {
					selectCell(rowIndex, selectColumnIndex);
					break;
				}
			}
			if (k == rowCount) {
				break;
			}
			if (rowIndex == rowCount - 1) {
				rowIndex = -1;
			}
		}
	}

	/**
	 * еǰ
	 * 
	 * @param rowIndex
	 * @param colIndex
	 * @param isLikeQuery
	 * @param findName
	 * @param findKey
	 */
	protected void forwardColumnFind(int rowIndex, int colIndex, boolean isLikeQuery, String findName, String findKey) {
		if (rowIndex == 0) {
			return;
		}
		int selectColumnIndex = table.getColumnIndex(findKey);
		for (int i = rowIndex; i > 0; i--) {
			if (getRowIndex() == rowIndex && getColIndex() == colIndex) {
				continue;
			}
			Object cellValue = table.getCell(rowIndex, findKey).getValue();
			if (isLikeQuery) {
				if ((cellValue == null ? "" : cellValue.toString()).indexOf(findName) != -1) {
					selectCell(rowIndex, selectColumnIndex);
					break;
				}
			} else {
				if (findName.equals(cellValue == null ? "" : cellValue.toString())) {
					selectCell(rowIndex, selectColumnIndex);
					break;
				}
			}
		}
	}

	protected void backwardColumnFind(int rowIndex, int colIndex, boolean isLikeQuery, String findName, String findKey) {
		int rowCount = table.getRowCount();
		if (rowIndex == rowCount - 1) {
			return;
		}
		int selectColumnIndex = table.getColumnIndex(findKey);
		for (int i = rowIndex; i < rowCount; i++) {
			if (getRowIndex() == rowIndex && getColIndex() == colIndex) {
				continue;
			}
			Object cellValue = table.getCell(rowIndex, findKey).getValue();
			if (isLikeQuery) {
				if ((cellValue == null ? "" : cellValue.toString()).indexOf(findName) != -1) {
					selectCell(rowIndex, selectColumnIndex);
					break;
				}
			} else {
				if (findName.equals(cellValue == null ? "" : cellValue.toString())) {
					selectCell(rowIndex, selectColumnIndex);
					break;
				}
			}
		}
	}

	protected void disposeUIWindow() {
		super.disposeUIWindow();
		table.getCell(oldRowIndex, oldColIndex).getStyleAttributes().setBackground(oldCellBgColor);
	}

	protected void forwardFind(int rowIndex, int colIndex, boolean isLikeQuery, String findName) {
		if (rowIndex == 0 && colIndex == 0) {
			return;
		}
		loop1: for (; rowIndex >= 0; rowIndex--) {
			for (; colIndex >= 0; colIndex--) {
				if (getRowIndex() == rowIndex && getColIndex() == colIndex) {
					continue;
				}
				Object cellObj = getCellValue(rowIndex, colIndex);
				String cellStr = cellObj == null ? "" : cellObj.toString();
				if (isLikeQuery) {
					if (cellStr == findName || cellStr.indexOf(findName) != -1) {
						selectCell(rowIndex, colIndex);
						break loop1;
					}
				} else {
					if (cellStr == findName || cellStr.equals(findName)) {
						selectCell(rowIndex, colIndex);
						break loop1;
					}
				}
			}
			colIndex = table.getColumnCount() - 1;
		}
	}

	protected void backwardFind(int rowIndex, int colIndex, boolean isLikeQuery, String findName) {
		if (table.getRowCount() - 1 == rowIndex && table.getColumnCount() - 1 == colIndex) {
			return;
		}
		int rowCount = table.getRowCount();
		int colCount = table.getColumnCount();
		loop1: for (; rowIndex < rowCount; rowIndex++) {
			for (; colIndex < colCount; colIndex++) {
				if (getRowIndex() == rowIndex && getColIndex() == colIndex) {
					continue;
				}
				Object cellObj = getCellValue(rowIndex, colIndex);
				String cellStr = cellObj == null ? "" : cellObj.toString();
				if (isLikeQuery) {
					if (cellStr == findName || cellStr.indexOf(findName) != -1) {
						selectCell(rowIndex, colIndex);
						break loop1;
					}
				} else {
					if (cellStr == findName || cellStr.equals(findName)) {
						selectCell(rowIndex, colIndex);
						break loop1;
					}
				}
			}
			colIndex = 0;
		}
	}

	private void selectCell(int rowIndex, int colIndex) {
		table.getCell(oldRowIndex, oldColIndex).getStyleAttributes().setBackground(oldCellBgColor);
		oldRowIndex = rowIndex;
		oldColIndex = colIndex;
		oldCellBgColor = table.getCell(rowIndex, colIndex).getStyleAttributes().getBackground();
		Color bgColor = getCellSelectBgColor() == null ? selectCellBgColor : getCellSelectBgColor();
		table.getCell(rowIndex, colIndex).getStyleAttributes().setBackground(bgColor);
		table.getSelectManager().select(rowIndex, colIndex);
	}

	private int getRowIndex() {
		return EDkdTableUtil.SelectManager.getSelectedRow(table);
	}

	private int getColIndex() {
		if (table.getSelectManager().size() == 0) {
			return -1;
		} else {
			return table.getSelectManager().get().getLeft();
		}
	}

	public boolean isAllSelect() {
		return isAllSelect;
	}

	public void setAllSelect(boolean isAllSelect) {
		this.isAllSelect = isAllSelect;
	}

	public Color getCellSelectBgColor() {
		return cellSelectBgColor;
	}

	public void setCellSelectBgColor(Color cellSelectBgColor) {
		this.cellSelectBgColor = cellSelectBgColor;
	}

}