package com.kingdee.eas.lifetime.util.baseDataWindow.commonui.ui;

import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

import org.apache.log4j.Logger;

import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.view.BusinessObjectBriefView;
import com.kingdee.bos.metadata.view.MetaDataBriefInfo;
import com.kingdee.bos.service.formula.engine.FormulaException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.lifetime.util.kdcontrolutils.EDtreeUtil;
import com.kingdee.eas.common.SubSystemUtils;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;

/**
 * ʵṹ,˫OKʱֵ,ֵΪѡĽڵ㼯.ʵɼ̳ʵ.
 * 
 * @author lifeTime
 * 
 */
public class EDentityTreeUI extends CoreUI {
	private static final Logger logger = CoreUIObject.getLogger(EDentityTreeUI.class);
	protected com.kingdee.bos.ctrl.swing.KDTreeView EDentityMenuTreeView;
	protected com.kingdee.bos.ctrl.swing.KDTree EDentityMenuTree;
	protected com.kingdee.bos.ctrl.swing.KDSeparator kDSeparator2;
	protected com.kingdee.bos.ctrl.swing.KDWorkButton EDok;
	protected com.kingdee.bos.ctrl.swing.KDWorkButton EDcancel;

	/**
	 * ǷΪѡ no : ʾԶѡ yes : ʾԶѡ
	 */
	public static final String IsMultipleSelect = "isMultipleSelect";
	private static final String Yes = "yes";
	private static final String No = "no";

	/**
	 * 
	 */
	public static final String ResultObject = "resultObject";

	/**
	 * ʾǷȷť
	 */
	public static final String isOK = "ok";

	private static final String personSign = "com.kingdee.eas.basedata.person.Person";

	public EDentityTreeUI() throws Exception {
		super();
		jbInit();
	}

	public void onLoad() throws Exception {
		super.onLoad();
		initPropValue();
		this.setUITitle("ʵȡֵ");
	}

	private void initPropValue() {
		EDentityMenuTree.setRootVisible(true);
		EDentityMenuTree.setToggleClickCount(1);
		EDentityMenuTree.setShowsRootHandles(true);
		initTreeSelectMode();
		EDentityMenuTree.getSelectionModel().setSelectionMode(1);
		EDentityMenuTree.addTreeSelectionListener(new TreeSelectionListener() {
			public void valueChanged(TreeSelectionEvent e) {
				treePropValue_valueChanged(e);
			}
		});

		EDentityMenuTree.addMouseListener(new MouseAdapter() {
			public void mouseClicked(MouseEvent mouseevent) {
				treePropValue_mouseClicked(mouseevent);
			}
		});

		IMetaDataLoader imetadataloader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
		BusinessObjectBriefView businessobjectbriefview = imetadataloader.getBusinessObjectBriefView(new MetaDataPK("com_kingdee_eas_base_subsystemEntity"));
		BOSObjectType abosobjecttype[] = { MetaDataTypeList.ENTITY };
		com.kingdee.bos.metadata.view.IBriefViewTreeNode ibriefviewtreenode = businessobjectbriefview.getViewRootByType(abosobjecttype);
		DefaultTreeModel defaulttreemodel = new DefaultTreeModel(SubSystemUtils.getKDTreeNode(ibriefviewtreenode));
		EDentityMenuTree.setModel(defaulttreemodel);
		EDentityMenuTree.updateUI();
	}

	protected void EDcancel_actionPerformed(ActionEvent e) throws Exception {
		this.disposeUIWindow();
	}

	protected void EDok_actionPerformed(ActionEvent e) throws Exception {
		doOK();
	}

	private void doOK() {
		getUIContext().put(isOK, isOK);
		EDtreeUtil.checkSelect(EDentityMenuTree);
		Object[] treepaths = EDentityMenuTree.getSelectionPath().getPath();
		if (treepaths == null) {
			getUIContext().put(ResultObject, null);
		} else {
			ArrayList resultList = new ArrayList();
			for (int i = treepaths.length - 1; i >= 0; i--) {
				DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode) treepaths[i];
				// if (!(node.getUserObject() instanceof MetaDataBriefInfo)) {
				resultList.add(node);
				// }
			}
			getUIContext().put(ResultObject, resultList);
		}
		this.disposeUIWindow();
	}

	/**
	 * ʼʵѡģʽ
	 */
	protected void initTreeSelectMode() {
		if (Yes.equals(getObjectString(getUIContext().get(IsMultipleSelect)))) {
			EDentityMenuTree.setShowCheckBox(true);
			EDentityMenuTree.setSyncChecked(true);
		}
	}

	private String getObjectString(Object obj) {
		return obj == null ? "" : obj.toString();
	}

	public void treePropValue_valueChanged(TreeSelectionEvent e) {

	}

	public void treePropValue_mouseClicked(MouseEvent mouseevent) {
		if (mouseevent.getClickCount() == 1) {
			oneClick();
		} else if (mouseevent.getClickCount() == 2) {
			doubleClick();
		}
	}

	protected void doubleClick() {
		canDoubleClick();
		getUIContext().put(isOK, isOK);
		TreePath treepath = EDentityMenuTree.getSelectionPath();
		if (treepath == null) {
			getUIContext().put(ResultObject, null);
		} else {
			DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode) treepath.getLastPathComponent();
			if (!(node.getUserObject() instanceof MetaDataBriefInfo)) {
				getUIContext().put(ResultObject, getNodeList(node, new ArrayList()));
			}
		}
		this.disposeUIWindow();
	}

	/**
	 * pathsϵUserObjects
	 * 
	 * @param node
	 * @param list
	 * @return
	 */
	private List getNodeList(DefaultKingdeeTreeNode node, List list) {
		list.add(node);
		if (node.getParent() == null) {
			return list;
		} else {
			getNodeList((DefaultKingdeeTreeNode) node.getParent(), list);
		}
		return list;
	}

	/**
	 * ѡʱ˫
	 */
	private void canDoubleClick() {
		if (Yes.equals(getObjectString(getUIContext().get(IsMultipleSelect)))) {
			SysUtil.abort();
		}
	}

	/**
	 * жǷǴpersonֱ
	 * 
	 * @param currentNode
	 * @return
	 */
	private boolean isPersonChild(DefaultKingdeeTreeNode currentNode) {
		DefaultKingdeeTreeNode parent = (DefaultKingdeeTreeNode) currentNode.getParent();
		Object obj = parent.getUserObject();
		if (obj instanceof EntityObjectInfo) {
			EntityObjectInfo parentEntity = (EntityObjectInfo) parent.getUserObject();
			if (personSign.equals(parentEntity.getBusinessImplName())) {
				return true;
			}
			return false;
		} else {
			return isPersonChild(parent);
		}
	}

	/**
	 * ԶӦݿֶ
	 * 
	 * @param propertyInfo
	 * @return
	 */
	private String getPropertyMappingField(OwnPropertyInfo propertyInfo) {
		logger.info(" ================ : " + (propertyInfo == null ? null : propertyInfo.getMappingField().getName()));
		String field = propertyInfo == null ? null : propertyInfo.getMappingField().getName();
		return field;
	}

	/**
	 * ԶӦݿֶ
	 * 
	 * @param propertyInfo
	 * @return
	 */
	private String getPropertyMappingField(LinkPropertyInfo propertyInfo) {
		logger.info(" ================ : " + (propertyInfo == null ? null : propertyInfo.getName()));
		String field = propertyInfo == null ? null : propertyInfo.getMappingField().getName();
		return field;
	}

	/**
	 * personʱɵsql
	 * 
	 * @param currentNode
	 * @return
	 */
	private String generateSqlInPerson(DefaultKingdeeTreeNode currentNode) {
		Object[] paths = EDentityMenuTree.getSelectionPath().getParentPath().getPath();
		String tableAlias = "\"t_bd_person\"";
		StringBuffer sqlPart1 = new StringBuffer(" select ");
		StringBuffer sqlPart2 = new StringBuffer(" from T_BD_Person " + tableAlias);
		StringBuffer sqlPart3 = new StringBuffer(" where " + tableAlias + ".fid = ");
		String endTableName = null;
		for (int i = 0; i < paths.length; i++) {
			DefaultKingdeeTreeNode parent = (DefaultKingdeeTreeNode) paths[i];
			Object info = parent.getUserObject();
			if (info instanceof LinkPropertyInfo) {
				LinkPropertyInfo linkProp = (LinkPropertyInfo) info;
				String linkTableName = getTableName(parent);
				String mappingFieldName = getPropertyMappingField(linkProp);
				sqlPart2.append("left join ").append(linkTableName + " " + linkTableName).append(" on t_bd_person.fid = " + linkTableName + "." + mappingFieldName);
				endTableName = linkTableName;
			}
		}
		OwnPropertyInfo propertyInfo = (OwnPropertyInfo) currentNode.getUserObject();
		String currentFieldName = getPropertyMappingField(propertyInfo);
		sqlPart1.append((endTableName == null ? tableAlias : endTableName) + "." + currentFieldName + " ");

		StringBuffer sql = sqlPart1.append(sqlPart2).append(sqlPart3);

		return sql.toString();
	}

	/**
	 * personʱɵsql
	 * 
	 * @param currentNode
	 * @param isLinkProp
	 *            Ƿ()
	 * @return
	 */
	private String generateSqlOutPerson(DefaultKingdeeTreeNode currentNode, boolean isLinkProp) {
		Object[] paths = EDentityMenuTree.getSelectionPath().getPath();
		StringBuffer sqlPart1 = new StringBuffer(" select ");
		StringBuffer sqlPart2 = new StringBuffer(" from ");
		StringBuffer sqlPart3 = new StringBuffer(" where t_bd_person.fid = ");
		String endTableName = null;
		String fromTableName = null;
		String endField = null;
		boolean temp = true;
		for (int i = 0; i < paths.length; i++) {
			DefaultKingdeeTreeNode current = null;
			if (paths[i] instanceof DefaultKingdeeTreeNode)
				current = (DefaultKingdeeTreeNode) paths[i];
			else
				continue;

			if (current.getUserObject() instanceof MetaDataBriefInfo) {
				continue;
			} else if (current.getUserObject() instanceof EntityObjectInfo) {
				EntityObjectInfo fromTableEntity = (EntityObjectInfo) current.getUserObject();
				fromTableName = getTableName(fromTableEntity);
				sqlPart2.append(fromTableName).append(" ").append(getTableAlias(fromTableName));
			} else if (current.getUserObject() instanceof OwnPropertyInfo) {
				OwnPropertyInfo ownPropertyInfo = (OwnPropertyInfo) current.getUserObject();
				endField = getPropertyMappingField(ownPropertyInfo);
				sqlPart1.append(" " + endTableName + "." + endField + " ");
			} else if (current.getUserObject() instanceof LinkPropertyInfo) {
				sqlPart2.append(getSqlWithLinkPro(current));
				endTableName = getTableName(current);
			}
			if (temp && isOneChildPerson(current)) {
				String tableName = getTableName(current);
				String linkTableName = getPropertyMappingField((LinkPropertyInfo) getChildPerson(current));
				sqlPart2.append(tableName + " " + tableName).append(" left join T_BD_Person t_bd_person on t_bd_person.fid = " + tableName + "." + linkTableName);
				temp = false;
			}

		}

		StringBuffer sql = sqlPart1.append(sqlPart2).append(sqlPart3);
		return sql.toString();
	}

	/**
	 * Ϊʱsql
	 * 
	 * @param node
	 * @return
	 */
	private String getSqlWithLinkPro(DefaultKingdeeTreeNode node) {
		DefaultKingdeeTreeNode parent = (DefaultKingdeeTreeNode) node.getParent();
		String parentTableName = getTableName(parent);
		StringBuffer sql = new StringBuffer();
		LinkPropertyInfo linkPropertyInfo = (LinkPropertyInfo) node.getUserObject();
		String mappingField = getPropertyMappingField(linkPropertyInfo);
		String linkTableName = getTableName(node);
		sql.append("left join " + linkTableName + " " + getTableAlias(linkTableName) + " on " + getTableAlias(linkTableName) + ".fid = " + getTableAlias(parentTableName) + "."
				+ mappingField);
		return sql.toString();
	}

	private String getTableAlias(String tableName) {
		return "\"" + tableName + "\"";
	}

	/**
	 * жϸýڵǷperson
	 * 
	 * @param parent
	 * @return
	 */
	private boolean isOneChildPerson(DefaultKingdeeTreeNode parent) {
		Object info = parent.getUserObject();
		if (info instanceof EntityObjectInfo) {
			PropertyCollection collection = ((EntityObjectInfo) info).getInheritedNoDuplicatedProperties();
			for (Iterator it = collection.iterator(); it.hasNext();) {
				PropertyInfo type = (PropertyInfo) it.next();
				if (type instanceof LinkPropertyInfo) {
					if (personSign.equals(((LinkPropertyInfo) type).getRelationship().getSupplierObject().getBusinessImplName())) {
						return true;
					}
					logger.info("businessInterface:        " + ((LinkPropertyInfo) type).getRelationship().getSupplierObject().getBusinessImplName());
				}
				logger.info("type.getMappingField()        " + type.getMappingField());
				logger.info("type.getName()         " + type.getName());
				logger.info("isLinkProp       " + (type instanceof LinkPropertyInfo == true ? "true" : "false"));
			}
		}
		return false;
	}

	/**
	 * жϸýڵǷperson
	 * 
	 * @param parent
	 * @return
	 */
	private PropertyInfo getChildPerson(DefaultKingdeeTreeNode parent) {
		Object info = parent.getUserObject();
		if (info instanceof EntityObjectInfo) {
			PropertyCollection collection = ((EntityObjectInfo) info).getInheritedNoDuplicatedProperties();
			for (Iterator it = collection.iterator(); it.hasNext();) {
				PropertyInfo type = (PropertyInfo) it.next();
				if (type instanceof LinkPropertyInfo) {
					if (personSign.equals(((LinkPropertyInfo) type).getRelationship().getSupplierObject().getBusinessImplName())) {
						return type;
					}
					logger.info("businessInterface:        " + ((LinkPropertyInfo) type).getRelationship().getSupplierObject().getBusinessImplName());
				}
				logger.info("type.getMappingField()        " + type.getMappingField());
				logger.info("type.getName()         " + type.getName());
				logger.info("isLinkProp       " + (type instanceof LinkPropertyInfo == true ? "true" : "false"));
			}
		}
		return null;
	}

	private String getTableName(DefaultKingdeeTreeNode node) {
		if (node.getUserObject() instanceof LinkPropertyInfo) {
			EntityObjectInfo parentEntity = getLinkEntityObjectInfo(node);
			return getTableName(parentEntity);
		} else if (node.getUserObject() instanceof EntityObjectInfo) {
			return getTableName((EntityObjectInfo) node.getUserObject());
		} else {
			return null;
		}
	}

	private String getTableName(EntityObjectInfo entity) {
		return entity == null ? null : entity.getTable() == null ? null : entity.getTable().getName();
	}

	/**
	 * ѡʱ
	 */
	protected void selectProperty(DefaultKingdeeTreeNode currentNode) {
		if (isPersonChild(currentNode)) {
			generateSqlInPerson(currentNode);
		} else {
			generateSqlOutPerson(currentNode, true);
		}
	}

	protected void oneClick() {
		TreePath treepath = EDentityMenuTree.getSelectionPath();
		if (treepath == null)
			return;
		DefaultKingdeeTreeNode defaultkingdeetreenode = (DefaultKingdeeTreeNode) treepath.getLastPathComponent();
		if (defaultkingdeetreenode.getUserObject() instanceof MetaDataBriefInfo) {
			MetaDataBriefInfo metadatabriefinfo = (MetaDataBriefInfo) defaultkingdeetreenode.getUserObject();
			BOSObjectType bosobjecttype = metadatabriefinfo.getMetaDataType();
			if (bosobjecttype.toString().equalsIgnoreCase("pack"))
				handlePackNode((DefaultKingdeeTreeNode) treepath.getLastPathComponent(), 2);
			else if (bosobjecttype.toString().equalsIgnoreCase("enty"))
				handleEntyNode((DefaultKingdeeTreeNode) treepath.getLastPathComponent(), 3);
		} else if (defaultkingdeetreenode.getUserObject() instanceof PropertyInfo)
			handlePropNode(defaultkingdeetreenode, 3);
		else if (defaultkingdeetreenode.getUserObject() instanceof EntityObjectInfo)
			handlePropNode((DefaultKingdeeTreeNode) treepath.getLastPathComponent(), 3);
		else
			throw new FormulaException("not support parentNode is " + defaultkingdeetreenode.getUserObject().getClass().getName());
	}

	private void handleEntyNode(DefaultKingdeeTreeNode defaultkingdeetreenode, int i) {
		if (i > 0) {
			MetaDataBriefInfo metadatabriefinfo = (MetaDataBriefInfo) defaultkingdeetreenode.getUserObject();
			IMetaDataLoader imetadataloader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
			EntityObjectInfo entityobjectinfo = imetadataloader.getEntity(metadatabriefinfo.getMetaDataPK());
			defaultkingdeetreenode.setUserObject(entityobjectinfo);
			handlePropNode(defaultkingdeetreenode, i);
		}
	}

	private void handlePropNode(DefaultKingdeeTreeNode defaultkingdeetreenode, int i) {
		if (i > 0) {
			DefaultKingdeeTreeNode defaultkingdeetreenode1 = (DefaultKingdeeTreeNode) defaultkingdeetreenode.getParent();
			if (defaultkingdeetreenode.getUserObject() instanceof LinkPropertyInfo) {
				if (defaultkingdeetreenode1.getUserObject() instanceof EntityObjectInfo) {
					EntityObjectInfo entityobjectinfo = getLinkEntityObjectInfo(defaultkingdeetreenode);
					PropertyCollection propertycollection = entityobjectinfo.getInheritedNoDuplicatedProperties();
					handlePropCol(defaultkingdeetreenode, i, propertycollection);
				} else if (defaultkingdeetreenode1.getUserObject() instanceof MetaDataBriefInfo) {
					EntityObjectInfo entityobjectinfo1 = getLinkEntityObjectInfo(defaultkingdeetreenode);
					PropertyCollection propertycollection1 = entityobjectinfo1.getInheritedNoDuplicatedProperties();
					handlePropCol(defaultkingdeetreenode, i, propertycollection1);
				} else if (defaultkingdeetreenode1.getUserObject() instanceof LinkPropertyInfo) {
					EntityObjectInfo entityobjectinfo2 = getLinkEntityObjectInfo(defaultkingdeetreenode);
					PropertyCollection propertycollection2 = entityobjectinfo2.getInheritedNoDuplicatedProperties();
					handlePropCol(defaultkingdeetreenode, i, propertycollection2);
				} else {
					throw new FormulaException("not support " + defaultkingdeetreenode1.getUserObject().getClass().getName());
				}
			} else if (!(defaultkingdeetreenode.getUserObject() instanceof OwnPropertyInfo))
				if (defaultkingdeetreenode.getUserObject() instanceof EntityObjectInfo) {
					EntityObjectInfo entityobjectinfo3 = (EntityObjectInfo) defaultkingdeetreenode.getUserObject();
					PropertyCollection propertycollection3 = entityobjectinfo3.getInheritedNoDuplicatedProperties();
					handlePropCol(defaultkingdeetreenode, i, propertycollection3);
				} else {
					throw new FormulaException("not support " + defaultkingdeetreenode.getUserObject().getClass());
				}
		}
	}

	private void handlePropCol(DefaultKingdeeTreeNode defaultkingdeetreenode, int i, PropertyCollection propertycollection) {
		boolean flag = defaultkingdeetreenode.getChildCount() == 0;
		if (i > 0)
			if (flag) {
				addchildNode(defaultkingdeetreenode, i, propertycollection);
			} else {
				for (int j = 0; j < defaultkingdeetreenode.getChildCount(); j++)
					handlePropNode((DefaultKingdeeTreeNode) defaultkingdeetreenode.getChildAt(j), i - 1);

			}
	}

	private void handlePackNode(DefaultKingdeeTreeNode defaultkingdeetreenode, int i) {
		if (i > 0) {
			for (int j = 0; j < defaultkingdeetreenode.getChildCount(); j++) {
				DefaultKingdeeTreeNode defaultkingdeetreenode1 = (DefaultKingdeeTreeNode) defaultkingdeetreenode.getChildAt(j);
				if (defaultkingdeetreenode1 instanceof DefaultKingdeeTreeNode) {
					if (defaultkingdeetreenode1.getUserObject() instanceof MetaDataBriefInfo) {
						MetaDataBriefInfo metadatabriefinfo = (MetaDataBriefInfo) defaultkingdeetreenode1.getUserObject();
						BOSObjectType bosobjecttype = metadatabriefinfo.getMetaDataType();
						if (bosobjecttype.toString().equalsIgnoreCase("enty")) {
							handleEntyNode(defaultkingdeetreenode1, i);
							continue;
						}
						if (bosobjecttype.toString().equalsIgnoreCase("pack"))
							handlePackNode(defaultkingdeetreenode1, i - 1);
						else
							throw new FormulaException("not support childNode is " + bosobjecttype.toString());
						continue;
					}
					if (defaultkingdeetreenode1.getUserObject() instanceof EntityObjectInfo)
						handlePropNode(defaultkingdeetreenode1, i);
					else
						throw new FormulaException("not support childNode is " + defaultkingdeetreenode1.getUserObject().getClass().getName());
				} else {
					throw new FormulaException("not support node is " + defaultkingdeetreenode.getUserObject().getClass().getName());
				}
			}
		}
	}

	private EntityObjectInfo getLinkEntityObjectInfo(DefaultKingdeeTreeNode defaultkingdeetreenode) {
		EntityObjectInfo entityobjectinfo = null;
		EntityObjectInfo entityobjectinfo1 = null;
		DefaultKingdeeTreeNode defaultkingdeetreenode1 = (DefaultKingdeeTreeNode) defaultkingdeetreenode.getParent();
		if (defaultkingdeetreenode1.getUserObject() instanceof EntityObjectInfo)
			entityobjectinfo1 = (EntityObjectInfo) defaultkingdeetreenode1.getUserObject();
		else if (defaultkingdeetreenode1.getUserObject() instanceof LinkPropertyInfo)
			entityobjectinfo1 = getLinkEntityObjectInfo(defaultkingdeetreenode1);
		else if (defaultkingdeetreenode1.getUserObject() instanceof MetaDataBriefInfo) {
			MetaDataBriefInfo metadatabriefinfo = (MetaDataBriefInfo) defaultkingdeetreenode1.getUserObject();
			IMetaDataLoader imetadataloader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
			entityobjectinfo1 = imetadataloader.getEntity(metadatabriefinfo.getMetaDataPK());
		} else {
			throw new FormulaException("not support " + defaultkingdeetreenode.getUserObject().getClass().getName());
		}
		LinkPropertyInfo linkpropertyinfo = (LinkPropertyInfo) defaultkingdeetreenode.getUserObject();
		RelationshipInfo relationshipinfo = linkpropertyinfo.getRelationship();
		entityobjectinfo = relationshipinfo.getClientObject().getFullName().equalsIgnoreCase(entityobjectinfo1.getFullName()) ? relationshipinfo.getSupplierObject()
				: relationshipinfo.getClientObject();
		return entityobjectinfo;
	}

	private void addchildNode(DefaultKingdeeTreeNode defaultkingdeetreenode, int i, PropertyCollection propertycollection) {
		for (int j = 0; j < propertycollection.size(); j++) {
			PropertyInfo propertyinfo = propertycollection.get(j);
			if (propertyinfo instanceof LinkPropertyInfo) {
				LinkPropertyInfo linkpropertyinfo = (LinkPropertyInfo) propertyinfo;
				if (defaultkingdeetreenode.getUserObject() instanceof EntityObjectInfo) {
					DefaultKingdeeTreeNode defaultkingdeetreenode1 = new DefaultKingdeeTreeNode();
					String s = linkpropertyinfo.getAlias() == null ? linkpropertyinfo.getName() : linkpropertyinfo.getAlias();
					defaultkingdeetreenode1.setText(s);
					defaultkingdeetreenode1.setUserObject(linkpropertyinfo);
					defaultkingdeetreenode1.setAllowsChildren(true);
					((DefaultTreeModel) EDentityMenuTree.getModel()).insertNodeInto(defaultkingdeetreenode1, defaultkingdeetreenode, defaultkingdeetreenode.getChildCount());
					continue;
				}
				if (defaultkingdeetreenode.getUserObject() instanceof LinkPropertyInfo) {
					DefaultKingdeeTreeNode defaultkingdeetreenode2 = new DefaultKingdeeTreeNode();
					String s1 = linkpropertyinfo.getAlias() == null ? linkpropertyinfo.getName() : linkpropertyinfo.getAlias();
					defaultkingdeetreenode2.setText(s1);
					defaultkingdeetreenode2.setUserObject(linkpropertyinfo);
					defaultkingdeetreenode2.setAllowsChildren(true);
					((DefaultTreeModel) EDentityMenuTree.getModel()).insertNodeInto(defaultkingdeetreenode2, defaultkingdeetreenode, defaultkingdeetreenode.getChildCount());
				} else {
					throw new FormulaException("not support parentNode is " + defaultkingdeetreenode.getUserObject().getClass().getName());
				}
				continue;
			}
			if (propertyinfo instanceof OwnPropertyInfo) {
				OwnPropertyInfo ownpropertyinfo = (OwnPropertyInfo) propertyinfo;
				DefaultKingdeeTreeNode defaultkingdeetreenode3 = new DefaultKingdeeTreeNode();
				if (ownpropertyinfo.getAlias() != null)
					defaultkingdeetreenode3.setText(ownpropertyinfo.getAlias());
				else
					defaultkingdeetreenode3.setText(ownpropertyinfo.getName());
				defaultkingdeetreenode3.setUserObject(ownpropertyinfo);
				defaultkingdeetreenode3.setAllowsChildren(false);
				((DefaultTreeModel) EDentityMenuTree.getModel()).insertNodeInto(defaultkingdeetreenode3, defaultkingdeetreenode, defaultkingdeetreenode.getChildCount());
			} else {
				throw new FormulaException("not support " + propertyinfo.getName());
			}
		}

	}

	private void jbInit() {
		this.setUITitle("ʵṹ˵");
		this.EDentityMenuTreeView = new com.kingdee.bos.ctrl.swing.KDTreeView();
		this.EDentityMenuTree = new com.kingdee.bos.ctrl.swing.KDTree();
		this.kDSeparator2 = new com.kingdee.bos.ctrl.swing.KDSeparator();
		this.EDok = new com.kingdee.bos.ctrl.swing.KDWorkButton();
		this.EDcancel = new com.kingdee.bos.ctrl.swing.KDWorkButton();
		this.EDentityMenuTreeView.setName("EDentityMenuTreeView");
		this.EDentityMenuTree.setName("EDentityMenuTree");
		this.kDSeparator2.setName("kDSeparator2");
		this.EDok.setName("EDok");
		this.EDcancel.setName("EDcancel");
		this.EDok.setText("ȷ");
		this.EDok.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent e) {
				beforeActionPerformed(e);
				try {
					EDok_actionPerformed(e);
				} catch (Exception exc) {
					handUIException(exc);
				} finally {
					afterActionPerformed(e);
				}
			}
		});
		this.EDcancel.setText("ȡ");
		this.EDcancel.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent e) {
				beforeActionPerformed(e);
				try {
					EDcancel_actionPerformed(e);
				} catch (Exception exc) {
					handUIException(exc);
				} finally {
					afterActionPerformed(e);
				}
			}
		});
	}

	public void initUIContentLayout() {
		this.setBounds(new Rectangle(10, 10, 400, 550));
		this.setLayout(null);
		EDentityMenuTreeView.setBounds(new Rectangle(10, 11, 380, 479));
		this.add(EDentityMenuTreeView, null);
		kDSeparator2.setBounds(new Rectangle(10, 506, 380, 10));
		this.add(kDSeparator2, null);
		EDok.setBounds(new Rectangle(209, 519, 83, 19));
		this.add(EDok, null);
		EDcancel.setBounds(new Rectangle(307, 519, 82, 19));
		this.add(EDcancel, null);
		EDentityMenuTreeView.setTree(EDentityMenuTree);

	}

	/**
	 * output initUIMenuBarLayout method
	 */
	public void initUIMenuBarLayout() {
		this.menuBar.add(menuFile);
		this.menuBar.add(menuTool);
		this.menuBar.add(menuHelp);
		// menuFile
		menuFile.add(menuItemPageSetup);
		menuFile.add(kDSeparator1);
		menuFile.add(menuItemExitCurrent);
		// menuTool
		menuTool.add(menuItemSendMessage);
		menuTool.add(menuItemCalculator);
		// menuHelp
		menuHelp.add(menuItemHelp);
		menuHelp.add(kDSeparator12);
		menuHelp.add(menuItemRegPro);
		menuHelp.add(menuItemPersonalSite);
		menuHelp.add(helpseparatorDiv);
		menuHelp.add(menuitemProductval);
		menuHelp.add(kDSeparatorProduct);
		menuHelp.add(menuItemAbout);

	}

	public IMetaDataPK getMetaDataPK() {
		return new MetaDataPK("c.baseDataWindow.commonui.commonSelector.EDentityTreeUI");
	}

}
