package com.kingdee.eas.lifetime.util.baseDataWindow.commonui.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;

import javax.swing.JFileChooser;

import org.apache.log4j.Logger;

import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.lifetime.util.fileOperate.FileOperateUtils;
import com.kingdee.eas.lifetime.util.kdcontrolutils.EDkdTableUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;

/**
 * ϢUI
 * 
 * @author lifeTime 2009-10-31 12:19:29
 */
public class EDexportTableUI extends com.kingdee.eas.framework.client.CoreUI {
	private static final Logger logger = CoreUIObject.getLogger(EDexportTableUI.class);
	protected com.kingdee.bos.ctrl.kdf.table.KDTable mainTable;
	protected com.kingdee.bos.ctrl.swing.KDLabelContainer labelFileChoose;
	protected com.kingdee.bos.ctrl.swing.KDWorkButton EDok;
	protected KDPromptBox fileSelect;
	protected com.kingdee.bos.ctrl.swing.KDContainer kDContainer1;

	public EDexportTableUI() throws Exception {
		super();
		jbInit();
		initUIP();
		mainTable.checkParsed();
		initData();
		mainTable.getColumn(MainTable.tableName).setWidth(150);
		mainTable.getColumn(MainTable.tablespaceName).setWidth(100);
	}

	protected void initData() {
		StringBuffer sb = new StringBuffer("t_bd_person,eashr;t_org_position,eashr");
		String str = sb.toString();
		String[] ss = str.split(";");
		for (int i = 0; i < ss.length; i++) {
			String s = ss[i];
			String[] dbs = s.split(",");
			if (dbs != null && dbs.length == 2) {
				String dbName = dbs[0];
				String dbspaceName = dbs[1];
				IRow row = mainTable.addRow();
				row.getCell(MainTable.tableName).setValue(dbName.toUpperCase());
				row.getCell(MainTable.tablespaceName).setValue(dbspaceName.toUpperCase());
			}
		}
	}

	protected void EDok_actionPerformed(java.awt.event.ActionEvent e) throws Exception {
		exportTableInfo();
	}

	/**
	 * 
	 * @throws Exception
	 */
	protected void exportTableInfo() throws Exception {
		checkFilePath();
		saveTableInfo();
		export();
		MsgBox.showInfo("ɣ");
	}

	void checkFilePath() {
		String filePath = fileSelect.getText();
		if (filePath == null || filePath.equals("")) {
			MsgBox.showWarning("ѡű·");
			SysUtil.abort();
		}

		if (!FileOperateUtils.exists(filePath)) {
			if (MsgBox.isYes(MsgBox.showConfirm2("űļ·ڣҪļ·"))) {
				try {
					FileOperateUtils.createFile(filePath);
				} catch (IOException e) {
					MsgBox.showError("ļʧܣ");
				}
			} else {
				SysUtil.abort();
			}
		}
	}

	void saveTableInfo() {
		// int rowCount = mainTable.getRowCount();
		// if (rowCount < 1) {
		// SysUtil.abort();
		// }
		// Properties properties = new Properties();
		// for (int i = 0; i < rowCount; i++) {
		// String tableName = (String) mainTable.getCell(i, MainTable.tableName).getValue();
		// String tablespaceName = (String) mainTable.getCell(i, MainTable.tablespaceName).getValue();
		// properties.put(tableName, tablespaceName);
		// }
		//
		// FileOutputStream outputStream = null;
		// try {
		// File file = File.createTempFile("temp", null);
		// outputStream = new FileOutputStream(file);
		// properties.store(outputStream, null);
		// } catch (FileNotFoundException e) {
		// e.printStackTrace();
		// } catch (IOException e) {
		// e.printStackTrace();
		// } finally {
		// if (outputStream != null) {
		// try {
		// outputStream.close();
		// } catch (IOException e) {
		// outputStream = null;
		// }
		// }
		// }
	}

	private static final String StateColumn = "state";

	void export() {
		String filePath = fileSelect.getText();
		IColumn column = mainTable.getColumn(StateColumn);
		if (column == null) {
			column = mainTable.addColumn();
			column.setKey(StateColumn);
			column.getStyleAttributes().setLocked(true);
		}
		int rowCount = mainTable.getRowCount();
		String sql = "select dbms_lob.substr(dbms_metadata.get_ddl('TABLE','";
		for (int i = 0; i < rowCount; i++) {
			String tableName = (String) mainTable.getCell(i, MainTable.tableName).getValue();
			String tablespaceName = (String) mainTable.getCell(i, MainTable.tablespaceName).getValue();
			String sqlTemp = sql + tableName + "','" + tablespaceName + "'),30000) from dual";
			try {
				IRowSet rowSet = null;// DBAccessUtil.executeQueryNotKingdee(sqlTemp)
				while (rowSet.next()) {
					String temp = rowSet.getObject(1) == null ? "" : rowSet.getObject(1).toString();
					FileOperateUtils.appendMethodA(filePath, temp);
				}
			} catch (Exception e2) {
				e2.printStackTrace();
				mainTable.getCell(i, StateColumn).setValue("ʧ");
				mainTable.getCell(i, StateColumn).getStyleAttributes().setBackground(new Color(255, 149, 149));
				continue;
			}
			mainTable.getCell(i, StateColumn).setValue("ɹ");
			mainTable.getCell(i, StateColumn).getStyleAttributes().setBackground(new Color(255, 255, 255));
		}
	}

	protected void showFileSelector(SelectorEvent e) {
		KDFileChooser fileChooser = new KDFileChooser();
		int returnVal = fileChooser.showOpenDialog(this);
		if (returnVal == JFileChooser.APPROVE_OPTION) {
			File file = fileChooser.getSelectedFile();
			String filePath = file.getPath();
			fileSelect.setText(filePath);
		}
	}

	private class MainTable {
		public static final String tableName = "tableName";
		public static final String tablespaceName = "tablespaceName";
	}

	private void jbInit() throws Exception {
		this.resHelper = new ResourceBundleHelper(EDexportTableUI.class.getName());
		this.setUITitle(resHelper.getString("this.title"));
		this.kDContainer1 = new com.kingdee.bos.ctrl.swing.KDContainer();
		this.kDContainer1.setName("kDContainer1");

		this.mainTable = new com.kingdee.bos.ctrl.kdf.table.KDTable();
		this.labelFileChoose = new com.kingdee.bos.ctrl.swing.KDLabelContainer();
		this.EDok = new com.kingdee.bos.ctrl.swing.KDWorkButton();
		this.mainTable.setName("mainTable");
		this.labelFileChoose.setName("labelFileChoose");
		this.EDok.setName("EDok");
		fileSelect = new KDPromptBox();
		fileSelect.addSelectorListener(new SelectorListener() {
			public void willShow(SelectorEvent e) {
				showFileSelector(e);
			}
		});
		this.mainTable.setFormatXml(resHelper.getString("mainTable.formatXml"));

		this.labelFileChoose.setBoundLabelText(resHelper.getString("labelFileChoose.boundLabelText"));
		this.labelFileChoose.setBoundLabelLength(80);
		this.labelFileChoose.setBoundLabelUnderline(true);
		this.labelFileChoose.setBoundEditor(fileSelect);
		this.EDok.setText(resHelper.getString("EDok.text"));
		EDok.setIcon(EASResource.getIcon("imgTbtn_metadata"));
		this.EDok.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent e) {
				beforeActionPerformed(e);
				try {
					EDok_actionPerformed(e);
				} catch (Exception exc) {
					handUIException(exc);
				} finally {
					afterActionPerformed(e);
				}
			}
		});
		this.kDContainer1.setEnableActive(false);
		KDWorkButton add = (KDWorkButton) kDContainer1.add(new ItemAction() {
			public void actionPerformed(ActionEvent e) {
				mainTable.addRow();
			}
		});
		add.setText("   +   ");
		add.setBounds(0, 0, 40, 40);

		KDWorkButton delete = (KDWorkButton) kDContainer1.add(new ItemAction() {
			public void actionPerformed(ActionEvent e) {
				int index = EDkdTableUtil.SelectManager.getSelectedRow(mainTable);
				mainTable.removeRow(index);
			}
		});
		delete.setText("   -   ");
		delete.setBounds(40, 40, 40, 40);
		// wf_event_flowover_complete_16
	}

	public void initUIContentLayout() {
		this.setBounds(new Rectangle(10, 10, 420, 450));
		this.setLayout(null);
		mainTable.setBounds(new Rectangle(14, 47, 387, 385));
		this.add(mainTable, null);
		labelFileChoose.setBounds(new Rectangle(14, 19, 280, 19));
		this.add(labelFileChoose, null);
		EDok.setBounds(new Rectangle(309, 19, 92, 22));
		this.add(EDok, null);
		kDContainer1.setBounds(new Rectangle(15, 46, 387, 385));
		this.add(kDContainer1, null);
		kDContainer1.getContentPane().setLayout(new BorderLayout(0, 0));
		kDContainer1.getContentPane().add(mainTable, BorderLayout.CENTER);

	}

	public void initUIMenuBarLayout() {
		this.menuBar.add(menuFile);
		this.menuBar.add(menuTool);
		this.menuBar.add(MenuService);
		this.menuBar.add(menuHelp);
		menuFile.add(menuItemPageSetup);
		menuFile.add(kDSeparator1);
		menuFile.add(menuItemExitCurrent);
		menuTool.add(menuItemSendMessage);
		menuTool.add(menuItemCalculator);
		MenuService.add(MenuItemKnowStore);
		MenuService.add(MenuItemAnwser);
		MenuService.add(SepratorService);
		MenuService.add(MenuItemRemoteAssist);
		menuHelp.add(menuItemHelp);
		menuHelp.add(kDSeparator12);
		menuHelp.add(menuItemRegPro);
		menuHelp.add(menuItemPersonalSite);
		menuHelp.add(helpseparatorDiv);
		menuHelp.add(menuitemProductval);
		menuHelp.add(kDSeparatorProduct);
		menuHelp.add(menuItemAbout);

	}

	public void initUIToolBarLayout() {
		this.toolBar.add(btnPageSetup);

	}

	public String getUIHandlerClassName() {
		return "";
	}

	public IUIActionPostman prepareInit() {
		IUIActionPostman clientHanlder = super.prepareInit();
		if (clientHanlder != null) {
			RequestContext request = new RequestContext();
			request.setClassName(getUIHandlerClassName());
			clientHanlder.setRequestContext(request);
		}
		return clientHanlder;
	}

	public boolean isPrepareInit() {
		return false;
	}

	protected void initUIP() {
		this.setUITitle("Ϣ");
		super.initUIP();
	}

	public void setDataObject(IObjectValue dataObject) {
		IObjectValue ov = dataObject;
		super.setDataObject(ov);
	}

	public void loadFields() {
		dataBinder.loadFields();
	}

	public void storeFields() {
		dataBinder.storeFields();
	}

	protected void registerValidator() {
		getValidateHelper().setCustomValidator(getValidator());
	}

	public void setOprtState(String oprtType) {
		super.setOprtState(oprtType);
	}

	public IMetaDataPK getMetaDataPK() {
		return new MetaDataPK("com.kingdee.eas.custom", "EDexportTableUI");
	}

}