package com.kingdee.eas.lifetime.util.baseDataWindow.commonui.util;

import java.util.HashMap;
import java.util.Map;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.eas.lifetime.util.bizutil.EDbizUtil;
import com.kingdee.eas.lifetime.util.edcommonutils.EDcommonUtils;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.ICoreBase;

/**
 * @author lifeTime 2009-11-8 10:40:04 
 *
 */
public class EDentityTreeUtil {

	private static final String PersonEntitySign = "com.kingdee.eas.basedata.person.PersonInfo";

	private EDentityTreeUtil() {
	}

	/**
	 * ʵϵnodeǷpersonй
	 * 
	 * @param node
	 * @return
	 */
	public static boolean checkNodeUnionPerson(DefaultKingdeeTreeNode node) {
		if (node != null && node.getUserObjectPath() != null) {
			return isRalationPerson(node.getUserObjectPath());
		}
		return false;
	}

	/**
	 * Ƿpersonϵ
	 * 
	 * @param objs
	 *            node.getUserObjectPath().
	 * @return
	 */
	public static boolean isRalationPerson(Object[] objs) {
		boolean boo = false;
		for (int i = 0; i < objs.length; i++) {
			if (objs[i] instanceof EntityObjectInfo) {
				EntityObjectInfo entityObjectInfo = (EntityObjectInfo) objs[i];
				String entityInfoStr = entityObjectInfo.getObjectValueClass();
				if (PersonEntitySign.equals(entityInfoStr)) {
					boo = true;
				}
			}
		}
		if (!boo) {
			if (isUnionPerson(objs) != null)
				boo = true;
			else
				boo = false;
		}
		return boo;
	}

	/**
	 * Ƿpersonй,عkey (ֻÿһ 磺personPositionpersonһ)
	 * 
	 * @param ΪΪû
	 * @return
	 */
	public static String isUnionPerson(Object[] objs) {
		StringBuffer sb = new StringBuffer();
		boolean isUnionPerson = false;
		int x = 0;
		for1: for (int i = 0; i < objs.length; i++) {
			if (objs[i] instanceof EntityObjectInfo) {
				EntityObjectInfo objectInfo = (EntityObjectInfo) objs[i];
				PropertyCollection propertyCollection = objectInfo.getInheritedProperties();
				if (propertyCollection != null) {
					for (int j = propertyCollection.size(); --j >= 0;) {
						PropertyInfo pInfo = propertyCollection.get(j);
						if (pInfo instanceof LinkPropertyInfo) {
							EntityObjectInfo entityObjectInfo = EDbizUtil.getEntity(objectInfo, (LinkPropertyInfo) pInfo);
							if (PersonEntitySign.equals(entityObjectInfo.getObjectValueClass())) {
								isUnionPerson = true;
								sb.append(pInfo.getName());
								break for1;
							}
						}
					}
				}
			} else if (objs[i] instanceof LinkPropertyInfo) {
				LinkPropertyInfo linkp = (LinkPropertyInfo) objs[i];
				if (x == 0)
					sb.append(linkp.getName());
				else
					sb.append(".").append(linkp.getName());

				EntityObjectInfo linkEntity = linkp.getRelationship().getSupplierObject();
				PropertyCollection propertyCollection = linkEntity.getInheritedProperties();
				if (propertyCollection != null) {
					for (int j = propertyCollection.size(); --j >= 0;) {
						PropertyInfo pInfo = propertyCollection.get(j);
						if (pInfo instanceof LinkPropertyInfo) {
							EntityObjectInfo entityObjectInfo = EDbizUtil.getEntity(linkEntity, (LinkPropertyInfo) pInfo);
							if (PersonEntitySign.equals(entityObjectInfo.getObjectValueClass())) {
								isUnionPerson = true;
								sb.append(".").append(pInfo.getName());
								break for1;
							}
						}
					}
				}
				x++;
			}
		}

		if (isUnionPerson)
			return sb.toString();
		else
			return null;
	}

	/**
	 * ʵinfoİȫ
	 */
	public static final String EntityInfoStr = "entityInfoStr";
	/**
	 * ʵҵӿڰȫ
	 */
	public static final String EntityIntefaceStr = "entityIntefaceStr";
	/**
	 * ѯkey
	 */
	public static final String EntityQueryStr = "entityQueryStr";
	/**
	 * personصĲѯkey
	 */
	public static final String PersonQueryStr = "personQueryStr";
	public static final String FenHao = ";";
	public static final String MaoHao = ":";

	/**
	 * node,õԱʱϢ
	 * 
	 * @param node
	 * @return
	 */
	public static Map analyzeNode(DefaultKingdeeTreeNode node) {
		int loopCount = 10;
		Map m = new HashMap();
		String entityInfoStr = null;// ѯʵinfo
		String entityIntefaceStr = null;// ʵҵӿ
		StringBuffer entityQueryStr = new StringBuffer();// ʵĲѯkey
		String personQueryStr = null;// personĲѯkey
		Object[] objects = node.getUserObjectPath();
		int count = 0;
		int x = 0;
		if (objects != null) {
			for (int i = 0; i < objects.length; i++) {
				if (count > loopCount) {
					System.out.println("ѭԵĴѾĬϵ10ӣ");
					return null;
				}
				if (objects[i] instanceof EntityObjectInfo) {
					EntityObjectInfo entityObjectInfo = (EntityObjectInfo) objects[i];
					entityInfoStr = entityObjectInfo.getObjectValueClass();
					entityIntefaceStr = entityObjectInfo.getBusinessInterface();
					if (PersonEntitySign.equals(entityInfoStr)) {// ʵλperson
						personQueryStr = "id";// personĲѯkey
					} else {
						String temp = isUnionPerson(objects);
						if (temp != null) {
							personQueryStr = temp;
						} else
							return null;
					}

					count++;
				} else if (objects[i] instanceof PropertyInfo) {
					PropertyInfo propertyInfo = (PropertyInfo) objects[i];
					if (x == 0)
						entityQueryStr.append(propertyInfo.getName());
					else
						entityQueryStr.append(".").append(propertyInfo.getName());
					count++;
					x++;
				}
			}
		}
		m.put(EntityInfoStr, entityInfoStr);
		m.put(EntityIntefaceStr, entityIntefaceStr);
		m.put(EntityQueryStr, entityQueryStr);
		m.put(PersonQueryStr, personQueryStr);
		return m;
	}

	/**
	 * analyzeNode,ó
	 * 
	 * @param map
	 * @param personId
	 * @return
	 */
	public static String getAnalyzeNodeResult(Map map, String personId) {
		String entityInfoStr = null;// ѯʵinfo
		String entityIntefaceStr = null;// ʵҵӿ
		String entityQueryStr = null;// ʵĲѯkey
		String personQueryStr = null;// personĲѯkey
		if (map.containsKey(EntityInfoStr) && map.containsKey(EntityIntefaceStr) && map.containsKey(EntityQueryStr)
				&& map.containsKey(PersonQueryStr)) {
			entityInfoStr = (String) map.get(EntityInfoStr);
			entityIntefaceStr = (String) map.get(EntityIntefaceStr);
			entityQueryStr = map.get(EntityQueryStr).toString();
			personQueryStr = (String) map.get(PersonQueryStr);
		} else {
			return null;
		}
		ICoreBase base = EDbizUtil.getBizInteface(entityInfoStr, entityIntefaceStr, null);
		try {
			CoreBaseCollection baseInfos = base.getCollection("select * " + analyzeEntityQueryStr(entityQueryStr) + " where " + personQueryStr
					+ " = '" + personId + "' ");
			if (baseInfos.isEmpty()) {
				return null;
			} else {
				StringBuffer sb = new StringBuffer();
				for (int i = 0; i < baseInfos.size(); i++) {
					Object obj = EDbizUtil.getPropertyValue(baseInfos.get(i), entityQueryStr);
					if (obj != null) {
						if (i == 0) {
							sb.append(clearFormulaIllegalChar(EDcommonUtils.StringUtils.getStringValue(obj)));
						} else {
							sb.append(FenHao).append(clearFormulaIllegalChar(EDcommonUtils.StringUtils.getStringValue(obj)));
						}
					}
				}
				return sb.toString();
			}
		} catch (BOSException e) {
			e.printStackTrace();
		}
		return null;
	}

	/**
	 * entityQueryStr
	 * 
	 * @return
	 */
	private static String analyzeEntityQueryStr(String entityQueryStr) {
		if (entityQueryStr == null || entityQueryStr.indexOf(".") == -1) {
			return "";
		} else {
			int lastIndex = entityQueryStr.lastIndexOf(".");
			String temp = EDcommonUtils.StringUtils.truncationString(entityQueryStr, lastIndex, entityQueryStr.length());
			return " , " + temp + ".*";
		}
	}

	/**
	 * ȥϷַ
	 * 
	 * @return
	 */
	private static String clearFormulaIllegalChar(String str) {
		if (str == null) {
			return "";
		}
		str = str.replaceAll("\\(", "");
		str = str.replaceAll("\\)", "");
		str = str.replaceAll("\\+", "");
		str = str.replaceAll("\\*", "");
		str = str.replaceAll("\\?", "");
		str = str.replaceAll("\\\\", "");
		str = str.replaceAll("\\!", "");
		str = str.replaceAll("\\&", "");
		str = str.replaceAll("\\|", "");
		str = str.replaceAll("\\.", "");
		str = str.replaceAll("\\>", "");
		str = str.replaceAll("\\<", "");
		return str;
	}

}
