package com.kingdee.eas.lifetime.util.bizutil;

import org.apache.log4j.Logger;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;

/**
 * @author lifeTime
 * 
 */
public class EDbillUtil {
	private EDbillUtil() {
	}

	static final Logger logger = Logger.getLogger(EDbillUtil.class);

	public static IObjectPK save(CoreBaseInfo billInfo, ICoreBase billInface) throws EASBizException, BOSException {
		IObjectPK billPK = null;
		if (billInfo == null) {
			logger.info("billInfo is null!");
			return billPK;
		}
		billPK = billInface.save(billInfo);
		return billPK;
	}

	/**
	 * info
	 * 
	 * @param ctx
	 * @param objectType
	 * @param id
	 * @param selector
	 * @return
	 * @throws BOSException
	 */
	public static IObjectValue getInfo(Context ctx, BOSObjectType objectType, String id, SelectorItemCollection selector) throws BOSException {
		if (objectType == null || BOSUuid.isValid(id, true)) {
			return null;
		}
		IDynamicObject iDynamicObj = null;
		if (ctx == null)
			iDynamicObj = DynamicObjectFactory.getRemoteInstance();
		else
			iDynamicObj = DynamicObjectFactory.getLocalInstance(ctx);
		return iDynamicObj.getValue(objectType, new ObjectUuidPK(id), selector);
	}

}
