package com.kingdee.eas.lifetime.util.bizutil;

import java.util.StringTokenizer;

import org.apache.log4j.Logger;

import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.query.PropertyUnitCollection;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SubEntityInfo;
import com.kingdee.bos.metadata.query.SubObjectCollection;
import com.kingdee.bos.metadata.query.SubObjectInfo;
import com.kingdee.bos.metadata.query.SubQueryInfo;
import com.kingdee.bos.metadata.query.UnionQueryInfo;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.QueryUtils;
import com.kingdee.eas.base.commonquery.client.DataObject;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;

/**
 * @author lifeTime
 *
 */
public class EDbizUtil {
	private static Logger logger = CoreUIObject.getLogger(EDbizUtil.class);

	/**
	 * ͨʵinfoȫҵӿڰȫûҵӿIObjectBase
	 * @param ObjValueClassName ʵinfoȫ
	 * @param businessInterfaceName ҵӿڰȫ
	 * @return
	 */
	public static ICoreBase getBizInteface(String ObjValueClassName, String businessInterfaceName,Context ctx) {
		try {
			Class clazz = Class.forName(ObjValueClassName);
			CoreBaseInfo baseInfo = (CoreBaseInfo) clazz.newInstance();
			Class biz = Class.forName(businessInterfaceName);
			ICoreBase objectBase = null;
			if(ctx == null){
				objectBase = (ICoreBase) BOSObjectFactory.createRemoteBOSObject(baseInfo.getBOSType(), biz);
			}else
				objectBase = (ICoreBase)BOSObjectFactory.createBOSObject(ctx, baseInfo.getBOSType());
			
			return objectBase;
		} catch (Exception e) {
			logger.info(e.getMessage(),e.getCause());
			return null;
		}
	}
	
	
	/**
	 * ʵֵ(Ϊ֧ȡֵa.b.c.e)
	 * @param info
	 * @param propertyStr
	 * @return
	 */
	public static Object getPropertyValue(CoreBaseInfo info ,String propertyStr){
		if(propertyStr.indexOf(".") == -1){
			return info.get(propertyStr);
		}
		String[] propertys = propertyStr.split("\\.");
		CoreBaseInfo baseInfo = info;
		for(int i = 0 ; i < propertys.length ; i++){
			String property = propertys[i];
			if(baseInfo.get(property) instanceof CoreBaseInfo){
				baseInfo = (CoreBaseInfo)baseInfo.get(property);
			}else{
				return baseInfo.get(property);
			}
		}
		return null;
	}
	
	
	/**
	 * ͨʵȫ·EntityObjectInfo
	 * @param entityName
	 * @return
	 */
	public static EntityObjectInfo getEntity(String entityName)
	{
		return QueryUtils.getEntity(null, entityName);
	}

	
	/**
	 * ʵԵEntityObjectInfo
	 * @param objInfo
	 * @param linkPropertyInfo
	 * @return
	 */
	public static EntityObjectInfo getEntity(EntityObjectInfo objInfo,LinkPropertyInfo linkPropertyInfo){
		String entityName = objInfo.getPackage()+"."+objInfo.getName();
		return getEntity(entityName,linkPropertyInfo);
	}
	
	/**
	 * ʵԵEntityObjectInfo
	 * @param mainEntityName
	 * @param propertyValue
	 * @return
	 */
	public static EntityObjectInfo getEntity(String mainEntityName,String propertyValue){
		return getEntity(QueryUtils.getEntity(null, mainEntityName),propertyValue);
	}
	
	/**
	 * ʵԵ
	 * @param entityPackageName
	 * @param propertyName
	 * @return
	 */
	public static DataObject getRefMetaData(String entityPackageName,String propertyName){
		return getRefMetaData(QueryUtils.getEntity(null, entityPackageName),propertyName);
	}
	
	
	
	/**
	 * entityԶ
	 * @param propertyName
	 * @param entity
	 * @return
	 */
	public static PropertyInfo getPropertyInfo(String propertyName, EntityObjectInfo entity)
	{
		String propNames[] = propertyName.split("\\.");
		if (propNames.length > 1)
		{
			EntityObjectInfo eoInfo = entity;
			for (int i = 0; i <= propNames.length - 1; i++)
			{
				PropertyInfo propInfo = eoInfo.getPropertyByName(propNames[i]);
				if (propInfo instanceof LinkPropertyInfo)
					eoInfo = getEntity(eoInfo.getFullName(), (LinkPropertyInfo)propInfo);
				else
					return propInfo;
			}

		} else
		{
			return entity.getPropertyByName(propertyName);
		}
		return null;
	}
	
	

	/**
	 * жǷΪString
	 * @param ownPropertyInfo
	 * @return
	 */
	public static boolean isString(OwnPropertyInfo ownPropertyInfo)
	{
		return ownPropertyInfo.getDataType().equals(DataType.STRING);
	}
	

	/**
	 * жqueryĳǷΪString
	 * @param queryInfo
	 * @param queryFieldName
	 * @return
	 */
	public static boolean isString(QueryInfo queryInfo, String queryFieldName)
	{
		if (queryInfo instanceof UnionQueryInfo)
		{
			UnionQueryInfo uqInfo = (UnionQueryInfo)queryInfo;
			SubObjectInfo subObj = null;
			try
			{
				subObj = uqInfo.getMainObject();
				if (subObj instanceof SubQueryInfo)
					queryInfo = ((SubQueryInfo)subObj).getQueryRef();
			}
			catch (Exception e)
			{
				logger.error(e);
			}
		}
		QueryFieldInfo fieldInfo = getQueryFieldInfo(queryInfo, queryFieldName);
		String entityNameInQueryField = null;
		if (fieldInfo.getPropertyRefs().get(0).getSubEntity() != null)
		{
			entityNameInQueryField = fieldInfo.getPropertyRefs().get(0).getSubEntity().getName();
		} else
		{
			QueryInfo subQueryInfo = fieldInfo.getPropertyRefs().get(0).getSubQuery().getQueryRef();
			queryFieldName = queryFieldName.substring(queryFieldName.indexOf(".") + 1);
			return isString(subQueryInfo, queryFieldName);
		}
		String entityProperty = fieldInfo.getPropertyRefs().get(0).getRefProperty().getName();
		SubObjectCollection subObjectCollection = queryInfo.getSubObjects();
		int size = subObjectCollection.size();
		for (int i = 0; i < size; i++)
		{
			SubObjectInfo subObjectInfo = subObjectCollection.get(i);
			if (!(subObjectInfo instanceof SubEntityInfo))
				continue;
			SubEntityInfo subEntityInfo = (SubEntityInfo)subObjectInfo;
			if (subEntityInfo.getName().equalsIgnoreCase(entityNameInQueryField))
			{
				String entityName = subEntityInfo.getEntityRef().getPackage() + "." + subEntityInfo.getEntityRef().getName();
				OwnPropertyInfo ownPropertyInfo = (OwnPropertyInfo)getEntity(entityName).getPropertyByName(entityProperty);
				return isString(ownPropertyInfo);
			}
		}

		return false;
	}
	
	
	
	
	/**
	 * жqueryĳֶǷΪDate
	 * @param queryInfo
	 * @param queryFieldName
	 * @return
	 */
	public static boolean isDate(QueryInfo queryInfo, String queryFieldName)
	{
		com.kingdee.eas.base.commonquery.client.DataObject dateType = getRefMetaData(queryInfo, queryFieldName);
		return dateType != null && (dateType.getName().equals(DataType.DATE.getName()) || dateType.getName().equals(DataType.TIMESTAMP.getName()) || dateType.getName().equals(DataType.TIME.getName()));
	}

	/**
	 * жentityĳֶǷΪDate
	 * @param entity
	 * @param propertiyName
	 * @return
	 */
	public static boolean isDate(EntityObjectInfo entity, String propertiyName)
	{
		com.kingdee.eas.base.commonquery.client.DataObject dateType = getRefMetaData(entity, propertiyName);
		return dateType != null && (DataType.DATE.getName().equals(dateType.getName()) || DataType.TIMESTAMP.getName().equals(dateType.getName()) || DataType.TIME.getName().equals(dateType.getName()));
	}

	
	
	/**
	 * жqueryĳֶǷΪEnum
	 * @param queryInfo
	 * @param queryFieldName
	 * @return
	 */
	protected static boolean isEnum(QueryInfo queryInfo, String queryFieldName)
	{
		com.kingdee.eas.base.commonquery.client.DataObject dateType = getRefMetaData(queryInfo, queryFieldName);
		return dateType != null && dateType.getName().equals(DataType.ENUM.getName());
	}

	/**
	 * жentityĳֶǷΪEnum
	 * @param entity
	 * @param propertiyName
	 * @return
	 */
	protected static boolean isEnum(EntityObjectInfo entity, String propertiyName)
	{
		com.kingdee.eas.base.commonquery.client.DataObject dateType = getRefMetaData(entity, propertiyName);
		return dateType.getName().equals(DataType.ENUM.getName());
	}

	
	/**
	 * жqueryInfoĳֶǷΪBoolean
	 * @param queryInfo
	 * @param queryFieldName
	 * @return
	 */
	protected static boolean isBoolean(QueryInfo queryInfo, String queryFieldName)
	{
		com.kingdee.eas.base.commonquery.client.DataObject dateType = getRefMetaData(queryInfo, queryFieldName);
		return dateType != null && dateType.getName().equals(DataType.BOOLEAN.getName());
	}

	/**
	 * жentityĳֶǷΪBoolean
	 * @param entity
	 * @param propertiyName
	 * @return
	 */
	protected static boolean isBoolean(EntityObjectInfo entity, String propertiyName)
	{
		com.kingdee.eas.base.commonquery.client.DataObject dateType = getRefMetaData(entity, propertiyName);
		return dateType.getName().equals(DataType.BOOLEAN.getName());
	}

	
	
	private static com.kingdee.eas.base.commonquery.client.DataObject getRefMetaData(QueryInfo queryInfo, String queryFieldName)
	{
		com.kingdee.eas.base.commonquery.DataObject do1 = QueryUtils.getRefMetaData(null, queryInfo, queryFieldName);
		return toClientDataObject(do1);
	}
	
	private static com.kingdee.eas.base.commonquery.client.DataObject toClientDataObject(com.kingdee.eas.base.commonquery.DataObject do1)
	{
		if (do1 == null)
		{
			return null;
		} else
		{
			com.kingdee.eas.base.commonquery.client.DataObject dataObject = new com.kingdee.eas.base.commonquery.client.DataObject();
			dataObject.setColLength(do1.getColLength());
			dataObject.setExtendValue(do1.getExtendValue());
			dataObject.setName(do1.getName());
			dataObject.setValue(do1.getValue());
			return dataObject;
		}
	}

	
	private static QueryFieldInfo getQueryFieldInfo(QueryInfo queryInfo, String queryFieldName)
	{
		QueryFieldInfo queryFieldInfo = new QueryFieldInfo();
		PropertyUnitCollection propertyUnitCollection = queryInfo.getUnits();
		int size = propertyUnitCollection.size();
		for (int i = 0; i < size; i++)
		{
			if (!(propertyUnitCollection.get(i) instanceof QueryFieldInfo))
				continue;
			queryFieldInfo = (QueryFieldInfo)propertyUnitCollection.get(i);
			if (queryFieldInfo.getName().equalsIgnoreCase(queryFieldName))
				return queryFieldInfo;
		}

		return queryFieldInfo;
	}

	
	
	public static QueryInfo getQueryInfo(String queryName)
	{
		return QueryUtils.getQueryInfo(null, queryName);
	}

	public static QueryInfo getQueryInfo(IMetaDataPK queryPK)
	{
		return QueryUtils.getQueryInfo(null, queryPK);
	}

	
	private static EntityObjectInfo getEntity(EntityObjectInfo mainEntity, String propertyValue)
	{
		EntityObjectInfo entity = mainEntity;
		PropertyCollection propertyCollection = getAllEntityProperties(entity);
		int size = propertyCollection.size();
		StringTokenizer stringTokenizer = new StringTokenizer(propertyValue, ".");
		String temp = stringTokenizer.nextToken();
		for (int i = 0; i < size; i++)
		{
			PropertyInfo propertyInfo = propertyCollection.get(i);
			if (propertyInfo.getName().equalsIgnoreCase(temp))
			{
				if (stringTokenizer.hasMoreTokens())
				{
					LinkPropertyInfo linkPropertyInfo = (LinkPropertyInfo)propertyInfo;
					entity = getEntity(getEntity(entity.getFullName(), linkPropertyInfo), propertyValue.substring(propertyValue.indexOf(".") + 1));
				}
				return entity;
			}
		}

		return entity;
	}
	
	public static PropertyCollection getAllEntityProperties(EntityObjectInfo entity)
	{
		PropertyCollection properties = new PropertyCollection();
		properties.addObjectCollection(entity.getProperties());
		for (; entity.getBaseEntity() != null; entity = entity.getBaseEntity())
			properties.addObjectCollection(entity.getBaseEntity().getProperties());

		return properties;
	}

	public static EntityObjectInfo getEntity(String mainEntityName, LinkPropertyInfo linkPropertyInfo)
	{
		String tempEntityName = linkPropertyInfo.getRelationship().getSupplierObject().getFullName();
		if (!tempEntityName.equalsIgnoreCase(mainEntityName))
			return linkPropertyInfo.getRelationship().getSupplierObject();
		else
			return linkPropertyInfo.getRelationship().getClientObject();
	}

	
	public static BizEnumInfo getEnum(String enumName)
	{
		IMetaDataPK enumPK = new MetaDataPK(enumName);
		IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
		return loader.getEnum(enumPK);
	}
	

	
	public static DataObject getRefMetaData(EntityObjectInfo entity, String propertiyName)
	{
		if (propertiyName.indexOf(".") > 0)
		{
			entity = getEntity(entity, propertiyName);
			propertiyName = propertiyName.substring(propertiyName.lastIndexOf(".") + 1);
		}
		com.kingdee.eas.base.commonquery.client.DataObject dataObject = null;
		PropertyCollection propertyCollection = getAllEntityProperties(entity);
		int size = propertyCollection.size();
		for (int i = 0; i < size; i++)
		{
			PropertyInfo propertyInfo = propertyCollection.get(i);
			String propName = propertyInfo.getName();
			if (!propName.toLowerCase().equalsIgnoreCase(propertiyName.toLowerCase()))
				continue;
			if (propertyInfo instanceof OwnPropertyInfo)
			{
				OwnPropertyInfo ownPropertyInfo = (OwnPropertyInfo)propertyInfo;
				if (ownPropertyInfo.getDataType().equals(DataType.ENUM))
				{
					dataObject = new com.kingdee.eas.base.commonquery.client.DataObject();
					dataObject.setName(ownPropertyInfo.getDataType().getName());
					String enumName = ownPropertyInfo.getMetaDataRef();
					BizEnumInfo enum1 = getEnum(enumName);
					dataObject.setValue(enum1.getClassName());
					return dataObject;
				}
				if (ownPropertyInfo.getDataType().equals(DataType.BOOLEAN))
				{
					dataObject = new com.kingdee.eas.base.commonquery.client.DataObject();
					dataObject.setName(ownPropertyInfo.getDataType().getName());
					dataObject.setValue((com.kingdee.eas.base.commonquery.BooleanEnum.class).getName());
					return dataObject;
				}
				if (ownPropertyInfo.getDataType().equals(DataType.DATE) || ownPropertyInfo.getDataType().equals(DataType.TIMESTAMP) || ownPropertyInfo.getDataType().equals(DataType.TIME))
				{
					dataObject = new com.kingdee.eas.base.commonquery.client.DataObject();
					dataObject.setName(ownPropertyInfo.getDataType().getName());
					dataObject.setValue(null);
					return dataObject;
				} else
				{
					dataObject = new com.kingdee.eas.base.commonquery.client.DataObject();
					dataObject.setName(ownPropertyInfo.getDataType().getName());
					dataObject.setValue(entity.getFullName());
					return dataObject;
				}
			}
			if (!(propertyInfo instanceof LinkPropertyInfo))
				continue;
			LinkPropertyInfo linkPropertyInfo = (LinkPropertyInfo)propertyInfo;
			EntityObjectInfo refEntity = getEntity(entity.getFullName(), linkPropertyInfo);
			String refEntityName = refEntity.getFullName();
			dataObject = new com.kingdee.eas.base.commonquery.client.DataObject();
			if (isSimpleEntity(refEntity))
			{
				dataObject.setName("SIMPLE_ENTITY");
				dataObject.setValue(refEntityName);
				return dataObject;
			} else
			{
				return getRefMetaData(refEntity, propertiyName);
			}
		}

		return dataObject;
	}
	
	private static boolean isSimpleEntity(EntityObjectInfo entity)
	{
		return QueryUtils.isSimpleEntity(entity);
	}

	
	

}
