package com.kingdee.eas.lifetime.util.bizutil;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.service.permission.metadata.PermissionItemInfo;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermItemFactory;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;

/**
 * @author lifeTime
 *
 */
public class EDpermissionUtil {
	private static IPermission permission = null;
	private static Context ctx = null;
	private static EDpermissionUtil util;

	private EDpermissionUtil() {
		try {
			if (permission == null && ctx == null) {
				permission = PermissionFactory.getRemoteInstance();
			} else if (permission == null && ctx != null) {
				permission = PermissionFactory.getLocalInstance(ctx);
			}
		} catch (BOSException e) {
			e.printStackTrace();
		}
	}

	public static EDpermissionUtil getInstance(Context ctx1) {
		if (util == null || (util != null && ctx != ctx1)) {
			util = new EDpermissionUtil();
		}
		return util;
	}

	public static EDpermissionUtil getInstance() {
		return getInstance(null);
	}

	/**
	 * 鵱ǰûڵ֯ǷitemStrȨ
	 * 
	 * @param itemStr
	 * @return
	 */
	public boolean exists(String itemStr) {
		String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
		String orgId = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
		try {
			return permission.hasFunctionPermission(new ObjectUuidPK(userId), new ObjectUuidPK(orgId), itemStr);
		} catch (EASBizException e) {
			e.printStackTrace();
		} catch (BOSException e) {
			e.printStackTrace();
		}

		return false;
	}

	/**
	 * 鵱ǰûȨޣʾ
	 * 
	 * @param itemStr
	 */
	public void check(String itemStr) {
		try {
			if (!exists(itemStr)) {
				PermissionItemInfo itemInfo = PermItemFactory.getRemoteInstance().getPermissionItemInfo(itemStr);
				if (itemInfo == null) {
					MsgBox.showError("ûиȨޣϵԱȨޣ");
					SysUtil.abort();
				}
				String itemAlias = itemInfo.getAlias();
				MsgBox.showError("û  " + SysContext.getSysContext().getCurrentOrgUnit() + itemAlias + "  Ȩޣ");
				SysUtil.abort();
			}
		} catch (BOSException e) {
			e.printStackTrace();
		}
	}

	/**
	 * ǷӵиȨ
	 * 
	 * @param userId
	 * @param orgId
	 * @param itemStr
	 * @return
	 */
	public boolean exists(String userId, String orgId, String itemStr) {
		try {
			return permission.hasFunctionPermission(new ObjectUuidPK(userId), new ObjectUuidPK(orgId), itemStr);
		} catch (EASBizException e) {
			e.printStackTrace();
		} catch (BOSException e) {
			e.printStackTrace();
		}
		return false;
	}

	/**
	 * ǷӵиȨ
	 * 
	 * @param userId
	 * @param orgId
	 * @param itemStr
	 * @return
	 */
	public boolean exists(IObjectPK userId, IObjectPK orgId, String itemStr) {
		try {
			return permission.hasFunctionPermission(userId, orgId, itemStr);
		} catch (EASBizException e) {
			e.printStackTrace();
		} catch (BOSException e) {
			e.printStackTrace();
		}
		return false;
	}
}
