package com.kingdee.eas.lifetime.util.bizutil;

import java.awt.Component;
import java.util.Map;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.common.EASBizException;

/**
 * ͨòѯ<b><font color=red>ǿҽ贫queryPK</font></b></br> ʹδܴqueryPKʱĬȡcom.kingdee.eas.sem.mp.app.TestQuerypk<br>
 * 跽ʹãûԶUI2getCustomerParams(),setCustomerParams().<br>
 * <br>
 * ʾ÷ûԶUIֻpersonһF7ѯF7ΪpersonF7.<br>
 * 
 * <pre>
 * public CustomerParams getCustomerParams() {
 * 	CustomerParams customerParams = new CustomerParams();
 * 	if (personF7.getValue() != null) {
 * 		String personID = ((PersonInfo) personF7.getValue()).getID().toString();
 * 		customerParams.addCustomerParam(&quot;person.id&quot;, personID);
 * 	}
 * 	return customerParams;
 * }
 * 
 * public void setCustomerParams(CustomerParams cp) {
 * 	if (cp == null) {
 * 		return;
 * 	}
 * 	if (cp.getCustomerParam(&quot;person.id&quot;) != null) {
 * 		PersonInfo personInfo = PersonFactory.getRemoteInstance().getPersonInfo(new ObjectUuidPK(cp.getCustomerParam(&quot;person.id&quot;)));
 * 		personF7.setValue(personInfo);
 * 	}
 * }
 * </pre>
 * 
 * <pre>
 * if (queryDialog == null) {
 * 	if (queryUI == null) {
 * 		queryUI = getUserPanelUI();
 * 	}
 * 	queryDialog = EDquerySeletorDialog.getInstance(this, queryUI);
 * }
 * queryDialog.showFilterDialog();
 * filterInfo = queryDialog.getFilterInfo();
 * if (queryDialog.isOK()) {
 * 	doSomting...
 * } else {
 * 	SysUtil.abort();
 * }
 * </pre>
 * 
 * @author lifeTime
 * 
 */
public class EDquerySeletorDialog {

	CommonQueryDialog commonQueryDialog;
	Component containt;
	CustomerQueryPanel customerPanel;
	IMetaDataPK queryPK;
	String panelName;
	String title;
	boolean maxReturnCountVisible = false;
	String parentClassName = getClass().getName();
	int width = 450;
	int height = 420;
	Map uiContext;
	boolean showFilter = true;
	boolean showSorter = false;
	boolean showToolbar = true;
	protected boolean isOK = false;

	FilterInfo filterInfo;

	private EDquerySeletorDialog(Component containt, CustomerQueryPanel customerPanel) {
		this(containt, customerPanel, null);
	}

	private EDquerySeletorDialog(Component containt, CustomerQueryPanel customerPanel, IMetaDataPK queryPK) {
		commonQueryDialog = new CommonQueryDialog();
		this.customerPanel = customerPanel;
		this.containt = containt;
		if (queryPK == null) {
			// com.kingdee.eas.basedata.person.app.PersonQuery
			// com.kingdee.eas.sem.mp.app.TestQuery
			this.queryPK = new MetaDataPK("com.kingdee.eas.sem.mp.app.TestQuery");
		} else {
			this.queryPK = queryPK;
		}
	}

	public static EDquerySeletorDialog getInstance(Component containt, CustomerQueryPanel customerPanel) {
		EDquerySeletorDialog seletorDialog = getInstance(containt, customerPanel, null);
		return seletorDialog;
	}

	public static EDquerySeletorDialog getInstance(Component containt, CustomerQueryPanel customerPanel, IMetaDataPK queryPK) {
		EDquerySeletorDialog seletorDialog = new EDquerySeletorDialog(containt, customerPanel, queryPK);
		seletorDialog.initQueryDialog();
		return seletorDialog;
	}

	protected void initQueryDialog() {
		initQuerySolution();
		commonQueryDialog.setWidth(getWidth());
		commonQueryDialog.setHeight(getHeight());
		commonQueryDialog.setOwner(containt);
		commonQueryDialog.setParentUIClassName(getParentClassName());
		commonQueryDialog.setQueryObjectPK(queryPK);
		commonQueryDialog.setShowFilter(isShowFilter());
		commonQueryDialog.setShowSorter(isShowSorter());
		commonQueryDialog.setShowToolbar(isShowToolbar());
		commonQueryDialog.setEntityViewInfo(new EntityViewInfo());
		commonQueryDialog.addUserPanel(customerPanel);
		customerPanel.setPanelName(getPanelName());
		commonQueryDialog.setTitle(getTitle());
		commonQueryDialog.setMaxReturnCountVisible(isMaxReturnCountVisible());
	}

	protected void initQuerySolution() {
		try {
			IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
			String queryName = queryPK.getFullName();
			if (iQuery.hasDefaultSolution(getClass().getName(), queryName)) {
				QuerySolutionInfo solution = iQuery.getDefaultSolution(getClass().getName(), queryName);
				if (solution.getQueryPanelInfo() != null && solution.getQueryPanelInfo().size() > 0) {
					CustomerParams customerParams = null;
					if (solution.getQueryPanelInfo().get(0).getCustomerParams() != null)
						customerParams = CustomerParams.getCustomerParams2(solution.getQueryPanelInfo().get(0).getCustomerParams());
					else if (solution.getQueryPanelInfo().size() > 1 && solution.getQueryPanelInfo().get(1).getCustomerParams() != null)
						customerParams = CustomerParams.getCustomerParams2(solution.getQueryPanelInfo().get(1).getCustomerParams());
					customerPanel.setCustomerParams(customerParams);
				}
			}
		} catch (BOSException e) {
			e.printStackTrace();
		} catch (EASBizException e) {
			e.printStackTrace();
		}
	}

	public EDquerySeletorDialog showFilterDialog() throws Exception {
		isOK = commonQueryDialog.show();
		if (isOK) {
			uiContext = customerPanel.getUIContext();
			filterInfo = customerPanel.getFilterInfo();
		} else {
			uiContext = null;
			filterInfo = null;
		}
		return this;
	}

	public boolean isOK() {
		return isOK;
	}

	public Map getUiContext() {
		return uiContext;
	}

	public String getParentClassName() {
		return parentClassName;
	}

	public void setParentClassName(String parentClassName) {
		this.parentClassName = parentClassName;
	}

	public String getPanelName() {
		return panelName;
	}

	public void setPanelName(String panelName) {
		this.panelName = panelName;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public boolean isMaxReturnCountVisible() {
		return maxReturnCountVisible;
	}

	public void setMaxReturnCountVisible(boolean maxReturnCountVisible) {
		this.maxReturnCountVisible = maxReturnCountVisible;
	}

	public boolean isShowFilter() {
		return showFilter;
	}

	public void setShowFilter(boolean showFilter) {
		this.showFilter = showFilter;
	}

	public CommonQueryDialog getCommonQueryDialog() {
		return commonQueryDialog;
	}

	public boolean isShowSorter() {
		return showSorter;
	}

	public void setShowSorter(boolean showSorter) {
		this.showSorter = showSorter;
	}

	public boolean isShowToolbar() {
		return showToolbar;
	}

	public void setShowToolbar(boolean showToolbar) {
		this.showToolbar = showToolbar;
	}

	public int getWidth() {
		return width;
	}

	public void setWidth(int width) {
		this.width = width;
	}

	public int getHeight() {
		return height;
	}

	public void setHeight(int height) {
		this.height = height;
	}

	public FilterInfo getFilterInfo() {
		return filterInfo;
	}

	/**
	 * 
	 * @return
	 */
	public EntityViewInfo getEntityViewInfo() {
		return commonQueryDialog.getEntityViewInfoResult();
	}

	public void setFilterInfo(FilterInfo filterInfo) {
		this.filterInfo = filterInfo;
	}

	public IMetaDataPK getQueryPK() {
		return queryPK;
	}

	public void setQueryPK(IMetaDataPK queryPK) {
		this.queryPK = queryPK;
	}

}
