package com.kingdee.eas.lifetime.util.bizutil;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.jdbc.rowset.IRowSet;

/**
 * 
 * @author lifeTime
 */
public class EDqueryUtil {

	/**
	 * ִЧksqlؽlist
	 * 
	 * @param sql
	 * @return
	 * @throws BOSException
	 * @throws SQLException
	 */
	public static List execQuery(String queryName, EntityViewInfo viewInfo) throws BOSException, SQLException {
		ArrayList result = new ArrayList();
		MetaDataPK queryPK = new MetaDataPK(queryName);
		IQueryExecutor executor = QueryExecutorFactory.getRemoteInstance(queryPK);
		executor.option().isAutoIgnoreZero = false;
		executor.option().isAutoTranslateBoolean = true;
		executor.option().isAutoTranslateEnum = true;
		IRowSet rowSet = executor.executeQuery();
		ResultSetMetaData metaData = rowSet.getMetaData();
		int colCount = metaData.getColumnCount();
		while (rowSet.next()) {
			HashMap resMap = new HashMap();
			for (int i = 1; i <= colCount; i++) {
				String colName = metaData.getColumnName(i);
				resMap.put(colName, rowSet.getObject(i));
			}
			result.add(resMap);
		}
		return result;
	}

	/**
	 * 
	 * @param queryName
	 *            queryȫ·
	 * @param fi
	 * @return
	 * @throws Exception
	 */
	public static IRowSet getRowSet(String queryName, FilterInfo fi) throws Exception {
		EntityViewInfo evi = new EntityViewInfo();
		evi.setFilter(fi);
		return getRowSet(queryName, evi);
	}

	/**
	 * 
	 * @param queryName
	 *            queryȫ·
	 * @param viewInfo
	 * @return
	 * @throws Exception
	 */
	public static IRowSet getRowSet(String queryName, EntityViewInfo viewInfo) throws Exception {
		MetaDataPK queryPK = new MetaDataPK(queryName);
		IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance(queryPK);
		exec.option().isAutoIgnoreZero = false;
		exec.option().isAutoTranslateBoolean = true;
		exec.option().isAutoTranslateEnum = true;
		exec.setObjectView(viewInfo);
		IRowSet rowSet = exec.executeQuery();
		return rowSet;
	}

}
