package com.kingdee.eas.lifetime.util.bizutil;

import java.awt.Frame;
import java.util.HashMap;
import java.util.Map;

import javax.swing.Action;

import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.eas.lifetime.util.BaseInfoRead.EDpersonRead;
import com.kingdee.eas.base.uiframe.client.UIFactoryHelper;
import com.kingdee.eas.base.uiframe.client.UIModelDialog;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.RealModeIDList;

/**
 * @author lifeTime
 * 
 */
public class EDuiUtils {

	private EDuiUtils() {
	}

	/**
	 * Ӱť
	 * 
	 * @return
	 */
	public static KDWorkButton addToolbarButton(CoreUI ui, Action action) {
		KDToolBar toolBar = ui.getUIToolBar();
		KDWorkButton button = null;
		if (toolBar != null) {
			button = (KDWorkButton) toolBar.add(action);
		}
		return button;
	}

	/**
	 * ԱϢĽ
	 * 
	 * @param personId
	 * @return
	 */
	public static IUIWindow getPersonInfoUI(String personId) {
		return new UIModelDialog(getPersonInfoUIObject(personId), (Frame) null);
	}

	/**
	 * ԱϢUIObject,ڽ
	 * 
	 * @param personId
	 * @return
	 */
	public static CoreUIObject getPersonInfoUIObject(String personId) {
		Map uiContext = getEmpContext(personId);
		try {
			return (CoreUIObject) UIFactoryHelper.initUIObject(com.kingdee.eas.hr.emp.client.EmployeeTreeEditUI.class.getName(), uiContext,
					null, "VIEW");
		} catch (UIException e) {
			e.printStackTrace();
		}
		return null;
	}

	private static Map getEmpContext(String personId) {
		Map ctx = new HashMap();
		ctx.put("ID", personId);
		ctx.put("isMyArchives", "isMyArchives");
		RealModeIDList idList = new RealModeIDList();
		idList.add(personId);
		ctx.put("IDList", idList);
		PositionInfo pInfo = EDpersonRead.getPositionByPersonId(personId);
		ctx.put("PositionNode", pInfo);
		ctx.put("SHOW_BOX_MSG", Boolean.TRUE);
		ctx.put("NO_PERMISSION", Boolean.TRUE);
		ctx.put("FROM_WORKBENCH", Boolean.TRUE);
		return ctx;
	}

}
