package com.kingdee.eas.EDxbangUtil.commonui;

import java.awt.BorderLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;

import javax.swing.JButton;
import javax.swing.SwingUtilities;

import org.apache.log4j.Logger;

import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDProgressBar;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.EDxbangUtil.edcommonutils.EDcommonUtils;
import com.kingdee.eas.EDxbangUtil.kdcontrolutils.EDkdTableUtil;
import com.kingdee.eas.EDxbangUtil.kdcontrolutils.table.SettingMustInput;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;

/**
 * ϸɸѡ
 * 
 * @author lifeTime 2010-1-11 11:09:42
 * 
 */
public class EntryFilterUI extends com.kingdee.eas.framework.client.CoreUI {
	private static final Logger logger = CoreUIObject.getLogger(EntryFilterUI.class);
	protected com.kingdee.bos.ctrl.swing.KDContainer kDContainer1;
	protected com.kingdee.bos.ctrl.kdf.table.KDTable mainTable;
	protected com.kingdee.bos.ctrl.swing.KDSeparator kDSeparator2;
	protected com.kingdee.bos.ctrl.swing.KDButton ok;
	protected com.kingdee.bos.ctrl.swing.KDButton cancel;
	protected KDProgressBar progressBar;
	protected JButton addLine;
	protected JButton removeLine;

	protected SettingMustInput mustInput;

	protected KDTable queryTable;
	protected String[] queryKeys;
	protected boolean isThreadRun = false;

	/**
	 * ѯַɵlist[ѯ߼ѯ߼]
	 */
	protected List queryStringList;

	/**
	 * KDTable
	 */
	public static final String QueryTableKey = "EntryFilterUI_QueryTable";

	/**
	 * String[]
	 */
	public static final String QueryKeysKey = "EntryFilterUI_QueryKeys";

	public EntryFilterUI() throws Exception {
		super();
		jbInit();
		initUIP();
	}

	public void onLoad() throws Exception {
		super.onLoad();
		try {
			mainTable.checkParsed();
			initData();
			initTable();
		} catch (Exception ex) {
			ex.printStackTrace();
			MsgBox.showWarning("ݳʼʧܣ\n" + ex.toString());
			SysUtil.abort();
		}
	}

	public void verifyData() throws Exception {
		mustInput.verifyAll();
	}

	protected void filterStart() {
		progressBar.setVisible(true);
		progressBar.setIndeterminate(true);
		ok.setEnabled(false);
		cancel.setEnabled(false);
	}

	protected void filterEnd() {
		progressBar.setVisible(false);
		progressBar.setIndeterminate(false);
		ok.setEnabled(true);
		cancel.setEnabled(true);
	}

	protected void ok_actionPerformed(java.awt.event.ActionEvent e) throws Exception {
		verifyData();
		try {
			if (isThreadRun) {
				Thread thread = new Thread() {
					public void run() {
						try {
							SwingUtilities.invokeAndWait(new Runnable() {
								public void run() {
									filterStart();
								}
							});
							doFilter(buildQueryStringList());
						} catch (Exception e) {
							e.printStackTrace();
							MsgBox.showConfirm3a("ʽд", e.getMessage());
						}
						filterEnd();
					}
				};
				thread.start();
			} else {
				doFilter(buildQueryStringList());
			}
		} catch (Exception ex) {
			MsgBox.showConfirm3a("ʽд", ex.getMessage());
			SysUtil.abort();
		}
	}

	protected List buildQueryStringList() {
		int rowCount = mainTable.getRowCount();
		if (queryStringList != null) {
			queryStringList.clear();
		} else {
			queryStringList = new ArrayList(rowCount);
		}
		for (int i = 0; i < rowCount; i++) {
			QueryKeyNameInfo queryKeyNameInfo = (QueryKeyNameInfo) getCellValue(i, ColumnKeys.QueryKeyName);
			String compareSignStr = String.valueOf(getCellValue(i, ColumnKeys.CompareSign));
			String compareValueStr = String.valueOf(getCellValue(i, ColumnKeys.CompareValue));
			String logicSignStr = String.valueOf(getCellValue(i, ColumnKeys.LogicSign));
			queryStringList.add(new EDFilterInfo(compareSignStr, compareValueStr, (logicSignStr == null || logicSignStr.equals("null") ? "" : logicSignStr), queryKeyNameInfo));
		}
		return queryStringList;
	}

	protected class EDFilterInfo {
		QueryKeyNameInfo queryKeyNameInfo;
		String compareSignStr;
		String compareValueStr;
		String logicSignStr;

		public EDFilterInfo(String compareSignStr, String compareValueStr, String logicSignStr, QueryKeyNameInfo queryKeyNameInfo) {
			this.compareSignStr = compareSignStr;
			this.compareValueStr = compareValueStr;
			this.logicSignStr = logicSignStr;
			this.queryKeyNameInfo = queryKeyNameInfo;
		}
	}

	protected Object getCellValue(int rowIndex, String colKey) {
		return mainTable.getCell(rowIndex, colKey).getValue();
	}

	protected void doFilter(List queryStringList) throws Exception {
		if (queryTable != null) {
			int rowCount = queryTable.getRowCount();
			queryTable.setRefresh(false);
			for (int i = 0; i < rowCount; i++) {
				boolean isHide = isHideQueryTableRow(i, queryStringList);
				logger.debug("filter with queryTable rowIndex : " + (i + 1) + "\t" + Boolean.toString(isHide));
				queryTable.getRow(i).getStyleAttributes().setHided(isHide);
			}
			queryTable.setRefresh(true);
			queryTable.repaint();
		}
	}

	protected boolean isHideQueryTableRow(int rowIndex, List queryStringList) throws Exception {
		if (queryStringList == null || queryStringList.isEmpty()) {
			return false;
		}
		int size = queryStringList.size();
		StringBuffer booleanStr = new StringBuffer();
		for (int i = 0; i < size; i++) {
			EDFilterInfo filterInfo = (EDFilterInfo) queryStringList.get(i);
			QueryKeyNameInfo queryKeyNameInfo = filterInfo.queryKeyNameInfo;
			String compareValue = filterInfo.compareValueStr;
			String compareSign = filterInfo.compareSignStr;
			String logicSign = filterInfo.logicSignStr;
			String oldValue = String.valueOf(queryTable.getCell(rowIndex, queryKeyNameInfo.key).getValue());
			booleanStr.append(Boolean.toString(stringCompare(oldValue, compareValue.trim(), compareSign.trim())));
			if (logicSign != null && !logicSign.equals("")) {
				booleanStr.append(logicSign.equals("and") ? "&&" : "||");
			}
		}
		try {
			return !EDcommonUtils.BooleanUtils.getBooleanValue(booleanStr.toString());
		} catch (Exception ex) {
			throw ex;
		}
	}

	protected boolean stringCompare(String oldValue, String compareValue, String compareSign) {
		oldValue = oldValue == null ? "" : oldValue;
		if ("==".equals(compareSign)) {
			return oldValue.compareTo(compareValue) == 0;
		} else if ("!=".equals(compareSign)) {
			return oldValue.compareTo(compareValue) != 0;
		} else if (">".equals(compareSign)) {
			return oldValue.compareTo(compareValue) == 1;
		} else if ("<".equals(compareSign)) {
			return oldValue.compareTo(compareValue) == -1;
		} else if (">=".equals(compareSign)) {
			return oldValue.compareTo(compareValue) != -1;
		} else if ("<=".equals(compareSign)) {
			return oldValue.compareTo(compareValue) != 1;
		} else if ("like".equals(compareSign)) {
			return oldValue.indexOf(compareValue) != -1;
		}
		return false;
	}

	protected void cancel_actionPerformed(java.awt.event.ActionEvent e) throws Exception {
		this.disposeUIWindow();
	}

	protected void initData() {
		queryTable = (KDTable) getUIContext().get(QueryTableKey);
		queryKeys = (String[]) getUIContext().get(QueryKeysKey);
		if (queryTable != null) {
			if (queryTable.getRowCount() > 5000) {
				isThreadRun = true;
			}
		}
	}

	protected void initTable() {
		createColumn();
		createHead();
		initColumnValue();
		registListener();
		mustInput = new SettingMustInput(mainTable, new String[] { ColumnKeys.CompareSign, ColumnKeys.CompareValue, ColumnKeys.QueryKeyName });
	}

	protected void registListener() {
		mainTable.addKDTEditListener(new KDTEditAdapter() {
			public void editStopped(KDTEditEvent e) {
				autoAddRow(e);
			}
		});
	}

	protected void autoAddRow(KDTEditEvent e) {
		int rowIndex = e.getRowIndex();
		Object logicObj = getCellValue(rowIndex, ColumnKeys.LogicSign);
		if (logicObj != null && !EDcommonUtils.StringUtils.isEmpty(String.valueOf(logicObj)) && mainTable.getRow(rowIndex + 1) == null) {
			autoAddRowAfter(mainTable.addRow());
		}
	}

	protected void autoAddRowAfter(IRow row) {

	}

	protected void initColumnValue() {
		initQueryKeyNameValue();
		initCompareSignValue();
		initLogicSignValue();
	}

	/**
	 * ѯֶĳʼ
	 */
	protected void initQueryKeyNameValue() {
		if (queryTable != null && queryKeys != null) {
			IRow headRow = queryTable.getHeadRow(0);
			Object[] queryKeyNames = new Object[queryKeys.length];
			for (int i = 0; i < queryKeys.length; i++) {
				queryKeyNames[i] = new QueryKeyNameInfo(queryKeys[i], headRow.getCell(queryKeys[i]).getValue());
			}
			KDComboBox box = EDkdTableUtil.Binding.bindColumnComboBox(mainTable, ColumnKeys.QueryKeyName);
			box.addItems(queryKeyNames);
		}
	}

	protected class QueryKeyNameInfo {
		String key;
		Object value;

		public QueryKeyNameInfo() {
		}

		public QueryKeyNameInfo(String key, Object value) {
			this.key = key;
			this.value = value;
		}

		public String toString() {
			return String.valueOf(this.value);
		}
	}

	/**
	 * ȽϷĳʼ
	 */
	protected void initCompareSignValue() {
		String[] compares = new String[] { "==", "!=", ">", "<", ">=", "<=", "like" };
		KDComboBox box = EDkdTableUtil.Binding.bindColumnComboBox(mainTable, ColumnKeys.CompareSign);
		box.addItems(compares);
	}

	/**
	 * ߼ʽ(and or)ĳʼ
	 */
	protected void initLogicSignValue() {
		String[] logics = new String[] { "and", "or", "" };
		KDComboBox box = EDkdTableUtil.Binding.bindColumnComboBox(mainTable, ColumnKeys.LogicSign);
		box.addItems(logics);
	}

	protected void createHead() {
		IRow headRow = mainTable.addHeadRow();
		for (int i = 0; i < ColumnKeys.Keys.length; i++) {
			if (ColumnKeys.Keys[i].equals(ColumnKeys.QueryKeyName)) {
				headRow.getCell(ColumnKeys.QueryKeyName).setValue("ѯֶ");
			} else if (ColumnKeys.Keys[i].equals(ColumnKeys.CompareSign)) {
				headRow.getCell(ColumnKeys.CompareSign).setValue("ȽϷ");
			} else if (ColumnKeys.Keys[i].equals(ColumnKeys.CompareValue)) {
				headRow.getCell(ColumnKeys.CompareValue).setValue("Ƚֵ");
			} else if (ColumnKeys.Keys[i].equals(ColumnKeys.LogicSign)) {
				headRow.getCell(ColumnKeys.LogicSign).setValue("߼ʽ");
			}
		}
	}

	protected void createColumn() {
		for (int i = 0; i < ColumnKeys.Keys.length; i++) {
			IColumn column = mainTable.addColumn();
			column.setKey(ColumnKeys.Keys[i]);
		}
	}

	protected static class ColumnKeys {
		/**
		 * ѯֶ
		 */
		public static final String QueryKeyName = "QueryKeyName";
		/**
		 * ȽϷ
		 */
		public static final String CompareSign = "CompareSign";
		/**
		 * Ƚֵ
		 */
		public static final String CompareValue = "CompareValue";
		/**
		 * ߼ʽ(and or)
		 */
		public static final String LogicSign = "LogicSign";

		public static final String[] Keys = new String[] { QueryKeyName, CompareSign, CompareValue, LogicSign };
	}

	private void jbInit() throws Exception {
		this.setUITitle("ϸɸѡ");
		this.mainTable = new com.kingdee.bos.ctrl.kdf.table.KDTable();
		this.kDContainer1 = new com.kingdee.bos.ctrl.swing.KDContainer();
		this.kDContainer1.setEnableActive(false);
		addLine = kDContainer1.add(new ItemAction() {
			public void actionPerformed(ActionEvent e) {
				actionPerformed_addLine(e);
			}
		});
		addLine.setIcon(EASResource.getIcon("imgTbtn_addline"));
		addLine.setToolTipText("");

		removeLine = kDContainer1.add(new ItemAction() {
			public void actionPerformed(ActionEvent e) {
				actionPerformed_removeLine(e);
			}
		});
		removeLine.setIcon(EASResource.getIcon("imgTbtn_deleteline"));
		addLine.setToolTipText("ɾ");

		this.kDSeparator2 = new com.kingdee.bos.ctrl.swing.KDSeparator();
		this.ok = new com.kingdee.bos.ctrl.swing.KDButton();
		this.cancel = new com.kingdee.bos.ctrl.swing.KDButton();
		this.mainTable.setName("kDTable1");
		this.kDSeparator2.setName("kDSeparator2");
		this.ok.setName("ok");
		this.cancel.setName("cancel");
		this.ok.setText("ȷ");
		this.ok.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent e) {
				beforeActionPerformed(e);
				try {
					ok_actionPerformed(e);
				} catch (Exception exc) {
					handUIException(exc);
				} finally {
					afterActionPerformed(e);
				}
			}
		});
		this.cancel.setText("ȡ");
		this.cancel.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent e) {
				beforeActionPerformed(e);
				try {
					cancel_actionPerformed(e);
				} catch (Exception exc) {
					handUIException(exc);
				} finally {
					afterActionPerformed(e);
				}
			}
		});
		progressBar = new KDProgressBar();
		progressBar.setToolTipText("ɸѡ");
		progressBar.setVisible(false);
	}

	protected void actionPerformed_removeLine(ActionEvent e) {
		EDkdTableUtil.SelectManager.checkSelect(mainTable);
		int rowIndex = EDkdTableUtil.SelectManager.getSelectedRow(mainTable);
		mainTable.removeRow(rowIndex);
	}

	protected void actionPerformed_addLine(ActionEvent e) {
		mainTable.addRow();
	}

	public void initUIContentLayout() {
		this.setBounds(new Rectangle(10, 10, 500, 300));
		this.setLayout(null);

		kDSeparator2.setBounds(new Rectangle(2, 269, 499, 10));
		this.add(kDSeparator2, null);
		ok.setBounds(new Rectangle(421, 274, 73, 21));
		this.add(ok, null);
		cancel.setBounds(new Rectangle(341, 274, 73, 21));
		this.add(cancel, null);
		progressBar.setBounds(new Rectangle(5, 275, 300, 18));
		this.add(progressBar, null);
		// kDContainer1
		kDContainer1.getContentPane().setLayout(new BorderLayout(0, 0));
		kDContainer1.getContentPane().add(mainTable, BorderLayout.CENTER);
		kDContainer1.setBounds(new Rectangle(5, 5, 490, 259));
		this.add(kDContainer1, null);
	}

	public void initUIMenuBarLayout() {
		this.menuBar.add(menuFile);
		this.menuBar.add(menuTool);
		this.menuBar.add(MenuService);
		this.menuBar.add(menuHelp);
		// menuFile
		menuFile.add(menuItemPageSetup);
		menuFile.add(kDSeparator1);
		menuFile.add(menuItemExitCurrent);
		// menuTool
		menuTool.add(menuItemSendMessage);
		menuTool.add(menuItemCalculator);
		// MenuService
		MenuService.add(MenuItemKnowStore);
		MenuService.add(MenuItemAnwser);
		MenuService.add(SepratorService);
		MenuService.add(MenuItemRemoteAssist);
		// menuHelp
		menuHelp.add(menuItemHelp);
		menuHelp.add(kDSeparator12);
		menuHelp.add(menuItemRegPro);
		menuHelp.add(menuItemPersonalSite);
		menuHelp.add(helpseparatorDiv);
		menuHelp.add(menuitemProductval);
		menuHelp.add(kDSeparatorProduct);
		menuHelp.add(menuItemAbout);

	}

	public void initUIToolBarLayout() {
		this.toolBar.add(btnPageSetup);
	}

	public String getUIHandlerClassName() {
		return "";
	}

	public IUIActionPostman prepareInit() {
		IUIActionPostman clientHanlder = super.prepareInit();
		if (clientHanlder != null) {
			RequestContext request = new RequestContext();
			request.setClassName(getUIHandlerClassName());
			clientHanlder.setRequestContext(request);
		}
		return clientHanlder;
	}

	public boolean isPrepareInit() {
		return false;
	}

	protected void initUIP() {
		super.initUIP();
	}

	public void setDataObject(IObjectValue dataObject) {
		IObjectValue ov = dataObject;
		super.setDataObject(ov);
	}

	public void loadFields() {
		dataBinder.loadFields();
	}

	public void storeFields() {
		dataBinder.storeFields();
	}

	protected void registerValidator() {
		getValidateHelper().setCustomValidator(getValidator());
	}

	public void setOprtState(String oprtType) {
		super.setOprtState(oprtType);
	}

	public IMetaDataPK getMetaDataPK() {
		return new MetaDataPK("com.kingdee.eas.test", "EntryFilterUI");
	}

}
