package com.kingdee.eas.lifetime.util.commonui.dataimp;

import java.awt.Rectangle;
import java.io.File;

import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.lifetime.util.edcommonutils.ExcelUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;

/**
 * @author lifeTime 2010-4-20 11:30:10
 * 
 */
public class AbstractDataImport extends CoreUI {
	protected static final long serialVersionUID = 1L;
	protected static final String Error_0 = "ִֹͣ";
	protected static final String Error_10 = "¼ﵽ10ʱֹͣ";
	protected static final String Error_20 = "¼ﵽ20ʱֹͣ";
	protected static final String Error_50 = "¼ﵽ50ʱֹͣ";
	protected static final String Error_Never = "ִϲֹͣ";

	protected static final String ImpMode_1 = "";
	protected static final String ImpMode_2 = "";

	/**
	 * 빦
	 */
	public static final String Interface = "interface";
	public static final String OwnerUI = "OwnerUI";

	protected com.kingdee.bos.ctrl.swing.KDButton cancel;
	protected com.kingdee.bos.ctrl.swing.KDButton doImport;
	protected com.kingdee.bos.ctrl.swing.KDButton expMode;
	protected com.kingdee.bos.ctrl.swing.KDSeparator kDSeparator2;
	protected com.kingdee.bos.ctrl.swing.KDLabel kDLabel1;
	protected com.kingdee.bos.ctrl.swing.KDLabelContainer kDLabelContainer1;
	protected com.kingdee.bos.ctrl.swing.KDLabelContainer kDLabelContainer2;
	protected com.kingdee.bos.ctrl.swing.KDLabelContainer kDLabelContainer3;
	protected com.kingdee.bos.ctrl.swing.KDLabelContainer kDLabelContainer4;
	protected com.kingdee.bos.ctrl.swing.KDTextField fileChooseTxt;
	protected com.kingdee.bos.ctrl.swing.KDWorkButton fileChoose;
	protected com.kingdee.bos.ctrl.swing.KDComboBox pageView;
	protected com.kingdee.bos.ctrl.swing.KDWorkButton refresh;
	protected com.kingdee.bos.ctrl.swing.KDComboBox errorHandle;
	protected com.kingdee.bos.ctrl.swing.KDComboBox impType;
	protected com.kingdee.bos.ctrl.swing.KDProgressBar probar;
	protected com.kingdee.bos.ctrl.swing.KDLabel lbl2;

	private String uiTitle = "";
	private IDataImport dataImport;
	private boolean isClose;
	protected JFileChooser excelFileChooser;
	private CoreUIObject ownerUI;

	public AbstractDataImport() throws Exception {
		super();
		isClose = true;
		jbInit();
		initUIP();
	}

	public void onLoad() throws Exception {
		super.onLoad();
		initData();
		initControl();
	}

	protected void initData() {
		dataImport = (IDataImport) getUIContext().get(Interface);
		ownerUI = (CoreUIObject) getUIContext().get(OwnerUI);
	}

	protected void initControl() {
		kDLabel1.setIcon(EASResource.getIcon("imgTransfers_pic260"));
		fileChoose.setIcon(EASResource.getIcon("imgTbtn_dcdwj"));
		refresh.setIcon(EASResource.getIcon("imgTbtn_refresh"));
		errorHandle.addItems(new String[] { Error_0, Error_10, Error_20, Error_50, Error_Never });
		showProgress(false);
		fileChooseTxt.setEditable(false);
		pageView.setEnabled(false);
		initImpMode();
	}

	protected void initImpMode() {
		if (dataImport != null) {
			Integer[] modes = dataImport.getImpMode();
			if (modes != null) {
				for (int i = 0; i < modes.length; i++) {
					if (modes[i].intValue() == 1) {
						impType.addItem(ImpMode_1);
					} else if (modes[i].intValue() == 2) {
						impType.addItem(ImpMode_2);
					}
				}
			}
		}
	}

	protected void showProgress(boolean state) {
		lbl2.setVisible(state);
		probar.setVisible(state);
		probar.setIndeterminate(state);
		errorHandle.setEnabled(!state);
		impType.setEnabled(!state);
		expMode.setEnabled(!state);
		doImport.setEnabled(!state);
		cancel.setEnabled(!state);
		pageView.setEnabled(!state);
		fileChoose.setEnabled(!state);
		refresh.setEnabled(!state);
	}

	private void jbInit() throws Exception {
		this.setUITitle(getUiTitle());
		this.cancel = new com.kingdee.bos.ctrl.swing.KDButton();
		this.doImport = new com.kingdee.bos.ctrl.swing.KDButton();
		this.expMode = new com.kingdee.bos.ctrl.swing.KDButton();
		this.kDSeparator2 = new com.kingdee.bos.ctrl.swing.KDSeparator();
		this.kDLabel1 = new com.kingdee.bos.ctrl.swing.KDLabel();
		this.kDLabelContainer1 = new com.kingdee.bos.ctrl.swing.KDLabelContainer();
		this.kDLabelContainer2 = new com.kingdee.bos.ctrl.swing.KDLabelContainer();
		this.kDLabelContainer3 = new com.kingdee.bos.ctrl.swing.KDLabelContainer();
		this.kDLabelContainer4 = new com.kingdee.bos.ctrl.swing.KDLabelContainer();
		this.fileChooseTxt = new com.kingdee.bos.ctrl.swing.KDTextField();
		this.fileChoose = new com.kingdee.bos.ctrl.swing.KDWorkButton();
		this.pageView = new com.kingdee.bos.ctrl.swing.KDComboBox();
		this.refresh = new com.kingdee.bos.ctrl.swing.KDWorkButton();
		this.errorHandle = new com.kingdee.bos.ctrl.swing.KDComboBox();
		this.impType = new com.kingdee.bos.ctrl.swing.KDComboBox();
		this.probar = new com.kingdee.bos.ctrl.swing.KDProgressBar();
		this.lbl2 = new com.kingdee.bos.ctrl.swing.KDLabel();
		this.cancel.setName("cancel");
		this.doImport.setName("doImport");
		this.expMode.setName("expMode");
		this.kDSeparator2.setName("kDSeparator2");
		this.kDLabel1.setName("kDLabel1");
		this.kDLabelContainer1.setName("kDLabelContainer1");
		this.kDLabelContainer2.setName("kDLabelContainer2");
		this.kDLabelContainer3.setName("kDLabelContainer3");
		this.kDLabelContainer4.setName("kDLabelContainer4");
		this.fileChooseTxt.setName("fileChooseTxt");
		this.fileChoose.setName("fileChoose");
		this.pageView.setName("pageView");
		this.refresh.setName("refresh");
		this.errorHandle.setName("errorHandle");
		this.impType.setName("impType");
		this.probar.setName("probar");
		this.lbl2.setName("lbl2");
		this.cancel.setText("ȡ");
		this.cancel.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent e) {
				beforeActionPerformed(e);
				try {
					cancel_actionPerformed(e);
				} catch (Exception exc) {
					handUIException(exc);
				} finally {
					afterActionPerformed(e);
				}
			}
		});
		this.doImport.setText("");
		this.doImport.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent e) {
				beforeActionPerformed(e);
				try {
					doImport_actionPerformed(e);
				} catch (Exception exc) {
					handUIException(exc);
				} finally {
					afterActionPerformed(e);
				}
			}
		});
		this.expMode.setText("ģ");
		this.expMode.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent e) {
				beforeActionPerformed(e);
				try {
					expMode_actionPerformed(e);
				} catch (Exception exc) {
					handUIException(exc);
				} finally {
					afterActionPerformed(e);
				}
			}
		});
		this.kDLabelContainer1.setBoundLabelText("ļ");
		this.kDLabelContainer1.setBoundLabelLength(80);
		this.kDLabelContainer1.setBoundLabelUnderline(true);
		this.kDLabelContainer2.setBoundLabelText("ҳǩ");
		this.kDLabelContainer2.setBoundLabelLength(80);
		this.kDLabelContainer2.setBoundLabelUnderline(true);
		this.kDLabelContainer3.setBoundLabelText("ݳ");
		this.kDLabelContainer3.setBoundLabelLength(80);
		this.kDLabelContainer3.setBoundLabelUnderline(true);
		this.kDLabelContainer4.setBoundLabelText("뷽ʽ");
		this.kDLabelContainer4.setBoundLabelLength(80);
		this.kDLabelContainer4.setBoundLabelUnderline(true);
		this.fileChoose.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent e) {
				beforeActionPerformed(e);
				try {
					fileChoose_actionPerformed(e);
				} catch (Exception exc) {
					handUIException(exc);
				} finally {
					afterActionPerformed(e);
				}
			}
		});
		this.refresh.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent e) {
				beforeActionPerformed(e);
				try {
					refresh_actionPerformed(e);
				} catch (Exception exc) {
					handUIException(exc);
				} finally {
					afterActionPerformed(e);
				}
			}
		});
		this.errorHandle.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent e) {
				beforeActionPerformed(e);
				try {
					errorHandle_actionPerformed(e);
				} catch (Exception exc) {
					handUIException(exc);
				} finally {
					afterActionPerformed(e);
				}
			}
		});
		this.lbl2.setText("...");
	}

	public void initUIContentLayout() {
		this.setBounds(new Rectangle(10, 10, 450, 320));
		this.setLayout(null);
		cancel.setBounds(new Rectangle(360, 291, 73, 21));
		this.add(cancel, null);
		doImport.setBounds(new Rectangle(271, 291, 73, 21));
		this.add(doImport, null);
		expMode.setBounds(new Rectangle(13, 291, 109, 21));
		this.add(expMode, null);
		kDSeparator2.setBounds(new Rectangle(0, 282, 451, 10));
		this.add(kDSeparator2, null);
		kDLabel1.setBounds(new Rectangle(12, 13, 138, 259));
		this.add(kDLabel1, null);
		kDLabelContainer1.setBounds(new Rectangle(170, 23, 236, 19));
		this.add(kDLabelContainer1, null);
		kDLabelContainer2.setBounds(new Rectangle(170, 61, 236, 19));
		this.add(kDLabelContainer2, null);
		kDLabelContainer3.setBounds(new Rectangle(170, 98, 270, 19));
		this.add(kDLabelContainer3, null);
		kDLabelContainer4.setBounds(new Rectangle(170, 137, 208, 19));
		this.add(kDLabelContainer4, null);
		fileChoose.setBounds(new Rectangle(409, 23, 31, 19));
		this.add(fileChoose, null);
		refresh.setBounds(new Rectangle(409, 61, 31, 19));
		this.add(refresh, null);
		probar.setBounds(new Rectangle(228, 250, 210, 21));
		this.add(probar, null);
		lbl2.setBounds(new Rectangle(168, 252, 76, 19));
		this.add(lbl2, null);
		kDLabelContainer1.setBoundEditor(fileChooseTxt);
		kDLabelContainer2.setBoundEditor(pageView);
		kDLabelContainer3.setBoundEditor(errorHandle);
		kDLabelContainer4.setBoundEditor(impType);
	}

	public void initUIMenuBarLayout() {
		this.menuBar.add(menuFile);
		this.menuBar.add(menuTool);
		this.menuBar.add(MenuService);
		this.menuBar.add(menuHelp);
		menuFile.add(menuItemPageSetup);
		menuFile.add(kDSeparator1);
		menuFile.add(menuItemExitCurrent);
		menuTool.add(menuItemSendMessage);
		menuTool.add(menuItemCalculator);
		MenuService.add(MenuItemKnowStore);
		MenuService.add(MenuItemAnwser);
		MenuService.add(SepratorService);
		MenuService.add(MenuItemRemoteAssist);
		menuHelp.add(menuItemHelp);
		menuHelp.add(kDSeparator12);
		menuHelp.add(menuItemRegPro);
		menuHelp.add(menuItemPersonalSite);
		menuHelp.add(helpseparatorDiv);
		menuHelp.add(menuitemProductval);
		menuHelp.add(kDSeparatorProduct);
		menuHelp.add(menuItemAbout);

	}

	public void initUIToolBarLayout() {
		this.toolBar.add(btnPageSetup);

	}

	public boolean isPrepareInit() {
		return false;
	}

	protected void cancel_actionPerformed(java.awt.event.ActionEvent e) throws Exception {
		this.destroyWindow();
	}

	protected void doImport_actionPerformed(java.awt.event.ActionEvent e) throws Exception {
	}

	protected void expMode_actionPerformed(java.awt.event.ActionEvent e) throws Exception {
	}

	protected void fileChoose_actionPerformed(java.awt.event.ActionEvent e) throws Exception {
		String filePath = fileChoose();
		if (filePath != null) {
			fillPageView(filePath);
		}
	}

	protected void refresh_actionPerformed(java.awt.event.ActionEvent e) throws Exception {
		pageViewRefresh(fileChooseTxt.getText());
	}

	protected void errorHandle_actionPerformed(java.awt.event.ActionEvent e) throws Exception {
	}

	protected String fileChoose() {
		if (excelFileChooser == null) {
			excelFileChooser = new JFileChooser();
			FileFilter fileFilter = new FileFilter() {
				public String getDescription() {
					return "ļѡ";
				}

				public boolean accept(File f) {
					String fpath = f.getAbsolutePath();
					if (fpath != null && fpath.lastIndexOf(".xls") != -1) {
						return true;
					}
					return false;
				}
			};
			excelFileChooser.setFileFilter(fileFilter);
		}
		int mode = excelFileChooser.showOpenDialog(this);
		if (mode == JFileChooser.APPROVE_OPTION) {
			return excelFileChooser.getSelectedFile().getAbsolutePath();
		}
		return null;
	}

	protected void fillPageView(String filePath) {
		fileChooseTxt.setText(filePath);
		pageView.setEnabled(true);
		pageViewRefresh(filePath);
	}

	/**
	 * 
	 */
	protected void pageViewRefresh(String filePath) {
		try {
			if (filePath != null && filePath.trim().length() != 0) {
				File file = new File(filePath);
				if (file.exists()) {
					pageView.removeAllItems();
					pageView.addItems(ExcelUtil.getSheetNames(filePath));
				} else {
					MsgBox.showInfo("ļ " + filePath + " Ѳڣ");
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	public IMetaDataPK getMetaDataPK() {
		return new MetaDataPK("com.kingdee.eas.EDxbangUtil.commonui", "AbstractDataImport");
	}

	protected boolean checkBeforeWindowClosing() {
		return isClose();
	}

	protected void disposeUIWindow() {
		super.disposeUIWindow();
		if (ownerUI != null && ownerUI instanceof ListUI) {
			try {
				((ListUI) ownerUI).refreshList();
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}

	public String getUiTitle() {
		return uiTitle;
	}

	public void setUiTitle(String uiTitle) {
		this.uiTitle = uiTitle;
	}

	public IDataImport getDataImport() {
		return dataImport;
	}

	public void setDataImport(IDataImport dataImport) {
		this.dataImport = dataImport;
	}

	public boolean isClose() {
		return isClose;
	}

	public void setClose(boolean isClose) {
		this.isClose = isClose;
	}

	public CoreUIObject getOwnerUI() {
		return ownerUI;
	}

	public void setOwnerUI(CoreUIObject ownerUI) {
		this.ownerUI = ownerUI;
	}

}
