package com.kingdee.eas.lifetime.util.commonui.dataimp;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;

import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;

import com.kingdee.eas.lifetime.util.edcommonutils.EDcommonUtils;
import com.kingdee.eas.lifetime.util.edcommonutils.ExcelUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;

/**
 * ݵ
 * 
 * <pre>
 * if (impWindow == null) {
 * 	getUIContext().put(DataImport.Interface, (IDataImport) instance);
 * 	getUIContext().put(DataImport.OwnerUI, this);
 * 	impWindow = EDwindowUtil.getWindow(getUIContext(), &quot;com.kingdee.eas.lifetime.util.commonui.dataimp.DataImport&quot;);
 * }
 * impWindow.show();
 * </pre>
 * 
 * @author lifeTime 2010-4-20 11:09:54
 */
public class DataImport extends AbstractDataImport {
	private static final long serialVersionUID = 1L;
	protected JFileChooser modeExpFileChooser;

	public DataImport() throws Exception {
		super();
	}

	public void verifyData() throws Exception {
		if (getDataImport() == null) {
			MsgBox.showInfo("ûָ빦ܣ");
			SysUtil.abort();
		} else if (getDataImport().getTemplate() == null) {
			MsgBox.showInfo("ģ岻Ϊգ");
			SysUtil.abort();
		}
	}

	protected void expMode_actionPerformed(ActionEvent e) throws Exception {
		verifyData();
		String filePath = selectFilePath();
		if (filePath != null) {
			HSSFWorkbook wb = createWB();
			saveTemplate(filePath, wb);
		}
	}

	protected void saveTemplate(String filePath, HSSFWorkbook wb) throws FileNotFoundException, IOException {
		String file = filePath + "\\" + getDataImport().getDescribe() + ".xls";
		File file2 = new File(file);
		if (file2.exists()) {
			if (MsgBox.isOk(MsgBox.showConfirm2("ļ " + file + " ѾڣҪ"))) {
				if (!file2.delete()) {
					MsgBox.showInfo("ʧܣļڱʹã");
					SysUtil.abort();
				} else {
					FileOutputStream fileOut = new FileOutputStream(file);
					wb.write(fileOut);
					fileOut.close();
					MsgBox.showInfo("ģ " + file + " Ǳɹ");
				}
			}
		} else {
			FileOutputStream fileOut = new FileOutputStream(file);
			wb.write(fileOut);
			fileOut.close();
			MsgBox.showInfo("ģ " + file + " ɹ");
		}
	}

	protected HSSFWorkbook createWB() {
		String[] temp = getDataImport().getTemplate();
		HSSFWorkbook wb = new HSSFWorkbook();
		HSSFCellStyle cellStyle = wb.createCellStyle();
		cellStyle.setBorderBottom(HSSFCellStyle.BORDER_DASHED);
		cellStyle.setBottomBorderColor(HSSFColor.RED.index);
		cellStyle.setBorderLeft(HSSFCellStyle.BORDER_DASHED);
		cellStyle.setLeftBorderColor(HSSFColor.RED.index);
		cellStyle.setBorderRight(HSSFCellStyle.BORDER_DASHED);
		cellStyle.setRightBorderColor(HSSFColor.RED.index);
		cellStyle.setBorderTop(HSSFCellStyle.BORDER_DASHED);
		cellStyle.setTopBorderColor(HSSFColor.RED.index);
		HSSFSheet sheet = wb.createSheet(getDataImport().getDescribe());
		HSSFRow row = sheet.createRow(0);
		row.createCell((short) 0).setCellValue(new HSSFRichTextString(getToptitle()));
		HSSFRow row1 = sheet.createRow(1);
		for (int i = 0; i < temp.length; i++) {
			HSSFCell cell = row1.createCell((short) i);
			cell.setCellStyle(cellStyle);
			cell.setCellValue(new HSSFRichTextString(temp[i]));
		}
		return wb;
	}

	protected String getToptitle() {
		return " : " + getDataImport().getDescribe() + "\n ";
	}

	/**
	 * 
	 */
	private String selectFilePath() {
		if (modeExpFileChooser == null) {
			modeExpFileChooser = new JFileChooser();
			modeExpFileChooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
		}
		int mode = modeExpFileChooser.showSaveDialog(this);
		if (mode == JFileChooser.APPROVE_OPTION) {
			return modeExpFileChooser.getSelectedFile().getAbsolutePath();
		}
		return null;
	}

	protected void doImport_actionPerformed(java.awt.event.ActionEvent e) throws Exception {
		dataVerify();
		if (templateVerify()) {
			doImport();
		}
	}

	/**
	 * @throws Exception
	 * 
	 */
	protected void doImport() throws Exception {
		final int mode = getMode();
		final int errorCount = getErrorCount();
		final List datas = getDatas();

		Thread thread = new Thread() {
			public void run() {
				try {
					SwingUtilities.invokeAndWait(new Runnable() {
						public void run() {
							importBefore();
						}
					});
				} catch (Exception e1) {
					e1.printStackTrace();
				}
				int errorCount_ = 0;
				List errors = new ArrayList();

				for (int i = 0, k = datas.size(); i < k; i++) {
					Map row = null;
					try {
						row = (Map) datas.get(i);
						runImport(mode, row);
					} catch (Exception e) {
						e.printStackTrace();
						addError(errors, e, row);
						errorCount_++;
						if (errorCount_ < errorCount) {
							continue;
						} else {
							break;
						}
					}
				}
				importAfter();
				showError(errors);
			}
		};
		thread.start();
	}

	/**
	 * @param errors
	 */
	protected void showError(List errors) {
		if (errors.isEmpty()) {
			MsgBox.showInfo("ɹɣ");
		} else {
			StringBuffer detail = new StringBuffer();
			for (int i = 0, k = errors.size(); i < k; i++) {
				detail.append(errors.get(i)).append("\n");
			}
			MsgBox.showConfirm3a("дڴ鿴ϸϢ", detail.toString());
		}
	}

	/**
	 * @param errors
	 * @param e
	 */
	protected void addError(List errors, Exception e, Map row) {
		errors.add("" + row.get("index") + "У" + e.getMessage());
	}

	protected void runImport(int mode, Map row) throws Exception {
		getDataImport().importing(row, mode);
	}

	protected void importBefore() {
		showProgress(true);
		setClose(false);
	}

	protected void importAfter() {
		showProgress(false);
		setClose(true);
	}

	protected int getMode() {
		if (ImpMode_1.equals(impType.getSelectedItem())) {
			return 1;
		} else if (ImpMode_2.equals(impType.getSelectedItem())) {
			return 2;
		}
		return -1;
	}

	protected int getErrorCount() {
		if (Error_0.equals(errorHandle.getSelectedItem())) {
			return 0;
		} else if (Error_10.equals(errorHandle.getSelectedItem())) {
			return 10;
		} else if (Error_20.equals(errorHandle.getSelectedItem())) {
			return 20;
		} else if (Error_50.equals(errorHandle.getSelectedItem())) {
			return 50;
		} else if (Error_Never.equals(errorHandle.getSelectedItem())) {
			return 1024 * 64;
		}
		return -1;
	}

	/**
	 * @return
	 */
	protected List getDatas() {
		String file = fileChooseTxt.getText();
		List datas = new ArrayList();
		try {
			HSSFWorkbook workbook = ExcelUtil.load(file);
			HSSFSheet sheet = workbook.getSheet(String.valueOf(pageView.getSelectedItem()));
			List heads = getHead(sheet);
			for (int i = 2; i <= sheet.getLastRowNum(); i++) {
				HashMap row = new HashMap();
				HSSFRow hssfRow = sheet.getRow(i);
				for (int j = 0; j < heads.size(); j++) {
					String cellStr = ExcelUtil.getCellValue(hssfRow.getCell((short) j));
					System.out.println("================       " + cellStr);
					row.put(heads.get(j), cellStr);
				}
				row.put("index", String.valueOf(i + 1));
				datas.add(row);
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return datas;
	}

	/**
	 * @param sheet
	 * @return
	 */
	private List getHead(HSSFSheet sheet) {
		HSSFRow hssfRow = sheet.getRow(1);
		int columnCount = ExcelUtil.getColumnCount(hssfRow);
		ArrayList list = new ArrayList();
		for (short i = 0; i < columnCount; i++) {
			HSSFRichTextString richTextString = hssfRow.getCell(i).getRichStringCellValue();
			list.add(richTextString == null ? "" : analyzeHeadStr(richTextString.getString()));
		}
		return list;
	}

	/**
	 * @param string
	 * @return
	 */
	private String analyzeHeadStr(String headStr) {
		int start = headStr.indexOf("(");
		int end = headStr.lastIndexOf(")");
		if (start != -1 && end != -1) {
			return EDcommonUtils.StringUtils.subString(headStr, start, end, false);
		}
		return headStr;
	}

	/**
	 * @throws Exception
	 * 
	 */
	protected boolean templateVerify() {
		String[] temp = getDataImport().getTemplate();
		String file = fileChooseTxt.getText();
		try {
			HSSFWorkbook workbook = ExcelUtil.load(file);
			HSSFSheet sheet = workbook.getSheet(String.valueOf(pageView.getSelectedItem()));
			HSSFRow row = sheet.getRow(1);
			for (int i = 0; i < temp.length; i++) {
				if (row.getCell((short) i) == null || !temp[i].equalsIgnoreCase(row.getCell((short) i).getRichStringCellValue().getString())) {
					MsgBox.showConfirm3a("ļģ岻ƥ䣬ģ壡", "ģ " + temp[i] + " ڣ");
					return false;
				}
			}
			return true;
		} catch (NullPointerException e) {
			MsgBox.showConfirm3a("ļģ岻ƥ䣬ģ壡", "ģҳǩΪգ");
			return false;
		} catch (Exception e) {
			MsgBox.showConfirm3a("ļģ岻ƥ䣬ģ壡", e.toString());
			return false;
		}
	}

	/**
	 * @throws Exception
	 * 
	 */
	protected void dataVerify() throws Exception {
		if (fileChooseTxt.getText() == null) {
			MsgBox.showInfo("ѡļ");
			fileChooseTxt.requestFocusInWindow();
			SysUtil.abort();
		}
		if (impType.getSelectedItem() == null) {
			MsgBox.showInfo("ָģʽ");
			impType.requestFocusInWindow();
			SysUtil.abort();
		}
		if (pageView.getSelectedItem() == null) {
			MsgBox.showInfo("ѡһҳǩ");
			pageView.requestFocusInWindow();
			SysUtil.abort();
		}
		verifyData();
	}

}
