package com.kingdee.eas.EDxbangUtil.edcommonutils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;

import org.apache.commons.jexl.Expression;
import org.apache.commons.jexl.ExpressionFactory;
import org.apache.commons.jexl.JexlContext;
import org.apache.commons.jexl.JexlHelper;
import org.apache.log4j.Logger;

import com.kingdee.bos.util.backport.Collections;
import com.kingdee.util.DateTimeUtils;

/**
 * @author lifeTime
 * 
 */
public class EDcommonUtils {

	private static final Logger logger = org.apache.log4j.Logger.getLogger(EDcommonUtils.class);

	private EDcommonUtils() {
	}

	public static class ListUtil {

		private ListUtil() {
		}

		public static boolean isEmpty(List list) {
			return list == null || list.isEmpty() ? true : false;
		}

		/**
		 * 
		 * @param src
		 * @param target
		 * @return
		 */
		public static List copy(List src, List target) {
			ArrayList list = new ArrayList();
			for (int i = src.size(); --i >= 0;) {
				list.add(src.get(i));
			}
			for (int i = target.size(); --i >= 0;) {
				list.add(target.get(i));
			}
			return list;
		}

		/**
		 * srcԪؼtarget
		 * 
		 * @param src
		 * @param target
		 * @return
		 */
		public static List addList(List src, List target) {
			for (int i = 0, k = src.size(); i < k; i++) {
				target.add(src.get(i));
			}
			return target;
		}

		/**
		 * object[]תΪList
		 * 
		 * @param objs
		 * @return
		 */
		public static List convertObjectToList(Object objs) {
			ArrayList list = new ArrayList();
			if (objs != null && objs instanceof Object[]) {
				Object[] objects = (Object[]) objs;
				for (int i = objects.length; --i >= 0; list.add(objects[i]))
					;
			}
			return list;
		}

		/**
		 * listȥظ
		 * 
		 * @param list
		 * @return
		 */
		public static List toSingleElement(List list) {
			ArrayList temp = new ArrayList(list.size());
			HashSet tempSet = new HashSet();
			for (int i = 0, k = list.size(); i < k; i++) {
				tempSet.add(list.get(i));
			}
			Iterator it = tempSet.iterator();
			while (it.hasNext()) {
				temp.add(it.next());
			}
			return temp;
		}

	}

	public static class MapUtil {
		private MapUtil() {
		}

		/**
		 * mapʴС
		 * 
		 * @param size
		 *            Ԫظ
		 * @return
		 */
		public static int getRightSize(int size) {
			int order = 0;
			int mapSize = 0;
			while (true) {
				mapSize = 2 ^ order;
				if (mapSize * 0.75 > size) {
					break;
				}
				order++;
			}
			return mapSize;
		}

		public static boolean isEmpty(Map m) {
			return m == null || m.isEmpty() ? true : false;
		}

		/**
		 * mapkey(Ȼ)󷵻ֵlist
		 * 
		 * @param map
		 * @return
		 */
		public static List sortByKeyToList(Map map) {
			return sortByKeyToList(map, null);
		}

		/**
		 * mapkey(ָ)󷵻ֵlist
		 * 
		 * @param map
		 * @return
		 */
		public static List sortByKeyToList(Map map, Comparator comparator) {
			List keyList = sortKey(map, comparator);
			ArrayList valueList = new ArrayList();
			for (int i = keyList.size(); --i >= 0;) {
				valueList.add(map.get(keyList.get(i)));
			}
			return valueList;
		}

		/**
		 * mapkey󷵻keylist
		 * 
		 * @param map
		 * @param comparator
		 * @return
		 */
		public static List sortKey(Map map, Comparator comparator) {
			if (map == null || map.isEmpty()) {
				return null;
			}
			Iterator it = map.keySet().iterator();
			ArrayList keyList = new ArrayList();
			while (it.hasNext()) {
				keyList.add(it.next());
			}
			Collections.sort(keyList, comparator);
			return keyList;
		}

	}

	public static class StringUtils {
		private StringUtils() {
		}

		/**
		 * ַбȽ
		 * 
		 * @param str1
		 *            ߵıȽ϶,ǶֵֵMultiValueSignϣ
		 * @param str2
		 *            ұߵıȽ϶
		 * @param sign
		 *            Ƚϱʽ
		 * @return
		 */
		public static String compareString(String str1, String str2, String sign) {
			if (str1 == null || str2 == null) {
				return falseValue;
			}
			str1 = str1.trim();
			str2 = str2.trim();
			try {
				java.util.Date date1 = DateTimeUtils.parseDate(str1);
				java.util.Date date2 = DateTimeUtils.parseDate(str2);
				logger.info("\t" + str1 + "\t" + str2 + "\t\t\tȽϣ");
				if (Greater.equals(sign)) {
					return date1.compareTo(date2) == 1 ? trueValue : falseValue;
				} else if (Less.equals(sign)) {
					return date1.compareTo(date2) == -1 ? trueValue : falseValue;
				} else if (Equals.equals(sign)) {
					return date1.compareTo(date2) == 0 ? trueValue : falseValue;
				} else if (Not_Equals.equals(sign)) {
					return date1.compareTo(date2) != 0 ? trueValue : falseValue;
				} else if (Greater_Equals.equals(sign)) {
					return date1.compareTo(date2) != -1 ? trueValue : falseValue;
				} else if (Less_Equals.equals(sign)) {
					return date1.compareTo(date2) != 1 ? trueValue : falseValue;
				}
			} catch (Exception e) {
				logger.info("\t" + str1 + "\t" + str2 + "\tȽϣ");
			}

			try {
				BigDecimal d1 = new BigDecimal(str1);
				BigDecimal d2 = new BigDecimal(str2);
				logger.info("\t" + str1 + "\t" + str2 + "\t\t\tֻȽϣ");
				if (Greater.equals(sign)) {
					return d1.compareTo(d2) == 1 ? trueValue : falseValue;
				} else if (Less.equals(sign)) {
					return d1.compareTo(d2) == -1 ? trueValue : falseValue;
				} else if (Equals.equals(sign)) {
					return d1.compareTo(d2) == 0 ? trueValue : falseValue;
				} else if (Not_Equals.equals(sign)) {
					return d1.compareTo(d2) != 0 ? trueValue : falseValue;
				} else if (Greater_Equals.equals(sign)) {
					return d1.compareTo(d2) != -1 ? trueValue : falseValue;
				} else if (Less_Equals.equals(sign)) {
					return d1.compareTo(d2) != 1 ? trueValue : falseValue;
				}
			} catch (Exception e) {
				logger.info("\t" + str1 + "\t" + str2 + "\tֻȽϣ");
			}

			boolean isCompareStr = false;
			if (Equals.equals(sign) && isEquals(str1, str2)) {
				isCompareStr = true;
				return trueValue;
			} else if (Equals.equals(sign) && !isEquals(str1, str2)) {
				isCompareStr = true;
				return falseValue;
			} else if (Not_Equals.equals(sign) && !isEquals(str1, str2)) {
				isCompareStr = true;
				return trueValue;
			} else if (Not_Equals.equals(sign) && isEquals(str1, str2)) {
				isCompareStr = true;
				return falseValue;
			}

			if (isCompareStr) {
				logger.info("\t" + str1 + "\t" + str2 + "\t\t\tַͽбȽϣ");
			}

			logger.info("\t" + str1 + "\t" + str2 + "\t\t\tûпɱԣ");
			return falseValue;
		}

		/**
		 * Ϊֵܶһ˿кܶѧ
		 * 
		 * @param str1
		 *            ߵıȽ϶
		 * @param str2
		 *            ұߵıȽ϶
		 * @return
		 */
		private static boolean isEquals(String str1, String str2) {
			if (str1.equals(str2)) {
				return true;
			}
			String[] dass = str1.split(MultiValueSign);
			for (int i = 0; i < dass.length; i++) {
				String das = dass[i];
				if (das.equals(str2)) {
					return true;
				}
			}
			return false;
		}

		/**
		 * ǷַΪʱֶ
		 * 
		 * @param str
		 * @return
		 */
		public static boolean isNumberString(String str) {
			if (isEmpty(str))
				return false;
			str = str.trim();
			int i = 0;
			for (int n = str.length(); i < n; i++) {
				char c = str.charAt(i);
				if (!Character.isDigit(c))
					return false;
			}
			return true;
		}

		/**
		 * ȥеĿո
		 * 
		 * @param str
		 * @return
		 */
		public static String trimAll(String str) {
			return str.replaceAll(" ", "");
		}

		/**
		 * ȥз
		 * 
		 * @param str
		 * @return
		 */
		public static String trimEnter(String str) {
			return str.replaceAll("\n", "");
		}

		public static String getStringValue(Object obj) {
			return obj == null ? "" : obj.toString();
		}

		/**
		 * sourceStrĵcounttargetStr滻Ϊstr2 (迼Ƿjavaַʽַ)
		 * 
		 * @param sourceStr
		 * @param targetStr
		 *            Ҫ滻ַ
		 * @param str2
		 * @param count
		 *            滻countγֵַ
		 * @return
		 */
		public static String replace(String sourceStr, String targetStr, String str2, int count) {
			StringBuffer sb = new StringBuffer(sourceStr + " ");
			int totalCount = findStrCount(sb.toString(), targetStr);
			if (count > totalCount) {
				return sb.toString().trim();
			}
			int startIndex = findSubStrIndex(sb.toString(), targetStr, count);
			int endIndex = startIndex + targetStr.length();
			sb.replace(startIndex, endIndex, str2);
			return sb.toString();
		}

		/**
		 * sourceStrtargetStr滻Ϊstr2 (迼Ƿjavaַʽַ)
		 * 
		 * @param sourceStr
		 * @param targetStr
		 * @param str2
		 * @return
		 */
		public static String replaceAll(String sourceStr, String targetStr, String str2) {
			int totalCount = findStrCount(sourceStr, targetStr);
			for (int i = 1; i <= totalCount; i++) {
				sourceStr = replace(sourceStr, targetStr, str2, totalCount - i);
			}
			return sourceStr;
		}

		/**
		 * strָ󷵻list
		 * 
		 * @param str
		 * @param spiltStr
		 * @return
		 */
		public static List split(String str, String splitStr) {
			ArrayList list = new ArrayList();
			String[] ss = str.split(splitStr);
			for (int i = 0; i < ss.length; i++) {
				list.add(ss[i]);
			}
			return list;
		}

		/**
		 * ұ߶Ӧַĵڼ (1+1+(2+3+(2+2)+(3+3)+(4+4)+(5+5))) øַ4ŶӦĵڶ
		 * 
		 * @param sourceStr
		 * @param zuoStr
		 *            
		 * @param signIndex
		 *            4
		 * @param youStr
		 *            Ӧ
		 * @return
		 */
		public static int getRightIndex(String sourceStr, String zuoStr, int signIndex, String youStr) {
			int zuoIndex = findSubStrIndex(sourceStr, zuoStr, signIndex);
			String s = subString(sourceStr, 0, zuoIndex, true);
			int youCount = findStrCount(s, youStr);
			return youCount + 1;
		}

		/**
		 * ִֵXεindex(ܴûҵͷһεindex)
		 * 
		 * @param sourceStr
		 * @param subStr
		 * @param count
		 * @return
		 */
		public static int findSubStrIndex(String sourceStr, String subStr, int count) {
			int fromIndex = -1;
			int i = 1;
			while (sourceStr.indexOf(subStr, fromIndex + 1) != -1) {
				fromIndex = sourceStr.indexOf(subStr, fromIndex + 1);
				i++;
				if (i > count) {
					break;
				}
			}
			return fromIndex;
		}

		/**
		 * ȡַ
		 * 
		 * @param str
		 * @param startIndex
		 * @param endIndex
		 * @param isInclude
		 *            Ƿ
		 * @return
		 */
		public static String subString(String str, int beginIndex, int endIndex, boolean isInclude) {
			str = str + " ";
			if (isInclude) {
				str = str.substring(beginIndex, endIndex + 1);
			} else
				str = str.substring(beginIndex + 1, endIndex);
			return str.trim();
		}

		/**
		 * صַ(Ҳȥ)
		 * 
		 * @param startIndex
		 * @param endIndex
		 * @return
		 */
		public static String truncationString(String str, int startIndex, int endIndex) {
			StringBuffer sb = new StringBuffer();
			str += " ";
			sb.append(str.substring(0, startIndex));
			sb.append(str.substring(endIndex + 1, str.length()));
			return sb.toString();
		}

		/**
		 * һַԴֵַĴ
		 * 
		 * @param sourceStr
		 * @param paramStr
		 * @return
		 */
		public static int findStrCount(String sourceStr, String paramStr) {
			if (isEmpty(paramStr)) {
				return -1;
			}
			int x = 0;
			int index = sourceStr.indexOf(paramStr, 0);
			while (index != -1) {
				x++;
				index = sourceStr.indexOf(paramStr, index + 1);
			}
			return x;
		}

		/**
		 * õstringַ(ַĵһγַּ,ַ)
		 * 
		 * @param sourceStr
		 * @param startStr
		 * @param endStr
		 * @return
		 */
		public static String findBetween(String sourceStr, String startStr, String endStr) {
			return findBetween(sourceStr, startStr, 1, endStr, 1);
		}

		/**
		 * õstringַ(ַ)
		 * 
		 * @param sourceStr
		 * @param startStr
		 * @param startLookCount
		 *            ֵĵڼ(עⲻ1ʼ)
		 * @param endStr
		 * @param endLookCount
		 *            ֵĵڼ(עⲻ1ʼ)
		 * @return
		 */
		public static String findBetween(String sourceStr, String startStr, int startLookCount, String endStr, int endLookCount) {
			sourceStr = " " + sourceStr + " ";
			String s = "";
			int startIndex = sourceStr.indexOf(startStr);
			int endIndex = sourceStr.indexOf(endStr);
			if (startIndex == -1 || endIndex == -1) {
				return s;
			}
			int temp = 0;
			startIndex = -1;
			endIndex = -1;
			while (temp < startLookCount) {
				startIndex = sourceStr.indexOf(startStr, startIndex + 1);
				temp++;
			}
			temp = 0;
			while (temp < endLookCount) {
				endIndex = sourceStr.indexOf(endStr, endIndex + 1);
				temp++;
			}
			if (startIndex + startStr.length() + 1 < endIndex)
				s = sourceStr.substring(startIndex + startStr.length(), endIndex);
			else
				s = sourceStr.substring(endIndex + endStr.length(), startIndex);

			return s;
		}

		/**
		 * ַʽļ
		 * 
		 * @param strExp
		 * @return
		 * @throws Exception
		 */
		public static Object calculateStr(String strExp) throws Exception {
			JexlContext context = JexlHelper.createContext();
			Expression expression = ExpressionFactory.createExpression(strExp);
			return expression.evaluate(context);
		}

		public static boolean isEmpty(String str) {
			return str == null || str.trim().equals("") ? true : false;
		}

		public static final String trueValue = "true";
		public static final String falseValue = "false";
		public static final String Equals = "==";
		public static final String Not_Equals = "!=";
		public static final String Greater = ">";
		public static final String Less = "<";
		public static final String Greater_Equals = ">=";
		public static final String Less_Equals = "<=";
		public static final String[] CompareExps = new String[] { Equals, Not_Equals, Greater, Less, Greater_Equals, Less_Equals };

		public static final String Qie = "&&";
		public static final String Huo = "||";
		public static final String[] LogicExps = new String[] { Qie, Huo };

		/**
		 * ֵָʾ
		 */
		public static final String MultiValueSign = "!!!!!";

	}

	public static class RandomUtils {
		private RandomUtils() {
		}

		private static Random random = new Random();

		/**
		 * ֵָּ
		 * 
		 * @param min
		 * @param max
		 * @return
		 */
		public static int getNumber(int min, int max) {
			int i = random.nextInt(max - min);
			return min + i;
		}

	}

	public static class BooleanUtils {
		private BooleanUtils() {
		}

		static final String trueValue = "1";
		static final String falseValue = "0";
		static final String zuoKuoHao = "(";
		static final String youKuoHao = ")";

		/**
		 * ַΪtruefalse (true && (true || false) && true)  true
		 * 
		 * @param boolean
		 * @return
		 */
		public static boolean getBooleanValue(String str) {
			verify(str);
			String tempStr = str;
			if (EDcommonUtils.StringUtils.isEmpty(str)) {
				return false;
			}
			str = str.replaceAll(" ", "");
			str = str.replaceAll("true", trueValue);
			str = str.replaceAll("false", falseValue);
			if (str.indexOf("&&") != -1 || str.indexOf("||") != -1) {
				if (str.indexOf(zuoKuoHao) != 0) {
					str = zuoKuoHao + str + youKuoHao;
				}
			}
			int zuoCount = EDcommonUtils.StringUtils.findStrCount(str, zuoKuoHao);
			int youCount = EDcommonUtils.StringUtils.findStrCount(str, youKuoHao);
			if (zuoCount != youCount) {
				throw new RuntimeException("BooleanַϹʽ淶,ϸ鹫ʽ ϵͳʾ鹫ʽǷȷ" + tempStr + "");
			}
			for (int i = 1, j = zuoCount; i <= youCount; i++, j--) {
				String s1 = EDcommonUtils.StringUtils.findBetween(str, zuoKuoHao, j, youKuoHao, EDcommonUtils.StringUtils.getRightIndex(str, zuoKuoHao, j, youKuoHao));
				String s2 = convert(s1);
				while (s2.length() != 1) {
					s2 = convert(s1);
					s1 = s2;
					if (s2.length() != 1 && s2.indexOf("&&") == -1 && s2.indexOf("||") == -1) {
						throw new RuntimeException("booleanʽʱִ,ʽвϷַ" + tempStr + "");
					}
				}
				int begin = EDcommonUtils.StringUtils.findSubStrIndex(str, zuoKuoHao, j);
				int end = EDcommonUtils.StringUtils.findSubStrIndex(str, youKuoHao, EDcommonUtils.StringUtils.getRightIndex(str, zuoKuoHao, j, youKuoHao));
				StringBuffer buffer = new StringBuffer(EDcommonUtils.StringUtils.truncationString(str, begin, end));
				buffer.insert(begin, s2);
				str = buffer.toString();
			}
			return trueValue.equals(str.trim());
		}

		private static void verify(String booleanStr) {
			if (booleanStr != null) {
				booleanStr = booleanStr.trim();
				booleanStr = EDcommonUtils.StringUtils.replaceAll(booleanStr, "(", "");
				booleanStr = EDcommonUtils.StringUtils.replaceAll(booleanStr, ")", "");
				if (booleanStr.endsWith("||") || booleanStr.endsWith("&&") || booleanStr.startsWith("||") || booleanStr.startsWith("&&")) {
					throw new RuntimeException("ʽϷformatString : " + booleanStr);
				}
			}
		}

		private static String convert(String str) {
			str = str.replaceAll("1\\|\\|1", trueValue);
			str = str.replaceAll("1\\|\\|0", trueValue);
			str = str.replaceAll("0\\|\\|1", trueValue);
			str = str.replaceAll("0\\|\\|0", falseValue);
			str = str.replaceAll("1\\&\\&1", trueValue);
			str = str.replaceAll("1\\&\\&0", falseValue);
			str = str.replaceAll("0\\&\\&1", falseValue);
			str = str.replaceAll("0\\&\\&0", falseValue);
			if (!verifyConvertString(str)) {
				throw new RuntimeException("Booleanʽִ,ȱʧ߼");
			}
			return str;
		}

		/**
		 * ֤ʽ,ָ&&||ĸһ
		 * 
		 * @param str
		 * @return
		 */
		private static boolean verifyConvertString(String str) {
			String strTemp = EDcommonUtils.StringUtils.replaceAll(str, "(", "");
			strTemp = EDcommonUtils.StringUtils.replaceAll(strTemp, ")", "");
			strTemp = EDcommonUtils.StringUtils.replaceAll(strTemp, "&&", "XXX");
			strTemp = EDcommonUtils.StringUtils.replaceAll(strTemp, "\\|\\|", "XXX");
			String[] strTemps = strTemp.split("XXX");
			int countXXX = EDcommonUtils.StringUtils.findStrCount(strTemp, "XXX");
			int countNumber = 0;
			for (int i = 0; i < strTemps.length; i++) {
				String s1 = strTemps[i];
				if (EDcommonUtils.StringUtils.isEmpty(s1)) {
					continue;
				}
				countNumber++;
			}
			if (strTemps != null && countNumber != countXXX + 1) {
				return false;
			}
			return true;
		}

	}

	public static class IntegerUtils {
		private IntegerUtils() {
		}

		/**
		 * 
		 */
		public static final int DESC = 0;
		/**
		 * 
		 */
		public static final int ASC = 1;

		/**
		 * 
		 * 
		 * @param number
		 * @param sortType
		 *            ʽ
		 */
		public static void sort(int[] number, int sortType) {
			boolean flag = true;
			for (int i = 0; i < number.length - 1 && flag; i++) {
				flag = false;
				for (int j = 0; j < number.length - i - 1; j++) {
					if (ASC == sortType) {
						if (number[j + 1] < number[j]) {
							swap(number, j + 1, j);
							flag = true;
						}
					} else if (DESC == sortType) {
						if (number[j + 1] > number[j]) {
							swap(number, j + 1, j);
							flag = true;
						}
					}
				}
			}
		}

		static void swap(int[] number, int i, int j) {
			int t;
			t = number[i];
			number[i] = number[j];
			number[j] = t;
		}

		/**
		 * ȡֵ
		 * 
		 * @param tnis
		 * @return
		 */
		public static int max(int[] tnis) {
			int temp = 0;
			if (tnis != null) {
				for (int i = 0; i < tnis.length; i++) {
					if (temp < tnis[i]) {
						temp = tnis[i];
					}
				}
			}
			return temp;
		}

		/**
		 * ȡСֵ
		 * 
		 * @param tnis
		 * @return
		 */
		public static int min(int[] tnis) {
			int temp = 0;
			if (tnis != null) {
				for (int i = 0; i < tnis.length; i++) {
					if (temp > tnis[i]) {
						temp = tnis[i];
					}
				}
			}
			return temp;
		}

	}

}
