package com.kingdee.eas.lifetime.util.edlogger.impl;

import java.util.Calendar;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

import org.apache.log4j.Logger;

import com.kingdee.eas.lifetime.util.edlogger.IEDlogger;
import com.kingdee.util.DateTimeUtils;

/**
 * @author lifeTime
 * 
 */
public abstract class AbstractEDlogger implements IEDlogger {
	Map loggerMsgs;
	Logger logger = Logger.getLogger(AbstractEDlogger.class);
	Object lastMsgKey;
	/**
	 * Ƿۻģʽ
	 */
	boolean isAdd = false;
	private static final String defaultFormatStr = "yyyy-MM-dd hh:mm:ss SSSS";

	public AbstractEDlogger() {
		loggerMsgs = new LinkedHashMap();
	}

	public AbstractEDlogger(Map msgsMap) {
		loggerMsgs = msgsMap;
	}

	public boolean isAddModel() {
		return isAdd;
	}

	public void addMsg(Object key, Object msg) {
		if (!isAddModel()) {
			loggerMsgs.clear();
		}
		if (key == null) {
			StringBuffer keyTemp = new StringBuffer();
			keyTemp.append(getLoggerClass() == null ? "" : getLoggerClass().getName());
			keyTemp.append(DateTimeUtils.format(Calendar.getInstance().getTime(), defaultFormatStr));
			lastMsgKey = keyTemp;
		} else
			lastMsgKey = key;

		loggerMsgs.put(lastMsgKey, msg);
	}

	protected void addMsg(Object msg) {
		addMsg(null, msg);
	}

	public void logger(Object msg) {
		addMsg(msg);
		showMsg(null);
	}

	/**
	 * Ϊlog4jlogger.info();
	 * 
	 * @param msg
	 */
	public void info(Object msg) {
		logger(msg);
	}

	protected void showMsg(Object key) {
		if (key == null)
			logger.info(loggerMsgs.get(lastMsgKey));
		else
			logger.info(loggerMsgs.get(key));
	}

	protected void showMsg() {
		showMsg(null);
	}

	public Map getAllLogger() {
		return loggerMsgs;
	}

	public void clearMsg() {
		loggerMsgs.clear();
	}

	public String toString() {
		StringBuffer sb = new StringBuffer();
		for (Iterator it = loggerMsgs.keySet().iterator(); it.hasNext();) {
			sb.append(loggerMsgs.get(it.next()).toString());
		}
		return sb.toString();
	}

}
