package com.kingdee.eas.lifetime.util.edtest;

import java.awt.Rectangle;
import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;

import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.lifetime.util.edcommonutils.EDcommonUtils;
import com.kingdee.eas.framework.client.CoreUI;

/**
 * @author lifeTime
 * 
 */
public abstract class EDtestUI extends CoreUI {

	private static final long serialVersionUID = 1L;
	private static final Logger logger = CoreUIObject.getLogger(EDtestUI.class);
	protected com.kingdee.bos.ctrl.kdf.table.KDTable testTable;

	public EDtestUI() throws Exception {
		super();
		init();
	}

	private void init() {
		this.testTable = new com.kingdee.bos.ctrl.kdf.table.KDTable();
		this.testTable.setName("testTable");
		testTable.checkParsed();
	}

	protected void initColumns() {
		if (getColumnKeys() == null || getColumnKeys().length < 1) {
			logger.info("ʼΪգ");
			return;
		}
		for (int i = 0; i < getColumnKeys().length; i++) {
			IColumn column = testTable.addColumn();
			column.setKey(getColumnKeys()[i]);
		}
	}

	protected void initHeads() {
		if (getHeads() == null || getHeads().length < 1) {
			logger.info("ʼͷΪգ");
			return;
		}
		IRow headRow = testTable.addHeadRow();
		for (int i = 0; i < getHeads().length; i++) {
			if (headRow.getCell(i) == null) {
				return;
			}
			headRow.getCell(i).setValue(getHeads()[i]);
		}
	}

	public void initUIContentLayout() {
		this.setBounds(new Rectangle(10, 10, 700, 400));
		this.setLayout(new KDLayout());
		this.putClientProperty("OriginalBounds", new Rectangle(10, 10, 700, 400));
		testTable.setBounds(new Rectangle(12, 12, 680, 377));
		this.add(testTable, new KDLayout.Constraints(12, 12, 680, 377, KDLayout.Constraints.ANCHOR_TOP | KDLayout.Constraints.ANCHOR_BOTTOM
				| KDLayout.Constraints.ANCHOR_LEFT | KDLayout.Constraints.ANCHOR_RIGHT));
	}

	public void initUIMenuBarLayout() {
		menuBar.add(menuFile);
		menuBar.add(menuTool);
		menuBar.add(menuHelp);
		menuFile.add(menuItemPageSetup);
		menuFile.add(kDSeparator1);
		menuFile.add(menuItemExitCurrent);
		menuTool.add(menuItemSendMessage);
		menuTool.add(menuItemCalculator);
		menuHelp.add(menuItemHelp);
		menuHelp.add(kDSeparator12);
		menuHelp.add(menuItemRegPro);
		menuHelp.add(menuItemPersonalSite);
		menuHelp.add(helpseparatorDiv);
		menuHelp.add(menuitemProductval);
		menuHelp.add(kDSeparatorProduct);
		menuHelp.add(menuItemAbout);

	}

	public void initUIToolBarLayout() {
		this.toolBar.add(btnPageSetup);
	}

	public void setDataObject(IObjectValue dataObject) {
		IObjectValue ov = dataObject;
		super.setDataObject(ov);
	}

	public IMetaDataPK getMetaDataPK() {
		return new MetaDataPK("com.kingdee.eas.lifetime.util.edtest", "EDtestUI");
	}

	public void onLoad() throws Exception {
		super.onLoad();
		initColumns();
		initHeads();
		fillTable(getRecords());
	}

	protected void fillTable(List records) {
		if (EDcommonUtils.ListUtil.isEmpty(records)) {
			logger.info("########ݼΪգʧܣ");
			return;
		} else if (getColumnKeys() == null || getColumnKeys().length < 1) {
			logger.info("########ʼΪգֹ");
			return;
		}
		if (records.get(0) instanceof List) {
			fillTableWithList(records);
		} else if (records.get(0) instanceof Map) {
			fillTableWithMap(records);
		} else {
			logger.info("########δҵݷʽ");
		}
	}

	/**
	 * listʽtable
	 */
	protected void fillTableWithList(List records) {
		for (int i = records.size(), j = 0; j < i; j++) {
			Object record = records.get(j);
			if (record instanceof List) {
				List list = (List) record;
				IRow row = testTable.addRow();
				for (int k = 0, x = list.size(); k < x; k++) {
					row.getCell(k).setValue(list.get(k));
				}
			}
		}
	}

	/**
	 * Mapʽtable
	 */
	protected void fillTableWithMap(List records) {
		for (int i = records.size(), j = 0; j < i; j++) {
			Object record = records.get(j);
			if (record instanceof Map) {
				Map m = (Map) record;
				IRow row = testTable.addRow();
				for (int k = 0, x = getColumnKeys().length; k < x; k++) {
					String key = getColumnKeys()[k];
					if (m.containsKey(key)) {
						row.getCell(key).setValue(m.get(key));
					}
				}
			}
		}
	}

	public String[] getColumnKeys() {
		Object obj = getUIContext().get(IEDTest.keys);
		if (obj != null && obj instanceof String[]) {
			String[] temp = (String[]) obj;
			return temp;
		}
		return null;
	}

	public String[] getHeads() {
		Object obj = getUIContext().get(IEDTest.heads);
		if (obj != null && obj instanceof String[]) {
			String[] temp = (String[]) obj;
			return temp;
		}
		return null;
	}

	public List getRecords() {
		Object obj = getUIContext().get(IEDTest.records);
		if (obj != null && obj instanceof List) {
			List temp = (List) obj;
			return temp;
		}
		return null;
	}

}
