package com.kingdee.eas.lifetime.util.fileOperate;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;

import javax.swing.filechooser.FileSystemView;

import com.kingdee.bos.ctrl.common.util.FileUtil;

/**
 * ļ
 * 
 * @author lifeTime
 * 
 */
public class FileOperateUtils {
	public FileOperateUtils() {
	}

	/**
	 * ļ
	 * 
	 * @param filePath
	 * @return
	 * @throws IOException
	 */
	public static final File createFile(String filePath) throws IOException {
		return FileUtil.createFile(filePath);
	}

	/**
	 * ɾļ
	 * 
	 * @param filePath
	 * @return
	 */
	public static File deleteFile(String filePath) {
		return FileUtil.deleteFile(filePath);
	}

	/**
	 * ļ
	 * 
	 * @param filePath
	 * @return
	 */
	public static final String getFileType(String filePath) {
		File file = new File(filePath);
		return FileSystemView.getFileSystemView().getSystemTypeDescription(file);
	}

	/**
	 * ļĿ¼Ƿ
	 * 
	 * @param dirPath
	 * @return
	 */
	public static final boolean exists(String dirPath) {
		File file = new File(dirPath == null ? "" : dirPath);
		return file.exists();
	}

	/**
	 * Ŀ¼
	 * 
	 * @param folderPath
	 * @return
	 */
	public static final boolean createFolder(String folderPath) {
		File file = new File(folderPath == null ? "" : folderPath);
		if (!file.exists()) {
			return file.mkdirs();
		}
		return true;
	}

	/**
	 * ȡļ
	 * 
	 * @param filePath
	 * @return
	 */
	public static final byte[] readFile(String filePath) {
		return FileUtil.readFile(filePath);
	}

	/**
	 * ļȡbyte鼯ϷأΪļ
	 * 
	 * @param filePath
	 * @param stepSize
	 *            ÿbyteݴСҲһζȡֽ
	 * @return
	 */
	public static final List readFileToByteArray(String filePath, int stepSize) {
		RandomAccessFile rfile = null;
		try {
			rfile = new RandomAccessFile(filePath, "r");
			int arraySize = Integer.parseInt("" + (rfile.length() % stepSize == 0 ? rfile.length() / stepSize : rfile.length() / stepSize + 1));
			ArrayList bytes = new ArrayList(arraySize);
			byte[] step = new byte[stepSize];
			while (rfile.read(step, 0, step.length) != -1) {
				bytes.add(step);
			}
			return bytes;
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (NumberFormatException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		} finally {
			if (rfile != null) {
				try {
					rfile.close();
				} catch (IOException e) {
					rfile = null;
					e.printStackTrace();
				}
			}
		}
		return null;
	}

	/**
	 * ļĹر
	 * 
	 * @param stream
	 */
	public static void closeStream(OutputStream stream) {
		if (stream != null) {
			try {
				stream.close();
			} catch (IOException e) {
				e.printStackTrace();
				stream = null;
			}
		}
	}

	/**
	 * дļ,ִ֧ļ
	 * 
	 * @param filePath
	 * @param bytes
	 *            ŵΪbyte[]
	 */
	public static final void writeByteArrayToFile(String filePath, List bytes) {
		FileOutputStream fos = null;
		try {
			fos = new FileOutputStream(filePath);
			for (int i = 0, k = bytes.size(); i < k; i++) {
				Object obj = bytes.get(i);
				if (obj != null && obj instanceof byte[]) {
					byte[] bbs = (byte[]) obj;
					fos.write(bbs);
				}
			}
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		} finally {
			closeStream(fos);
		}
	}

	/**
	 * дļ
	 * 
	 * @param filePath
	 * @param data
	 * @throws FileNotFoundException
	 * @throws IOException
	 */
	public static final void writeFile(String filePath, byte data[]) throws FileNotFoundException, IOException {
		FileUtil.writeFile(filePath, data);
	}

	/**
	 * ֽͨļСͨ
	 * 
	 * @param size
	 * @return
	 */
	public static final String byteCountToDisplaySize(long size) {
		StringBuffer displaySize = new StringBuffer();
		if (size < 1024L && size >= 0L) {
			return String.valueOf(size) + "B";
		} else if (size < 0) {
			return "δ֪С";
		}
		if (size / 1073741824L > 0L) {
			displaySize.append(String.valueOf(size / 1073741824L) + "GB ");
			size = size % 1073741824L;
		}
		if (size / 1048576L > 0L) {
			displaySize.append(String.valueOf(size / 1048576L) + "MB ");
			size = size % 1048576L;
		}
		if (size / 1024L > 0L) {
			displaySize.append(String.valueOf(size / 1024L) + "KB ");
			size = size % 1024L;
		}
		return displaySize.toString();
	}

	/**
	 * ļֽ
	 * 
	 * @param filePath
	 * @return
	 */
	public static final long getFileSize(String filePath) {
		File file = new File(filePath);
		return getFileSize(file);
	}

	/**
	 * ļֽ
	 * 
	 * @param file
	 * @return
	 */
	public static final long getFileSize(File file) {
		FileInputStream inputStream;
		try {
			inputStream = new FileInputStream(file);
			return inputStream.available();
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		return -1;
	}

	/**
	 * Ŀ¼ĴС
	 * 
	 * @param directory
	 * @return
	 */
	public static final long sizeOfDirectory(File directory) {
		if (!directory.exists()) {
			String message = directory + " does not exist";
			throw new IllegalArgumentException(message);
		}
		if (!directory.isDirectory()) {
			String message = directory + " is not a directory";
			throw new IllegalArgumentException(message);
		}
		long size = 0L;
		File files[] = directory.listFiles();
		if (files == null)
			return 0L;
		for (int i = 0; i < files.length; i++) {
			File file = files[i];
			if (file.isDirectory())
				size += sizeOfDirectory(file);
			else
				size += file.length();
		}

		return size;
	}

	/**
	 * A׷ļʹRandomAccessFile
	 * 
	 * @param fileName
	 *            ļ
	 * @param content
	 *            ׷ӵ
	 */
	public static void appendMethodA(String fileName, String content) {
		try {
			RandomAccessFile randomFile = new RandomAccessFile(fileName, "rw");
			long fileLength = randomFile.length();
			randomFile.seek(fileLength);
			randomFile.writeBytes(content);
			randomFile.close();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	/**
	 * B׷ļʹFileWriter
	 * 
	 * @param fileName
	 * @param content
	 */
	public static void appendMethodB(String fileName, String content) {
		try {
			FileWriter writer = new FileWriter(fileName, true);
			writer.write(content);
			writer.close();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	/**
	 * ÿõĴ̿ռ
	 * 
	 * @param dirName
	 *            C: D: e: f: Ҫ(/)
	 * @return
	 */
	public static long getFreeDiskSpace(String dirName) {
		try {
			// String os = System.getProperty("os.name");
			String command = "cmd.exe /c dir " + dirName;
			Runtime runtime = Runtime.getRuntime();
			Process process = null;
			process = runtime.exec(command);
			if (process == null) {
				return -1;
			}
			BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
			String line;
			String freeSpace = null;
			while ((line = in.readLine()) != null) {
				freeSpace = line;
			}
			if (freeSpace == null) {
				return -1;
			}
			process.destroy();
			freeSpace = freeSpace.trim();
			freeSpace = freeSpace.replaceAll("\\.", "");
			freeSpace = freeSpace.replaceAll(",", "");
			String[] items = freeSpace.split(" ");
			int index = 1;
			while (index < items.length) {
				try {
					long bytes = Long.parseLong(items[index++]);
					return bytes;
				} catch (NumberFormatException nfe) {
				}
			}
			return -1;
		} catch (Exception exception) {
			return -1;
		}
	}

}
