package com.kingdee.eas.lifetime.util.jcomponentutil;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

import org.apache.log4j.Logger;

import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.eas.base.uiframe.client.NewMainFrame;

/**
 * @author lifeTime
 *
 */
public class EDjComponentUtil {
	private static Logger logger = Logger.getLogger(EDjComponentUtil.class);

	public static Frame getCurrMainFrame(Component component) {
		if (component == null)
			throw new IllegalArgumentException("Argument component is null");
		Component window = SwingUtilities.getRoot(component);
		if (window instanceof Applet)
			return JOptionPane.getFrameForComponent(window);
		if (window instanceof Frame)
			return (Frame) window;
		if (window instanceof Dialog)
			return getCurrMainFrame(((Component) (((Dialog) window).getOwner())));
		if (window instanceof NewMainFrame)
			return (NewMainFrame) window;
		if (window instanceof IUIWindow) {
			IUIWindow uiWindow = (IUIWindow) window;
			IUIObject ui = uiWindow.getUIObject();
			Map context = ui.getUIContext();
			Component c = (Component) context.get("OwnerWindow");
			if (c != null)
				return getCurrMainFrame(c);
		}
		throw new IllegalArgumentException("Component is not associated mainframe");
	}

	/**
	 * Ƴؼϵkey¼
	 * 
	 * @param component
	 */
	public static void removeAllKeyListeners(JComponent component) {
		KeyListener[] keyListeners = component.getKeyListeners();
		for (int i = 0; i < keyListeners.length; i++) {
			KeyListener listener = keyListeners[i];
			component.removeKeyListener(listener);
		}
	}

	/**
	 * Ƴؼϵ¼
	 * @param component
	 */
	public static void removeClickListeners(JComponent component) {
		MouseListener[] keyListeners = component.getMouseListeners();
		for (int i = 0; i < keyListeners.length; i++) {
			MouseListener listener = keyListeners[i];
			component.removeMouseListener(listener);
		}
	}

	/**
	 * ݿؼҴ϶ӦĿؼ
	 * 
	 * @param name
	 * @param window
	 * @return
	 */
	public static JComponent getComponentByName(String name, JComponent window) {
		if (window == null) {
			logger.error("岻Ϊգ");
			return null;
		} else if (name == null) {
			logger.error("岻Ϊգ");
			return null;
		}
		List list = getAllComponents(window);
		for (int i = list.size(); --i >= 0;) {
			JComponent comp = (JComponent) list.get(i);
			if (name.equals(comp.getName())) {
				return comp;
			}
		}
		return null;
	}

	/**
	 * ÿؼϵӿؼ
	 * 
	 * @param component
	 * @return
	 */
	public static List getAllComponents(JComponent component) {
		ArrayList list = new ArrayList();
		return getAllComponents(component, list);
	}

	private static List getAllComponents(JComponent component, List list) {
		Component[] components = component.getComponents();
		if (components != null && components.length != 0) {
			for (int i = 0; i < components.length; i++) {
				if (components[i] instanceof JComponent) {
					list.add(components[i]);
					JComponent child = (JComponent) components[i];
					if (child != null && child.getComponents() != null && child.getComponents().length > 0) {
						getAllComponents((JComponent) components[i], list);
					}
				} else {
					logger.info("ؼ" + components[i] + "δ룬ΪJComponent!");
				}
			}
		}
		return list;
	}

}
