package com.kingdee.eas.lifetime.util.kdcontrolutils;

import java.util.Iterator;
import java.util.List;

import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox;
import com.kingdee.bos.ctrl.swing.KDMultiLangBox;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.util.LocaleUtils;

/**
 * ԶԿĲ
 * 
 * @author lifeTime
 * 
 */
public class EDkdMultiLangBoxUtil {

	private EDkdMultiLangBoxUtil() {
	}

	/**
	 * @param multiLangBox
	 * @param value
	 */
	public static void setValue(KDMultiLangBox multiLangBox, Object value) {
		List list = KDBizMultiLangBox.getLanguageList();
		Iterator iterator = list.iterator();
		LanguageInfo languageinfo = null;
		while (iterator.hasNext()) {
			LanguageInfo languageinfo1 = (LanguageInfo) iterator.next();
			multiLangBox.addItem(languageinfo1, value);
			if (LocaleUtils.getDefaultLocale().equals(languageinfo1.getLocale()))
				languageinfo = languageinfo1;
		}
		if (languageinfo != null)
			multiLangBox.setSelectedLanguage(languageinfo);
	}

	/**
	 * @param multiLangBox
	 * @return
	 */
	public static Object getValue(KDMultiLangBox multiLangBox) {
		List list = KDBizMultiLangBox.getLanguageList();
		Iterator iterator = list.iterator();
		while (iterator.hasNext()) {
			LanguageInfo info = (LanguageInfo) iterator.next();
			if (LocaleUtils.getDefaultLocale().equals(info.getLocale()))
				return info;
		}
		return null;
	}

	/**
	 * ضֵ
	 * 
	 * @param kdmultilangbox
	 * @param iobjectvalue
	 * @param s
	 */
	public static void loadMultiLangFields(KDMultiLangBox kdmultilangbox, IObjectValue iobjectvalue, String s) {
		List list = KDBizMultiLangBox.getLanguageList();
		Iterator iterator = list.iterator();
		LanguageInfo languageinfo = null;
		while (iterator.hasNext()) {
			LanguageInfo languageinfo1 = (LanguageInfo) iterator.next();
			kdmultilangbox.addItem(languageinfo1, iobjectvalue.get(s, languageinfo1.getLocale()));
			if (LocaleUtils.getDefaultLocale().equals(languageinfo1.getLocale()))
				languageinfo = languageinfo1;
		}
		if (languageinfo != null)
			kdmultilangbox.setSelectedLanguage(languageinfo);
	}

	/**
	 * Կֵ洢ֵ
	 * 
	 * @param kdmultilangbox
	 * @param iobjectvalue
	 * @param s
	 */
	public static void storeMultiLangFields(KDMultiLangBox kdmultilangbox, IObjectValue iobjectvalue, String s) {
		List list = KDBizMultiLangBox.getLanguageList();
		Iterator iterator = list.iterator();
		LanguageInfo languageinfo = null;
		while (iterator.hasNext()) {
			LanguageInfo languageinfo1 = (LanguageInfo) iterator.next();
			Object obj1 = kdmultilangbox.getItemBy(languageinfo1).getData();
			if (obj1 != null && obj1.equals(""))
				obj1 = null;
			iobjectvalue.put(s, obj1, languageinfo1.getLocale());
			if (LocaleUtils.getDefaultLocale().equals(languageinfo1.getLocale()))
				languageinfo = languageinfo1;
		}
		Object obj = kdmultilangbox.getItemBy(languageinfo).getData();
		if (obj != null && obj.equals(""))
			obj = null;
		iobjectvalue.put(s, obj);
	}

}
