package com.kingdee.eas.lifetime.util.kdcontrolutils;

import java.awt.Color;
import java.awt.event.KeyListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.swing.JCheckBox;

import org.apache.log4j.Logger;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.BeforeActionEvent;
import com.kingdee.bos.ctrl.kdf.table.event.BeforeActionListener;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDNumberTextField;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDTimePicker;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.eas.EDxbangUtil.DButil.EDdbUtil;
import com.kingdee.eas.EDxbangUtil.edcommonutils.EDcommonUtils;
import com.kingdee.eas.EDxbangUtil.edcommonutils.EDconstantVar;
import com.kingdee.eas.lifetime.util.EDxbangUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;

/**
 * KDTableһЩ
 * 
 * @author lifeTime
 * 
 */
public class EDkdTableUtil {

	private static Logger logger = Logger.getLogger(EDkdTableUtil.class);

	private EDkdTableUtil() {
	}

	/**
	 * tableʽ
	 * 
	 * @author lifeTime 2009-10-20 02:33:53
	 * 
	 */
	public static class Formator {
		private Formator() {
		}

		/**
		 * ʽΪʾĬϷʽ(yyyy-MM-dd)
		 * 
		 * @param table
		 * @param colKey
		 */
		public static void formatColumnDate(KDTable table, String colKey) {
			formatColumn(table, colKey, "%{yyyy-MM-dd}t");
		}

		/**
		 * ʽΪʾĬϷʽ(yyyy-MM-dd)
		 * 
		 * @param table
		 * @param colIndex
		 */
		public static void formatColumnDate(KDTable table, int colIndex) {
			formatColumn(table, colIndex, "%{yyyy-MM-dd}t");
		}

		/**
		 * ʽΪʾĬϷʽ(#,###.##)
		 * 
		 * @param table
		 * @param colIndex
		 */
		public static void formatColumnNumber(KDTable table, int colIndex) {
			formatColumn(table, colIndex, "%r-{#,###.##}15f");
		}

		/**
		 * ʽΪʾĬϷʽ(#,###.##)
		 * 
		 * @param table
		 * @param colIndex
		 */
		public static void formatColumnNumber(KDTable table, String colKey) {
			formatColumn(table, colKey, "%r-{#,###.##}15f");
		}

		/**
		 * ʽԪΪʾĬϷʽ(yyyy-MM-dd)
		 * 
		 * @param table
		 * @param colIndex
		 */
		public static void formatCellDate(KDTable table, int rowIndex, int colIndex) {
			formatColumn(table, colIndex, "%{yyyy-MM-dd}t");
		}

		/**
		 * ʽԪΪʾĬϷʽ(yyyy-MM-dd)
		 * 
		 * @param table
		 * @param colIndex
		 */
		public static void formatCellDate(KDTable table, int rowIndex, String colKey) {
			formatColumn(table, colKey, "%{yyyy-MM-dd}t");
		}

		/**
		 * ʽԪΪʾĬϷʽ(#,###.##)
		 * 
		 * @param table
		 * @param colIndex
		 */
		public static void formatCellNumber(KDTable table, int rowIndex, int colIndex) {
			formatColumn(table, colIndex, "%r-{#,###.##}15f");
		}

		/**
		 * ʽԪΪʾĬϷʽ(#,###.##)
		 * 
		 * @param table
		 * @param colIndex
		 */
		public static void formatCellNumber(KDTable table, int rowIndex, String colKey) {
			formatColumn(table, colKey, "%r-{#,###.##}15f");
		}

		public static void formatColumn(KDTable table, String colKey, String formulaStr) {
			table.getColumn(colKey).getStyleAttributes().setNumberFormat(formulaStr);
		}

		public static void formatColumn(KDTable table, int colIndex, String formulaStr) {
			table.getColumn(colIndex).getStyleAttributes().setNumberFormat(formulaStr);
		}

		public static void formatCell(KDTable table, int rowIndex, String colKey, String formulaStr) {
			table.getCell(rowIndex, colKey).getStyleAttributes().setNumberFormat(formulaStr);
		}

		public static void formatCell(KDTable table, int rowIndex, int colIndex, String formulaStr) {
			table.getCell(rowIndex, colIndex).getStyleAttributes().setNumberFormat(formulaStr);
		}

	}

	/**
	 * KDTable󶨿ؼ
	 * 
	 * @author lifeTime
	 * 
	 */
	public static class Binding {
		private Binding() {
		}

		/**
		 * ĳаΪKDPromptBox
		 * 
		 * @param table
		 * @param colName
		 * @return
		 */
		public static KDPromptBox bindPromptBox(KDTable table, String colName) {
			KDPromptBox biz = new KDPromptBox();
			KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor(biz);
			table.getColumn(colName).setEditor(cellEditor);
			return biz;
		}

		/**
		 * ĳаΪKDPromptBox
		 * 
		 * @param table
		 * @param colIndex
		 * @return
		 */
		public static KDPromptBox bindPromptBox(KDTable table, int colIndex) {
			KDPromptBox biz = new KDPromptBox();
			KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor(biz);
			table.getColumn(colIndex).setEditor(cellEditor);
			return biz;
		}

		/**
		 * ĳԪΪKDPromptBox
		 * 
		 * @param table
		 * @param rowIndex
		 * @param colName
		 * @return
		 */
		public static KDPromptBox bindPromptBox(KDTable table, int rowIndex, String colName) {
			KDPromptBox biz = new KDPromptBox();
			KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor(biz);
			table.getCell(rowIndex, colName).setEditor(cellEditor);
			return biz;
		}

		/**
		 * ĳԪΪKDPromptBox
		 * 
		 * @param table
		 * @param rowIndex
		 * @param colIndex
		 * @return
		 */
		public static KDPromptBox bindPromptBox(KDTable table, int rowIndex, int colIndex) {
			KDPromptBox biz = new KDPromptBox();
			KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor(biz);
			table.getCell(rowIndex, colIndex).setEditor(cellEditor);
			return biz;
		}

		/**
		 * Ϊcellڿؼ
		 * 
		 * @param table
		 * @param rowIndex
		 * @param colName
		 * @return
		 */
		public static KDDatePicker bindDatePicker(KDTable table, int rowIndex, String colName) {
			KDDatePicker datePicker = new KDDatePicker();
			KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor(datePicker);
			table.getCell(rowIndex, colName).setEditor(cellEditor);
			return datePicker;
		}

		/**
		 * Ϊcellʱؼ
		 * 
		 * @param table
		 * @param rowIndex
		 * @param colName
		 * @return
		 */
		public static KDTimePicker bindTimePicker(KDTable table, int rowIndex, String colName) {
			KDTimePicker datePicker = new KDTimePicker();
			KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor(datePicker);
			table.getCell(rowIndex, colName).setEditor(cellEditor);
			return datePicker;
		}

		/**
		 * Ϊtableϵĳһаб
		 * 
		 * @param table
		 * @param colIndex
		 * @return
		 */
		public static KDComboBox bindColumnComboBox(KDTable table, int colIndex) {
			KDComboBox box = new KDComboBox();
			KDTDefaultCellEditor seqState = new KDTDefaultCellEditor(box);
			table.getColumn(colIndex).setEditor(seqState);
			return box;
		}

		/**
		 * Ϊtableϵĳһаб
		 * 
		 * @param table
		 * @param colIndex
		 * @return
		 */
		public static KDComboBox bindColumnComboBox(KDTable table, String colName) {
			KDComboBox box = new KDComboBox();
			KDTDefaultCellEditor seqState = new KDTDefaultCellEditor(box);
			table.getColumn(colName).setEditor(seqState);
			return box;
		}

		/**
		 * ΪtableϵĳһԪб
		 * 
		 * @param table
		 * @param colIndex
		 * @return
		 */
		public static KDComboBox bindCellComboBox(KDTable table, int rowIndex, int colIndex) {
			KDComboBox box = new KDComboBox();
			KDTDefaultCellEditor seqState = new KDTDefaultCellEditor(box);
			table.getCell(rowIndex, colIndex).setEditor(seqState);
			return box;
		}

		/**
		 * ΪtableϵĳһԪб
		 * 
		 * @param table
		 * @param colIndex
		 * @return
		 */
		public static KDComboBox bindCellComboBox(KDTable table, int rowIndex, String colName) {
			KDComboBox box = new KDComboBox();
			KDTDefaultCellEditor seqState = new KDTDefaultCellEditor(box);
			table.getCell(rowIndex, colName).setEditor(seqState);
			return box;
		}

		/**
		 * ΪtableϵĳһԪ󶨸ѡ
		 * 
		 * @param table
		 * @param colIndex
		 * @return
		 */
		public static KDCheckBox bindCellCheckBox(KDTable table, int rowIndex, String colName) {
			KDCheckBox box = new KDCheckBox();
			KDTDefaultCellEditor seqState = new KDTDefaultCellEditor(box);
			table.getCell(rowIndex, colName).setEditor(seqState);
			return box;
		}

		/**
		 * ΪtableϵĳһԪ󶨸ѡ
		 * 
		 * @param table
		 * @param colIndex
		 * @return
		 */
		public static KDCheckBox bindCellCheckBox(KDTable table, int rowIndex, int colIndex) {
			KDCheckBox box = new KDCheckBox();
			KDTDefaultCellEditor seqState = new KDTDefaultCellEditor(box);
			table.getCell(rowIndex, colIndex).setEditor(seqState);
			return box;
		}

		/**
		 * Ϊtableϵĳһа󶨸ѡ
		 * 
		 * @param table
		 * @param colIndex
		 * @return
		 */
		public static KDCheckBox bindColumnCheckBox(KDTable table, int colIndex) {
			KDCheckBox box = new KDCheckBox();
			KDTDefaultCellEditor seqState = new KDTDefaultCellEditor(box);
			table.getColumn(colIndex).setEditor(seqState);
			return box;
		}

		/**
		 * Ϊtableϵĳһа󶨸ѡ
		 * 
		 * @param table
		 * @param colIndex
		 * @return
		 */
		public static KDCheckBox bindColumnCheckBox(KDTable table, String colName) {
			KDCheckBox box = new KDCheckBox();
			KDTDefaultCellEditor seqState = new KDTDefaultCellEditor(box);
			table.getColumn(colName).setEditor(seqState);
			return box;
		}

		/**
		 * Ϊtableϵĳһаıؼ
		 * 
		 * @param table
		 * @param colIndex
		 * @return
		 */
		public static KDNumberTextField bindColumnNumberText(KDTable table, String colName) {
			KDNumberTextField numberText = new KDNumberTextField();
			numberText.setVisible(true);
			numberText.setEditable(true);
			numberText.setHorizontalAlignment(2);
			numberText.setDataType(1);
			numberText.setMaximumNumber(new java.math.BigDecimal("99999999999999.99"));
			numberText.setMinimumNumber(new java.math.BigDecimal("-99999999999999.99"));
			numberText.setPrecision(10);
			KDTDefaultCellEditor seqState = new KDTDefaultCellEditor(numberText);
			table.getColumn(colName).setEditor(seqState);
			return numberText;
		}

		/**
		 * Ϊtableϵĳһаıؼ
		 * 
		 * @param table
		 * @param colIndex
		 * @return
		 */
		public static KDNumberTextField bindColumnNumberText(KDTable table, int colIndex) {
			KDNumberTextField numberText = new KDNumberTextField();
			numberText.setVisible(true);
			numberText.setEditable(true);
			numberText.setHorizontalAlignment(2);
			numberText.setDataType(1);
			numberText.setMaximumNumber(new java.math.BigDecimal("99999999999999.99"));
			numberText.setMinimumNumber(new java.math.BigDecimal("-99999999999999.99"));
			numberText.setPrecision(10);
			KDTDefaultCellEditor seqState = new KDTDefaultCellEditor(numberText);
			table.getColumn(colIndex).setEditor(seqState);
			return numberText;
		}

		/**
		 * ΪtableϵĳһԪıؼ
		 * 
		 * @param table
		 * @param colIndex
		 * @return
		 */
		public static KDNumberTextField bindCellNumberText(KDTable table, int rowIndex, String colName) {
			KDNumberTextField numberText = new KDNumberTextField();
			numberText.setVisible(true);
			numberText.setEditable(true);
			numberText.setHorizontalAlignment(2);
			numberText.setDataType(1);
			numberText.setMaximumNumber(new Long(999999999));
			numberText.setMinimumNumber(new Long(-999999999));
			numberText.setPrecision(10);
			KDTDefaultCellEditor seqState = new KDTDefaultCellEditor(numberText);
			table.getCell(rowIndex, colName).setEditor(seqState);
			return numberText;
		}

		/**
		 * ΪtableϵĳһԪıؼ
		 * 
		 * @param table
		 * @param colIndex
		 * @return
		 */
		public static KDNumberTextField bindCellNumberText(KDTable table, int rowIndex, int colIndex) {
			KDNumberTextField numberText = new KDNumberTextField();
			numberText.setVisible(true);
			numberText.setEditable(true);
			numberText.setHorizontalAlignment(2);
			numberText.setDataType(1);
			numberText.setMaximumNumber(new java.math.BigDecimal("99999999999999.99"));
			numberText.setMinimumNumber(new java.math.BigDecimal("-99999999999999.99"));
			numberText.setPrecision(10);
			KDTDefaultCellEditor seqState = new KDTDefaultCellEditor(numberText);
			table.getCell(rowIndex, colIndex).setEditor(seqState);
			return numberText;
		}

		/**
		 * ΪcellKDFormattedTextField
		 * 
		 * @param table
		 * @param rowIndex
		 * @param colName
		 * @return
		 */
		public static KDFormattedTextField bindCellFormattedTextField(KDTable table, int rowIndex, String colName) {
			KDFormattedTextField formatText = new KDFormattedTextField();
			formatText.setVisible(true);
			formatText.setEditable(true);
			formatText.setHorizontalAlignment(2);
			formatText.setDataType(1);
			formatText.setMinimumValue(new java.math.BigDecimal("-999999999999.9999"));
			formatText.setMaximumValue(new java.math.BigDecimal("999999999999.9999"));
			formatText.setPrecision(4);
			KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor(formatText);
			table.getCell(rowIndex, colName).setEditor(cellEditor);
			return formatText;
		}

		/**
		 * ΪcolumnKDFormattedTextField
		 * 
		 * @param table
		 * @param rowIndex
		 * @param colName
		 * @return
		 */
		public static KDFormattedTextField bindColumnFormattedTextField(KDTable table, String colName) {
			KDFormattedTextField formatText = new KDFormattedTextField();
			formatText.setMinimumValue(new java.math.BigDecimal("-999999999999.9999"));
			formatText.setMaximumValue(new java.math.BigDecimal("999999999999.9999"));
			KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor(formatText);
			table.getColumn(colName).setEditor(cellEditor);
			return formatText;
		}

		/**
		 * ΪԪ ıؼKDTextField
		 * 
		 * @param table
		 * @param rowIndex
		 * @param colName
		 * @return
		 */
		public static KDTextField bindTextField(KDTable table, int rowIndex, String colName) {
			KDTextField textField = new KDTextField();
			textField.setName("textField");
			textField.setMaxLength(80);
			KDTDefaultCellEditor seqState = new KDTDefaultCellEditor(textField);
			table.getCell(rowIndex, colName).setEditor(seqState);
			return textField;
		}

		/**
		 * ΪtableϵĳһаF7
		 * 
		 * @param table
		 * @param colIndex
		 * @return
		 */
		public static KDBizPromptBox bindColumnF7(KDTable table, int colIndex, String queryStr) {
			KDBizPromptBox bizPromptBox = new KDBizPromptBox();
			bizPromptBox.setQueryInfo(queryStr);
			KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor(bizPromptBox);
			table.getColumn(colIndex).setEditor(cellEditor);
			return bizPromptBox;
		}

		/**
		 * ΪtableϵĳһаF7
		 * 
		 * @param table
		 * @param colIndex
		 * @return
		 */
		public static KDBizPromptBox bindF7(KDTable table, int colIndex, String queryStr) {
			return bindColumnF7(table, colIndex, queryStr);
		}

		/**
		 * ΪtableϵĳһаF7
		 * 
		 * @param table
		 * @param colIndex
		 * @return
		 */
		public static KDBizPromptBox bindColumnF7(KDTable table, String colName, String queryStr) {
			KDBizPromptBox bizPromptBox = new KDBizPromptBox();
			bizPromptBox.setQueryInfo(queryStr);
			KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor(bizPromptBox);
			table.getColumn(colName).setEditor(cellEditor);
			return bizPromptBox;
		}

		/**
		 * ΪtableϵĳһаF7
		 * 
		 * @param table
		 * @param colIndex
		 * @return
		 */
		public static KDBizPromptBox bindF7(KDTable table, String colName, String queryStr) {
			return bindColumnF7(table, colName, queryStr);
		}

		/**
		 * ΪtableϵĳһԪcomboBox
		 * 
		 * @param table
		 * @param colIndex
		 * @return
		 */
		public static KDBizPromptBox bindCellF7(KDTable table, int rowIndex, String colName, String queryStr) {
			KDBizPromptBox bizPromptBox = new KDBizPromptBox();
			bizPromptBox.setQueryInfo(queryStr);
			KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor(bizPromptBox);
			table.getCell(rowIndex, colName).setEditor(cellEditor);
			return bizPromptBox;
		}

		/**
		 * ΪtableϵĳһԪF7
		 * 
		 * @param colIndex
		 * @return
		 */
		public static KDBizPromptBox bindCellF7(KDTable table, int rowIndex, int colIndex, String queryStr) {
			KDBizPromptBox bizPromptBox = new KDBizPromptBox();
			bizPromptBox.setQueryInfo(queryStr);
			KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor(bizPromptBox);
			table.getCell(rowIndex, colIndex).setEditor(cellEditor);
			return bizPromptBox;
		}

		/**
		 * ĳаΪKDTextArea
		 * 
		 * @param columnName
		 */
		public static KDTextArea bindTextArea(KDTable table, String columnName) {
			KDTextArea area = new KDTextArea();
			KDTDefaultCellEditor allowance = new KDTDefaultCellEditor(area);
			area.setLineWrap(true);
			table.getColumn(columnName).setEditor(allowance);
			return area;
		}

		/**
		 * ĳаΪKDTextArea
		 * 
		 * @param columnName
		 */
		public static KDTextArea bindTextArea(KDTable table, int colIndex) {
			KDTextArea area = new KDTextArea();
			KDTDefaultCellEditor allowance = new KDTDefaultCellEditor(area);
			area.setLineWrap(true);
			table.getColumn(colIndex).setEditor(allowance);
			return area;
		}

		/**
		 * ĳԪΪKDTextArea
		 * 
		 * @param columnName
		 */
		public static KDTextArea bindTextArea(KDTable table, int rowIndex, int colIndex) {
			KDTextArea area = new KDTextArea();
			KDTDefaultCellEditor allowance = new KDTDefaultCellEditor(area);
			area.setLineWrap(true);
			table.getCell(rowIndex, colIndex).setEditor(allowance);
			return area;
		}

		/**
		 * ĳԪΪKDTextArea
		 * 
		 * @param columnName
		 */
		public static KDTextArea bindTextArea(KDTable table, int rowIndex, String columnName) {
			KDTextArea area = new KDTextArea();
			KDTDefaultCellEditor allowance = new KDTDefaultCellEditor(area);
			area.setLineWrap(true);
			table.getCell(rowIndex, columnName).setEditor(allowance);
			return area;
		}

	}

	/**
	 * @author lifeTime
	 * 
	 */
	public static class MergeManager {
		private MergeManager() {
		}

		/**
		 * ں
		 * 
		 * @param table
		 * @param columnName
		 */
		public static void mergeColumn(KDTable table, String columnName) {
			table.checkParsed();
			table.getGroupManager().setGroup(true);
			table.getColumn(columnName).setGroup(true);
			table.getColumn(columnName).setMergeable(true);
		}

		public static void mergeColumn(KDTable table, int columnIndex) {
			table.checkParsed();
			table.getGroupManager().setGroup(true);
			table.getColumn(columnIndex).setGroup(true);
			table.getColumn(columnIndex).setMergeable(true);
		}

		/**
		 * еںϣtableʾĵһΪ׼
		 * 
		 * @param table
		 * @param columnNames
		 */
		public static void mergeColumns(KDTable table, String[] columnNames) {
			table.checkParsed();
			table.getGroupManager().setGroup(true);
			for (int i = 0; i < columnNames.length; i++) {
				table.getColumn(columnNames[i]).setGroup(true);
				table.getColumn(columnNames[i]).setMergeable(true);
			}
		}

		/**
		 * еںϣtableʾĵһΪ׼
		 * 
		 * @param table
		 * @param columnIndexs
		 */
		public static void mergeColumns(KDTable table, int[] columnIndexs) {
			table.checkParsed();
			table.getGroupManager().setGroup(true);
			for (int i = 0; i < columnIndexs.length; i++) {
				table.getColumn(columnIndexs[i]).setGroup(true);
				table.getColumn(columnIndexs[i]).setMergeable(true);
			}
		}

	}

	/**
	 * tableһ(ɾ)
	 * 
	 * @author lifeTime
	 * 
	 */
	public static class OperateManager {
		private OperateManager() {
		}

		/**
		 * ƶtable
		 * 
		 * @param table
		 * @param sourceRowIndexs
		 * @param setp
		 *            ƶĲ
		 */
		public static void moveRows(KDTable table, int[] sourceRowIndexs, int step) {
			table.setRefresh(false);
			int columnCount = table.getColumnCount();
			ArrayList oldList = new ArrayList(sourceRowIndexs.length);
			int[] newRowIndexs = new int[sourceRowIndexs.length];
			for (int i = 0; i < sourceRowIndexs.length; i++) {
				HashMap rowMap = new HashMap();
				for (int j = 0; j < columnCount; j++) {
					String colKey = table.getColumnKey(j);
					rowMap.put(colKey, table.getCell(sourceRowIndexs[i], j).getValue());
				}
				oldList.add(rowMap);
				newRowIndexs[i] = sourceRowIndexs[i] + step;
				table.removeRow(sourceRowIndexs[i]);
			}
			for (int i = 0, rowCount = oldList.size(); i < rowCount; i++) {
				IRow row = table.addRow(newRowIndexs[i]);
				HashMap rowMap = (HashMap) oldList.get(i);
				for (Iterator iterator = rowMap.keySet().iterator(); iterator.hasNext();) {
					String colKey = (String) iterator.next();
					row.getCell(colKey).setValue(rowMap.get(colKey));
				}
			}

			for (int i = 0; i < newRowIndexs.length; i++) {
				int rowIndex = newRowIndexs[i];
				table.getSelectManager().select(rowIndex, 0);
			}
			table.setRefresh(true);
			table.repaint();
		}

		/**
		 * ĳcheckBoxʽʾ(Ȱ󶨺checkBox). null||0ֵtrue
		 * 
		 * @param table
		 * @param columnKey
		 */
		public static void showCheckBox(KDTable table, String columnKey) {
			int rowCount = table.getRowCount();
			if (table.getColumn(columnKey).getEditor() == null) {// KDTDefaultCellEditor
				logger.info("[" + columnKey + "]ûEditor");
				return;
			}
			KDTDefaultCellEditor cellEditor = (KDTDefaultCellEditor) table.getColumn(columnKey).getEditor();
			if (!(cellEditor.getComponent() instanceof JCheckBox)) {
				logger.info("[" + columnKey + "]󶨵EditorͲΪcheckBox");
				return;
			}
			for (int i = 0; i < rowCount; i++) {
				ICell cell = table.getCell(i, columnKey);
				Object cellValue = cell.getValue();
				if (EDconstantVar.Zero_String.equals(cellValue == null ? EDconstantVar.Zero_String : cellValue.toString())) {
					table.getCell(i, columnKey).setValue(Boolean.FALSE);
				} else {
					table.getCell(i, columnKey).setValue(Boolean.TRUE);
				}
			}
		}

		/**
		 * checkBoxʽʾ(Ȱ󶨺checkBox). 0ֵtrue
		 * 
		 * @param table
		 * @param columnKeys
		 */
		public static void showCheckBox(KDTable table, String[] columnKeys) {
			for (int i = 0; i < columnKeys.length; i++) {
				showCheckBox(table, columnKeys[i]);
			}
		}

		/**
		 * ĳһ
		 * 
		 * @param table
		 * @param columnName
		 * @param state
		 */
		public static void lockColumn(KDTable table, String columnName, boolean state) {
			EDxbangUtil.setColumnEnable(table, columnName, state);
		}

		/**
		 * 
		 * 
		 * @param table
		 * @param columnNames
		 * @param state
		 */
		public static void lockColumn(KDTable table, String[] columnNames, boolean state) {
			for (int i = 0; i < columnNames.length; i++) {
				lockColumn(table, columnNames[i], state);
			}
		}

		public static void removeAllListener(KDTable table) {
			KeyListener[] keyListeners = table.getKeyListeners();
			for (int i = 0; i < keyListeners.length; i++) {
				KeyListener listener = keyListeners[i];
				table.removeKeyListener(listener);
			}
		}

		/**
		 * ɾѡе
		 * 
		 * @param table
		 */
		public static void removeRows(KDTable table) {
			int[] tnis = EDkdTableUtil.SelectManager.getSelectedRows(table);
			for (int i = 0; i < tnis.length; i++) {
				table.removeRow(tnis[i]);
			}
		}

		/**
		 * ɾУȡ
		 * 
		 * @param table
		 */
		public static void removeAllRow(KDTable table) {
			for (int i = table.getRowCount() - 1; i >= 0; i--)
				table.removeRow(i);
		}

		/**
		 * ɾtableһݶΪյ
		 * 
		 * @param table
		 */
		public static void removeNullRow(KDTable table) {
			int rowCount = table.getRowCount();
			int colCount = table.getColumnCount();
			for1: for (int i = rowCount - 1; i >= 0; i--) {
				IRow row = table.getRow(i);
				if (row == null) {
					continue;
				}
				boolean isDelete = true;
				for (int j = 0; j < colCount; j++) {
					if (row.getCell(j).getValue() != null) {
						isDelete = false;
						continue for1;
					}
				}
				if (isDelete) {
					table.removeRow(i);
				}
			}
		}

	}

	/**
	 * tableѡ
	 * 
	 * @author lifeTime
	 * 
	 */
	public static class SelectManager {
		private SelectManager() {
		}

		public static final int SELECT_TOP = 1;
		public static final int SELECT_LEFT = 2;
		public static final int SELECT_BOTTOM = 3;
		public static final int SELECT_RIGHT = 4;

		public static void hideAll(KDTable table) {
			int rowCount = table.getRowCount();
			for (int i = 0; i < rowCount; i++) {
				table.getRow(i).getStyleAttributes().setHided(true);
			}
		}

		/**
		 * 󽹵(tableĵһ)
		 * 
		 * @param table
		 */
		public static void requestFocus(KDTable table) {
			if (table.getSelectManager().getSelectMode() == KDTSelectManager.CELL_SELECT
					|| table.getSelectManager().getSelectMode() == KDTSelectManager.MULTIPLE_CELL_SELECT) {
				table.getSelectManager().select(0, 0, 1, 1);
			} else {
				table.getSelectManager().select(0, 0);
			}
			table.requestFocus();
		}

		/**
		 * tableǷѡ(messageʾ)
		 * 
		 * @param table
		 */
		public static void checkSelect(KDTable table) {
			if (!isSelect(table)) {
				MsgBox.showInfo(EASResource.getString("com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
				SysUtil.abort();
			}
		}

		/**
		 * tableǷѡ
		 * 
		 * @param table
		 */
		public static boolean isSelect(KDTable table) {
			KDTSelectBlock block = table.getSelectManager().get();
			if (block == null || block.getTop() == -1) {
				return false;
			}
			return true;
		}

		/**
		 * tableѡеtopУ
		 * 
		 * @param table
		 * @return
		 */
		public static int getSelectedRow(KDTable table) {
			return getSelectedRow(table, SELECT_TOP);
		}

		/**
		 * tableѡеУֻһУ
		 * 
		 * @param table
		 * @param selectModel
		 *            ȡеģʽEDxbangUtil.SELECT_TOP
		 * @return
		 */
		public static int getSelectedRow(KDTable table, int selectModel) {
			if (table.getSelectManager().size() == 0) {
				return -1;
			} else {
				if (SELECT_TOP == selectModel) {
					return table.getSelectManager().get().getTop();
				} else if (SELECT_BOTTOM == selectModel) {
					return table.getSelectManager().get().getBottom();
				}
				return table.getSelectManager().get().getTop();
			}
		}

		/**
		 * ñѡе
		 * 
		 * @param table
		 * @return
		 */
		public static int getSelectedRowCount(KDTable table) {
			int count = 0;
			for (int i = 0; i < table.getSelectManager().size(); i++) {
				KDTSelectBlock block = table.getSelectManager().get(i);
				count += (block.getBottom() - block.getTop()) + 1;
			}
			return count;
		}

		/**
		 * tableѡе
		 * 
		 * @param table
		 * @return
		 */
		public static int[] getSelectedRows(KDTable table) {
			if (table.getSelectManager().size() == 0)
				return new int[0];
			int count = getSelectedRowCount(table);
			int rows[] = new int[count];
			int k = 0;
			for (int i = 0; i < table.getSelectManager().size(); i++) {
				KDTSelectBlock block = table.getSelectManager().get(i);
				for (int j = block.getTop(); j <= block.getBottom(); j++) {
					rows[k] = j;
					k++;
				}
			}
			return rows;
		}

	}

	/**
	 * tableı¼
	 * 
	 * @author lifeTime
	 * 
	 */
	public static class SettingMustInput {
		KDTable table;
		String[] columnNames;
		static SettingMustInput This;

		/**
		 * @param table
		 * @param columnNames
		 * @return
		 */
		public static SettingMustInput getInstance(KDTable table, String[] columnNames) {
			return getInstance(table, columnNames, false);
		}

		/**
		 * @param table
		 * @param columnNames
		 * @param isSingle
		 *            Ƿ񱣳ֵ
		 * @return
		 */
		public static SettingMustInput getInstance(KDTable table, String[] columnNames, boolean isSingle) {
			if (This == null) {
				This = new SettingMustInput(table, columnNames);
			} else {
				if (!isSingle) {
					This = new SettingMustInput(table, columnNames);
				}
			}
			This.init();
			return This;
		}

		private SettingMustInput(KDTable table, String[] columnNames) {
			this.table = table;
			this.columnNames = columnNames;
		}

		protected void init() {
			for (int i = 0; i < columnNames.length; i++) {
				table.getColumn(columnNames[i]).getStyleAttributes().setBackground(new Color(255, 255, 191));
			}
		}

		public void verifyAll() {
			int rowCount = This.getTable().getRowCount();
			for (int i = 0; i < rowCount; i++) {
				doVerify(i + 1);
			}
		}

		public void verify(int rowIndex) {
			doVerify(rowIndex + 1);
		}

		protected void doVerify(int rowLine) {
			IRow row = This.getTable().getRow(rowLine - 1);
			boolean isNull = false;
			for (int j = 0; j < columnNames.length; j++) {
				if (row.getCell(columnNames[j]) == null) {
					logger.error("" + columnNames[j] + "tableﲻڣ");
					continue;
				}
				if (row.getCell(columnNames[j]).getValue() == null) {
					isNull = true;
					break;
				}
			}
			if (isNull) {
				MsgBox.showWarning(" " + rowLine + " ݲ ");
				SysUtil.abort();
			}
		}

		public KDTable getTable() {
			return table;
		}

		public void setTable(KDTable table) {
			this.table = table;
		}

		public String[] getColumnNames() {
			return columnNames;
		}

		public void setColumnNames(String[] columnNames) {
			this.columnNames = columnNames;
		}

	}

	/**
	 * Ϊtablequeryѯ
	 * 
	 * @param table
	 * @param columnKeys
	 *            tableϵkeyqueryֶһ
	 * @param queryStr
	 * @param viewInfo
	 * @throws BOSException
	 * @throws SQLException
	 */
	public static void bindQuery(KDTable table, String[] columnKeys, String queryStr, EntityViewInfo viewInfo) throws BOSException, SQLException {
		EDxbangUtil.removeAllRow(table);
		List result = EDdbUtil.execQueryInfo(queryStr, viewInfo);
		_bindQuery(table, columnKeys, result);
	}

	/**
	 * Ϊtablequeryѯ
	 * 
	 * @param table
	 * @param columnKeys
	 *            tableϵkeyqueryֶһ
	 * @param queryStr
	 * @param oql
	 *            (ʱַ)
	 * @throws BOSException
	 * @throws SQLException
	 */
	public static void bindQuery(KDTable table, String[] columnKeys, String queryStr, String oql) throws BOSException, SQLException {
		EDxbangUtil.removeAllRow(table);
		List result = EDdbUtil.execQueryInfo(queryStr, oql);
		_bindQuery(table, columnKeys, result);
	}

	/**
	 * Ϊtablesqlѯ
	 * 
	 * @param table
	 * @param columnKeys
	 *            tableϵkeysqlıһ£ִСд
	 * @param ksqlStr
	 * @throws BOSException
	 * @throws SQLException
	 */
	public static void bindSql(KDTable table, String[] columnKeys, String ksqlStr) throws BOSException, SQLException {
		EDxbangUtil.removeAllRow(table);
		List result = EDdbUtil.execQuery(ksqlStr);
		_bindQuery(table, columnKeys, result);
	}

	private static void _bindQuery(KDTable table, String[] columnKeys, List result) {
		table.setRefresh(false);
		for (int i = 0, x = result.size(); i < x; i++) {
			Map rm = (Map) result.get(i);
			IRow row = table.addRow();
			for (int j = 0; j < columnKeys.length; j++) {
				String columnKey = columnKeys[j];
				if (rm.containsKey(columnKey.toUpperCase())) {
					row.getCell(columnKey).setValue(rm.get(columnKey.toUpperCase()));
				}
			}
		}
		table.setRefresh(true);
		table.repaint();
	}

	/**
	 * tableȸƣճ
	 * 
	 * @param table
	 */
	public static void enableDeepCopyPasteCut(KDTable table) {
		enableDeepCopyPasteCut(table, false);
	}

	/**
	 * tableȸƣճ
	 * 
	 * @param table
	 * @param isHasMenu
	 */
	public static void enableDeepCopyPasteCut(final KDTable table, boolean isHasMenu) {
		table.setBeforeAction(new BeforeActionListener() {
			private Map datas = new HashMap();

			public void beforeAction(BeforeActionEvent e) {
				if (BeforeActionEvent.ACTION_COPY == e.getType()) {
					datas.clear();
					ArrayList list = table.getSelectManager().getBlocks();
					if (list != null && !list.isEmpty()) {
						for (int i = 0; i < list.size(); i++) {
							KDTSelectBlock block = (KDTSelectBlock) list.get(i);
							int beginRow = block.getTop();
							int endRow = block.getBottom();
							int beginCol = block.getLeft();
							int endCol = block.getRight();
							for (int x = beginRow; x <= endRow; x++) {
								for (int y = beginCol; y <= endCol; y++) {
									Object value = table.getCell(x, y).getValue();
									datas.put(x + "" + y, value);
								}
							}
						}
					}
				} else if (BeforeActionEvent.ACTION_PASTE == e.getType()) {
					Map cellMap = new HashMap();
					ArrayList list = table.getSelectManager().getBlocks();
					if (list != null && !list.isEmpty()) {
						for (int i = 0; i < list.size(); i++) {
							KDTSelectBlock block = (KDTSelectBlock) list.get(i);
							int beginRow = block.getTop();
							int endRow = block.getBottom();
							int beginCol = block.getLeft();
							int endCol = block.getRight();
							for (int x = beginRow; x <= endRow; x++) {
								for (int y = beginCol; y <= endCol; y++) {
									ICell cell = table.getCell(x, y);
									cellMap.put(x + "" + y, cell);
								}
							}
						}
					}

					Iterator dataIt = datas.keySet().iterator();
					List cellList = EDcommonUtils.MapUtil.sortByKeyToList(cellMap);
					int i = 0;
					int cellSize = cellList.size();
					while (dataIt.hasNext()) {
						Object key = dataIt.next();
						if (i >= cellSize) {
							break;
						}
						ICell cell = (ICell) cellList.get(i);
						try {
							cell.setValue(datas.get(key));
						} catch (ClassCastException ex) {
							cell.setValue(null);
							logger.info("ճʱcellͺҪճͲһ,Ѻԣ");
						}
						i++;
					}
				}
			}
		});
	}

	/**
	 * tableǷѡ
	 * 
	 * @param table
	 */
	public static boolean isSelect(KDTable table) {
		if (table.getSelectManager() == null || table.getSelectManager().get() == null)
			return false;
		return true;
	}

	/**
	 * ȫ
	 * 
	 * @param table
	 */
	public static void hideAll(KDTable table) {
		stateChange(table, true);
	}

	/**
	 * ȫʾ
	 * 
	 * @param table
	 */
	public static void showAll(KDTable table) {
		stateChange(table, false);
	}

	public static void stateChange(KDTable table, boolean state) {
		int rowCount = table.getRowCount();
		for (int i = 0; i < rowCount; i++) {
			table.getRow(i).getStyleAttributes().setHided(state);
		}
	}

}
