package com.kingdee.eas.lifetime.util.kdcontrolutils;

import java.util.ArrayList;
import java.util.Enumeration;

import javax.swing.tree.TreeNode;

import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.eas.lifetime.util.kdcontrolutils.edcommonui.EDTreeInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;

/**
 * @author lifeTime
 * 
 */
public class EDtreeUtil {

	/**
	 * õǰڵuserObject
	 * 
	 * @param tree
	 * @return
	 */
	public static Object getCurrentUserObject(KDTree tree) {
		DefaultKingdeeTreeNode node = getCurrentNode(tree);
		return getNodeUserObject(tree, node);
	}

	/**
	 * ýڵuserObject
	 * 
	 * @param tree
	 * @param node
	 * @return
	 */
	public static Object getNodeUserObject(KDTree tree, DefaultKingdeeTreeNode node) {
		if (node != null && node.getUserObject() != null && node.getUserObject() instanceof EDTreeInfo) {
			EDTreeInfo treeInfo = (EDTreeInfo) node.getUserObject();
			return treeInfo.getValue();
		}
		return node == null ? null : node.getUserObject();
	}

	/**
	 * õǰѡnode
	 * 
	 * @param tree
	 * @return
	 */
	public static DefaultKingdeeTreeNode getCurrentNode(KDTree tree) {
		if (tree.getSelectionPath() == null) {
			return null;
		}
		if (!(tree.getSelectionPath().getLastPathComponent() instanceof DefaultKingdeeTreeNode)) {
			return null;
		}
		return (DefaultKingdeeTreeNode) tree.getSelectionPath().getLastPathComponent();
	}

	/**
	 * ǰѡеĽڵǷΪҶ
	 * 
	 * @param tree
	 * @return
	 */
	public static boolean isLeaf(KDTree tree) {
		DefaultKingdeeTreeNode node = getCurrentNode(tree);
		if (node == null) {
			return false;
		}
		return node.isLeaf();
	}

	/**
	 * ǷΪڵ
	 * 
	 * @param tree
	 * @param node
	 * @return
	 */
	public static boolean isRootNode(KDTree tree, TreeNode node) {
		return node == null ? false : (node.getParent() == null ? true : false);
	}

	/**
	 * treeǷбѡнڵ
	 * 
	 * @param tree
	 * @param isNeedCall
	 *            Ƿʾ
	 * @return
	 */
	public static boolean checkSelect(KDTree tree, boolean isNeedCall) {
		if (tree.getSelectionPath() == null) {
			if (isNeedCall) {
				MsgBox.showWarning("ѡڵ㣡");
			}
			return false;
		}
		return true;
	}

	/**
	 * treeǷбѡнڵ,Ϣʾ
	 * 
	 * @param tree
	 */
	public static void checkSelect(KDTree tree) {
		if (!checkSelect(tree, true)) {
			SysUtil.abort();
		}
	}

	/**
	 * ǷѡΪĿ¼
	 * 
	 * @param tree
	 * @return
	 */
	public static boolean isSelectRoot(KDTree tree) {
		return tree.getSelectionPath() != null && tree.getSelectionPath().getParentPath() == null ? true : false;
	}

	/**
	 * nodeеUserObjectӣ
	 * 
	 * @param node
	 * @return
	 */
	public static ArrayList getAllUserObject(DefaultKingdeeTreeNode node) {
		ArrayList list = new ArrayList();
		list.add(node.getUserObject());
		int i = 0;
		for (int size = node.getChildCount(); i < size; i++) {
			DefaultKingdeeTreeNode tmpNode = (DefaultKingdeeTreeNode) node.getChildAt(i);
			list.addAll(getAllUserObject(tmpNode));
		}
		return list;
	}

	/**
	 * nodeеӽڵ(Լ)
	 * 
	 * @param node
	 * @return
	 */
	public static ArrayList getAllSubNode(DefaultKingdeeTreeNode node) {
		ArrayList list = new ArrayList();
		list.add(node);
		int i = 0;
		for (int size = node.getChildCount(); i < size; i++) {
			DefaultKingdeeTreeNode tmpNode = (DefaultKingdeeTreeNode) node.getChildAt(i);
			list.addAll(getAllUserObject(tmpNode));
		}
		return list;
	}

	/**
	 * checkboxʱKDTreeбѡеnode
	 * 
	 * @param kdtree
	 * @return
	 */
	public static DefaultKingdeeTreeNode[] getCheckedNodes(KDTree kdtree) {
		ArrayList list = new ArrayList();
		DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode) kdtree.getModel().getRoot();
		Enumeration nodeAlls = root.depthFirstEnumeration();
		do {
			if (!nodeAlls.hasMoreElements())
				break;
			DefaultKingdeeTreeNode nodeTemp = (DefaultKingdeeTreeNode) nodeAlls.nextElement();
			if (nodeTemp.isCheckBoxVisible() && nodeTemp.isChecked())
				list.add(nodeTemp);
		} while (true);
		DefaultKingdeeTreeNode nodes[] = new DefaultKingdeeTreeNode[list.size()];
		return (DefaultKingdeeTreeNode[]) list.toArray(nodes);
	}

}
