package com.kingdee.eas.lifetime.util.kdcontrolutils;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.Map;

import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.common.client.UIFactoryName;
import com.kingdee.eas.util.client.ComponentUtil;

/**
 * 
 * 
 * @author lifeTime
 * 
 */
public class EDwindowUtil {

	private EDwindowUtil() {
	}

	/**
	 * 촰
	 * 
	 * @param obj
	 *            new UIContext(obj)
	 * @param windowName
	 *            
	 * @param windowState
	 *            ״̬
	 * @return
	 */
	public static IUIWindow getWindow(Object obj, String windowName, String windowState) {
		IUIWindow myWindow = null;
		Map map = new UIContext(obj);
		try {
			myWindow = UIFactory.createUIFactory(UIFactoryName.MODEL).create(windowName, map, null, windowState);
		} catch (UIException e) {
			e.printStackTrace();
		}
		return myWindow;
	}

	/**
	 * 촰
	 * 
	 * @param obj
	 *            new UIContext(obj)
	 * @param windowName
	 *            
	 * @param windowState
	 *            ״̬
	 * @return
	 */
	public static IUIWindow getWindow(Map uiContent, String windowName, String windowState) {
		IUIWindow myWindow = null;
		try {
			myWindow = UIFactory.createUIFactory(UIFactoryName.MODEL).create(windowName, uiContent, null, windowState);
		} catch (UIException e) {
			e.printStackTrace();
		}
		return myWindow;
	}

	public static IUIWindow getWindow(Map uiContext, String windowName) {
		return getWindow(uiContext, windowName, null);
	}

	/**
	 * 촰
	 * 
	 * @param UIFactoryName
	 *            .MODEL ״̬
	 * 
	 * @param obj
	 *            new UIContext(obj)
	 * @param windowName
	 *            
	 * @param windowState
	 *            ״̬
	 * @return
	 */
	public static IUIWindow getWindow(String uiFactoryName, Map uiContent, String windowName, String windowState) {
		IUIWindow myWindow = null;
		try {
			myWindow = UIFactory.createUIFactory(uiFactoryName).create(windowName, uiContent, null, windowState);
		} catch (UIException e) {
			e.printStackTrace();
		}
		return myWindow;
	}

	/**
	 * ģʽԻĴ
	 * 
	 * @author lifeTime
	 * 
	 */
	public static class ResizeWindowSize {
		Window dialog_;
		Rectangle winSize;
		public static ResizeWindowSize instance = new ResizeWindowSize();

		private ResizeWindowSize() {
		}

		/**
		 * 
		 */
		public void toMax() {
			dialog_ = ComponentUtil.getOwnerWindow(null);
			winSize = dialog_.getBounds();
			Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
			Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(dialog_.getGraphicsConfiguration());
			Rectangle desktopBounds = new Rectangle(screenInsets.left, screenInsets.top, screenSize.width - screenInsets.left - screenInsets.right, screenSize.height
					- screenInsets.top - screenInsets.bottom);
			dialog_.setBounds(0, 0, desktopBounds.width, desktopBounds.height);
		}

		/**
		 * ԭ
		 */
		public void resume() {
			dialog_.setBounds(winSize);
		}
	}

}
