package com.kingdee.eas.lifetime.util.kdcontrolutils.edcommonui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.kingdee.bos.ctrl.kdf.table.CellTreeNode;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.eas.lifetime.util.edcommonutils.EDcommonUtils;
import com.kingdee.eas.lifetime.util.kdcontrolutils.EDkdTableUtil;

/**
 * ʾ÷
 * 
 * <pre>
 * tableTree.setLongNumberKey(longNumberе);
 * tableTree.setDefaultCollapse(Ĭչڼ);
 * tableTree.setDisplayKey(Ϊ״һ);
 * tableTree.refreshToTableTree();
 * </pre>
 * 
 * @author lifeTime
 * 
 * 
 */
public class EDTableTree extends KDTable {

	private static final long serialVersionUID = 1L;

	/**
	 * ҪʾΪ״һе
	 */
	private String displayKey;

	/**
	 * Ĭϵĳָ
	 */
	private String defaultSep = "!";

	/**
	 * ڵcolumnkey
	 */
	private String longNumberKey;

	/**
	 * Ĭչļ
	 */
	private int defaultCollapse = -1;

	String[] columnKeys = null;

	public EDTableTree() {
		super();
	}

	public void refresh() {
		super.refresh();
	}

	/**
	 * ʹrefreshToTableTreeǰúlongNumberKeydisplayKey
	 */
	public void refreshToTableTree() {
		reconstructTable();
	}

	/**
	 * عtable򹹽ΪtableTree
	 */
	protected void reconstructTable() {
		if (isEmpty(this.displayKey)) {
			throw new NullPointerException("EDTableTree's displayKey can not be null!");
		} else if (isEmpty(this.longNumberKey)) {
			throw new NullPointerException("EDTableTree's longNumberKey can not be null!");
		} else {
			generating();
		}
	}

	protected void generating() {
		Map numberRows = getLongNumberMapRow();
		EDkdTableUtil.OperateManager.removeAllRow(this);
		if (numberRows != null) {
			List keyList = EDcommonUtils.MapUtil.sortKey(numberRows, new Comparator() {
				public int compare(Object arg0, Object arg1) {
					String str0 = arg0.toString();
					String str1 = arg1.toString();
					if (str0.length() < str1.length()) {
						return -1;
					} else if (str0.length() > str1.length()) {
						return 1;
					} else {
						return str0.compareTo(str1);
					}
				}
			});
			List keyList_ = analyzeKeyList(keyList);
			generateTableTree(keyList_, numberRows);
		}
	}

	private List analyzeKeyList(List keyList) {
		ArrayList list = new ArrayList();
		List rootKeyList = getRootKeyList(keyList);
		Collections.sort(rootKeyList, new Comparator() {
			public int compare(Object arg0, Object arg1) {
				return arg0.toString().compareTo(arg1.toString());
			}
		});
		for (int i = 0, k = rootKeyList.size(); i < k; i++) {
			String rootKey = (String) rootKeyList.get(i);
			list.add(rootKey);
			EDcommonUtils.ListUtil.addList(getSameParentKeys(rootKey, keyList, new ArrayList()), list);
		}

		return list;
	}

	private List getSameParentKeys(String parentKey, List keyList, List returnList) {
		int parentSign = EDcommonUtils.StringUtils.findStrCount(parentKey, getDefaultSep());
		for (int i = 0, k = keyList.size(); i < k; i++) {
			String key = (String) keyList.get(i);
			int childSign = EDcommonUtils.StringUtils.findStrCount(key, getDefaultSep());
			if (childSign - 1 == parentSign) {
				if (key.indexOf(parentKey) != -1) {
					returnList.add(key);
					getSameParentKeys(key, keyList, returnList);
				}
			}
			continue;
		}
		return returnList;
	}

	private List getRootKeyList(List keyList) {
		int rootKeySize = 0;
		if (keyList != null && !keyList.isEmpty()) {
			rootKeySize = ((String) keyList.get(0)).length();
		}
		ArrayList rootKeys = new ArrayList();
		for (int i = 0, k = keyList.size(); i < k; i++) {
			String key = (String) keyList.get(i);
			if (key.length() == rootKeySize) {
				rootKeys.add(key);
			}
		}
		return rootKeys;
	}

	private void generateTableTree(List keyList, Map numberRows) {
		for (int i = 0, k = keyList.size(); i < k; i++) {
			Object key = keyList.get(i);
			Object value = numberRows.get(key);
			if (value instanceof IRow) {
				IRow oldRow = (IRow) value;
				IRow row = this.addRow(oldRow);
				Object cellValue = row.getCell(getDisplayKey()).getValue();
				String longNumber = (String) oldRow.getCell(getLongNumberKey()).getValue();
				int level = getLevel(longNumber);
				CellTreeNode treeNode = new CellTreeNode();
				treeNode.setHasChildren(!isLeaf(keyList, longNumber));
				treeNode.setValue(cellValue);
				treeNode.setTreeLevel(level);
				treeNode.setCollapse(!isCollapse(level));
				row.getCell(getDisplayKey()).setValue(treeNode);
				row.getStyleAttributes().setHided(!(level <= defaultCollapse));
			}
		}
	}

	private boolean isCollapse(int level) {
		return defaultCollapse <= level ? false : true;
	}

	private int getLevel(String longNumber) {
		return EDcommonUtils.StringUtils.findStrCount(longNumber, getDefaultSep());
	}

	private boolean isLeaf(List keyList, String longNumber) {
		for (int i = 0, k = keyList.size(); i < k; i++) {
			String key = (String) keyList.get(i);
			if (key.indexOf(longNumber + defaultSep) != -1) {
				return false;
			}
		}
		return true;
	}

	/**
	 * õȫlongNumberrowĶӦϵ
	 * 
	 * @return
	 */
	private Map getLongNumberMapRow() {
		int rowCount = this.getRowCount();
		if (rowCount < 1) {
			return null;
		}
		Map m = new HashMap(rowCount);
		for (int i = 0; i < rowCount; i++) {
			IRow row = this.getRow(i);
			m.put(row.getCell(getLongNumberKey()).getValue(), row);
		}
		return m;
	}

	public IRow addRow(IRow row) {
		String[] keys = getColumnKeys();
		if (keys == null) {
			throw new NullPointerException("EDTableTree's hasn't initialize columns!");
		}
		IRow cutRow = this.addRow();
		for (int i = 0; i < keys.length; i++) {
			String key = keys[i];
			ICell cutCell = cutRow.getCell(key);
			ICell oldCell = row.getCell(key);
			if (cutCell == null)
				continue;
			cutCell.setValue(oldCell == null ? null : oldCell.getValue());
		}
		return cutRow;
	}

	/**
	 * еkey
	 * 
	 * @return
	 */
	public String[] getColumnKeys() {
		if (this.getColumnCount() < 1)
			return null;
		columnKeys = new String[this.getColumnCount()];
		for (int i = 0; i < columnKeys.length; i++) {
			columnKeys[i] = this.getColumnKey(i);
		}
		return columnKeys;
	}

	private boolean isEmpty(String str) {
		return str == null || str.equals("") ? true : false;
	}

	public String getDisplayKey() {
		return displayKey;
	}

	/**
	 * ʾΪ״ṹһеkey
	 * 
	 * @param displayKey
	 */
	public void setDisplayKey(String displayKey) {
		this.displayKey = displayKey;
	}

	public String getLongNumberKey() {
		return longNumberKey;
	}

	/**
	 * óһеkey
	 * 
	 * @param longNumberKey
	 */
	public void setLongNumberKey(String longNumberKey) {
		this.longNumberKey = longNumberKey;
	}

	/**
	 * longNumberķָ,ĬΪ!
	 * 
	 * @return
	 */
	public String getDefaultSep() {
		return defaultSep;
	}

	public void setDefaultSep(String defaultSep) {
		this.defaultSep = defaultSep;
	}

	public int getDefaultCollapse() {
		return defaultCollapse;
	}

	/**
	 * չڼ,Ǵ0ʼ
	 * 
	 * @param defaultCollapse
	 */
	public void setDefaultCollapse(int defaultCollapse) {
		this.defaultCollapse = defaultCollapse;
	}

}
