package com.kingdee.eas.lifetime.util.kdcontrolutils.edcommonui;

import java.awt.Component;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DnDConstants;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.ITreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.eas.lifetime.util.bizutil.EDbizUtil;
import com.kingdee.eas.lifetime.util.edcommonutils.EDcommonUtils;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.TreeBaseInfo;

/**
 * Ϊ֧קͨMapֱӹtreeһKDTreeеķװ mapkeyΪ룬valueΪֵ<br>
 * ҪקḶ́EDTreeDragDropRoundListenerʵֲּ<br>
 * 
 * <pre>
 * ʾ룺
 * 
 * Map map = new HashMap();
 * map.put(&quot;1&quot;, &quot;aaa&quot;);
 * map.put(&quot;1!2&quot;, &quot;bbb&quot;);
 * map.put(&quot;1!2!3&quot;, &quot;ccc&quot;);
 * map.put(&quot;2&quot;, &quot;ddd&quot;);
 * EDTree tree = new EDTree(map);
 * tree.setEnableMove(true);
 * tree.setDragDropRoundListener(new EDTreeDragDropRoundListenerImp() {
 * 	public void doingDrag(DefaultMutableTreeNode sourceNode) {
 * 		super.doingDrag(sourceNode);
 * 		System.out.println(&quot;϶ĽڵΪ&quot; + sourceNode);
 * 	}
 * 
 * 	public boolean allowDrag() {
 * 		return true;
 * 	}
 * 
 * 	public void doingDrop(DefaultMutableTreeNode sourceNode, DefaultMutableTreeNode targetNode) {
 * 		super.doingDrop(sourceNode, targetNode);
 * 		System.out.println(&quot;ڵ&quot; + sourceNode + &quot; ϶ &quot; + targetNode + &quot;&quot;);
 * 	}
 * 
 * 	public boolean allowDrop() {
 * 		return super.allowDrop();
 * 	}
 * });
 * tree.updateUI();
 * </pre>
 * 
 * @author lifeTime
 */
public class EDTree extends KDTree {

	private static final long serialVersionUID = 1L;

	private Object rootObj;
	private static final String defaultRootName = "Root";
	private String rootName;
	private String separator;
	private final String defaultSeparator = "!";
	private boolean enableMove = false;
	private Map treeMap = null;

	private int treeDeep = 10;
	private List nodeMapKey;
	private String entityName;
	private EntityViewInfo viewInfo;
	private EDTreeDragDropRoundListener dragDropRoundListener;

	/**
	 * ˢ£entityNameЧ,ڹжӦʵ
	 */
	public void refresh() {
		reload();
		updateUI();
	}

	/**
	 * 
	 * @param entityName
	 *            ̳ʵ
	 * @param viewInfo
	 */
	public EDTree(String entityName, EntityViewInfo viewInfo) {
		this.entityName = entityName;
		this.viewInfo = viewInfo;
		reload();
	}

	private void reload() {
		if (this.entityName == null) {
			System.out.println("refresh¼ֻentityNameúЧ");
			return;
		}
		if (treeMap != null) {
			treeMap.clear();
		} else {
			treeMap = new HashMap();
		}
		EntityObjectInfo entityObjectInfo = EDbizUtil.getEntity(entityName);
		ICoreBase base = EDbizUtil.getBizInteface(entityObjectInfo.getObjectValueClass(), entityObjectInfo.getBusinessInterface(), null);
		try {
			CoreBaseCollection collection = base.getCollection(viewInfo);
			for (int i = 0, k = collection.size(); i < k; i++) {
				TreeBaseInfo baseInfo = (TreeBaseInfo) collection.get(i);
				String key = baseInfo.getLongNumber();
				treeMap.put(key, baseInfo);
			}
		} catch (BOSException e) {
			e.printStackTrace();
		}
	}

	/**
	 * @param entityName
	 *            ̳ʵ
	 */
	public EDTree(String entityName) {
		this(entityName, null);
	}

	protected TreeModel buildTree(Map treeMap) {
		if (treeMap == null || treeMap.isEmpty()) {
			DefaultKingdeeTreeNode root = getRoot();
			return new DefaultTreeModel(root);
		}
		TreeModel treeModel = buildTreeMode(treeMap);
		if (treeModel == null)
			return getDefaultTreeModel();
		else
			return treeModel;
	}

	public DefaultKingdeeTreeNode getRoot() {
		return new DefaultKingdeeTreeNode(getRootObj());
	}

	protected TreeModel buildTreeMode(Map treeMap) {
		DefaultKingdeeTreeNode root = getRoot();
		analyzeMapToRoot(treeMap, root);
		return new DefaultTreeModel(root);
	}

	/**
	 * Ĭɵĳ˳()
	 */
	protected List getTreeLongNumberList() {
		return nodeMapKey;
	}

	/**
	 * Ĭɵĳ˳,ط⴦ʱ뱣֤зʽ
	 * 
	 * <pre>
	 * {
	 * 			  ȷ
	 * 			  01
	 * 			  02
	 * 			  01!001
	 * 			  01!002
	 * 			  02!001
	 * 			  02!002
	 * 		  }
	 * 		  
	 * 		  {
	 * 			  :
	 * 			  01
	 * 			  01!001
	 * 			  01!002
	 * 			  02
	 * 			  02!001
	 * 			  02!002
	 * 		  }
	 * 
	 * </pre>
	 */
	public void comparatorTreeLongNumberList(Comparator comparator) {
		Collections.sort(getTreeLongNumberList(), comparator);
	}

	private void analyzeMapToRoot(Map treeMap, DefaultKingdeeTreeNode root) {
		if (treeMap == null || treeMap.isEmpty()) {
			return;
		}
		Iterator iterator = treeMap.keySet().iterator();
		HashMap nodeMap = new HashMap();
		nodeMapKey = new ArrayList();
		while (iterator.hasNext()) {
			Object key = iterator.next();
			if (!(key instanceof String)) {
				return;
			}
			String keyStr = key == null ? "" : key.toString();
			int level = EDcommonUtils.StringUtils.findStrCount(keyStr, getSeparator());
			EDTreeInfo treeInfo = new EDTreeInfo(level, keyStr, treeMap.get(key));
			nodeMapKey.add(treeInfo);
			nodeMap.put(treeInfo, new DefaultKingdeeTreeNode(treeInfo));
		}
		comparatorTreeLongNumberList(new LengthComparator());
		for (int i = 0, k = nodeMapKey.size(); i < k; i++) {
			EDTreeInfo key = (EDTreeInfo) nodeMapKey.get(i);
			if (key.getLevel() == 0) {
				root.add((DefaultKingdeeTreeNode) nodeMap.get(key));
			} else {
				DefaultKingdeeTreeNode node = getParentNode(nodeMap, key);
				if (node != null || (node == null && key.getLongNumber().indexOf(getSeparator()) == -1)) {
					node.add((DefaultKingdeeTreeNode) nodeMap.get(key));
				} else
					System.out.println("longNumber:[" + key.getLongNumber() + "]not found parentLongNumber!");
			}
		}
	}

	private DefaultKingdeeTreeNode getParentNode(Map nodeMap, EDTreeInfo key) {
		String longNumber = key.getLongNumber();
		int lastIndex = longNumber.lastIndexOf(getSeparator());
		longNumber = EDcommonUtils.StringUtils.subString(longNumber, 0, lastIndex - 1, true);
		EDTreeInfo temp = getTreeInfo(longNumber);
		return (DefaultKingdeeTreeNode) nodeMap.get(temp);
	}

	private EDTreeInfo getTreeInfo(String longNumber) {
		if (EDcommonUtils.ListUtil.isEmpty(nodeMapKey)) {
			return null;
		}
		for (int i = 0, k = nodeMapKey.size(); i < k; i++) {
			EDTreeInfo treeInfo = (EDTreeInfo) nodeMapKey.get(i);
			if (longNumber.equals(treeInfo.getLongNumber())) {
				return treeInfo;
			}
		}
		return null;
	}

	class LengthComparator implements Comparator {
		public int compare(Object obj1, Object obj2) {
			String s1 = ((EDTreeInfo) obj1).getLongNumber();
			String s2 = ((EDTreeInfo) obj2).getLongNumber();
			if (s1.length() < s2.length()) {
				return -1;
			} else
				return 1;
		}
	}

	class ABComparator implements Comparator {
		public int compare(Object obj1, Object obj2) {
			String s1 = obj1.toString();
			String s2 = obj2.toString();
			return s1.compareTo(s2);
		}
	}

	/**
	 * updateUIˢṹҪrefreshˢ£refreshentityNameˢ¡
	 * 
	 * @param treeMap
	 */
	public EDTree(Map treeMap) {
		this(getEDTreeModel(), false);
		setTreeMap(treeMap);
	}

	private static TreeModel getEDTreeModel() {
		DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode(defaultRootName);
		return new KingdeeTreeModel(root);
	}

	public EDTree() {
		this(getDefaultTreeModel(), false);
	}

	public EDTree(boolean flag) {
		this(getDefaultTreeModel(), flag);
	}

	public EDTree(Object aobj[]) {
		this(aobj, true);
	}

	public EDTree(Object aobj[], boolean flag) {
		this(createTreeModel(((Object) (aobj))), flag);
		setRootVisible(false);
	}

	public EDTree(Vector vector) {
		this(vector, true);
	}

	public EDTree(Vector vector, boolean flag) {
		this(createTreeModel(vector), flag);
		setRootVisible(false);
	}

	public EDTree(Hashtable hashtable, boolean flag) {
		this(createTreeModel(hashtable), flag);
		setRootVisible(false);
	}

	public EDTree(ITreeNode itreenode) {
		this(itreenode, true);
	}

	public EDTree(ITreeNode itreenode, boolean flag) {
		this(itreenode, flag, false);
	}

	public EDTree(ITreeNode itreenode, boolean flag, boolean flag1) {
		this(((TreeModel) (new KingdeeTreeModel(itreenode, flag1))), flag);
	}

	public EDTree(TreeModel treemodel) {
		this(treemodel, true);
	}

	protected DefaultMutableTreeNode dragTreeNode = null;

	public EDTree(TreeModel treemodel, boolean flag) {
		super(treemodel, flag);
	}

	public Map getTreeMap() {
		return treeMap;
	}

	public void setTreeMap(Map treeMap) {
		this.treeMap = treeMap;
	}

	public int getTreeDeep() {
		return treeDeep;
	}

	public void setTreeDeep(int treeDeep) {
		this.treeDeep = treeDeep;
	}

	public void setSeparator(String separator) {
		this.separator = separator;
	}

	public boolean isEnableMove() {
		return enableMove;
	}

	public void setEnableMove(boolean enableMove) {
		this.enableMove = enableMove;
	}

	public String getRootName() {
		if (this.rootName == null) {
			return defaultRootName;
		}
		return rootName;
	}

	public void setRootName(String rootName) {
		this.rootName = rootName;
	}

	public Object getRootObj() {
		if (rootObj == null) {
			return getRootName();
		}
		return rootObj;
	}

	public void setRootObj(Object rootObj) {
		this.rootObj = rootObj;
	}

	public String getSeparator() {
		if (separator == null || separator.equals("")) {
			return defaultSeparator;
		}
		return separator;
	}

	public EDTree(KDTree tree) {
		this(tree.getModel(), true);
	}

	public void updateUI() {
		if (treeMap != null || rootName != null) {
			this.setModel(buildTree(treeMap));
		}
		initTreeFacade();
		super.updateUI();
	}

	protected void initTreeFacade() {
		initEnableMove();
	}

	protected void initEnableMove() {
		if (isEnableMove()) {
			DragSource dragSource = DragSource.getDefaultDragSource();
			dragSource.createDefaultDragGestureRecognizer(this, DnDConstants.ACTION_MOVE, new EDDragGestureRecognizerListener());
			new DropTarget(this, new EDDragAndDropDropTargetListener());
		}
	}

	// קʱ״̬
	class EDDragGestureRecognizerListener implements DragGestureListener {
		public void dragGestureRecognized(DragGestureEvent e) {
			JTree tree = (JTree) e.getComponent();
			TreePath path = tree.getSelectionPath();
			if (path != null) {
				dragTreeNode = (DefaultMutableTreeNode) path.getLastPathComponent();
				if (dragTreeNode != null) {
					EDTreeTransferable dragAndDropTransferable = new EDTreeTransferable(dragTreeNode);
					e.startDrag(DragSource.DefaultMoveDrop, dragAndDropTransferable, new EDDragAndDropDragSourceListener());
				}
			}
		}
	}

	/**
	 * ڵǷܱ϶
	 */
	private boolean isCanDrag = true;

	class EDDragAndDropDragSourceListener implements DragSourceListener {
		public void dragEnter(DragSourceDragEvent e) {
			DragSourceContext context = e.getDragSourceContext();
			DefaultMutableTreeNode dragTreeNode = getDragTreeNode();
			EDTreeDragDropRoundListener dragDropRoundListener = getDragDropRoundListener();
			if (dragDropRoundListener != null && isEnableMove()) {
				if (!dragDropRoundListener.allowDrag()) {
					isCanDrag = false;
					context.setCursor(DragSource.DefaultMoveNoDrop);
				}
				dragDropRoundListener.doingDrag(dragTreeNode);
			}
			int dropAction = e.getDropAction();
			if ((dropAction & DnDConstants.ACTION_COPY) != 0) {
				context.setCursor(DragSource.DefaultCopyDrop);
			} else if ((dropAction & DnDConstants.ACTION_MOVE) != 0) {
				context.setCursor(DragSource.DefaultMoveDrop);
			} else {
				context.setCursor(DragSource.DefaultCopyNoDrop);
			}
		}

		public void dragExit(DragSourceEvent e) {
		}

		public void dragOver(DragSourceDragEvent e) {
		}

		public void dropActionChanged(DragSourceDragEvent e) {
		}

		public void dragDropEnd(DragSourceDropEvent e) {
			if (!isCanDrag || !e.getDropSuccess() || e.getDropAction() != DnDConstants.ACTION_MOVE) {
				return;
			}
			DragSourceContext context = e.getDragSourceContext();
			Object comp = context.getComponent();
			if (comp == null || !(comp instanceof JTree)) {
				return;
			}
			DefaultMutableTreeNode dragTreeNode = getDragTreeNode();
			if (dragTreeNode != null) {
				((DefaultTreeModel) getModel()).removeNodeFromParent(dragTreeNode);
				setDragTreeNode(null);
			}
		}
	}

	/**
	 * ϶ڵ
	 */
	public void setDragTreeNode(DefaultMutableTreeNode dragTreeNode) {
		this.dragTreeNode = dragTreeNode;
	}

	/**
	 * ȡ϶ڵ
	 * 
	 * @return DefaultMutableTreeNode
	 */
	public DefaultMutableTreeNode getDragTreeNode() {
		return dragTreeNode;
	}

	class EDDragAndDropDropTargetListener implements DropTargetListener {

		public void dragEnter(DropTargetDragEvent e) {
		}

		public void dragOver(DropTargetDragEvent e) {
		}

		public void dropActionChanged(DropTargetDragEvent e) {
		}

		public void dragExit(DropTargetEvent e) {
		}

		// e.rejectDrop()drop()е
		public void drop(DropTargetDropEvent e) {
			if (!isCanDrag) {
				e.dropComplete(false);
				return;
			}
			Transferable transfer = e.getTransferable();
			DefaultMutableTreeNode dragSource = null;
			if (transfer.isDataFlavorSupported(EDTreeTransferable.TREENODE_FLAVOR)) {
				try {
					e.acceptDrop(DnDConstants.ACTION_MOVE);
					dragSource = (DefaultMutableTreeNode) transfer.getTransferData(EDTreeTransferable.TREENODE_FLAVOR);
				} catch (Exception ex) {
					ex.printStackTrace();
				}
			}
			if (dragSource == null) {
				e.dropComplete(false);
				return;
			}
			DropTarget dt = (DropTarget) e.getSource();
			Component comp = dt.getComponent();
			if (!(comp instanceof JTree)) {
				e.dropComplete(false);
				return;
			}
			JTree jtr = (JTree) comp;
			TreePath treePath = jtr.getPathForLocation(e.getLocation().x, e.getLocation().y);
			if (treePath == null) {
				e.dropComplete(false);
				return;
			}
			DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode) treePath.getLastPathComponent();
			if (!isCanDrop(dragSource, treeNode, jtr)) {
				e.dropComplete(false);
				return;
			}
			EDTreeDragDropRoundListener dragDropRoundListener = getDragDropRoundListener();
			if (dragDropRoundListener != null && isEnableMove()) {
				if (!dragDropRoundListener.allowDrop()) {
					e.dropComplete(false);
					return;
				}
				dragDropRoundListener.doingDrop(dragSource, treeNode);
			}
			treeNode.add(dragSource);
			((DefaultTreeModel) jtr.getModel()).reload(treeNode);
			e.dropComplete(true);
		}

		/**
		 * жǷԷò
		 * 
		 * @param dragTreeNode
		 *            DefaultMutableTreeNode ϶Դڵ
		 * @param dropTreeNode
		 *            DefaultMutableTreeNode Ŀڵ
		 * @return boolean
		 */
		public boolean isCanDrop(DefaultMutableTreeNode dragTreeNode, DefaultMutableTreeNode dropTreeNode, JTree jtr) {
			if (dragTreeNode == null) {
				return false;
			}
			if (dropTreeNode == null) {
				return false;
			}
			if (dragTreeNode == dropTreeNode) {
				return false;
			}
			TreePath dragPath = new TreePath(((DefaultTreeModel) jtr.getModel()).getPathToRoot(dragTreeNode));
			TreePath dropPath = new TreePath(((DefaultTreeModel) jtr.getModel()).getPathToRoot(dropTreeNode));
			String strDragPath = dragPath.toString();
			String strDropPath = dropPath.toString();
			String subDragPath = strDragPath.substring(0, strDragPath.length() - 1);

			if (strDropPath.startsWith(subDragPath)) {// Ŀ϶Դڵ
				return false;
			}
			if (dragPath.getParentPath().toString().equals(strDropPath)) {// Ŀ϶Դĸڵ
				return false;
			}

			// Ŀ϶Դĸڵ˳
			if (dragTreeNode.getParent().equals(dropTreeNode)) {
				return false;
			}

			return true;
		}

	}

	public String getEntityName() {
		return entityName;
	}

	public void setEntityName(String entityName) {
		this.entityName = entityName;
	}

	public EntityViewInfo getViewInfo() {
		return viewInfo;
	}

	public void setViewInfo(EntityViewInfo viewInfo) {
		this.viewInfo = viewInfo;
	}

	public EDTreeDragDropRoundListener getDragDropRoundListener() {
		return dragDropRoundListener;
	}

	public void setDragDropRoundListener(EDTreeDragDropRoundListener dragDropRoundListener) {
		this.dragDropRoundListener = dragDropRoundListener;
	}

}
