package com.kingdee.eas.lifetime.util.kdcontrolutils.edcommonui;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;

import javax.swing.tree.DefaultMutableTreeNode;

public class EDTreeTransferable implements Transferable{
	private DefaultMutableTreeNode treeNode;
	public final static DataFlavor TREENODE_FLAVOR = new DataFlavor(DefaultMutableTreeNode.class, "TreeNode instance");
	DataFlavor[] flavors = new DataFlavor[] { TREENODE_FLAVOR };

	public EDTreeTransferable(DefaultMutableTreeNode treeNode) {
		this.treeNode = treeNode;
	}

	public DataFlavor[] getTransferDataFlavors() {
		return flavors;
	}

	public boolean isDataFlavorSupported(DataFlavor flavor) {
		for (int i = 0; i < flavors.length; i++) {
			DataFlavor df = flavors[i];
			if (df.equals(flavor)) {
				return true;
			}
		}
		return false;
	}

	public Object getTransferData(DataFlavor df) throws UnsupportedFlavorException, IOException {
		if (df.equals(TREENODE_FLAVOR)) {
			return treeNode;
		}
		throw new UnsupportedFlavorException(df);
	}
}
